package BM::BannersMaker::Tasks::PerfMergeFeed;

use base qw(ObjLib::ProjPart);

sub init {
    my ($self) = @_;
    die unless defined($self->{filename});
    $self->{feed} = $self->proj->feed( {extfile => $self->{filename}, datatype => 'offers_tskv'})
}

sub get_by_key {
    my ($self, $key) = @_;
    while ((!$self->{feed_finished}) && ((! defined($self->{current_product})) || $self->{current_product}->{merge_key} lt $key)) {
        # читаем по одной строке, батчи нужны только для ускорения работы фильтров, а тут фильтров нет
        my $ptl = $self->{feed}->next_ptl_pack(1);

        my @offers = @$ptl;
        if (@offers) {
            $self->{current_product} = $offers[0];
        } else {
            $self->{current_product} = undef;
            $self->{feed_finished} = 1;
        }
    }
    if (defined($self->{current_product}) && $self->{current_product}->{merge_key} eq $key) {
        return $self->{current_product};
    } else{
        return undef;
    }
}

1;