package BM::BannersMaker::Tasks::PerfTask;

use utf8;
use open ':utf8';

use std;
use base qw(BM::BannersMaker::Tasks::BasePerfTask);

use Data::Dumper;

use Utils::Hosts qw(get_host_role);

use Utils::Array qw/uniq_array/;

########################################################
# Интерфейс
########################################################

#   data                  Указатель на массив товаров

########################################################
# Инициализация
########################################################

sub init {
    my ($self) = @_;

    my $task = $self->taskinf;
    $self->{source_taskjson} = $self->proj->serial([$task]);
    my $targdata = $task->{Resource}{Targets}; #Фильтры для фида

    #Исправляем формат Директа, так как разошлась логика представления фильтров
    if(1){
         if( ref($targdata) eq 'ARRAY' ){
             my $targets = {};
             $task->{Resource}{SpecUrls} ||= [];        #Структура для тасков по товарам с урлов
             $task->{Resource}{SpecFilters} ||= [];     #Структура для фильтров по товарам с урлов
             for my $cond (@$targdata){
                 $_->{type} = 'url' for grep { $_->{type} eq 'URL' } @{$cond->{Condition}}; #Исправляем имя поля урла
                 #Особый случай фильтрации, когда не должно быть товаров с урл
                 if( grep { ($_->{kind} eq 'not_equals') } @{$cond->{Condition}} ){ #Особый случай фильтрации, когда не должно быть товаров с урла
                     my $spec_cond = [ grep { ($_->{kind} eq 'not_equals') } @{$cond->{Condition}} ]; #Получаем специальные фильтры
                     push( @{ $task->{Resource}{SpecFilters} }, [ $cond->{DynamicConditionID}, $spec_cond ] ); #Сохраняем фильтры в специальную структуру
                     $cond->{Condition} = [ grep { ($_->{kind} ne 'not_equals') } @{$cond->{Condition}} ]; #Убираем условия из обычного фильтра
                 }
                 #Особый случай, когда урл приходит как отдельный таск
                 if( grep { ($_->{kind} eq 'equals') } @{$cond->{Condition}} ){ #Особый случай, когда урл приходит как отдельный таск
                     my $spec_urls = [ grep { ($_->{kind} eq 'equals') } @{$cond->{Condition}} ]; #Получаем специальные урлы для обхода
                     my $filter = [ grep { ($_->{kind} ne 'equals') } @{$cond->{Condition}} ];
                     $filter = BM::Filter::ext2bm($filter) || {};
                     push( @{ $task->{Resource}{SpecUrls} }, [ $cond->{DynamicConditionID}, $spec_urls, $filter ] );
                 }else{ #Обычный обход сайта
                     #Преобразование фильтра к стандартному виду
                     $targets->{$cond->{DynamicConditionID}} = BM::Filter::ext2bm($cond->{Condition}) || {};
                 }
             }
             $task->{Resource}{Targets} = $targets;
         }
    }

    $self->{'banners_dirs_param'} = 'perf_banners_dirs';

    $self->check_deprecated_options();
}

sub domains_remove_get_params {
    my ($self) = @_;
    return $self->proj->options->{domains_remove_get_params}->{perf};
}

########################################################
# Методы
########################################################

sub get_export_offers_dir {
    my $self = shift;
    return $self->proj->options->{perf_export_offers_dir};
}
sub get_svn_revision_file {
    my $self = shift;
    return $self->proj->options->{perf_svn_revision_file};
}

sub tablename : CACHE {
    my ($self) = @_;
    return 'PerfTasks';
}

sub get_banners_method_par {
    return {};
}

sub get_utp_fix_domains :GLOBALCACHE {
    my ($self) = @_;
    my $proj = $self->proj;
    my $dbt;
    if ($ENV{MR_BROADMATCH}) {
        $dbt = $proj->elem_factory->elem_from_db_dump('bannerland', 'PerfUtmProblemDomains');
    } else {
        $dbt = $proj->dbtable('PerfUtmProblemDomains', undef, 'bannerland_dbh');
    }
    my %h = map {$_->{domain} => 1} @{$dbt->List};
    return \%h;
}

sub fix_url_by_task {
    my ($self, $url) = @_;
    my $task = $self->taskinf;
    #$url =~ s/(?<=)utm_(?:source|medium|campaign|term|content)=[^\&]+\&?//; #удаление меток
    my $s = $self->proj->site($url);
    my $dmn = $s->domain;
    my $dmn2lvl = $s->domain_2lvl;
    if($self->get_utp_fix_domains->{$dmn} || $self->get_utp_fix_domains->{$dmn2lvl} || (($task->{Resource}{RemoveUtm}||'') eq 'YES') || (($task->{Resource}{RemoveUtm}||'') eq 'Yes')){
        #$url =~ s/(?<=)utm_(?:source|medium|campaign|term|content)=[^\&]+\&?//; #удаление меток
        $url =~ s/utm_(?:[_a-z0-9]+)=[^\&]+\&?//gi; #удаление меток
        $url =~ s/(\?|\&)$//g;
    }
    $url = $self->transf_url_macros($url); #Раскрытие макросов от Директа

    # add_param_to_url не используется

    # временный фикс для IRT-267
    if($task->{OrderID} == 6225951) {
        $url =~ s/(\?.+)//g;
        $url .= "?from=yandex_rm&utm_source=yandex_rm&utm_medium=rm&utm_campaign=proryv_msk_product_n_CID_detail_our_no_appliance";
    }

    # фикс для стенда IRT-894
    if($task->{OrderID} == 1100005 ){
        my $tail = 'type={source_type}&source={source}&added={addphrases}&addphrasestext={addphrasestext}&block={position_type}&pos={position}&key={keyword}&campaign={campaign_id}&retargeting={retargeting_id}&ad={ad_id}&adtarget_name={adtarget_name}&adtarget_id={adtarget_id}&banner_id={banner_id}&phrase={phrase_id}&gbid={gbid}&device={device_type}&region={region_id}&region_name={region_name}&offer_id{offer_id}&smartbanner_id={creative_id}';
        $url = $self->add_param_to_url( $url,  $tail );
    }

    return $url;
}

=h
    OfferPriceMinPriceRatio = Отношение цены оффера к минимальной цене модели в Маркете
    OfferPriceAvgPriceRatio = Отношение цены оффера к средней цене модели в Маркете
    OfferPriceMaxPriceRatio = Отношение цены оффера к максимальной цене модели в Маркете
    OfferModelReviewsCount = Количество оценок модели оффера в Маркете
    OfferModelRating = Звездочки модели оффера в Маркете
    OfferModelIsNew = Признак новизны модели оффера
    OffersCount = Количество офферов данной модели в Маркете
=cut

sub use_product_page_visit :CACHE {
    my $self = shift;
    return ($self->taskinf->{OrderID} ~~ @{$self->proj->options->{use_product_page_visit_orderids}}) ? 1 : 0;
}

sub get_effective_target_funnel {
    my $self = shift;
    my $target_funnel = shift;
    if ($target_funnel eq 'product_page_visit' and !$self->use_product_page_visit) {
        return 'same_products';
    } else {
        return $target_funnel;
    }
}

sub _get_templates_list : CACHE {
    my $proj = shift;
    return $proj->dbtable('PerfCustomTemplates', 'ID', 'bannerland_dbh')->List;
}

# используется в BMYT, там db_dump не меняется, от id не зависит - можно кешировать глобально
sub _get_templates_list_local :GLOBALCACHE {
    my $proj = shift;
    return $proj->elem_factory->elem_from_db_dump('bannerland', 'PerfCustomTemplates')->List;
}
sub get_custom_templates {
    my ($self, $domain, $adv_type) = @_;
    my $orderid = $self->taskinf->{OrderID};
    my $proj = $self->proj;
    my $templates_list;
    if ($ENV{MR_BROADMATCH}) {
        $templates_list = _get_templates_list_local($proj);
    } else {
        $templates_list = _get_templates_list($proj);
    }

    my ($text_templates, $title_templates);
    my @h = grep { ($_->{OrderIDOrDomain} eq 'orderid') and ($_->{OrderIDOrDomainValue} eq $orderid) and ($_->{AdvType} eq $adv_type) } @$templates_list;
    unless (@h) {
        my $domain_re = $domain;
        if ($domain_re =~ /^www\./) {
            $domain_re =~ s/^www\.//i;
            $domain_re = "(".(quotemeta $domain_re)."|".(quotemeta $domain).")";
        }
        @h = grep { ($_->{OrderIDOrDomain} eq 'domain') and ($_->{OrderIDOrDomainValue} =~ $domain_re) and ($_->{AdvType} eq $adv_type) } @$templates_list;
    }
    if (@h) {
        my $varialbes;
        my @r = map { $h[0]->{$_} } (qw/PhraseTemplates TitleTemplates Variables/);
        ($text_templates, $title_templates, $varialbes) = map { $h[0]->{$_} } (qw/PhraseTemplates TitleTemplates Variables/);
        my %replace = ();
        for my $t (split /\s*,\s*\n/, $varialbes) {
            $t =~ s/^\s+|\s+$//g;
            my @res = split /\s*=\s*/, $t, 2;
            $replace{$res[0]} = $res[1];
        }
        for my $k (sort { length $b <=> length $a } keys %replace) {
            my $re = quotemeta "[".$k."]";
            $text_templates =~ s/$re/[$replace{$k}]/g;
            $title_templates =~ s/$re/[$replace{$k}]/g;
        }
    }

    return ($text_templates, $title_templates);
}

sub task_feedurl_lock {
    my $self = shift;
    return "perf_" . $self->feedurl_md5;
}

sub get_default_input_tasks_yt_table: CACHE {
    my $self = shift;
    my $source_table;
    if (get_host_role() eq 'bannerland-preprod') {
        $source_table = $self->proj->options->{"perf_tasks_source_table_preprod"};
    } else {
        $source_table = $self->proj->options->{"perf_tasks_source_table"};
    }
    return $source_table;
}

sub get_task_type {
    return 'perf';
}

sub get_priority_order {
    my $self = shift;
    return $self->proj->options->{PerfSources}{priority_order};
}

1;
