package BM::BannersMaker::Tasks::TaskUtils;
use strict;

use Digest::MD5 qw(md5_hex);
use List::Util qw(maxstr);

use Utils::Sys qw(load_json);
use Utils::Hosts qw(get_hosts);

use base qw(Exporter);
our @EXPORT = qw/
    domain_to_dir
/;
our @EXPORT_OK = qw(
    get_task_file
    get_hash_remainder
    get_task_from_alljson
);

sub domain_to_dir {
    my ($domain) = @_;
    $domain = lc($domain);
    $domain =~ s/www\.//;
    $domain =~ s/\./_/g;
    return $domain;
}

sub filebegtime {
    my ($time) = @_;
    $time =~ s/ (\d+).+/_$1/g; #Срезаем минуты и секунды
    $time =~ s/[-:]//g;
    $time =~ s/[ ]/_/g;
    return $time;
}

# скачиваем файл с json таски
sub get_task_file {
    my $proj = shift;
    my $type = shift;
    my $task_id = shift;
    my $output_file = shift;

    my $table = ($type eq 'dyn') ? "DynTasks" : "PerfTasks";
    my $dbt = $proj->dbtable($table, 'TaskID', 'bannerland_dbh');
    my $task_info = $dbt->Get($task_id)
        or do { warn "Can't get task_info for $type:$task_id"; return };
    my $host = $task_info->{host};

    my $dmn_dir = $task_info->{domain_dir_name};
    my @task_files = split /\n/, $proj->read_sys_cmd_bash_remote($host, "find /opt/broadmatching/temp/${type}_banners/$dmn_dir -type f");
    @task_files = grep { m!/$task_id(_|/).*taskjson$! } @task_files;
    if (!@task_files) {
        warn "Can't find taskjson file for $type:$task_id";
        return;
    }
    my $fname = maxstr(@task_files);
    $proj->do_sys_cmd("scp -o StrictHostKeyChecking=no $host:$fname $output_file");
    return 1;
}

sub get_task_from_alljson {
    my $proj = shift;
    my $task_type = shift;
    my $task_ids = shift;

    my @hosts = get_hosts(role => 'bannerland', master => 1);
    my $host = $hosts[0];

    my $src = "/opt/broadmatching/temp/${task_type}_banners/${task_type}tasks_all.json";
    my $dst = $proj->get_tempfile("${task_type}_all.json", UNLINK => 1);
    $proj->do_sys_cmd("scp $host:$src $dst");

    my $data = load_json($dst);

    my %todo = map { $_ => 1 } @$task_ids;
    my %res;
    for my $taskinf (@$data) {
        my $obj = $proj->get_task_obj($task_type, $taskinf);
        my $tid = $obj->task_id;
        if ($todo{$tid}) {
            $res{$tid} = $taskinf;
        }
    }

    return \%res;
}

# остаток от деления хэша по модулю; соответствует питоновскому int(md5.new(arg).hexdigest(), base=16) % mod
sub get_hash_remainder {
    my $arg = shift;
    my $mod = shift;

    my $md5 = md5_hex($arg);
    my $sum = 0;
    my $pow = 1;
    for my $s (reverse split //, $md5) {
        $sum = ($sum + hex($s) * $pow) % $mod;
        $pow = ($pow * 16) % $mod;
    }
    return $sum;
}

1;
