package BM::BroadKyoto;

use strict;

use utf8;

use base qw(ObjLib::Obj);
use Encode;
use Storable;
use Utils::Sys qw[ md5int ];
use ObjLib::Timer;
use MIME::Base64;
use Data::Dumper;

sub get {
    my ( $self, $key ) = @_;
    my $new_key = md5int($key);
    my $res_raw = $self->{kyoto}->get( $new_key );
    if ( $res_raw ) {
       return ${Storable::thaw( MIME::Base64::decode_base64( $res_raw ) )};
    }
    return undef;
}

sub set {
    my ( $self, $key, $value, $timeout ) = @_;
    $timeout //= $self->{timeout};
    my $new_key = md5int($key);
    my $new_value = MIME::Base64::encode_base64(Storable::freeze( \$value ));
    my $res = $self->{kyoto}->set( $new_key, $new_value, $timeout );
    return $res;  
}

sub delete {
    my ( $self, $key ) = @_;
    my $new_key = md5int($key);
    my $res = $self->{kyoto}->delete($new_key);
    return $res;
}

sub get_multi {
    my ( $self, @get_array ) = @_;

    my $encoding_hash = { map { md5int($_) => $_ } @get_array };

    # init result hash with undef values
    my $result_hash = { map { $_ => undef } @get_array };
    my @small_array = splice( @get_array, 0, $self->{keys_pack} );
    my $res = {};
    while ( @small_array ) {
	@small_array = map { md5int($_) } @small_array;
        my $small_res = $self->{kyoto}->get_multi( @small_array );
        for my $encoded_key ( keys %$small_res ) {
            if ( exists( $encoding_hash->{$encoded_key} ) ) {
                $result_hash->{ $encoding_hash->{$encoded_key} } = 
                    ${Storable::thaw( MIME::Base64::decode_base64( $small_res->{$encoded_key} ) )};
            }
        }
        @small_array = splice( @get_array, 0, $self->{keys_pack} );
    }
    return $result_hash;
}

sub set_multi {
    my ( $self, @set_array ) = @_;
    my %res = ();

    my $rehash_result = { map { md5int($_->[0]) => $_->[0] } @set_array };

    my @small_array = splice( @set_array, 0, $self->{keys_pack} );
    while ( @small_array ) {
	@small_array = map { [
	   md5int($_->[0]),
	   MIME::Base64::encode_base64(Storable::freeze( \$_->[1] )),
	   $_->[2] // $self->{timeout},
	] } @small_array;
        my $small_res = $self->{kyoto}->set_multi( @small_array );
        %res = ( %res, %$small_res );
        @small_array = splice( @set_array, 0, $self->{keys_pack} );
    }
    return { map { $rehash_result->{$_} => $res{$_} } keys %res };
}

sub delete_multi {
    my ( $self, @delete_array ) = @_;

    my $rehash_result = { map { md5int($_) => $_ } @delete_array };

    my %res = ();
    my @small_array = splice( @delete_array, 0, $self->{keys_pack} );
    while ( @small_array ) {
	@small_array = map { md5int($_) } @small_array;
        my $small_res = $self->{kyoto}->delete_multi( @small_array );
        %res = ( %res, %$small_res );
        @small_array = splice( @delete_array, 0, $self->{keys_pack} );
    }

    return { map { $rehash_result->{$_} => $res{$_} } keys %res };
}

1;
