package BM::Categories::CategoryGroups;

use strict;

use utf8;
use open ':utf8';
no warnings 'utf8';
use base qw(ObjLib::ProjPart);

use Data::Dumper;
use Utils::Common;
use JSON::XS;

use Utils::Sys qw(md5int);

########################################################
# Интерфейс
########################################################

__PACKAGE__->mk_accessors(qw(
    name
    file
    is_loaded
    direct_mapping_file
));

sub load_data {
    my ($self) = @_;
    my $num_chars;

    $self->log("groups " . $self->name);

    open F, $self->file or $self->log("ERROR: $!");
    my ($h1, $h2, $h3, $h4) = <F>;
    close F;

    my $json = JSON::XS->new;

    chomp $h1;
    ($self->{categ2group}, $num_chars) = $json->decode_prefix($h1);
    $self->log("WARNING: only $num_chars/".length($h1)." characters were parsed") if $num_chars && $num_chars < length($h1);

    chomp $h2;
    ($self->{groups_fix}, $num_chars) = $json->decode($h2);
    $self->log("WARNING: only $num_chars/".length($h2)." characters were parsed") if $num_chars && $num_chars < length($h2);

    if(!$h3) {
        $self->{brandgroups} = [];
    } else {
        chomp $h3;
        ($self->{brandgroups}, $num_chars) = $json->decode($h3);
        $self->log("WARNING: only $num_chars/".length($h3)." characters were parsed") if $num_chars && $num_chars < length($h3);
    }

    if(!$h4) {
        $self->{group2secondlevelgroup} = {};
    } else {
        chomp $h4;
        ($self->{group2secondlevelgroup}, $num_chars) = $json->decode($h4);
        $self->log("WARNING: only $num_chars/".length($h4)." characters were parsed") if $num_chars && $num_chars < length($h4);
    }


    $self->{group2directid} = {};
    if ($self->direct_mapping_file) {
        open F, $self->direct_mapping_file or $self->log("ERROR: $!");
        while (<F>) {
            chomp;
            my ($directid, $groupname) = split /\t/, $_, 2;
            $self->{group2directid}->{$groupname} = $directid if $directid && $groupname;
        }
        close F;
    }

    $self->{is_loaded} = 1;

    $self->log("/ groups " . $self->name);
}

sub group2directid {
    my $self = shift;
    $self->load_data unless exists $self->{group2directid};
    return $self->{group2directid};
}

sub is_mapped_to_direct {
    my $self = shift;
    return $self->direct_mapping_file ? 1 : 0;
}

sub save_data {
    my ($self) = @_;
    my $proj = $self->proj;
    my $temp_file = $proj->get_tempfile('groups.json');
    my $json = JSON::XS->new;

    $proj->log("load data from db");
    my $h1 = $self->categ2group;
    my $h2 = [$self->groups_fix];
    my $h3 = $self->brandgroups;
    my $h4 = $self->group2secondlevelgroup;
    $proj->log("/ load data from db");

    open F, "> $temp_file" or die($!);
    print F $json->encode($_) . "\n" for ($h1, $h2, $h3, $h4);
    close F;

    $proj->do_sys_cmd("mv $temp_file ".$self->file);
}

sub categ2group {
    my ($self) = @_;

    if(!$self->{categ2group}) {
        if($self->proj->{dbgroups}) {
            my $h = {};

            push @{$h->{$_->{categ}} ||= []}, $_->{$self->{db_categ2group_fld_group}} for map {@$_} $self->proj->dbtable($self->{db_categ2group})->List;

            $self->{categ2group} = $h;
        } else {
            $self->load_data;
        }
    }

    return $self->{categ2group};
}

sub group2secondlevelgroup {
    my ($self) = @_;

    if(!$self->{group2secondlevelgroup}) {
        if($self->proj->{dbgroups}) {
            $self->{group2secondlevelgroup} = {};
            if ($self->{db_secondlevel}) {
                push @{$self->{group2secondlevelgroup}->{$_->{$self->{db_categ2group_fld_group}}}}, $_->{level2} foreach @{$self->proj->dbtable($self->{db_secondlevel})->List};
            }
        } else {
            $self->load_data;
        }
    }

    return $self->{group2secondlevelgroup};
}


sub group2categ :CACHE {
    my ($self) = @_;

    my $h = $self->categ2group;
    my $hh = {};
    for my $k (keys %$h){
        for my $m (@{ $h->{$k} }){
            $hh->{$m} ||= [];
            push(@{ $hh->{$m} }, $k);
        }
    }
    return $hh;
}

sub groups_fix {
    my ($self) = @_;

    if(!$self->{groups_fix}) {
        if ($self->proj->{dbgroups}) {
            if ($self->{db_fix}) {
                my @arr =
                    map { [split /\s*->\s*/, $_] }
                    grep { ! /^\s*$/ } grep { ! /^#/ }
                    map { split(/\r?\n/, $_->{rules}) } map { @$_ } $self->proj->dbtable($self->{db_fix})->List;
                
                $_->[0] =~ s/\s*\(.*\)|\w\d+\w*//g for @arr;
                $_->[1] =~ s/\s*\(.*\)|\w\d+\w*//g for @arr;
                $_->[0] =~ s/^\s+|\s+$//g for @arr;
                $_->[1] =~ s/^\s+|\s+$//g for @arr;
            
                #дополнительные категории родителей, которые нужно дописывать
                my $h = {};
                for my $t (@arr) {
                    if ( $t->[1] =~ /^\s*\*\s*(.+)/ ) {
                        $h->{$_}{$t->[1]}++ for $self->proj->get_minicategs_subtrees($1);
                    } 
                }
                #Хэш хэшей превращаем в хэш массивов
                $h->{$_} = [ keys %{$h->{$_}} ] for keys %$h;

                #Разворачиваем категории с * в их список детей
                @arr = map {
                    my $t = $_;
                    $t->[0] =~ /^\s*\*\s*(.+)/ 
                        ? map { [$_, $t->[1] ] } $self->proj->get_minicategs_subtrees($1) 
                        : $t
                } @arr;

                my $fixh = { map { my $t = $_; (join '/', sort @$_ ) => $t->[0] } @arr };
             
                $self->{groups_fix} = [ $fixh, $h ];
            } else {
                $self->{groups_fix} = [];
            }
        } else {
            $self->load_data;
        }
    }

    return @{$self->{groups_fix}};
}

sub brandgroups {
    my ($self) = @_;

    if(!$self->{brandgroups}) {
        if($self->proj->{dbgroups}) {
            if($self->{db_brandgroups}) {
                my $items = $self->proj->dbtable($self->{db_brandgroups})->List; 
                $self->{brandgroups} = [ map{[ $_->{domain}, $_->{brandgroup} ]} @$items ];
            } else {
                $self->{brandgroups} = [];
            }
        } else {
            $self->load_data;
        }
    }

    return $self->{brandgroups};
}

sub generate_groups_tree {
    my ($self) = @_;
    my $ct = $self->proj->categs_tree;
    return map { [
            @{$_}{$self->{db_categ2group_fld_group}, "categ"},
            md5int( $_->{$self->{db_categ2group_fld_group}} ),
            $ct->get_minicateg_directid($_->{categ}),
        ] } map {@$_} $self->proj->List_SQL('select '.$self->{db_categ2group_fld_group}.', categ from ' . $self->{db_categ2group});
}

1;

