package BM::Categories::Layer;

use strict;

use utf8;
use open ':utf8';
no warnings 'utf8';
use base qw(ObjLib::ProjPart);

use Data::Dumper;
use Time::HiRes qw/gettimeofday tv_interval/;
use BM::Phrase;
use Utils::Common;
use Utils::SubsetIndex;
use URI::Escape;
use List::Util qw(sum);
use Scalar::Util qw(looks_like_number);

########################################################
# Интерфейс
########################################################

__PACKAGE__->mk_accessors(qw(  
    name
    is_ready
    orighash
));

########################################################
# Инициализация
########################################################

# настройки объекта:
#
# use_norm_with_stops       не выкидывать стоп-слова и не использовать синонимы
# max_words_dist            максимальное расстояние между найденными в тексте словами подфразы
# dont_sort                 не сортировать слова
#

sub init {
    my ($self) = @_;
    
    $self->{is_ready} = 0;
    $self->{orighash} = {};
}

sub norm_phr {
    my ($self, $ph) = @_;

    return $self->{use_norm_with_stops} ? $ph->norm_phr_with_stops : $ph->snorm_phr;
}

sub add_phrase {
    my ($self, $ph, $data) = @_;

    $self->add_text($self->norm_phr($ph), $data);
}

sub get_phrase_data {
    my ($self, $ph) = @_;

    return $self->get_text_data($self->norm_phr($ph));
}

sub _phrase_words_arr {
    my ($self, $ph) = @_;
        
    return [$ph->normwords_with_stops] if $self->{use_norm_with_stops};
    return [$ph->uniqsnormwords];
}

sub set_orig_phrase {
    my ($self, $categ, $snorm, $orig) = @_;

    push @{($self->{orighash}{$categ} ||= {})->{$snorm} ||= []}, $orig;
}

sub get_orig_phrases {
    my ($self, $categ, $snorm) = @_;

    return ($self->{orighash}{$categ} || {})->{$snorm} || [];
}

# возвращает оставшиеся формы фразы
sub remove_orig_phrase {
    my ($self, $categ, $snorm, $orig) = @_;
    my $arr = ($self->{orighash}{$categ} ||= {})->{$snorm} || [];

    return ($self->{orighash}{$categ}{$snorm} = [grep{$_ ne $orig} @$arr]);
}

sub get_orig_phrase {
    my ($self, $categ, $snorm) = @_;
    my $arr = $self->get_orig_phrases($categ, $snorm);

    return $arr->[0] if @$arr;
    return $snorm;
}

# массив фраз категории в том виде, как они были записаны в словаре
sub get_category_raw_phrases {
    my ($self, $categ) = @_;
    my %h = map{$_ => 1} map{@{$self->{orighash}{$categ}{$_}}} keys %{$self->{orighash}{$categ} || {}};
    return sort keys %h;
}

#
# методы, которые должны быть реализованы в потомках класса
#

sub add_text {
    my ($self, $ph, $data) = @_;
    
    # добавление новой фразы в индекс
}

sub get_phrases {
    my ($self) = @_;

    # получение списка всех фраз в индексе
    return ();
}

sub get_text_data {
    my ($self, $ph) = @_;

    # получение данных для строки (без поиска подфраз)
}

sub search_subphrases_data_for_phl {
    my ($self, $phl, $field_name) = @_;

    # поиск подфраз для PhraseList, запись в поле $field_name для каждой фразы
}

sub search_subphrases_data {
    my ($self, $ph) = @_;
    
    # поиск подфраз для фразы
    return {};
}

sub prepare {
    my ($self) = @_;

    # подготовка индекса перед первым использованием
    $self->{is_ready} = 1;
}

1;
