package BM::Categories::LocalLayer;

use strict;

use utf8;
use open ':utf8';
no warnings 'utf8';
use base qw(BM::Categories::Layer);

use Data::Dumper;
use Time::HiRes qw/gettimeofday tv_interval/;
use BM::Phrase;
use Utils::Common;
use Utils::SubsetIndex;
use URI::Escape;
use List::Util qw(sum);
use Scalar::Util qw(looks_like_number);

sub init {
    my ($self) = @_;
    
    $self->{phrases_data} = {};
    $self->SUPER::init;
}

sub is_local {
    my ($self) = @_;
    return 1;
}

sub add_text {
    my ($self, $ph, $data) = @_;

    $self->{phrases_data}{$ph} = $data;
}

sub get_phrases {
    my ($self) = @_;

    return keys %{$self->{phrases_data}};
}

sub get_text_data {
    my ($self, $ph) = @_;

    return $self->{phrases_data}{$ph};
}

sub _local_get_subphrases {
    my ($self, $ph) = @_;

    my %opts;
    $opts{max_dist} = $self->{max_words_dist} if $self->{max_words_dist};

    return () if !$self->{local_index};

    return map{join " ", @$_} $self->{local_index}->search_subsets($self->_phrase_words_arr($ph), %opts);
}

sub search_subphrases_data_for_phl {
    my ($self, $phl, $field_name) = @_;

    for my $ph ($phl->phrases) {
        my @phrases = $self->_local_get_subphrases($ph);

        $ph->{$field_name} = {map{$_ => $self->{phrases_data}{$_}} @phrases};
    }
}

sub search_subphrases_data {
    my ($self, $ph) = @_;
    my @phrases = $self->_local_get_subphrases($ph);

    return {map{$_ => $self->{phrases_data}{$_}} @phrases};
}

sub prepare {
    my ($self) = @_;
    my $fwords;

    $self->{local_index} = Utils::SubsetIndex->new;
    $self->{local_index}{dont_sort} = $self->{dont_sort};
    $self->{local_index}->fill_index(map{[split " "]} keys %{$self->{phrases_data}});

    $self->SUPER::prepare;
}

1;
