package BM::Categories::PagesCategories;

use utf8;
use open ':utf8';

use std;
use base qw(ObjLib::ProjPart);

use BM::Phrase;

use Utils::Sys;

use Data::Dumper;
use List::Util qw(max min sum);
use BM::Phrase;
use Time::HiRes qw(usleep);
use FindBin;
use FileHandle;
use IPC::Open3;
use Time::HiRes qw(tv_interval gettimeofday);

########################################################
#Доступ к полям
########################################################

__PACKAGE__->mk_accessors(qw(
    language
));

########################################################
# Интерфейс
########################################################
#

sub init {
    my ($self) = @_;

    $self->{get_phrase_weight} = sub { return 1; };
}

sub domain2categs {
    my ($self) = @_;

    if(!$self->{domain2categs}) {
        # костыль для отдельных доменов
        $self->{domain2categs} = {};
        $self->log("load domain2categs");
        open F, $self->{domains_file} or $self->log("ERROR: can't open ".$self->{domains_file});
        while(<F>) {
            chomp;
            my ($url, $cts) = split "\t";
            my @categs = split "/", $cts;

            my $domain = $self->proj->page($url)->domain;
            if(!$domain) {
                $self->log("WARNING: bad domain for url '$url'");
                next;
            }

            $self->{domain2categs}{$domain} = [@categs];
        }
        close F;
        $self->log("/ load domain2categs");
    }

    return $self->{domain2categs};
}

# фразы, которые нужно выкидывать из категоризации
sub bad_categ_phrases {
    my ($self) = @_;

    if(!$self->{bad_categ_phrases}) {
        $self->{bad_categ_phrases} = {map{$self->language->phrase($_)->snorm_phr => 1} 
            qw(mail галерея история магазин новости продукт сеть фотогалерея ип английский) 
        };
    }

    return $self->{bad_categ_phrases};
}

# категоризация объекта Page
sub categorize_page {
    my ($self, $page, %opts) = @_;
    my @cts = $self->get_static_domain_categs($page);
    
    return @cts if @cts;
    return $self->categorize_one_line($page->one_line_text, %opts);
}

sub categorize_page_debug_inf {
    my ($self, $page) = @_;
    #return [ $self->get_page_categs_subphrases($page->one_line_text) ];
    my $ptext = $page->one_line_text;
    $ptext = $self->preprocess_page_text($ptext);
    my @arr = $self->get_page_tag_phrase_pairs($ptext);
    #push(@arr, $self->get_page_href_pairs($ptext)) ; 
    for my $pr (@arr){
        my $catinf = $self->get_subphrases_for_tag_phrase_pairs($pr);
        #print Dumper('RRRRRRR', $pr, $catinf);
        if( $catinf ){
            $pr->[2] ||= [];
            push( @{$pr->[2]},  map { $_.' => '.join('/', keys %{$catinf->{$_}{categs} || {}}) } keys %$catinf );
        }
    }
    return \@arr;
}

# категоризация текста страницы, записанного одной строкой (без \n)
sub categorize_one_line {
    my ($self, $page, %opts) = @_;

    my %found;
    my %tagw = (title => 10, h1 => 8, h2 => 1, keywords => 1, description => 1);

    my $subphrases = $self->get_page_categs_subphrases($page, %opts);
    #print Dumper ( $subphrases );
#    exit;
    
    #Фильтр по текстам фраз
    #my $flt = $self->proj->page;
    #print Dumper($subphrases);
    #$self->proj->dd($subphrases);

    # считаем статистику по категориям
    my %cts;
    for my $ph (sort keys %$subphrases) {
        #next if $flt->check_badre_text($ph);
        my $pobj = $self->proj->snormed_phrase($ph);
        my $pw = $self->{get_phrase_weight}->($pobj);
        my @cts = keys %{$subphrases->{$ph}{categs}};
        $cts{$_} += $pw * sum(map{$tagw{$_} || 1} keys %{$subphrases->{$ph}{tags}})  for @cts;
    }
    #print Dumper(['D1', \%cts]);

    # очистка по иерархии
    my %clean_cts;
    for my $ct (keys %cts) {
        next if !$self->proj->categs_tree->get_minicateg_parent($ct);
        my @children = grep{$cts{$_}} $self->proj->categs_tree->get_minicateg_children($ct);
        next if scalar(@children) == 1 && $cts{$children[0]} == $cts{$ct};
        $clean_cts{$ct} = $cts{$ct};
    }
    %cts = %clean_cts;
    #print Dumper(['D2', \%cts]);

    my @top = sort{$b->[1] <=> $a->[1]} map{[$_, $cts{$_}]} keys %cts;

    return sort map{$_->[0]} grep{2 * $_->[1] > $top[0]->[1]} @top; 
}

# категории конкретного домена из словаря
sub get_static_domain_categs {
    my ($self, $page) = @_;
    my $cts = $self->domain2categs->{$page->domain} || [];

    return () if grep{!$self->proj->categs_tree->get_minicateg_id($_)} @$cts;
    return @$cts;
}

sub preprocess_tag_phrase_pairs {
    my ($self, @data) = @_;
    my @result;

    #Фильтр по текстам фраз
    my $flt = $self->proj->page;
        
    for (@data) {
        my ($tag, $text) = map{lc $_} @$_;

        #if($tag ne 'a'){ $text =~ /<a[ \>].+<\/a>/g; } #Удаляем из тэгов вложенные ссылки, так как они обрабатываются отдельно

        $text =~ s/"[^"]+"/ /g;                 # кавычки ""
        $text =~ s/\&laquo;.+?\&raquo;/ /g;     # кавычки laquo/raquo
        $text =~ s/<[^>]+>//g;                  # вложенные тэги
        $text =~ s/\s+/ /g;                     # лишние пробелы
        $text =~ s/\s+в\s+подарок/ /g;          
        $text =~ s/^(инструкция|расписание) \|/ /g;
        $text =~ s/(?<=[А-Яа-я])\.ru( |$)/ _ru /g; 
        $text =~ s/\.ru( |$)/_ru /g; 
        
        # пропускаем служебные фрагменты
        next if !$self->is_good_for_categs($text);

        #print Dumper([$text, $flt->check_badre_text($text), $self->proj->phrase($text)->get_minicategs]);
        next if ($tag ne 'title') && $flt->check_badre_text($text);

        push @result, [$tag, $text];
    }
#    print Dumper (\@result);
#    exit;
    
    return @result;
}

sub get_page_tag_phrase_pairs {
    my ($self, $page, %opts) = @_;
#    print STDERR $page . "\n";

    # ищем интересующие тэги
    my @data = $page =~ /<(title|h1|h2)[^>]*>(.*?)<\/\1/ig;
    #print Dumper(\@data);
    
    # содержимое meta
    my @metas = $page =~ /<meta ([^>]+)/ig;
    for my $meta (@metas) {
        my ($name) = $meta =~ /name\s*=\s*\"?(description|keywords)/i;
        next if !$name;
        my ($content) = $meta =~ /content\s*=\s*\"([^"]+)/i;
        next if !$content;
        push @data, $name;
        push @data, $content;
    }
#    print STDERR Dumper (\@data);

    my @taglist = map{[$data[2 * $_], $data[2 * $_ + 1]]} 0..(scalar(@data) / 2 - 1);
    #print Dumper(\@taglist);

    return $self->preprocess_tag_phrase_pairs(@taglist);
    #return $self->preprocess_tag_phrase_pairs(map{[$data[2 * $_], $data[2 * $_ + 1]]} 0..(scalar(@data) / 2 - 1));
}

sub get_page_href_pairs {
    my ($self, $page) = @_;

    my @data = $page =~ /<a\s([^>]*)>(.*?)<\/a/ig;

    my %urls;
    my @hrefs;
    for(my $i = 0; $i < @data; $i += 2) {
        my ($url) = $data[$i] =~ /href=["']?([^\s]+)/;
        next if !$url || $url =~ /mailto:/;

        $urls{$url}++;
        push @hrefs, [$url, $data[$i + 1]];
    }

    return $self->preprocess_tag_phrase_pairs(map{["a", $_->[1]]} grep{$_->[0] !~ /^http:\/\// || $urls{$_->[0]} > 1} @hrefs);
}

sub get_subphrases_for_tag_phrase_pairs {
    my ($self, @data) = @_;
    my $result = {};
   
    # предобработка фраз
    my @phdata;
    for (@data) {
        my ($tag, $text) = @$_;

        my @words = $self->language->phrase($text)->pluswords;

        # обрезаем слишком длинные фразы
        my $num_words = @words;
        $num_words = min(10, $num_words);

        my $pobj = $self->language->phrase(join " ", @words[0..($num_words - 1)]);
        push @phdata, [$tag, $pobj, $text];
    }
    
    # для категоризации фраз включаем пакетную обработку
    my $phl = $self->proj->phrase_list({ phrases_list => [map{$_->[1]} @phdata] });
    $phl->enable_categs_pack;

#print STDERR Dumper(["get_subphrases_for_tag_phrase_pairs:",\@phdata]);
    for (@phdata) {
        my ($tag, $pobj, $text) = @$_;
        #print STDERR "get_subphrases_for_tag_phrase_pairs: $tag => $pobj \n";
        my $h = $pobj->decode_minicategs_subphrases_hash;
        #print STDERR Dumper([$h, [ grep{!$self->bad_categ_phrases()->{$_}} keys %$h ]]);
        for my $ph (grep{!$self->bad_categ_phrases()->{$_}} keys %$h) {
            $result->{$ph} ||= {orig_texts => {}, tags => {}, categs => $h->{$ph}};
            $result->{$ph}{tags}{$tag}++;
            $result->{$ph}{orig_texts}{$tag. ' => '. $text}++;
            #print STDERR "get_subphrases_for_tag_phrase_pairs ok\n";
        }
    }
#print STDERR Dumper([ "get_subphrases_for_tag_phrase_pairs result:", $result ]);
    return $result;
}

sub hier_categs_subphrases {
    my ($self, $phrase2categs) = @_;
    my $result = {};

    for my $ph (keys %$phrase2categs) {
        $result->{$ph} = {tags => $phrase2categs->{$ph}{tags}, categs => {}};
        for my $ct (keys %{$phrase2categs->{$ph}{categs}}) {
            for (my $parent = $ct; $parent; $parent = $self->proj->categs_tree->get_minicateg_parent($parent)) {
                $result->{$ph}{categs}{$parent} += $phrase2categs->{$ph}{categs}{$ct};
            }
        }
    }

    return $result;
}

# предобработка текста страницы
sub preprocess_page_text {
    my ($self, $page) = @_;

    $page =~ s/\s+/ /g;
    $page =~ s/\&nbsp;/ /g;
    $page =~ s/\&shy;//g;
    $page =~ s/<script .*?<\/script>//g;
    $page =~ s/<noscript .*?<\/noscript>//g;

    return $page;
}

# ищет на странице категорийные подфразы
# возвращает ссылку на хэш вида
# фраза => {tags => {хэш тэгов}, categs => {хэш категориий}}
sub get_page_categs_subphrases {
    my ($self, $page, %opts) = @_;

    # предобработка текста страницы
    $page = $self->preprocess_page_text($page);
    #print Dumper($page);

    # ищем подфразы категорий
    my @data = $self->get_page_tag_phrase_pairs($page, %opts);
    #print Dumper(\@data);
    my $phrase2categs = $self->get_subphrases_for_tag_phrase_pairs(@data);
#print STDERR Dumper( $phrase2categs );

    # если не получилось, пытаемся извлечь информацию из ссылок на странице
    if(! $opts{ dont_use_hrefs }){ 
        if(!%$phrase2categs) {
            my @data = $self->get_page_href_pairs($page);
            if ((exists $opts{no_hier}) and $opts{no_hier}) {
                $phrase2categs = $self->get_subphrases_for_tag_phrase_pairs(@data);
            }
            else {
                $phrase2categs = $self->hier_categs_subphrases($self->get_subphrases_for_tag_phrase_pairs(@data));
            }
        }
    }

#print STDERR Dumper ( $phrase2categs );
    return $phrase2categs;
}

sub is_good_for_categs {
    my ($self, $text) = @_;

    return 0 if $text =~ /^\s*$/;

    # отбрасываем неинформативные фрагменты
    return 0 if (
        # системы управления контентом
        $text =~ /joomla/ ||                                                          

        # контактная информация
        $text =~ /^(e-mail|эл\. почта|тел\.|skype:|icq:|контактная информация|информация о компании)/ ||

        # навигация
        $text =~ /^(фотогалерея|галерея|новости|последние новости|гостевая книга|навигация)/);

    return 1;
}

1;
