package BM::Categories::RemoteLayer;

use strict;

use utf8;
use open ':utf8';
no warnings 'utf8';
use base qw(BM::Categories::Layer);

use Data::Dumper;
use Time::HiRes qw/gettimeofday tv_interval/;
use BM::Phrase;
use Utils::Common;
use Utils::SubsetIndex;
use URI::Escape;
use List::Util qw(sum);
use Scalar::Util qw(looks_like_number);

sub is_local {
    my ($self) = @_;

    return 0;
}

sub add_text {
    my ($self, $ph, $data) = @_;

    $self->proj->subphrases_client->exec_command(
        join("\t", "add", $self->name, $ph, $data));
}

sub get_text_data {
    my ($self, $ph) = @_;
    my $cmd = "data\t" . $self->name . "\t$ph";
    my $resp = $self->proj->subphrases_client->exec_command($cmd);

    return substr($resp, 3)
}

sub search_subphrases_data_for_phl {
    my ($self, $phl, $field_name) = @_;
    my $cmd = join("\t", "getn", $self->name, join(",", map{$self->norm_phr($_)} $phl->phrases));
    my $resp = $self->proj->subphrases_client->exec_command($cmd);
    $resp =~ s/OK\t?//;
    if(!$resp) {
        $_->{$field_name} = {} for @$phl;
        return;
    }
    my @data = split "\t", $resp;
    my $i = 0;
    for my $ph ($phl->phrases) {
        last if $i > @data;
        my $next = $i + $data[$i] + 1;
        my %result = @data[($i+1)..($next - 1)];
        $i = $next;
        $ph->{$field_name} = \%result;
    }
}

sub search_subphrases_data {
    my ($self, $ph) = @_;
    my $norm = $self->norm_phr($ph);
    my $resp = $self->proj->subphrases_client->exec_command(join("\t", "get", $self->name, $norm));
    my @data = split "\t", $resp;

    push @data, "" if $resp =~ /\t$/;

    if(!(scalar(@data) % 2)) {
        $self->log("WARNING: search_subphrases_data bad response for '".$self->name."' / '$norm' ");
        $self->log("(the response was '" . join("\t", @data) . "')");
    }

    shift @data;
    my %result = @data;

    return \%result;
}

sub remove_orig_phrase {
    my ($self, $categ, $snorm, $orig) = @_;
    my $curr_orig = $self->get_orig_phrases($categ, $snorm);
    my $new_orig = [grep{$_ ne $orig} @$curr_orig];
    
    $self->proj->subphrases_client->exec_command(join("\t", "setorig", $self->name, $categ, $snorm, join(",", @$new_orig)));

    return $new_orig;
}

sub set_orig_phrase {
    my ($self, $categ, $snorm, $orig) = @_;

    return if !$categ;

    my $curr_orig = $self->get_orig_phrases($categ, $snorm);
    my %h = map{$_ => 1} @$curr_orig;

    $h{$orig}++;
    $self->proj->subphrases_client->exec_command(join("\t", "setorig", $self->name, $categ, $snorm, join(",", sort keys %h)));
}

sub get_orig_phrases {
    my ($self, $categ, $snorm) = @_;

    return [] if !$categ;

    my $cmd = join "\t", "getorig", $self->name, $categ, $snorm;
    my $resp = $self->proj->subphrases_client->exec_command_once($cmd);
    return [] if !defined($resp);

    $resp =~ s/^OK\t?//;

    return [$self->proj->categs_tree->split_phrases_text($resp, keep_spaces => 1)];
}

sub get_category_raw_phrases {
    my ($self, $categ) = @_;

    return @{$self->get_orig_phrases($categ, "%RAW")};
}

1;
