package BM::CategoriesTextFields;

use strict;
use utf8;
use open ':utf8';

use base qw(ObjLib::ProjPart);

use Data::Dumper;
use Utils::Common;
use JSON;

sub init {
    my ($self) = @_;

    my $dict_file = $Utils::Common::options->{dirs}{dicts} . '/dict_categories_text_fields';
    open (my $dict_fh, '<', $dict_file) or die($!);
    while (my $json_text = <$dict_fh>) {
        chomp($json_text);
        my $text_field = JSON::from_json($json_text);
        $self->{data}{join('_', @{$text_field}{qw/CatID Language/}, Utils::Sys::md5int($text_field->{Key}))} = $text_field;
    }
    close $dict_fh or die($!);
}

sub get_value {
    my ($self, $cat_id, $field, $lang) = @_;

    my $proj = $self->proj;
    $cat_id = $proj->categs_tree->get_minicateg_id($cat_id) || $cat_id;
    $lang ||= 'ru';
    my $field_id = Utils::Sys::md5int($field);

    return ($self->{data}{join('_', $cat_id, $lang, $field_id)} || {})->{'Value'};
}

1;
