package BM::CategoriesTree;

use base qw(ObjLib::ProjPart);
use BM::PhraseCategs;
use Data::Dumper;

my @ACCESSORS = qw{
    never_read_categs_cache
    never_write_categs_cache
    never_suppress_categs
    dont_use_catalysts
    use_categs_biwords
    use_virtual_categs
    always_spdiff
    categs_strict_subphrases
};

for my $accessor (@ACCESSORS) {
    *{$accessor} = sub {
        my $self = shift;
        no strict 'refs';
        ${"BM::PhraseCategs::$accessor"} = $_[0] if @_;
        return ${"BM::PhraseCategs::$accessor"};
    }
}

sub get_category_raw_phrases {
    my ($self, $categ) = @_;

    return $self->proj->default_language->get_category_raw_phrases($categ);
}

# методы, которые нужно вызывать как методы Phrase
sub get_cat_path {
    my $self = shift;
    $self->proj->phrase('dummy')->get_cat_path(@_);
}


sub init {
    my ($self) = @_;

    my $params = $self->proj->options->{CategoriesTree_params};
    for my $accessor (@ACCESSORS) {
        next unless exists $params->{$accessor};
        no strict; $accessor->($self, $params->{$accessor}); use strict;
    }
    
    # кэширование поддеревьев
#    $self->{subtrees_ids} = {};
#    for my $categ ($self->get_minicategs_list()) {
#        my $id = $self->get_minicateg_id($categ);
#        $self->{subtrees_ids}{$id} = [map{$self->get_minicateg_id($_)} $self->get_minicategs_subtrees($categ)];
#    }
}

sub ref_get_minicateg_by_id {
    return \&BM::PhraseCategs::get_minicateg_by_id;
}

#Кэшируем выдачу, так как доступ дорогой, а категорий мало
sub cached_get_minicateg_parent {
    my ($self, $cat) = @_;
    $self->{_cached_get_minicateg_parent}{$cat} //= $self->get_minicateg_parent($cat);
    return $self->{_cached_get_minicateg_parent}{$cat};
} 

sub minicategs_to_related_minicategs_hash {
    my ($self, $categs) = @_;
#$self->proj->dd('fffffffffff', $categs);
    my $ctree = $self->proj->phrase('');
    my @catnms = @$categs;
    my %gvrt = map {$_ => 1} map { /(.*) _ /; $1 } grep { / _ / } @catnms;
    #$self->proj->dd(\@catnms, \%gvrt);
    my %cth = ();
    $cth{$_}++ for @catnms; #Добавляем сами категории
    #Добавляем путь наверх
    $cth{$_}++ for map { $ctree->get_cat_path($_) } @catnms;
    #Добавляем подкатегории, сиблинги и невьюсы
    $cth{$_}++ for $ctree->get_related_minicategs( @catnms );
#$self->proj->dd('fl',\%cth,);
    #Фильтруем виртуалки
    %cth = map { $_ => 1 } grep { /(.*) _ / ? $gvrt{$1} : 1 } keys %cth;
#$self->proj->dd('fl2',\%cth,);
    return \%cth;
}

sub shrink_categs_tree {
    # Параметры:
    #   limit => integer
    #   order => 'Banners'|'Shows'|'Clicks'|'Cost'
    #   max_level => integer
    #   id => 1/0
    #   verbose => 1/0
    my $self = shift;
    my %par = @_;

    # Значения по умолчанию
    my $max_level = $par{max_level} // 1;
    my $limit = $par{limit} // 1;
    my $order = $par{order} // 'Banners';

    my %big_categs;
    # Шаг 1.
    # берем все вершины до уровня max_level включительно
    # корни на уровне 1
    # ищем корни, выбрасывая виртуальные и атомы
    $self->log("shrink_categs_tree: select up to level $max_level") if $par{verbose};
    my @all_categs = grep {!/^\.|^!/} $self->get_minicategs_list;
    my @roots = grep {!/_/} grep {! $self->get_minicateg_parent($_)} @all_categs;
    for my $level (1..$max_level) {
        $big_categs{$_} = 1 for @roots;
        my @new_roots;
        push @new_roots, $self->get_minicateg_children($_) for @roots;
        if ($par{handle_virtual_categs}) {
            @new_roots = grep {!/_/} @new_roots;
        }
        @roots = @new_roots;
    }
    # Шаг 2.
    # Проверяем, не исчерпан ли лимит по категориям
    # Если можно добавить еще категорий, добираем ТОП
    my $slack = $limit - scalar(keys %big_categs); 
    if ($slack > 0) {
        $self->log("shrink_categs_tree: connect to DB") if $par{verbose};
        my $dbh = $self->proj->catalogia_media_dbh;
        my $exclude_categs_str = join(',', map {$dbh->quote($_)} (keys %big_categs,'ALL','NOCATEGORY'));
        my $sth = $dbh->prepare("
            select 
                Category 
            from 
                CatStatExtMonth
            where 
                UpdateDate>=date(now() - interval 1 year)
                and
                Category not in ($exclude_categs_str)
            group by 
                Category 
            order by 
                sum($order) desc 
            limit $slack
        ");
        $self->log("shrink_categs_tree: select") if $par{verbose};
        $sth->execute() or return undef;
        while(my $h = $sth->fetchrow_hashref) {
            $big_categs{$h->{Category}} = 1;
        }
        $dbh->disconnect;
    }

    # Шаг 3.
    # Отображаем все категории в крупные
    my %categ2big_categ;
    $self->log("shrink_categs_tree: map categories") if $par{verbose};
    for my $cat (@all_categs) {
        my $current = $cat;
        if ($par{handle_virtual_categs}) {
            if ($cat =~ /_/) {
                my ($virt, $parent) = split(" _ ", $cat);
                $current = $parent;
            }
        }
        while (!defined($big_categs{$current})) {
            $current = $self->get_minicateg_parent($current);
            last if !$current;
        }
        next if !$current;
        $categ2big_categ{$cat} = $current;
    }

    if ($par{id}) {
        my $mapping_ids = {};
        while(my ($c, $big_c) = each %categ2big_categ) {
            $mapping_ids->{$self->get_minicateg_id($c)} = $self->get_minicateg_id($big_c);
        }
        return $mapping_ids;
    } else {
        return \%categ2big_categ;
    }
}

sub AUTOLOAD {
    my $self = shift;
    my $attr = $AUTOLOAD;
    $attr =~ s/.*:://;
    return if $attr !~ /[a-z]/;  # skip destroy and all-cap methods
    #return eval('BM::PhraseCategs::'.$attr.'(@_)');
#$self->proj->dd('DDD', $attr, $self->proj->stack_trace);
    $self->{'__phr'} = $self->proj->phrase('1') unless exists $self->{'__phr'};
#$self->proj->dd('DDD', $attr, \@_, $self->{'__phr'}->do_categs_method($attr, @_));
    return $self->{'__phr'}->do_categs_method($attr, @_); #Выполняется не метод, а функция !!!
    #return eval('BM::Phrase::'.$attr.'(@_)');
};



1;

