package BM::ContextFiltering::BannersCategories;

use strict;

use utf8;
use open ':utf8';
no warnings 'utf8';
use base qw(ObjLib::ProjPart);

use Digest::MD5 qw(md5_hex);
use Data::Dumper;
use Encode qw(encode_utf8);
use File::Copy;
use File::Basename qw(basename);
use Time::HiRes qw/gettimeofday tv_interval/;
use BM::Phrase;
use BM::YQL::Client qw(make_yql_request);
use Utils::Common;
use URI::Escape;
use List::Util qw(sum);
use Utils::Sys qw(md5int);
use Utils::Hosts qw(get_hosts);
use StaticZmap;

########################################################
# Интерфейс
########################################################
# categs_file            - файл с полученными категориями
# send_to_direct         - отправить данные в Директ
#

__PACKAGE__->mk_accessors(qw(
    categs_file
    recategorized_yt_table
    categs_file_direct
    camp_categs_file
    domains_categs_file
    sold_phrases_file
    send_to_direct_url
    yt_table_path
));

########################################################
# Инициализация
########################################################

sub init {
    my ($self) = @_;
}


sub export_mediagroups {
    my ($self) = @_;
    my $proj = $self->proj;
    my $fn_categ2mediagroup = $Utils::Common::options->{dirs}{temp} . "/categ2mediagroup";
    my $fn_id2mediagroup = $Utils::Common::options->{dirs}{temp} . "/id2mediagroup";
    my $fn_brandgroups = $Utils::Common::options->{dirs}{temp} . "/brandgroups";
    my $fn_mediagroup2videodirectgroup = $Utils::Common::options->{dirs}{temp} . "/mediagroup2videodirectgroup";
    my $fn_videodirectgroups_second_level = $Utils::Common::options->{dirs}{temp} . "/videodirectgroups_second_level";

    open F, "> $fn_categ2mediagroup" or die($!);
    my $h = $proj->categ2mediagroup_hash;
    for my $categ (keys %$h) {
        my $direct_id = $proj->categs_tree->get_minicateg_directid($categ);
        next if !$direct_id;

        print F "$direct_id\t".join(",", map{md5int($_)} @{$h->{$categ}}) . "\n";
    }
    close F;

    open F, "> $fn_id2mediagroup" or die($!);
    $h = $proj->categ2mediagroup_hash;
    my $mgs = { map{$_ => 1}  map { @{$h->{$_}} } keys %$h };
    print F join("\n", map{md5int($_)."\t$_"} keys %$mgs) . "\n";
    close F;

    open F, "> $fn_brandgroups" or die($!);
    $h = $proj->mediagroups->brandgroups;
    print F join("\n", map{join "\t", @$_} @$h) . "\n";
    close F;

    open F, "> $fn_mediagroup2videodirectgroup" or die($!);
    $h = $proj->categ2mediagroup_hash;
    $mgs = { map{$_ => 1}  map { @{$h->{$_}} } keys %$h };
    my %uniq_hash = ();
    foreach my $mediagroup ( keys %$mgs ) {
        my $list = $proj->mediagroups->group2secondlevelgroup->{$mediagroup};
        foreach my $level2 (@$list) {
            my $level2id = md5int($level2);
            my $mediagroupid = md5int($mediagroup);
            my @categs = @{$proj->mediagroups->group2categ->{$mediagroup}};
            my %vdgroupshash = map {$_ => 1} grep {$_} $proj->categs_tree->get_videodirectgroups_from_categs(@categs);
            my @vdgroups = keys %vdgroupshash;
            foreach my $vdgroup ( @vdgroups ) {
                my $vdgroupid = $proj->categs_tree->get_videodirectgroup_directid($vdgroup);
                if ( $vdgroupid && !exists $uniq_hash{$level2id}{$vdgroupid}) {
                    print F join ("\t", $level2id, $level2, $vdgroupid, $vdgroup) ."\n";
                    $uniq_hash{$level2id}{$vdgroupid} = 1;
                }
            }
        }
    }
    close F;

    open F, "> $fn_videodirectgroups_second_level" or die($!);
    $h = $proj->videodirectgroups->group2secondlevelgroup;
    foreach my $group (keys %$h) {
        my $groupid = $proj->categs_tree->get_videodirectgroup_directid($group);
        foreach my $level2 ( @{$h->{$group}} ) {
            my $level2id = md5int($level2);
            if ( $groupid ) {
                print F join ("\t", $level2id, $level2, $groupid, $group) ."\n";
            }
        }
    }
    close F;

    $self->do_sys_cmd("mv $fn_categ2mediagroup " . $self->{categ2mediagroup_file});
    $self->do_sys_cmd("mv $fn_id2mediagroup " . $self->{id2mediagroup_file});
    $self->do_sys_cmd("mv $fn_brandgroups " . $self->{brandgroups_file});
    $self->do_sys_cmd("mv $fn_mediagroup2videodirectgroup " . $self->{mediagroup2videodirectgroup_file});
    $self->do_sys_cmd("mv $fn_videodirectgroups_second_level " . $self->{videodirectgroups_second_level_file});
}

sub export_interests_mapping {
    my ($self) = @_;
    my $proj = $self->proj;

    my $result_file = $self->{interests_mapping_file};
    my $temp_file = $Utils::Common::options->{dirs}{temp} . basename($result_file);

    open(my $temp_fh, ">", $temp_file) or die $!;

    my $mapping = $proj->interests_mapping->categ2group;
    use Data::Dumper; print Dumper($mapping);
    for my $categ (keys %$mapping) {
        my $direct_id = $proj->categs_tree->get_minicateg_directid($categ) or die "wtf? '$categ'";
        for my $alias (@{ $mapping->{$categ} }) {
            print $temp_fh join("\t", $direct_id, $alias) . "\n";
        }
    }

    close($temp_fh);

    $self->do_sys_cmd("mv $temp_file $result_file");
}

sub upload_data_to_yt {
    my ($self) = @_;

    my $yt_client = $self->proj->yt_client;
    $yt_client->write_tsv_file(
        $self->{'id2mediagroup_file'},
        $self->yt_table_path . '/id2mediagroup',
        ['MediagroupID', 'MediagroupName'],
        ['uint64', 'string'],
    );
    $yt_client->write_tsv_file(
        $self->{'categ2mediagroup_file'},
        $self->yt_table_path . '/categ2mediagroup',
        ['CategoryID', 'Mediagroups'],
        ['uint64', 'string'],
    );
    $yt_client->write_tsv_file(
        $self->{'mediagroup2videodirectgroup_file'},
        $self->yt_table_path . '/mediagroup2videodirectgroup',
        ['MediagroupID', 'Mediagroup', 'VideodirectgroupID', 'Videodirectgroup'],
        ['uint64', 'string', 'uint64', 'string'],
    );
    $yt_client->write_tsv_file(
        $self->proj->videodirectgroups->direct_mapping_file,
        $self->yt_table_path . '/id2videodirectgroup',
        ['VideodirectgroupID', 'Videodirectgroup'],
        ['uint64', 'string'],
    ) if $self->proj->videodirectgroups->direct_mapping_file;

    $yt_client->write_tsv_file(
        $self->{'videodirectgroups_second_level_file'},
        $self->yt_table_path . '/videodirectgroups_second_level',
        ['Level2ID', 'Level2', 'VideodirectgroupID', 'Videodirectgroup'],
        ['uint64', 'string', 'uint64', 'string'],
    );

    $yt_client->write_tsv_file(
        $self->{interests_mapping_file},
        $self->yt_table_path . '/interests_mapping',
        ['DirectID', 'Alias'],
        ['uint64', 'string'],
    );

    $yt_client->write_tsv_file(
        $self->proj->options->{categs_direct_ids},
        $self->yt_table_path . '/categs_direct_ids',
        ['DirectID', 'Category'],
        ['uint64', 'string'],
    );
}

1;
