package BM::ContextSyns::DBSyns;

use utf8;
use open ':utf8';

use std;
use base qw(BM::ContextSyns::ContextLinks);

use BM::Phrase;

use Utils::Sys;
use Utils::Words;

use Data::Dumper;
use List::Util qw(max);

########################################################
# Интерфейс
########################################################
#

# Загружает синонимы из таблицы типа CatalogiaPhrases
# Параметры:
#   dbh_name    => Название dbh. Если не задано - берет из proj 
#   table       => Название таблицы
#   field       => Поле, в котором записаны синонимы
#   condition   => Условие для select
# Пример:
#   dbh_name    => "catalogia_media_dbh",
#   table       => "CatalogiaPhrases",
#   field       => "InitialPhrase",
#   condition   => " Action = 'AddContextSyn' and not Status = 'Declined' ",

__PACKAGE__->mk_accessors(qw(
));

sub init {
    my $self = shift;
    $self->SUPER::init;
}

sub load {
    my ($self) = @_;

    if (not $self->{table}) {
        $self->log("WARN: void table");
        return;
    }

    my $dbh = $self->{dbh_name} ? $self->proj->dbhlist->{$self->{dbh_name}} : $self->proj->dbh;

    # $self->{update_time}          - Время загрузки данных из таблицы
    # $self->{table_update_time}    - Время обновления данных в таблице 

    if ($self->{update_time} // '') {
        my $max_delta_time = 2; # minutes   Время, в течение которого не обновляем (и не проверяем таблицу)
        if ($self->proj->dates->delta_time($self->{update_time}, $self->proj->dates->cur_date('db_time'), 'db_time', 'minutes') < $max_delta_time) {
            # Если данные обновлялись недавно, не обновляем
            #$self->log("db_syns:  Do not update (update_time: '" . $self->{update_time} . "')");
            return 1;
        }
    }

    my $table_update_time = $self->proj->dbtable($self->{table}, undef, $self->{dbh_name})->table_status->{Update_time};
    if ($self->{table_update_time} // '') {
        #$self->log("db_syns:  table_update_time: $table_update_time, update_time: " . $self->{update_time});
        if ($table_update_time le ($self->{table_update_time} // '')) {
            # Таблица не менялась - можно не обновлять данные
            $self->log("db_syns:  Do not update (table is old: '" . $self->{table_update_time} . "', '$table_update_time')");
            $self->{update_time} = $self->proj->dates->cur_date('db_time');
            return 1;
        }
    }

    $self->log("load db_syns (Old: '" . ($self->{update_time} // '') . "', '" . ($self->{table_update_time} // ''). "'. New: '$table_update_time')");
    $self->clear_links();
    if ($self->{table}) {
        my $tbl = $self->{table};
        my $fld = $self->{field};
        my $condition = $self->{condition} // '';
        #my $login = $self->proj->user->login;
        my $lang = $self->lang;

        my $where = "where " . join(" and ",
            ($condition || ()),
            "Language = '$lang'",
        );
        $self->log("loading context synonyms from table '$tbl' ($where) ...");
        my $stm = "select * from $tbl $where ";   # TODO проверять User?
        my $list = $dbh->List_SQL($stm);
        for my $el (@$list) {
            my $text = $el->{$fld};
            # TODO Использовать загрузку из phrase_list
            $self->add_from_line($text)  or
                $self->log("ERROR: wrong format in db_syns ($text)");
        }
    }
    $self->{update_time} = $self->proj->dates->cur_date('db_time');
    $self->{table_update_time} = $table_update_time;
    $self->log("/ load db_syns");
}

1;
