package BM::ContextSyns::Hyperonyms;

use utf8;
use open ':utf8';

use std;
use base qw(BM::ContextSyns::ContextLinks);

use BM::Phrase;

use Utils::Sys;
use Utils::Words;

use Data::Dumper;
use List::Util qw(max);

########################################################
# Интерфейс
########################################################
#

__PACKAGE__->mk_accessors(qw(
    file
));

sub init {
    my $self = shift;
    $self->SUPER::init;
}

sub load {
    my ($self) = @_;

    $self->log("load hyperonyms");
    open F, '<', $self->file
        or $self->log("ERROR: can't open ".$self->file." for reading");
    while(<F>) {
        chomp;
        my ($hypers, $categs, $hypos) = split "\t";
        next if !$hypers;
        my @hypers = grep{$_} map{$self->proj->phrase($_)->snorm_phr} split ",", $hypers;
        my @hypos;

        for my $hypo (split ",", $hypos) {
            my $text = $hypo;
            my @atoms = $hypo =~ /\[([^\]]+)\]/g;
            my $num_phrases = 1;
            $hypo =~ s/\[([^\]]+)\]/ /g;

            for my $atom (@atoms) {
                my @a = split "/", $atom;
                $num_phrases *= scalar(@a);
            }

            if($num_phrases > 300) {
                $self->log("WARNING: too many phrases in atoms '$text'");
            } else {
                my $generate_phrases;
                $generate_phrases = sub {
                    my ($curr, $i) = @_;
                    if($i >= scalar(@atoms)) {
                        push @hypos, $curr;
                    } else {
                        $generate_phrases->("$curr $_", $i + 1) for split "/", $atoms[$i];
                    }
                };
                $generate_phrases->($hypo, 0);
            }
        }

        my $context = {
            type => 'categ',
            categs => [ split /\//, $categs ],
        };
        $self->add_links_text(\@hypers, [ @hypers, @hypos ], $context);
    }
    close F;
    $self->log("/ load hyperonyms");
}

1;
