package BM::DB::Tables;
use strict;

use utf8;
use open ':utf8';

use base qw(Exporter);

our @EXPORT_OK = (
    'get_table_def',
);

our %table_def;


sub get_table_def {
    my $name = shift;
    return $table_def{$name};
}

$table_def{BannerReverseDomain} = '(
    `id` int unsigned not null,
    `reverse_site_domain` varchar(255) not null,
    primary key (`id`),
    key (`reverse_site_domain`)
) engine=MyISAM default charset=utf8;
';

# типы полей взяты отсюда: http://direct-dev.yandex-team.ru/db/ppc/tables/campaigns.html
$table_def{Campaigns} = '(
    `cid` int(10) unsigned NOT NULL,
    `name` text NOT NULL,
    `OrderID` int(11) NOT NULL,
    `shows` int(11) NOT NULL,
    `clicks` int(11) NOT NULL,
    `sum` decimal(16,6) NOT NULL,
    `sum_spent` decimal(16,6) NOT NULL,
    `statusActive` enum("yes","no") NOT NULL,
    `autobudget` enum("yes","no") NOT NULL,
    `autobudget_sum` double NOT NULL,
    `ContextLimit` int(10) unsigned NOT NULL,
    `minus_words` text NOT NULL,
    `broad_match_flag` enum("yes","no") NOT NULL,
    `broad_match_limit` int(11) NOT NULL,
    `GoalID` int(10) unsigned NOT NULL,
    `uid` int(10) unsigned NOT NULL,
    `ClientID` int(10) unsigned NOT NULL,
    `broad_match_rate` enum("minimal","optimal","maximum") DEFAULT NULL,
    `stat_days` tinyint(3) unsigned NOT NULL,
    `recent_shows` int(10) unsigned NOT NULL,
    `recent_clicks` int(10) unsigned NOT NULL,
    `recent_sum_rub` decimal(16,6) NOT NULL,
    `status_archived` tinyint(3) unsigned NOT NULL,
    `related_keywords_flag` tinyint(3) unsigned NOT NULL,
    `BMGoalID` int(11) DEFAULT NULL,
    PRIMARY KEY (`cid`),
    KEY `OrderID` (`OrderID`),
    KEY `uid` (`uid`),
    KEY `ClientID` (`ClientID`),
    KEY `broad_match_flag` (`broad_match_flag`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
';

$table_def{EstOwnCost} = '(
    `bid` bigint unsigned not null,
    `Cost` bigint unsigned not null,
    `UpdateTime` timestamp,
    primary key (`bid`)
) engine=MyISAM default charset=utf8;
';

$table_def{EstBMCost} = '(
    `bid` bigint unsigned not null,
    `Cost` bigint unsigned not null,
    `UpdateTime` timestamp,
    primary key (`bid`),
    key (`UpdateTime`)
) engine=InnoDB default charset=utf8;
';

$table_def{Phrases} = '(
    `PhraseID` bigint unsigned not null,
    `Phrase` text not null,
    primary key (`PhraseID`)
) Engine=MyISAM CHARSET=utf8;
';

# Контекстные синонимы из таблицы CatalogiaPhrases
$table_def{ContextSynFresh} = q!(
    `ID` int(11) unsigned not null auto_increment,
    `Language` char(2) NOT NULL DEFAULT 'ru',
    `InitialPhrase` text NOT NULL,
    `Status` char(255) NOT NULL DEFAULT 'New',
    `UpdateTime` datetime,
    PRIMARY KEY (`ID`),
    KEY `Language` (`Language`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
!;

$table_def{PhraseListCache} = q!(
    `PhraseListID` char(20) NOT NULL,
    `Phrases` longtext,
    `UpdateTime` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
    `IsComposite` tinyint NOT NULL DEFAULT 0,
    PRIMARY KEY (`PhraseListID`)
) engine=MyISAM default charset=utf8;
!;


# bmdb

$table_def{Sources} = '(
    `SourceID` int unsigned not null auto_increment,
    `Source` varchar(255) not null,
    primary key (`SourceID`),
    unique key `Source` (`Source`)
) engine=MyISAM default charset=utf8;
';
$table_def{Experiments} = '(
    `ExperimentID` int unsigned not null auto_increment,
    `Experiment` varchar(255) not null,
    primary key (`ExperimentID`),
    unique key (`Experiment`)
) engine=MyISAM default charset=utf8;
';

# catmedia

$table_def{TasksQueue} = q/(
    `ID` int unsigned not null auto_increment,
    `Type` varchar(16) not null default '',
    `Login` varchar(32) not null default '',
    `Cmd` varchar(32) not null default '',
    `Act` varchar(32) not null default '',
    `Params` text not null default '',
    `Title` text not null default '',
    `Comment` text not null default '',
    `ComeTime` timestamp not null default current_timestamp,
    `StartTime` timestamp not null,
    `UpdateTime` timestamp not null,
    `State` varchar(16) default '',
    `Result` text NOT NULL,
    `WaitIds` text default '',
    `Queue` varchar(32) not null default '',
    `PID` int unsigned,
    `AttemptsRemained` int DEFAULT 1,
    primary key (`ID`),
    key (`Type`, `Login`, `Cmd`, `Act`, `State`),
    key (`Login`, `Cmd`, `Act`, `State`),
    key (`Cmd`, `Act`, `Type`, `State`)
) Engine=MyISAM CHARSET='utf8';
/;

$table_def{UsersFiles} = q!(
    `ID` int(11) unsigned not null auto_increment,
    `Date` datetime,
    `Login` varchar(128),
    `Info` text,
    `Title` text default '',
    `FileName` varchar(255),
    `FileType` varchar(255),
    `FileContent` longblob,
    `Comment` text default '',
    `State` varchar(128) default '',
    PRIMARY KEY (`ID`),
    KEY `Login` (`Login`, `State`),
    KEY `State` (`State`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
!;

# aggrstat
$table_def{AggrStat} = q'(
    `KeyID` bigint(20) unsigned NOT NULL,
    `Shows` bigint(20) unsigned NOT NULL DEFAULT 0,
    `Clicks` int(11) unsigned NOT NULL DEFAULT 0,
    `Cost` bigint(20) unsigned NOT NULL DEFAULT 0,
    `PShows` bigint(20) unsigned NOT NULL DEFAULT 0,
    `PClicks` int(11) unsigned NOT NULL DEFAULT 0,
    `PCost` bigint(20) unsigned NOT NULL DEFAULT 0,
    PRIMARY KEY (`KeyID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
';
$table_def{AggrConv} = q'(
    `KeyID` bigint(20) unsigned NOT NULL,
    `VClicks` int(11) unsigned NOT NULL DEFAULT 0,
    `Views` bigint(20) unsigned NOT NULL DEFAULT 0,
    `PBounceClicks` bigint(20) unsigned NOT NULL DEFAULT 0,
    PRIMARY KEY (`KeyID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
';

# TODO  правильные типы полей
$table_def{bo_v_crm_v_bis_clients_latest} = q!(
    `AGENCY_ID` varchar(255) NOT NULL DEFAULT '',
    `AGENCY_MANAGER_CODE` varchar(255) NOT NULL DEFAULT '',
    `AGENCY_MANAGER_ID` varchar(255) NOT NULL DEFAULT '',
    `AGENCY_MANAGER_LOGIN` varchar(255) NOT NULL DEFAULT '',
    `AGENCY_MANAGER_NAME` varchar(255) NOT NULL DEFAULT '',
    `AGENCY_NAME` varchar(255) NOT NULL DEFAULT '',
    `CHUNK` varchar(255) NOT NULL DEFAULT '',
    `CLIENT_BRAND` varchar(255) NOT NULL DEFAULT '',
    `CLIENT_COUNTRY` varchar(255) NOT NULL DEFAULT '',
    `CLIENT_DOMAIN` varchar(255) NOT NULL DEFAULT '',
    `CLIENT_EMAIL` varchar(255) NOT NULL DEFAULT '',
    `CLIENT_GRADE` varchar(255) NOT NULL DEFAULT '',
    `CLIENT_ID` bigint(20),
    `CLIENT_INDUSTRY` varchar(255) NOT NULL DEFAULT '',
    `CLIENT_LOGIN` varchar(255) NOT NULL DEFAULT '',
    `CLIENT_NAME` varchar(255) NOT NULL DEFAULT '',
    `HAS_BAYAN` varchar(255) NOT NULL DEFAULT '',
    `HAS_DIRECT` varchar(255) NOT NULL DEFAULT '',
    `HAS_MARKET` varchar(255) NOT NULL DEFAULT '',
    `HAS_MEDIASEL` varchar(255) NOT NULL DEFAULT '',
    `HAS_METRIKA` varchar(255) NOT NULL DEFAULT '',
    `HAS_PAID_METRIKA` varchar(255) NOT NULL DEFAULT '',
    `IS_INDUSTRY_MANAGER` varchar(255) NOT NULL DEFAULT '',
    `MANAGER_CITY` varchar(255) NOT NULL DEFAULT '',
    `MANAGER_ID` varchar(255) NOT NULL DEFAULT '',
    `MANAGER_LOGIN` varchar(255) NOT NULL DEFAULT '',
    `MANAGER_NAME` varchar(255) NOT NULL DEFAULT '',
    `ORDER_MANAGER_CODE` varchar(255) NOT NULL DEFAULT '',
    `ORDER_MANAGER_ID` varchar(255) NOT NULL DEFAULT '',
    `ORDER_MANAGER_LOGIN` varchar(255) NOT NULL DEFAULT '',
    `ORDER_MANAGER_NAME` varchar(255) NOT NULL DEFAULT '',
    `SCN` varchar(255) NOT NULL DEFAULT '',
    KEY (`CLIENT_ID`),
    KEY (`MANAGER_LOGIN`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
!;

# TODO  правильные типы полей
$table_def{bo_v_crm_v_bis_users_latest} = q!(
    `CHUNK` varchar(255) NOT NULL DEFAULT '',
    `CITY_ID` varchar(255) NOT NULL DEFAULT '',
    `CREATED_AT` varchar(255) NOT NULL DEFAULT '',
    `DEPARTMENT_ID` varchar(255) NOT NULL DEFAULT '',
    `FIRST_NAME` varchar(255) NOT NULL DEFAULT '',
    `ID` varchar(255) NOT NULL DEFAULT '',
    `IS_DISMISSED` varchar(255) NOT NULL DEFAULT '',
    `LAST_NAME` varchar(255) NOT NULL DEFAULT '',
    `LOGIN` varchar(255) NOT NULL DEFAULT '',
    `LOGIN_CRM` varchar(255) NOT NULL DEFAULT '',
    `LOGIN_PASSPORT` varchar(255) NOT NULL DEFAULT '',
    `MOBILE_PHONE` varchar(255) NOT NULL DEFAULT '',
    `MODIFIED_AT` varchar(255) NOT NULL DEFAULT '',
    `NAME` varchar(255) NOT NULL DEFAULT '',
    `OFFICE_ID` varchar(255) NOT NULL DEFAULT '',
    `PARENT_LOGIN` varchar(255) NOT NULL DEFAULT '',
    `PASSPORT_ID` varchar(255) NOT NULL DEFAULT '',
    `POSITION` varchar(255) NOT NULL DEFAULT '',
    `SCN` varchar(255) NOT NULL DEFAULT '',
    `TZ` varchar(255) NOT NULL DEFAULT '',
    `WORK_EMAIL` varchar(255) NOT NULL DEFAULT '',
    `WORK_PHONE` varchar(255) NOT NULL DEFAULT ''
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
!;

# TODO  правильные типы полей
$table_def{bo_v_crm_v_bis_departments_latest} = q!(
    `CHUNK` varchar(255) NOT NULL DEFAULT '',
    `CODE` varchar(255) NOT NULL DEFAULT '',
    `DEPARTMENT_ID` varchar(255) NOT NULL DEFAULT '',
    `DEPARTMENT__PARENT_ID` varchar(255) NOT NULL DEFAULT '',
    `NAME` varchar(255) NOT NULL DEFAULT '',
    `SCN` varchar(255) NOT NULL DEFAULT '',
    `URL` varchar(255) NOT NULL DEFAULT ''
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
!;

$table_def{SvnRevisions} = q!(
    `Revision` int(10) NOT NULL,
    `ArcadiaRevision` int(10) NOT NULL,
    PRIMARY KEY (`Revision`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
!;

$table_def{BannersCategoriesDiffMeta} = "(
    `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
    `Login` char(255) NOT NULL DEFAULT '',
    `UpdateTime` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
    `Comment` text NOT NULL,
    `NumBanners` int(11) NOT NULL DEFAULT '10000',
    `InputFileName` text NOT NULL,
    `State` char(20) NOT NULL DEFAULT 'New',
    `DataType` char(16) NOT NULL,
    `Language` char(2) NOT NULL DEFAULT 'ru',
    `DiffType` char(32) NOT NULL,
    PRIMARY KEY (`ID`),
    KEY `Language` (`Language`,`ID`),
    KEY `Login` (`Login`,`ID`),
    KEY `State` (`State`)
    ) ENGINE=MyISAM DEFAULT CHARSET=utf8
";

$table_def{BannersCategoriesDiffInput} = "(
    `ID` bigint(20) unsigned NOT NULL,
    `Input` longblob NOT NULL,
    PRIMARY KEY (`ID`)
    ) ENGINE=MyISAM DEFAULT CHARSET=utf8
";

$table_def{BannersCategoriesDiffResults} = "(
    `ID` bigint(20) unsigned NOT NULL,
    `Result` longblob NOT NULL,
    PRIMARY KEY (`ID`)
    ) ENGINE=MyISAM DEFAULT CHARSET=utf8
";


# automoderate.pl, moderation : CMDH
$table_def{AutoModerationScores} = "(
  `CatID` char(50) NOT NULL DEFAULT '',
  `Language` char(2) NOT NULL DEFAULT 'ru',
  `InitialPhraseID` bigint(20) unsigned NOT NULL DEFAULT '0',
  `Action` char(20) NOT NULL DEFAULT 'Add',
  `Score` decimal(18,6) DEFAULT NULL,
  `ScoreStat` text,
  `ScoreGroupID` varchar(128) DEFAULT NULL,
  `UpdateTime` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`CatID`,`InitialPhraseID`,`Action`,`Language`),
  KEY `ScoreGroupID` (`ScoreGroupID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8
";

# automoderate.pl, moderation : CMDH
$table_def{AutoModerationScoreGroupExamples} = "(
  `ScoreGroupID` varchar(128) NOT NULL,
  `BannerID` bigint(20) NOT NULL,
  `BannerInfo` text,
  `UpdateTime` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`ScoreGroupID`,`BannerID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8
";

$table_def{MetaStringStorage} = "(
  `Key` varchar(255) NOT NULL,
  `Value` text NOT NULL,
  `UpdateTime` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`Key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8
";

# Лог Красной Кнопки (база "catalogia_media_dbh")
$table_def{RedButtonLog} = "(
    `ID` int(10) unsigned NOT NULL AUTO_INCREMENT,
    `BeginTime` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
    `UpdateTime` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
    `Username` varchar(255) NOT NULL DEFAULT '',
    `Command` varchar(255) NOT NULL DEFAULT '',
    `Hosts` text NOT NULL,
    `Paths` text NOT NULL,
    `Macro` varchar(255) NOT NULL DEFAULT '',
    `DeployParams` text NOT NULL,
    `Revision` varchar(255) NOT NULL DEFAULT '',
    `ArcadiaRevision` varchar(255) NOT NULL DEFAULT '',
    `UseCustomRevision` varchar(255) NOT NULL DEFAULT '',
    `Errors` text NOT NULL,
    `Log` longtext NOT NULL,
    PRIMARY KEY (`ID`),
    KEY `UpdateTime` (`UpdateTime`),
    KEY `Username` (`Username`),
    KEY `Command` (`Command`),
    FULLTEXT KEY `Hosts` (`Hosts`),
    KEY `Macro` (`Macro`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8
";

for my $table_name ('PerfTasks') {
    $table_def{$table_name} = "(
        `TaskID` varchar(200) NOT NULL DEFAULT '',
        `OrderID` int(11) NOT NULL,
        `BannerIDs` varchar(200) DEFAULT NULL,
        `ParentExportIDs` varchar(200) DEFAULT NULL,
        `GroupExportIDs` varchar(200) DEFAULT NULL,
        `cronlight_id` varchar(250) DEFAULT NULL,
        `FeedUrl` varchar(250) DEFAULT NULL,
        `Geo` varchar(200) DEFAULT NULL,
        `Body` varchar(200) DEFAULT NULL,
        `firsttime` datetime DEFAULT NULL,
        `lasttime` datetime DEFAULT NULL,
        `begin` datetime DEFAULT NULL,
        `end` datetime DEFAULT NULL,
        `crontime` datetime DEFAULT NULL,
        `prev_begin` datetime DEFAULT NULL,
        `prev_end` datetime DEFAULT NULL,
        `prev_crontime` datetime DEFAULT NULL,
        `errors` text,
        `taskinf` text,
        `resinf` text,
        `srccount` int(11) NOT NULL,
        `filters` text,
        `offerscount` int(11) NOT NULL,
        `resultcount` int(11) NOT NULL,
        `currentstatus` varchar(200) DEFAULT NULL,
        `stagelog` text,
        `stat` text,
        `addurlparams` varchar(200) DEFAULT NULL,
        `work` varchar(200) DEFAULT NULL,
        `Shows` int(11) unsigned DEFAULT '0',
        `Clicks` int(11) unsigned DEFAULT '0',
        `Cost` int(11) unsigned DEFAULT '0',
        `host` varchar(200) DEFAULT NULL,
        `retarg` varchar(200) DEFAULT NULL,
        `Domain` varchar(200) DEFAULT NULL,
        `feed_data_type` varchar(200) DEFAULT NULL,
        `st_task` varchar(200) DEFAULT NULL,
        `st_status` varchar(200) DEFAULT NULL,
        `BSTaskID` varchar(200) DEFAULT NULL,
        `GenerationID` varchar(200) DEFAULT NULL,
        `FunnelInfo` text,
        `export_offers_info` varchar(2000) DEFAULT NULL,
        PRIMARY KEY (`TaskID`),
        KEY `Domain` (`Domain`),
        KEY `OrderID` (`OrderID`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8;"
    ;
}

for my $table_name ('DynTasksQueue', 'PerfTasksQueue') {
    $table_def{$table_name} = "(
        `ID` bigint(22) NOT NULL AUTO_INCREMENT,
        `Domain` text,
        `OrderID` int(11),
        `Host` text,
        `TaskFile` text,
        `State` text,
        PRIMARY KEY (`ID`)
    ) ENGINE=MyISAM DEFAULT CHARSET=utf8" # ! in mdb InnoDB: NOT MyISAM
    ;
}

for my $table_name ('DynTasksMonitorEntries', 'PerfTasksMonitorEntries') {
    $table_def{$table_name} = "(
      `ID` bigint(22) NOT NULL AUTO_INCREMENT,
      `Time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
      `Domain` varchar(200),
      `Host` varchar(200),
      `TaskID` varchar(200),
      `State` varchar(50),
      `DebugInfo` text,
      PRIMARY KEY (`ID`)
    ) ENGINE=MyISAM DEFAULT CHARSET=utf8"; # ! in mdb InnoDB: NOT MyISAM
    ;
}
1;


__END__


Про наши таблицы.


Исторически, у нас в mysql был и есть некоторый бардак. В 2017-2018 была предпринята попытка провести уборку и инвентаризацию, IRT-1536, в рамках которых у части таблиц появились описания. Не у всех, правда: что-то забыли описать, а про что-то никто и не помнит, зачем оно, и найти ответ можно только грепая код. Если вы видите в описании ошибку, или вы можете описать неописанную таблицу - исправляйте ошибку, добавляйте описание.

Есть несколько классов временных таблиц, которые в перечисление не включены:

# dblist_*: https://st.yandex-team.ru/CATALOGIA-737
# Log_*: c этого префикса начинаются таблицы для логирования изменений в основных таблицах через dbist. Чистятся, если давно не обновлялись
# _drop_after_YYYYMMDD_*: когда мы хотим удалить таблицу, мы не удаляем её сразу, а переименовываем с таким префиксом и датой в будущем. Скрипта, который бы их дропал после этой даты, нет (рискованно), удаляем вручную. Если вы видите такую таблицу и дата уже прошла, её можно смело дропать.
# *_old_data: предыдущая версия какой-то таблицы, обновлённой скриптом (обычно при загрузке чего-нибудь через интерфейс).
# Done*: предыдущая версия "ресурсной" таблицы. Если таблица DoneTablename есть, а таблицы Tablename нет - это что-то старое, наверное можно дропать

В остальном список полон по состоянию на дату его составления.

breqwas@, 07.11.2018


catalogia_media_dbh: база bm в основном mysql. Там всё подряд, но в основном Каталогия и старый броадматч.

* AutoModerationScoreGroupExamples: Catalogia, примеры баннеров с изменившейся категоризацией для интерфейса автомодератора  breqwas@
* AutoModerationScores: Catalogia, результаты работы автомодератора   breqwas@
* BannerReverseDomain: Общее, для быстрого поиска поддоменов  apovetkin@
- BannersCategoriesDiff
* BannersCategoriesDiffInput: дифф категоризации cmd=banners_categs_diff, categs_diff_manager.pl  breqwas@
* BannersCategoriesDiffMeta: дифф категоризации cmd=banners_categs_diff, categs_diff_manager.pl  breqwas@
* BannersCategoriesDiffResults: дифф категоризации cmd=banners_categs_diff, categs_diff_manager.pl  breqwas@
- BannersSetCategorasationDiff
* BannersTaggingBenchmark: Catalogia, эталон категоризации баннеров  pelmeshka@
* BannersTaggingBenchmarkForReview: Catalogia, баннеры из эталона категоризации, у которых изменилась категория  pelmeshka@
* BannersTaggingElems: Catalogia, элементы сетов разметки категоризации баннеров  pelmeshka@
* BannersTaggingSets: Catalogia, сеты разметки категоризации баннеров  pelmeshka@
* CatStatExtDay: когда-то считалось на bmcollect'ах, сейчас не обновляется и используется в адаптивных  breqwas@
* CatStatExtMonth: когда-то считалось на bmcollect'ах, сейчас не обновляется и используется в адаптивных  breqwas@
* CatalogiaBrief: Catalogia, дерево категорий, обновляется при инфьюзе (update_catmedia_db)  apovetkin@
* CatalogiaDict: Catalogia, фразы категорий, обновляется при инфьюзе (update_catmedia_db)  apovetkin@
* CatalogiaDomainFlags: Catalogia, исключения по флагам модерации для определенных доменов и урлов  apovetkin@
* CatalogiaFlags: Catalogia, список флагов для каждой категории  apovetkin@
* CatalogiaFlagsDescription: Catalogia, словесное описание флагов модерации, обновляется при инфьюзе (update_catmedia_db)  apovetkin@
* CatalogiaManualFlags: Catalogia, выгрузка из ручки Модерации списка ручных изменений, которые делают модераторы. Будет выпилена в рамках работ по тикету CATALOGIA-547  apovetkin@
- CatalogiaModerate
* CatalogiaPhrases: Catalogia, практически любое изменение правил категоризации (добавление/удаление категорий, фраз, флагов и т.д.). Модерируется через интерфейс модерации, промодерированные изменения при инфьюзе попадают в словари  apovetkin@
- CatalogiaStatTable
- CatalogiaTagsDescription
* CatalogiaVirtualBrief: Catalogia, айдишники и флаги шаблонов виртуальных категорий, обновляется при инфьюзе  apovetkin@
* CatalogiaVirtualDict: Catalogia, фразы шаблонов виртуальных категорий, обновляется при инфьюзе  apovetkin@
- CatalogiaVisits
- CategoriesTags
- CategoriesTextFields
- CategoryComments
* CategoryDescription: Catalogia, словесное описание категорий  apovetkin@
* CategorySubscriptions: Catalogia, список подписчиков на изменения в правилах категорий, используется  apovetkin@
* Categs_Diff_Data: cmd=banners_categs_diff  emurav@
- Categs_Diff_Data_External
- CheckModeration
- CheckModerationDone
- ContextSynFresh
- DataCache
* DataTaggingElems: Catalogia, наверное, это имеет отношение к разметке (BannersTaggingElems, PhrasesTaggingElems), но это уже не используется. Кажется, что можно удалять  pelmeshka@
- Design_Tests
* DirectUsers: см. direct_users в Project.pm  emurav@
* DynTasksMonitorEntries: BannerLand, данные по динамическим таскам для отчетов  sergio@
* DynTasksQueue: BannerLand, актуальное состояние очереди в разбивке по хостам  sergio@
* FcgiProcess: Catalogia, чем заняты fcgi-процессы веб-интерфейса  apovetkin@
* FcgiProcessBeta: расскажу позже (emurav@)  emurav@
* FlagsTaggingElems: Catalogia, элементы сетов разметки флагов  pelmeshka@
* FlagsTaggingSets: Catalogia, сеты разметки флагов  pelmeshka@
- HiddenPhrases
* MediaGroups: Catalogia, неактуальная таблица с медиагруппами. Будет выпилена в тикете CATALOGIA-516  apovetkin@
* ModerationPhrasesBucket: используется в интерфейсе модерации, для фичи "набрать кучку фраз и посчитать по ним diff"  breqwas@
* NormToOrigStop: источник гармонизированных фраз, использовался в удалённом Автомедиапланировании  apovetkin@
- OptimCampBannerPhrase
- OptimCampRatings
* PerfTasksMonitorEntries: Bannerland, данные для отчета по мониторингу тасок Смартбаннера  sergio@
* PerfTasksQueue: Bannerland, актуальное состояние очереди тасок Смартбаннеров  sergio@
* PhraseListActionLog: Catalogia, лог операций с PhraseList'ами в интерфейсе edit_phrase_list, по нему можно смотреть когда последний раз операция кому-то была нужна  breqwas@
* PhraseListCache: Catalogia, хранилище списков фраз, которые мы видим в веб-интерфейсе в "редактировании списков фраз"  apovetkin@
* PhrasesTaggingBenchmark: Catalogia, эталон категоризации фраз (по идее штука нужная, по крайней мере на это был запрос от Тани, но давно не используется, надо спросить Таню, выпилить или оставить)  pelmeshka@
* PhrasesTaggingElems: Catalogia, элементы сетов разметки категоризации фраз  pelmeshka@
* PhrasesTaggingSets: Catalogia, сеты разметки категоризации фраз  pelmeshka@
* PrefilterList: Catalogia, список префильтров  apovetkin@
* RedButtonLog: Красная кнопка  emurav@
- Siblings
- SubscriptionsFilters
* SvnRevisions: переезд в Аркадию. Предлагаю пока не дропать  emurav@
- SynCells
* TasksQueue: Catalogia, очередь отложенных заданий (в основном из интерфейса, из редактирования списка фраз)  apovetkin@
- TestBanners
- TestDicts
- TestDictsDirs
- TestDirs
- TestDirs2
* UrlsTaggingBenchmark: Catalogia, эталон категоризации урлов  pelmeshka@
* UrlsTaggingElems: Catalogia, элементы сетов разметки категоризации урлов  pelmeshka@
* UrlsTaggingSets: Catalogia, сеты разметки категоризации урлов  pelmeshka@
- UserActivity
* Users: Catalogia, таблица для назначения прав пользователям Каталогии  pelmeshka@
- UsersFiles
- UsersGroups
* UsersVisitsLog: заходы пользователей в веб-интерфейс катмедиа  emurav@
- analyse_phrase_list
* brandgroups: Catalogia, таблица с брендами, используется аналитиками  apovetkin@
* categs_mediagroups: Catalogia, маппинг категорий в медиагруппы, используются и редактируются аналитиками  apovetkin@
* categs_videodirectgroups: Catalogia, маппинг категорий в группы видеоподложек, используются и редактируются видеорекламщиками  apovetkin@
- interests_mapping
- lite_analyse_phrase_list
* mediagroups_brandgroups: Catalogia, маппинг медиагрупп в бренды, для аналитиков  apovetkin@
* mediagroups_fix: Catalogia, подавление медиагрупп, используется  apovetkin@
* mediagroups_second_level: Catalogia, второй уровень группировки медиагрупп, для аналитиков  apovetkin@
- mediaplanner_optimcamp
- native_phrases_filter_tasks
- native_phrases_filter_tasks_banners
* videodirectgroups_fix: Catalogia, подавление видеогрупп, используется  apovetkin@
* videodirectgroups_second_level: Catalogia, второй уровень группировки групп видеоподложек, используется видеорекламщиками  apovetkin@


- bo_v_crm_v_bis_clients_latest
- bo_v_crm_v_bis_departments_latest
- bo_v_crm_v_bis_users_latest

bannerland_dbh: база bannerland в основном mysql. Здесь "всё про bannerland", предполагается что баннерленд зависит от неё, а от других баз не зависит.

* DynDomains: BannerLand, актуальный список доменов ДО из очереди тасков, обновляется по крону  sergio@
* DynGrpTasksMonitorEntries: BannerLand, мониторинг групповых тасок ДО, когда началась, когда закончилась. Пока используется только чтоб вручную поселектить, может в будущем вытащим ее на страничку в catmedia  sergio@
* DynTasks: BannerLand, основная рабочая таблица генератора дин-баннеров  breqwas@
* DynTasksDirectSummary: BannerLand, отчет по ДО со статистикой по доменам и таскам  sergio@
- DynTasksDirectSummaryOld
* DynTasksMonitorAggr: BannerLand, отчет "Мониторинг динамических тасок"  sergio@
* DynTasksMonitorEntries: BannerLand, данные по динамическим таскам для отчетов  sergio@
* DynTasksQueue: BannerLand, актуальное состояние очереди в разбивке по хостам  sergio@
* LoadingCounterIDToWatchLogCdict: BannerLand, таблица для counterid, для которых надо найти информацию в watchlog'е  pelmeshka@
* MetaStringStorage: BannerLand, но потенциально что угодно, таблица класса BM::DB::MetaStringStorage, он же $proj->meta_string_storage, сейчас используется в ??  breqwas@
- PerfAllowCustomPhrases
- PerfCustomTemplates
* PerfParamMapping: BannerLand, маппинг facilites для формата GoogleHotels, нужен для нормализации Facilites. Актуальность нужно уточнить у Артема Федотова.  sergio@
* PerfPremiumGoodsDomains: BannerLand, vip-генерация для Смартов, справочник; уточнить статус этой функциональности у Пети Сивкова и Артема Федотова  sergio@
* PerfTasks: BannerLand, таблица с тасками для Смартбаннеров  sergio@
* PerfTasksDirectSummary: BannerLand, отчет со статистикой по показам/кликам/деньгам для Смартбаннера  sergio@
- PerfTasksDirectSummaryOld
* PerfTasksMonitorEntries: Bannerland, данные для отчета по мониторингу тасок Смартбаннера  sergio@
* PerfTasksQueue: Bannerland, актуальное состояние очереди тасок Смартбаннеров  sergio@
* PerfUtmProblemDomains: BannerLand, справочник - домены, из которых нужно удалять utm-метки в Смартах  sergio@

- feed_files_data
* feed_tasks: таблица для тестовой генерации перфомансов и динамиков по фидам, таблица для входных данных (фидов и настроек генерации)
* feed_tasks_banners: таблица для тестовой генерации перфомансов и динамиков по фидам, таблица для выходных данных (полученных баннеров)
- feed_tasks_banners_cmp
- feed_tasks_banners_test
- feed_tasks_cmp
- feed_tasks_test
