package BM::DBFiles;
# Сохраняем пользовательские файлы в mysql и скачиваем их

use strict;

use utf8;
use open ':utf8';

use base qw(Cmds::Base);
use Utils::Common;
use IO::Compress::Gzip qw( gzip );
use IO::Uncompress::Gunzip qw( gunzip $GunzipError );
use Utils::XLS qw(array2xls);
use DBI qw(:sql_types);
use JSON qw(from_json to_json);
use Encode qw();


use base qw(Exporter);
our @EXPORT_OK = qw(
    upload_file
    download_file
    process_task
    array2file
);


# TODO  Не делать die в функциях?


my $table_name = 'UsersFiles';


# Создает файл заданного формата из массива данных (типа используемого в DBList)
# Поддерживаемые форматы файлов:   txt, xls. json - хранение данных в формате to_json
sub array2file {
    my ($proj, %prm) = @_;
    my $type = $prm{type} // 'json';
    my $list = $prm{list} // [];
    if (ref($list) ne 'ARRAY') {
        $proj->log("ERROR: Not array ref in array2file");
        return;
    }
    my $content;
    if ($type eq 'txt') {
        $content = join '', map { join("\t", @$_)."\n" } @$list;
    } elsif ($type eq 'xls') {
        $content = array2xls($list);
    } elsif ($type eq 'json') {
        $content = to_json($list);
    } else {
        $content = "";  # TODO
    }
    return $content;
}



# Using:
#    my $file_id = upload_file(
#       $proj,
#       file_name => $file_name,
#       file_type => 'xls',
#       file_content => $content,
#       title => $title,        # Заголовок файла в таблице файлов
#       comment => $comment,    # Например, комментарий, который будет отправлен пользователю вместе с файлом
#       info => "",
#       login => $proj->{login},
#   );
sub upload_file {
    my ($proj, %prm) = @_;
    my $file_name       = $prm{file_name} // '';
    my $file_content    = $prm{file_content} // '';
    my $info            = $prm{info} // '';
    my $login           = $prm{login} // '';
    my $file_type       = $prm{file_type} // '';
    my $comment         = $prm{comment} // '';
    my $title           = $prm{title} // '';

    my $date = $proj->dates->cur_date('db_time');   #   $prm{date}  ? 
    my $state = '';     #      $prm{state}   ?
    $proj->log("upload_file: " . join(", ",  $login, $file_name, $file_type, $info, $comment, $title, $state));

    $file_content = Encode::encode('UTF-8', $file_content)   if $file_type eq 'txt';

    my $compresses_content = "";
    gzip \$file_content => \$compresses_content;
    $proj->log("data read length:" . length($file_content));
    $proj->log("gzipped length:" . length($compresses_content));

    my $dbh = $proj->dbh;
    my @fld = qw( Date Login Info Title FileName FileType FileContent Comment State );
    my $sth = $dbh->prepare("INSERT INTO $table_name (" . join(", ", map {"`$_`"} @fld) . ") VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)" );
    $sth->bind_param( 1, $date );
    $sth->bind_param( 2, $login );
    $sth->bind_param( 3, $info );
    $sth->bind_param( 4, $title);
    $sth->bind_param( 5, $file_name );
    $sth->bind_param( 6, $file_type );
    $sth->bind_param( 7, $compresses_content, SQL_LONGVARCHAR );
    $sth->bind_param( 8, $comment);
    $sth->bind_param( 9, $state);
    $sth->execute() or die $DBI::errstr;

    my $result = $dbh->selectrow_arrayref('select last_insert_id()');   # TODO   получать ID одновременно с insert?
    my $file_id = $result->[0];
    $proj->log("upload_file done    file_id=$file_id");
    return $file_id;
}


# Using:
#    my $data = download_file($proj, $id);
#    my $file_name = $data->{file_name} // 'data';
#    my $file_type = $data->{file_type} // '';
#    my $file_content = $data->{file_content} // '';
#    my $comment = $data->{comment} // '';
sub download_file {
    my ($proj, $id, %prm) = @_;
    return if not $id;
    $proj->log("download_file: file_id=$id");

    my $dbh = $proj->dbh;

    # from db
    #my $sth = $dbh->prepare("select `Date`, `Login`, `Info`, `Title`, `FileName`, `FileType`, `FileContent` from $table_name where id=$id");
    my @fld = qw( Date Login Info Title FileName FileType FileContent Comment State );
    my $sth = $dbh->prepare("SELECT " . join(", ", map {"`$_`"} @fld) . " from $table_name where ID=$id");
    $sth->execute() or die $DBI::errstr;
    my ($date, $login, $info, $title, $file_name, $file_type, $content_compressed, $comment, $state ) = $sth->fetchrow_array();
    $sth->finish;
    $proj->log("from content length: " . length($content_compressed));
    # /from db

    # unzip
    my $content_uncompressed;
    gunzip \$content_compressed => \$content_uncompressed or die "gunzip failed: $GunzipError\n";
    $proj->log("from content unzipped: " . length($content_uncompressed));
    # /unzip

    my $result = {
        id => $id,
        date => $date,
        login => $login,
        info => $info,
        file_name => $file_name,
        file_type => $file_type,
        file_content => $content_uncompressed,
        comment => $comment,
        title => $title,
        state => $state,
    };
    $proj->log("download_file done");
    return $result;
}


# Отправить на email пользователя ссылку для скачивания файла
# send_file_link($proj,
#    file_id => $file_id,    # ID файла из таблицы файлов
#    email => $email,
#    title => $title,
#    comment => $comment,
#)
sub send_file_link {
    my ($proj, %prm) = @_;
    $proj->log("send_file_link... $prm{file_id} $prm{email} $prm{login}");
    my $file_id = $prm{file_id} // return;
    my $email_to = $prm{email} || $proj->login2email($prm{login}) || return;
    my $comment = $prm{comment} // '';
    my $title = $prm{title} // '';

    $proj->log("send_file_link: $email_to ($title)");

    #$title .= " [$email_to] "; # For test!  TODO remove!
    #$email_to = 'emurav@yandex-team.ru'; # For test!  TODO remove!

    my $host = _get_host($proj);
    my $http_path = _get_download_link($proj, $file_id);
    if (not $http_path) {
        $proj->log("ERROR: void http_path (file_id=$file_id)");
        return;
    }
    my $text = '';
    $text .= "Заказанные Вами данные "
            . "Вы можете скачать по ссылке:\n$http_path\n\n"
            . ($comment ? "$comment\n\n" : "")
            . "\nЭто письмо сформировано автоматически. Пожалуйста, не отвечайте на него.\n"
            . "Если у Вас возникли вопросы о полученном файле, Вы можете писать на адрес " . 'emurav@yandex-team.ru' . "\n";

    my $email_from = 'no_reply@yandex-team.ru';
    my $subject = "$host data" . ($title ? ": $title" : "");
    my $email_bcc = 'emurav@yandex-team.ru';   # To be removed  TODO 

    my $mail_data = {
        from    => $email_from,
        to      => $email_to,
        bcc     => $email_bcc,
        subject => $subject,
        body    => $text,
    };
    $proj->log("SendMail ($email_to, '$subject')... ");
    $proj->SendMail($mail_data);
    $proj->log("send_file_link done");
    return 1;
}


sub _get_host {
    my ($proj) = @_;
    if ($proj->host_role eq "bmfront") {
        return "bmfront.bm.yandex-team.ru";
    }
    return "catmedia.yandex.ru";
}


# Создает ссылку для скачивания файла
sub _get_download_link {
    my ($proj, $file_id, %prm) = @_;

    my $host = _get_host($proj);
    my $http_path = "http://$host/fcgi-bin/interface/";
    my $query = "cmd=get_file&file_id=$file_id";
    my $sign = $proj->get_sign(query => $query);
    $http_path .= "ind.pl?$query&sign=$sign";
    return $http_path;
}


# Скачать файл, сохраненный в базе
sub get_file : CMD {
    my ($proj, $vars) = @_;
    my $form = $vars->{form};
    my $file_id = $form->{file_id};

    my $query = $ENV{QUERY_STRING};
    if (not $file_id  or  not $proj->check_sign(query => $query)) {
        $proj->log("ERROR in get_file ($file_id)");
        $vars->{template} = "Lists/message.tmpl";
        $vars->{title} = "Ошибка";
        $vars->{text} = "Неверный адрес";
        return;
    }

    # TODO Check user login?
    my $data = download_file($proj, $file_id);
    my $file_name = $data->{file_name} // 'data';
    $file_name = 'data'    if $file_name eq '';
    my $file_type = $data->{file_type} // '';
    my $file_content = $data->{file_content} // '';

    if ($file_type eq 'xls') {
        $vars->{'_return_real_xls'} = "$file_name.$file_type";
        $vars->{text} = $file_content;
    } elsif ($file_type eq 'txt') {
        $vars->{'_return_textfile'} = "$file_name.$file_type";
        $vars->{text} = $file_content;
    } else {
        # TODO
        $proj->log("ERROR in get_file ($file_id - $file_name.$file_type)");
        $vars->{title} = "ERROR";
        $vars->{text} = "Could not download file";
        $vars->{template} = "Lists/message.tmpl";
        return;
    }
}


# Обработка тасков из TasksQueue
sub process_task {
    my ($proj, $task, $prm) = @_;
    return if not $task or not $prm;

    my $url = $prm->{url};

    my $res;
    $res = download_dblist_link($proj, $url);
    return { state => 'done' }   if $res;
}


sub download_dblist_link {
    my ($proj, $url) = @_;
    return if not $url;

    my $logfile_wget = $Utils::Common::options->{dirs}{'log'} . "/wget.err";
    my $max_attempt_count = 5;
    my $res;
    my $attempt_count = 0;
    while ($attempt_count < $max_attempt_count) {
        $proj->log("Downloading $url ...     attempt_count=$attempt_count");
        my $res_wget = `wget --user-agent='bm_download' --append-output=$logfile_wget -O- '$url'`;
        $proj->log("Downloaded");
        if ($res_wget =~ /DBList_OK/  and  $res_wget !~ /ERROR/) {
            $res = 1;
            last;
        }
        $proj->log("res_wget: $res_wget");
        ++$attempt_count;
        sleep(5 + int rand 5)  if !$res  and  $attempt_count < $max_attempt_count;
    }
    if ($res) {
        $proj->log("Download OK ($url)");
        return 1;
    } else {
        $proj->log("ERROR: Bad download ($url)");
    }
    return;
}



1;

