package BM::Dicts::BaseDict;
use strict;

use utf8;
use open ':encoding(utf8)';

use std;
use base qw(ObjLib::ProjPart);

__PACKAGE__->mk_accessors(qw(
    proj
    name
    phrase_list
    language
));

sub init {
    my ($self) = @_;
    my $ts_key_value = {};
    my $line_count = 0;

    $self->log("load " . $self->name . " " . $self->lang);
    
    $self->{pre_load}->($self) if $self->{pre_load};

    if($self->{source_file}) {
        my @phrases;
        $self->log("load from source: `$self->{source_file}'");
        open F, $self->{source_file} or die "Can't open $self->{source_file}: $!";
        while(my $line = <F>) {
            chomp $line;

            if($self->{load_line}) {
                $self->{load_line}->($self, $line);
            } else {
                unless ($line =~ m/^\s*#/) { # Игнорируем строки-комментарии
                    push @phrases, $self->language->phrase($line);
                }
            }

            $line_count++;
        }
        close F;
        $self->{phrase_list} = $self->proj->phrase_list(\@phrases);
    }
    
    $self->{post_load}->($self) if $self->{post_load};

    $self->log("/ load " . $self->name . " " . $self->lang . " ($line_count)");
}

sub lang :CACHE {
    my ($self) = @_;

    return $self->language->name;
}

sub norm_with_stops_hash {
    my ($self) = @_;
    my $h = {};

    $h->{$_->norm_phr_with_stops}++ for $self->phrase_list->phrases;

    return $h;
}

sub norm_hash :CACHE {
    my ($self) = @_;
    my $h = {};

    $h->{$_->norm_phr}++ for $self->phrase_list->phrases;

    return $h;
}

sub snorm_hash :CACHE {
    my ($self) = @_;
    my $h = {};

    $h->{$_->snorm_phr}++ for $self->phrase_list->phrases;

    return $h;
}

1;
