package BM::Dicts::DictManager;
use strict;

use utf8;
use open ':encoding(utf8)';

use std;
use base qw(ObjLib::ProjPart);

use Scalar::Util qw(weaken);

use BM::Categories::Atom;
use BM::Dicts::BaseDict;
use BM::Dicts::DictOptions;
use Utils::Common;
use Utils::Words;

__PACKAGE__->mk_accessors(qw(
));

sub init {
    my ($self) = @_;

    $self->proj->{name2lang2dict} = {};
}

sub get_dict {
    my ($self, $name, $lang) = @_;
    my $proj = $self->proj;

    $lang ||= "ru";
    $proj->{name2lang2dict}{$lang} ||= {};

    if(!$proj->{name2lang2dict}{$lang}{$name}) {
        my $dict = undef;

        # пытаемся определить имя файла
        my $source_file = ($BM::Dicts::DictOptions::dicts->{$name} || {})->{source_file};
        if(!$source_file) {
            for my $fn (
                (map{$Utils::Common::options->{dirs}{dicts} . "/$_"} (
                    $lang . "_dict_$name", 
                    "dict_$name" . "_$lang", 
                    "dict_$name",
                    "custom/$name",
                )),
                (map{$Utils::Common::options->{dirs}{gen_dicts} . "/$_"} (
                    "dict_$name",
                    $name . "_dict",
                )),
                (map{$Utils::Common::options->{dirs}{work} . "/$_"} (
                    "$name",
                ))) {
                if (-e $fn) {
                    $source_file = $fn;
                    last;
                }
            }
        }

        if(!$source_file) {
            die "Can't load dict $name $lang";
        } else {
            $dict = BM::Dicts::BaseDict->new({
                proj        => $proj,
                name        => $name,
                source_file => $source_file,
                language    => $proj->get_language($lang),
                %{$BM::Dicts::DictOptions::dicts->{$name} || {}}
            });
            $proj->{name2lang2dict}{$lang}{$name} = $dict;
        }
    }

    return $proj->{name2lang2dict}{$lang}{$name};
}

1;
