package BM::Dicts::DictOptions;
use strict;

use utf8;
use open ':encoding(utf8)';

use Utils::Common;


my $dictopt = $Utils::Common::options->{DictOptions_params};

our ($dicts);

$dicts = {
    directmod => {
        source_file => $Utils::Common::options->{DictDirectMod}{file},
    },
    bad_dyn_phrases => {
        source_file => $Utils::Common::options->{dyn_stat_params}{file_bad_dyn_phrases},
    },
    biwords => {
        source_file => $dictopt->{biwords_source},
        post_load => sub {
            my ($dict) = @_;
            my $proj = $dict->proj;
            my $biwords = {};
            for my $phr (@{$dict->phrase_list}) {
                for my $pair (split (/,\s*/, $phr->text)) {
                    my @words = $proj->phrase($pair)->snormwords;
                    if(@words == 2) {
                        my ($w1, $w2) = sort @words;
                        $biwords->{$w1, $w2} = $pair;
                    }
                }
            }

            $dict->{pairs} = $biwords;
        }
    },
    biwords_strict => {
        source_file => $dictopt->{biwords_strict_source},
        post_load => sub {
            my ($dict) = @_;
            my $proj = $dict->proj;
            my $biwords = {};
            for my $phr (@{$dict->phrase_list}) {
                for my $pair (split (/,\s*/, $phr->text)) {
                    my @words = $proj->phrase($pair)->normwords;
                    if(@words == 2) {
                        my ($w1, $w2) = sort @words;
                        $biwords->{$w1, $w2} = $pair;
                    }
                }
            }

            $dict->{pairs} = $biwords;
        }
    },

    multiwords => {
        post_load => sub {
            my ($dict) = @_;
            my $proj = $dict->proj;
            my $trie = {};
            for my $phr (@{$dict->phrase_list}) {
                for my $pair (split (/,\s*/, $phr->text)) {
                    my @words = $proj->phrase($pair)->snormwords;

                    my $node = $trie;
                    for my $word (@words) {
                        $node = ($node->{$word} ||= {});
                    }
                    $node->{" "} = 1;
                }
            }

            $dict->{trie} = $trie;
        }
    },

    translit_en2ru => {
        post_load => sub {
            my ($dict) = @_;
            my $proj = $dict->proj;
            my $trie = {};
            my $prefix2node = { "" => $trie };

            for my $phr (@{$dict->phrase_list}) {
                my ($from, $to) = split /\s+/, $phr->text;
                next if !$from || !$to;

                my @from_chars = split //, $from;
                my $node = $trie;
                my $prefix = "";
                for my $char (@from_chars) {
                    $prefix .= $char;
                    
                    if(!$node->{$char}) {
                        $node->{$char} = {};
                        $prefix2node->{$prefix} = $node->{$char};
                    }

                    $node = $node->{$char};
                }

                $node->{" "} = [ grep{$_} split /\s*,\s*/, $to]
            }

            $dict->{trie} = $trie;
            $dict->{prefix2node} = $prefix2node;
        },
    },

    wordcount => {
        pre_load => sub {
            my ($dict) = @_;
            $dict->{word2count} = {};
            $dict->{restore_signs} = {};
        },

        load_line => sub {
            my ($dict, $line) = @_;
            my ($word, $count) = split "\t", $line;

            if($count > 100) {
                $dict->{word2count}{$word} = $count;

                if($word =~ /[ьъ]/) {
                    my $short = $word;
                    $short =~ s/[ьъ]//g;

                    my $curr_orig = $dict->{restore_signs}{$short};
                    $dict->{restore_signs}{$short} = $word if !$curr_orig || ($dict->{word2count}{$curr_orig} || 0) < $count;
                }
            }
        },

        post_load => sub {
            my ($dict) = @_;
            $dict->proj->log(scalar(keys %{$dict->{word2count}}) . " words totally");
        },
    },
};

1;
