package BM::Dicts::Multiwords;
use strict;
use utf8;

use open ':utf8';

use base qw(ObjLib::ProjPart);

sub init {
    my ($self) = @_;
    
    $self->{root} = {};
    $self->{empty} = " ";
}

sub get_phrase_words {
    my ($self, $phrase) = @_;

    return $phrase->normwords_with_stops;
}

sub words2multiword {
    my ($self, @words) = @_;

    return "__mw_".join("_", @words);
}

sub multiword2words {
    my ($self, $mw) = @_;

    if(!($mw =~ s/^__mw_//)) {
        return @{[$mw]};
    }

    my @ww = split /_+/, $mw; # __mw_удобный_поиск__работы_ -> qw[ удобный поиск работы ]
    # TODO: должно быть: __mw_удобный_поиск__работы_ -> qw[ удобный поиск _работы_ ]   ???

    return grep { $_ ne '' } @ww;
}

sub add_phrase {
    my ($self, $phrase) = @_;
    my $node = $self->{root};
    my @words = $self->get_phrase_words($phrase);

    if(!@words) {
        return "";
    }

    for my $w (@words) {
        $node = ($node->{$w} ||= {});
    }

    $node->{$self->{empty}}++;

    return $self->words2multiword(@words);
}

sub search_multiwords_arr {
    my ($self, $phrase) = @_;
    my @words = $self->get_phrase_words($phrase);
    my @result;

    for my $i (0..$#words) {
        my $node = $self->{root};
        my $next;
        my $j = $i;

        while($j < @words && ($next = $node->{$words[$j]})) {
            if($next->{$self->{empty}}) {
                push @result, [@words[$i..$j]];
            }
            $node = $next;
            $j++;
        }
    }

    return @result;
}

sub search_multiwords {
    my ($self, $phrase) = @_;

    return map{$self->words2multiword(@$_)} $self->search_multiwords_arr($phrase);
}

1;
