package BM::Filters;

# массив фильтров
use base qw(ObjLib::ProjPart);
use strict;

sub init {
    my ( $self ) = @_;
    $self->{zora_pack_size} = 50;
    my $params = $self->{params};
    for my $key ( keys %$params ) {
        $self->{filters}{$key} = $self->proj->filter({ filter => $params->{$key} });
    }
    return $self;
}

sub filter_tskv {
    my ( $self, $tskv ) = @_;
    my %result_hash = ();
    for my $filter ( values %{$self->{filters}} ) {
        %result_hash = ( %result_hash, %{ $filter->filter_tskv_to_hash_strings( $tskv ) } );
    }
    return join("\n", keys %result_hash);
}

sub filter_tskv_count {
    my ( $self, $tskv ) = @_;
    my %result_hash = ();
    for my $filter ( values %{$self->{filters}} ) {
        %result_hash = ( %result_hash, %{ $filter->filter_tskv_to_hash_strings( $tskv ) } );
        # если костыль с name normlike удалил все
        if (scalar(keys %result_hash) == 0 && $filter->{'filter'}->{'name normlike'}) {
            $self->log("Remove name normlike");
            $filter->remove_name_normlike;
            %result_hash = ( %result_hash, %{ $filter->filter_tskv_to_hash_strings( $tskv ) } );
        }
    }
    return scalar(keys %result_hash);
}

sub grep_filter {
    my ( $self, $item ) = @_;
    my @result = ();
    for my $key ( keys %{$self->{filters}} ) {
        my $result_item = $self->{filters}{$key}->filter( [$item] );
        if ( ref($result_item) eq 'ARRAY' && scalar(@$result_item) > 0 ) {
            push @result, $key;
        }
    }
    return @result;
}

sub grep_list {
    my ($self, $list) = @_;
    my $keyname = '___grep_filter_simple';
    for my $key ( keys %{$self->{filters}} ) {
        my $fltd = $self->{filters}{$key}->filter($list);
        $_->{$keyname} .= ($_->{$keyname} ? ',' : '').$key for @$fltd;
    }
    $list = [ grep { defined( $_->{$keyname}) } @$list ];
    delete($_->{$keyname}) for @$list;
    return $list; 
}

# Params:
# $list     - list of object to filter
# $keyname  - key to write info
#
# For each $obj in $list writes to $obj->{$keyname} names (comma-separated) of filters that save $obj
sub grep_filter_list {
    my ($self, $list, $keyname) = @_;

    # сначала используем $keyname для хранения фильтров, по которым выполнены простые условия
    $_->{$keyname} = [] for @$list;
    while (my ($filter_id, $filter_obj) = each %{$self->{filters}}) {
        my $filt = $filter_obj->filter_by_simple_conditions($list);
        $filt = $filter_obj->filter_by_extended_conditions($filt);
        push @{$_->{$keyname}}, $filter_id for @$filt;
    }

    my @ext_list;
    for my $item (@$list) {
        my $ids = delete($item->{$keyname});
        push @ext_list, [$item, $ids] if @$ids;
    }
    for my $h (@{$self->filter_by_zora_conditions(\@ext_list)}) {
        my ($item, $ids) = @$h;
        $item->{$keyname} = join(',', @$ids) if @$ids;
    }
}

# применяем фильтрацию по контенту страниц
# на входе список пар [$item, $filter_ids_list]
# возвращаем подобный список (и той же длины), но оставляем только id фильтров, по которым удовлетворены zora_conditions
sub filter_by_zora_conditions {
    my $self = shift;
    my $list_with_fids = shift;

    my $filters = $self->{filters};

    # готовим данные для вычисления фильтров, нам нужны:
    # * ключи вида "$url\t$value", по ним есть кэширование
    # * подготовленные данные - вместо field/value запоминаем ключи
    my (%key2data, @prep_data);
    for my $h (@$list_with_fids) {
        my ($item, $filter_ids) = @$h;
        my %prep_filter;
        for my $filter_id (@$filter_ids) {
            my $filter_obj = $filters->{$filter_id};
            my @prep_zora_conds;
            for my $cond ($filter_obj->get_zora_conditions) {
                my $field = $cond->{field};
                my @cond_keys;
                for my $value (@{$cond->{values}}) {
                    my $url = $item->{$field};
                    my $key = join("\t", $url, $value);
                    $key2data{$key} = {url => $url, value => $value} if !$key2data{$key};
                    push @cond_keys, $key;
                }
                push @prep_zora_conds, {keys => \@cond_keys, type => $cond->{type}, negation => $cond->{negation}};
            }
            $prep_filter{$filter_id} = \@prep_zora_conds;
        }
        push @prep_data, {item => $item, filters => \%prep_filter};
    }

    my $key2res = $self->_get_zora_condition_matches_kyoto([keys %key2data], \%key2data);

    my @result;
    for my $h (@prep_data) {
        my $item = $h->{item};
        my @res_filter_ids;
        FILT: while (my ($filter_id, $conds) = each %{$h->{filters}}) {
            # вычисляем результат фильтра: нужно проверить все условия через "И"
            for my $cond (@$conds) {
                my $type = $cond->{type};
                # вычисляем результат условия:
                # not? ((url contains|titlecontains value1) OR (url contains|titlecontains value2) OR ...)
                my $or_res = 0;
                for my $key (@{$cond->{keys}}) {
                    if ($key2res->{$key}{$type}) {
                        $or_res = 1;
                        last;
                    }
                }
                my $cond_res = $cond->{negation} ? (not $or_res) : $or_res;
                next FILT if !$cond_res;  # одно из условий нарушено, дальше не смотрим
            }
            push @res_filter_ids, $filter_id;  # все условия выполнены
        }
        push @result, [$h->{item}, \@res_filter_ids];
    }
    return \@result;
}

# возвращает результаты матчинга контента урлов с фильтрами
# параметры:
#   $keys - список ключей ("$url\t$filter_value"), по которым кэширование в киото
#   key2data: хэш {$key => {url => $url, value => $filter_value}}
# доп. параметры:
#   zora_pack_size => subj (дефолт прописан в init)
# результат: {$key1 => {contains => 1, titlecontains =>0}, ...}
sub _get_zora_condition_matches_kyoto : KYOTOCACHEHASHREF(864000) {
    my ($self, $keys, $key2data, %par) = @_;

    my %url2keys;
    for my $key (@$keys) {
        my $url = $key2data->{$key}{url};
        push @{$url2keys{$url}}, $key;
    }

    my %result;
    my $zora_pack_size = $par{zora_pack_size} // $self->{zora_pack_size};
    my $zora_client = $self->proj->zora_client;
    my @urls = keys %url2keys;
    while (@urls) {
        my @urls_pack = splice(@urls, 0, $zora_pack_size);
        my $zora_result = $zora_client->multi_get_hashref(\@urls_pack);
        for my $url (@urls_pack) {
            my $url_raw_data = $zora_result->{$url} // {};
            my $url_data = { map { $_ => lc($url_raw_data->{$_} // '') } qw(title content) };
            for my $key (@{$url2keys{$url}}) {
                my $key_result = {contains => 0, titlecontains => 0};
                my $value = $key2data->{$key}{value};
                if (index($url_data->{content}, $value) > -1) {
                    $key_result->{contains} = 1;
                }
                if (index($url_data->{title}, $value) > -1) {
                    $key_result->{titlecontains} = 1;
                }
                $result{$key} = $key_result;
            }
        }
    }

    return \%result;
}

1;
