package BM::Kyoto;

use strict;

use base qw(ObjLib::ProjPart);

use Data::Dumper;
$Data::Dumper::Useqq = 1;
use Time::HiRes qw/gettimeofday tv_interval/;

use Utils::Sys; # для md5
use Utils::Common;
use Storable;

# по имени функции и значению kyoto возвращает хэш: obj->get_remotecache
sub get_kyoto_values {
    my ( $proj, $function_name, $arrayref ) = @_;

    my $ktclient = $proj->ktclient();
    my $result = {};

    for my $object ( @$arrayref ) {
        unless ( $object->can('get_remotecache_id') ) {
            $proj->log("ERROR: object cannot get_remotecache_id");
            exit(0);
        }

        my $key = md5int_base64($function_name . $Utils::Common::options->{kyoto}{salt}) . '_' .md5int_base64($object->get_remotecache_id);

        # если смогли прочитать из кэша - вернем все что нужно
        my $remote_value = Storable::thaw($ktclient->get($key));

        # правильное значени всегда массив
        if ( defined($remote_value) && ref($remote_value) eq 'ARRAY' ) {
            $result->{ $object->get_remotecache_id } = $remote_value;
        }
    }
    return $result;
}

1;
