package BM::LRUCache;

use strict;

use utf8;

use base qw(ObjLib::ProjPart);

sub init {
    my ($self) = @_;
    require Tie::Cache;
    my %lru_cache;
    tie %lru_cache, 'Tie::Cache', $self->{conf};
    $self->{__cache} = \%lru_cache;
    $self->{__namespaces} = {};
    $self->{__namespace_next_id} = 0;
    $self->{__default_namespace} = $self->{conf}{default_namespace} // '__DEFAULT__';
}

sub get {
    my ($self, $key, $namespace) = @_;
    return $self->{__cache}{$self->_get_key($namespace, $key)};
}

sub set {
    my ($self, $key, $value, $namespace) = @_;
    $self->{__cache}{$self->_get_key($namespace, $key)} = $value;
}

sub _get_key {
    my ($self, $namespace, $key) = @_;
    $namespace //= $self->{__default_namespace};
    return join("\t", $self->_get_namespace_id($namespace), $key);
}

sub _get_namespace_id {
    my ($self, $namespace) = @_;
    my $id = $self->{_namespaces}{$namespace};
    if ( !defined $id ) {
        $id = $self->{_namespace_next_id}++;
        $self->{_namespaces}{$namespace} = $id;
    }
    return $id;
}

1;
