package BM::LemmerTest;
use strict;
use utf8;


# перловый интерфейс к lemmer-test
#
# my $lmr = BM::LemmerTest->new(@opts);
# my $str = $lmr->analyze('текст в utf-8');

use base qw(ObjLib::ProjPart);

use IPC::Open2;

use open ':utf8';

sub init {
    my $self = shift;
    my $call = join(' ',
        $Utils::Common::options->{DictNorm}{lemmer_bin},
        '-c', '-d', '-m ru,en,tr',
        @{$self->{args}},
    );

    $self->log("init lemmer_test with call `$call' ...");
    $self->{pid} = IPC::Open2::open2(my $out_fh, my $in_fh, $call);
    binmode $in_fh, ':utf8';
    binmode $out_fh, ':utf8';
    $self->{in_fh} = $in_fh;
    $self->{out_fh} = $out_fh;
    return $self;
}

sub analyze {
    my $self = shift;
    my $text = shift;
    $text =~ s/\x00//g;
    my ($in_fh, $out_fh) = ($self->{in_fh}, $self->{out_fh});
    my $res = '';
    for my $line (split /\n/, $text, -1) {
        print $in_fh $line."\n";
        while (<$out_fh>) {
            $res .= $_;
            last if /====/;
        }
    }

    return $res;
}

# парсим выдачу метода analyze
# выдает список хэшей с инфой о леммах
sub parse {
    my $self = shift;
    my $output = shift;
    my @fields = qw(lemma rule_id quality stem_gram flex_gram form token_pos token_span lang flags paradigm);
    my @result;
    my $curr_query;
    my $mode = 'query';  # что ждет нас
    for my $line (split /\n/, $output) {
        if (!$line) {
            next;
        } elsif ($line =~ /^\s*====\s*$/) {
            $mode = 'query';
            next;
        }

        if ($mode eq 'query') {
            $curr_query = $line;
            $mode = 'lemmas';
        } elsif ($mode eq 'lemmas') {
            my @data = split / /, $line;  # важно разрезать по / / а не ' '!
            my %data;
            @data{@fields} = @data;
            $data{query} = $curr_query;
            push @result, \%data;
        }
    }
    return @result;
}

# парсит строку с описанием парадигмы, выдает слово
sub parse_paradigm {
    my $self = shift;
    my $str  = shift;
    $str =~ s/\{[^\}]*\}//g;
    $str =~ s/[\[\]]//g;
    return split /,/, $str;
}


sub DESTROY {
    my $self = shift;

    close $self->{in_fh};
    close $self->{out_fh};

    waitpid($self->{pid}, 0);
}

1;
