package BM::MCached;

use Data::Dumper;
use Digest::MD5;
use POSIX qw/strftime/;
use Fcntl qw/:DEFAULT :flock/;

use base qw(ObjLib::ProjPart);
use Utils::Sys qw/md5int/;
use Utils::Common;
use Time::HiRes qw/gettimeofday tv_interval/;

use constant EXPIRATION_INTERVAL => 14 * 24 * 3600; 	# 2 недели
use constant MIN_KEYS_TO_DUMP => 1_000;     		# по сколько ключей кладем в dump
use constant MCACHED_PACK     => 20;			# насколько большими пачками получаем значения из memcached и кладем

use constant DUMP_GETCC => 0;
use constant DUMP_GETCCARRAY => 0;
use constant DUMP_SETCC => 0;
use constant DUMP_SETCCARRAY => 0;

use utf8;
use open ':utf8';

sub getcc {
	my ( $self, $type, $key ) = @_;
	
	my $initial_key = $key;	# для последующего сохранения в дампе
	$key = md5int($key);

    	my $clh = $self->proj->memclient();

	my $result = $clh->get($key);

	if ( defined($result) && ref($result) eq 'HASH' && exists($result->{$type} )) {
		if ( DUMP_GETCC ) {
			$self->proj->{mcached_dump}{$key} = [ $initial_key, $result ];
			$self->dump_mcached_keys();
		}
		return $result->{$type};
	}
	return "-1";

}

sub setcc {
	my ( $self, $type, $key, $value ) = @_;
	my $initial_key = $key;	# для последующего сохранения в дампе

	$key = md5int($key);


    	my $clh = $self->proj->memclient();

	my $result = $clh->get($key) || {};

	$result->{$type} = $value;
	my $set_result = $clh->set($key,$result,EXPIRATION_INTERVAL);

	if ( DUMP_SETCC ) {
		$result = $clh->get($key) || {};
		$self->proj->{mcached_dump}{$key} = [ $initial_key, $result ];
		$self->dump_mcached_keys();
	}

	return;
}

sub dump_mcached_keys {
	my ( $self ) = @_;
	if ( scalar( keys %{$self->proj->{mcached_dump}}) > MIN_KEYS_TO_DUMP ) {
		my $dump_start = [gettimeofday];
		$self->log("dump mcached keys start");
		local $Data::Dumper::Indent = 0;
		local $Data::Dumper::Terse = 1;

		my @insert = ();
		for my $key ( keys %{$self->proj->{mcached_dump}}  ) {
			my $initial_key = $self->proj->{mcached_dump}{$key}[0];
			my $value = $self->proj->{mcached_dump}{$key}[1];
			if ( ref($value) eq 'HASH' ) {
				push @insert, join("\t", $key, $initial_key, Dumper( $value )) ."\n";
			}
		}
		my $current_dump = $Utils::Common::options->{dirs}{work} . '/matchingcontroller/dynamic_memcached_dump_'. strftime("%Y-%m",localtime);

		open (tF,">>$current_dump") || $self->log("cannot open file: $current_dump, $!") && return 0;
		flock (tF, LOCK_EX);
		print tF $_ for @insert;
		close tF;

		$self->proj->{mcached_dump} = {};
		$self->log("dump mcached keys done to file $current_dump done in " . tv_interval($dump_start) . " sec");
	}
	return 1;

}


1;
