package BM::Markers;

use strict;

use utf8;
use open ':utf8';
no warnings 'utf8';
use base qw(ObjLib::ProjPart);

use Data::Dumper;
use Time::HiRes qw/gettimeofday tv_interval/;
use BM::Phrase;
use Utils::Common;

########################################################
# Интерфейс
########################################################

__PACKAGE__->mk_accessors(qw(
));

########################################################
# Инициализация
########################################################

sub get_plus_markers {
    my ($self, $in_phr) = @_;
    my %markers = ();

    #проставляем плюсы к стоп-словам, чтобы работали плюс-стоп-слова в маркерах
    my $phr = $self->proj->phrase($self->proj->phrase($in_phr->text_add_pluses_to_stop_words)->text_delete_pluses_except_stop_words);
    $phr->{mw_codes} = {}; #эта строчка отключает поиск по мультивордам (preprocess_for_atoms), которые не поддерживаются в маркерах. Сделано для ускорения
    $phr = $phr->preprocess_for_atoms;

    my $atoms = $phr->search_marker_atoms;

    my $flag2norm2mw = {};
    my %atom_names = ();
    for my $match ( keys %$atoms ) {
        my $sortedmatchminuswords;
        my $matchsnorm;
        my $match_phr = $self->proj->phrase($match);
        #достаем минус-слова из ответа сабфрейзера. Не прошедшие инфьюз (у них минус-слова в $match) затирают прошедшие (у них минус-слова после @aw)
        foreach my $str ( keys %{$atoms->{$match}} ) {
            if ( $str =~ /@/ ) {
                my ($flag,$mw) = split /\@aw /, $str;
                $mw = join ' ', map { "-$_" } sort split /\s+/, $mw;
                $flag =~ s/^[.]//;
                $flag =~ s/^_//;
                $flag2norm2mw->{$flag}->{$match}->{old}->{$mw} = 1;
            }
            else {
                $sortedmatchminuswords //= [ sort $match_phr->normminuswords ];
                if ( @$sortedmatchminuswords ) {
                    my $flag = $str;
                    $flag =~ s/^[.]//;
                    $flag =~ s/^_//;
                    my $mw = join ' ', map { "-$_" } @$sortedmatchminuswords;
                    $matchsnorm //= $match_phr->snorm_phr;
                    $flag2norm2mw->{$flag}->{$matchsnorm}->{new}->{$mw} = 1;
                }
                else {
                    my $flag = $str;
                    $flag =~ s/^[.]//;
                    $flag =~ s/^_//;
                    $flag2norm2mw->{$flag}->{$match}->{empty} = 1;
                }
            }
        }
    }
    for my $match ( keys %$atoms ) {
        my @match_markers = map {$_ =~ s/^_//r} map {$_ =~ s/^[.]//r} map { $_ =~ s/@.*$//r } keys %{$atoms->{$match}};

        foreach my $flag ( @match_markers ) {
            my @matches;
            foreach my $match (keys %{$flag2norm2mw->{$flag}}) {
                my @mw_arr = ();

                #высший приоритет у свежих правок
                if ( exists $flag2norm2mw->{$flag}->{$match}->{new} ) {
                    @mw_arr = keys %{$flag2norm2mw->{$flag}->{$match}->{new}};
                }
                #если их нет - то фраза без минус-слов, неважно, новая она или старая, в обоих случаях это правильное место
                elsif ( exists $flag2norm2mw->{$flag}->{$match}->{empty} ) {
                    @mw_arr = ( ' ' );
                }
                #если ничего нет - то фразы, прошедшие инфьюз
                elsif ( exists $flag2norm2mw->{$flag}->{$match}->{old} ) {
                    @mw_arr = keys %{$flag2norm2mw->{$flag}->{$match}->{old}};
                }
                push @matches, $match . ' ' . $_ foreach @mw_arr;
            }
            foreach my $txt ( @matches ) {
                if (! grep {$phr->snormwordshash()->{$_} } $self->proj->phrase($txt)->snormminuswords ) {
                    $markers{$flag} = $txt;
                    last;
                }
            }
        }
    }
    return \%markers;
}

sub get_minus_markers {
    my ($self, $phr, $flaglist) = @_;
    my %result = ();
    foreach my $flag ( @$flaglist ) {
        my @aw = @{$phr->search_phrase_antiwords(".$flag")} || @{$phr->search_phrase_antiwords("._$flag")};
        $result{$flag} = join ',', @aw if @aw;
    }

    return \%result;
}

sub get_marker_plus_phrases {
    my ($self, $marker) = @_;
    my $cat_id = $self->proj->categs_tree->get_minicateg_id(".$marker");
    my %uniq_phrases = ();
    return @{$self->proj->get_category_phrases($cat_id )};
}

sub get_marker_minus_phrases {
    my ($self, $marker) = @_;
    my $cat_id = $self->proj->categs_tree->get_minicateg_id(".$marker");
    return @{$self->proj->category_interface->get_antiwords($cat_id, "ru")};
}

1;
