package BM::Matching::SrvGraph;
use strict;
use warnings;

use utf8;
use open ':utf8';

use std;
use base qw(BM::Matching::Graph);

use List::Util qw(sum min max);

use Utils::Sys qw(md5int);

# Это на самом деле симпграф, а не граф!

########################################################
# Интерфейс
########################################################

#   load_graph                 загрузка графа в память
#   get_phl_phrases            по списку фраз (PhraseList) возвращает привязки (PhraseList)
#   get_bnr_phrases            по баннеру возвращает привязки к его родным фразам

########################################################
# Инициализация
########################################################

sub init {
    my ($self) = @_;
    my $proj = $self->proj;
}

sub load_graph {
    my ($self) = @_;
}

# получить все ассоциации по списку фраз
# на входе:
#   $phl = список фраз
# на выходе:
#   список [ src_snorm_phr,  $assoc_phl ]
sub get_all_phrases {
    my $self = shift;
    my $phl  = shift;

    return [] if !$phl->count;

    my $text;

    my $data_source = $self->{data_source} // 'cdict';

    if ($data_source eq 'mysql') {
        my @ids = map { $_->snorm_id } @$phl;
        my ($dbh_name, $tbl_name) = ($self->{dbh_name}, $self->{tbl_name});
        my $dbh = $self->proj->dbhlist->{$dbh_name};
        my $data = $dbh->List_SQL("select Source,Assocs from $tbl_name where SourceID in (".join(',', @ids).")");
        $text = join("\n", map { $_->{Source}."\t".$_->{Assocs} } @$data);
    }

    return [] if !$text;
    chomp $text;

    my @result;
    for my $line (split /\n/, $text) {
        my ($src, $assocs) = split /\t/, $line;
        my $assoc_phl = $self->proj->phrase_list({ phrases_inf_text => $assocs });
        if ($assoc_phl->count) {
            push @result, [ $src, $assoc_phl ];
        }
    }
    return \@result;  # TODO переделать на хэш
}

1;
