package BM::Models;
use strict;

use utf8;
use open ':utf8';

use std;
use base qw(ObjLib::ProjPart);

use Data::Dumper;
use Utils::Words;
use XML::Parser;

use Utils::Sys qw(
    do_safely
);

use JSON qw(to_json from_json);

########################################################
#Доступ к полям
########################################################

__PACKAGE__->mk_accessors(qw(
    vendors
    modeltypes
    vendormodel2modeltype
));

########################################################
#Методы
########################################################

#   load_models              Прочитать файл с моделями -- здесь логика комбинирования model-vendor-type
#   get_phr_models           Расклеить фразу на много фраз с помощью моделей
#   is_model_type            Является ли фраза типом товара

sub load_models {
    my ($self) = @_;
    my $proj = $self->proj;

    $self->modeltypes({});
    $self->vendors({});

    $self->log('vendor');
    
    for my $name ("vendors", "modeltypes") {
        my $fn = $self->{"gen_".$name."_file"};
        open F, $fn or $self->log("ERROR: can't open $fn for reading");
        while(<F>) {
            chomp;
            $self->{$name}{$_}++;
        }
        close F;
    }
    
    $self->log('/ vendor');
}




sub get_phr_models {
    my ($self, $phr) = @_;
    my $proj = $self->proj;
    my @arr = @{ $self->{'phr_models_data'}->{ $phr->snorm_phr } || [] };
    $#arr = 300 if @arr > 300;
    return $proj->phrase_list({ phrases_arr => \@arr });
}

sub is_model_type {
    my ($self, $phr) = @_;
    return $self->modeltypes->{$phr->snorm_phr};
}

# Здесь определяются handler-ы для событий от XML-парсера
# XML::Parser::Style::Stream работает только с Pkg::sub

package ParseXMLModels;

our $out_fh;  # костыль ?

my %curr;
my ($categ, $model, $vendor, $text);

sub StartTag {
    my $self = shift;
    my $tag = shift;
    if ($tag eq 'category') {
        # здесь мы предполагаем, что категория всего одна
        # на момент написания этого кода так и было
        $categ = int($_{id});
    }
}

sub EndTag {
    my $self = shift;
    my $tag = shift;
    if ($tag eq 'name') {
        $model = $text;
        $model =~ s/[\t\n]//g;
    } elsif ($tag eq 'vendor') {
        $vendor = $text;
        $vendor =~ s/[\t\n]//g;
    } elsif ($tag eq 'model') {
        print $out_fh join("\t", $model, $vendor, $categ), "\n";
    }
}

sub Text {
    $text = $_;
}

package ParseXMLCategs;

our $out_fh;  

sub StartTag {
    my $self = shift;
    my $tag = shift;
    if ($tag eq 'category') {
        my $categ = $_{hyper_id};
        my $name  = $_{name};  # TODO: прикрутить uniq_name
        print $out_fh join("\t", $categ, $name), "\n";
    }
}

sub EndTag {
    return;
}

sub Text {
    return;
}

# Возвращаемся в исходный namespace
package BM::Models;


########################################################
#Вспомогательные методы
########################################################

#Из массива генерирует все возможные сочетания входящих элементов
sub sochet {
    my $self = shift;
    my @a = @_;
    return @a, '' if @a == 1;
    my $cur = shift @a;
    my @arr = sochet(@a);
    push(@arr, map { $_ ? "$cur-$_" : $cur } @arr);
    return @arr;
}

#Возвращает варианты склейки
sub verjoin {
    my $self = shift;
    my $t = shift;
    my $tn = $t;
    return $t unless $tn =~ s/-//g;
    return ($t, $tn);
}

#Возвращает варианты склейки
sub verjoin2 {
    my $self = shift;
    my $arr = shift;
    return @$arr unless @$arr>1;
    my $prev1 = shift @$arr;
    my $prev2 = shift @$arr;
    my @narr = ("$prev1$prev2", "$prev1 $prev2");
    for(@$arr){
        push(@narr, "$prev2 $_", "$prev2$_", "$prev1$prev2$_", "$prev1 $prev2$_","$prev1$prev2 $_", "$prev1 $prev2 $_");
        $prev1 = $prev2;
        $prev2 = $_;
    }
    return @narr;
}

#Разваливаем модели по сокращённым вариантам записи
#Movie-Cube-recorder-R700-750Gb
sub model2vrnts {
    my $self = shift;
    my ($mdl) = @_;
    $mdl =~ s/([a-zA-Z])([0-9])|([0-9])([a-zA-Z])/$1? $1."-".$2 : $3."-".$4/eg;
    return $mdl unless $mdl =~ /-/;
    my @pt = grep {$_} split /-/, $mdl;
    @pt = $self->verjoin2(\@pt);
    return @pt;
}

1;
