package BM::Pages::Image;

use utf8;
use open ':utf8';

use std;
use base qw(BM::Pages::Page);

use Data::Dumper;

use Encode;
use IPC::Open2;

use URI::Escape;
use LWP::UserAgent;
use IPC::Open2;
use Digest::MD5 qw(md5_hex);
use FileHandle;
use Utils::Common;
use MIME::Base64;

use BM::Pages::PageText;
use Utils::Sys;

use open ":utf8";
no warnings 'utf8';

########################################################
#Доступ к полям
########################################################

__PACKAGE__->mk_accessors(qw(
    name
    url
    url_filter
    inf
));
#    site_proxy_ref


########################################################
# Интерфейс
########################################################

#    url                               урл страницы
#    domain                            домен, получаемый из урла
#    pagetext                          текст страницы
#    norm_url                          нормализованный урл (нужно для сравнений) 
#    digits_norm_url                   нормализованный урл с заменой цифр на _digits_
#    split_url_for_tmpl                разбивает урл на массив элементов для шаблонов
#    compare_with_tmpl                 сравниваем урл с шаблоном

# хандлеры сегнотатора
my $segin;
my $segout;

########################################################
# Инициализация
########################################################

our $badre = '';

sub init {
    my ($self) = @_;

    $self->{url} ||= "";
    $self->{url} = "http://".$self->{url} unless $self->{url} =~ /^http/;

    $self->{'url_filter'} = [] unless $self->{'url_filter'};
}

########################################################
#Вспомогательные методы
########################################################


########################################################
#Методы
########################################################

sub is_bad_image :CACHE {
    my ($self) = @_;
    my $url = $self->url;
    return 1 if $url =~ /doubleclick\.(net|com)/;
    return 1 if $url =~ /googleadservices\.com/;
    return 1 if $url =~ /\/.\.gif/;
    return 1 if $url =~ /\/logo[^A-Za-z]/i;
    return 1 if $url =~ /logo.*\.gif/i;
    return 1 if $url =~ /\/header\./i;
    return 1 if $url =~ /(mc|an|bs)\.yandex\.ru/;
    return 1 if $url =~ /(?:\/\/|\.)yandex\.st/;
    return 1 if $url =~ /kiks\.yandex\.ru/;
    return 1 if $url =~ /\/_c\//;
    return 0;
}

sub is_direct_good :CACHE {
    my ($self) = @_;
    my ($w, $h) = $self->get_image_size;
    return 0 if ($w < 150) || ($h < 150);
    return 0 if ($w > 5000) || ($h > 5000);
    return 1;
}

our $pages_url_cache = {};

sub get_image {
    my ($self) = @_;

    my $url = $self->url;

    my $ua_opts = $self->{opts}{user_agent} || {};
    $ua_opts->{agent} ||= $BM::Pages::PageText::ua_agent;
   
    my $img = undef;
    my $ua = LWP::UserAgent->new(%$ua_opts);
    $ua->timeout(300); #таймаут, чтобы не зависали долгие урлы
    my $resp;
    $resp = $ua->get($url);
    if(!$resp->is_success) {
        $self->log("can't download url '".$url."': ".$resp->status_line);
        return $img;
    }
    $img = $resp->content;
    #Если файл неподдерживаемого формата, то не прокидываем его содержимое, чтобы избежать потенциальных уязвимостей
    return '' unless $self->_get_image_data_type($img);
    return $img;
}

sub sizeJPG {
  return unless $_[0];
    my ($width, $height);
    ($height,$width) = unpack( "nn", $1 ) if $_[0] =~ /\xFF\xC0...(....)/;
  return ($width,$height);
}

sub sizePNG {
  return unless $_[0];
    my ($width, $height);
    ($width, $height) = unpack( "NN", $1 ) if $_[0] =~ /IHDR(........)/;
  return ($width,$height);
}

sub sizeGIF {
  return unless $_[0];
    my ($width, $height);
    ($width, $height) = unpack( "SS", $1 ) if $_[0] =~ /^GIF8..(....)/;
  return ($width,$height);
}

sub get_image_type :CACHE {
    my ($self) = @_;
    my $url = $self->url;
    return 'jpg' if $url =~ /\.jpe?g/i;
    return 'gif' if $url =~ /\.gif/i;
    return 'png' if $url =~ /\.png/i;
    return '';    
}

#Проверка тиа файла по содержимому
sub _get_image_data_type {
    my ($self, $data) = @_;
    if (
        (unpack('H12', $data) eq '474946383961') ||
        (unpack('H12', $data) eq '474946383761')
    ) {
        return 'gif';
    } elsif (
        unpack('H4', $data) eq 'ffd8'
    ) {
        return 'jpg';
    } elsif (
        unpack('H16', $data) eq '89504e470d0a1a0a'
    ) {
        return 'png';
    } elsif (
        unpack('H4', $data) eq '424d'
    ) {
        return 'bmp';
    }
    return '';
}

sub get_image_data_type :CACHE {
    my ($self) = @_;
    return $self->_get_image_data_type($self->get_image);
}

sub get_image_size :CACHE {
    my ($self) = @_;
    my $type = $self->get_image_type;
    return sizeJPG($self->get_image) if $type eq 'jpg';
    return sizeGIF($self->get_image) if $type eq 'gif';
    return sizePNG($self->get_image) if $type eq 'png';
    return (0, 0);
}

sub get_image_info {
    my ($self) = @_;

    my $img = $self->get_image;
#print $img;
    return Dumper(sizeJPG($img));
}

sub get_all_images { #Получаем все урлы картинок
    my ($self) = @_;
    my @arr = $self->_text2imgs( $self->text );
    $_->[0] = $self->_normurl($_->[0]) for @arr; #Приводим  урлы к классическому виду
    @arr = grep { $_->[0] } @arr; #Выкидываем проблемные урлы
    @arr = map {$_->[0]} @arr;
    return @arr;
}

sub get_images { #Получаем все урлы картинок
    my ($self) = @_;
    my @arr = $self->_text2imgs( $self->text );
    @arr = map {$_->[0]} @arr;
    #print Dumper(\@arr);
    @arr = grep { $_ } @arr; #Выкидываем проблемные урлы
    if($self->site){
        my $flt = $self->site->design_images_hash;
        @arr = grep {! $flt->{$_} } @arr;
    }
    @arr = $self->_delete_bad_imgs(@arr);
    @arr = map { $self->_normurl($_) } @arr; #Приводим  урлы к классическому виду
    return @arr;
}

sub get_page_image {
    my ($self) = @_;
    my @arr = $self->get_images;
    return '' unless @arr;
    my $mn = shift @arr;
    return $mn;  
}

sub convert2direct_format {
    my ($self, $file) = @_;
    #my $hh = 150;
    #my $ww = 200;
    #my ($hh, $ww) = (20, 20);
    my ($ww, $hh) = (612, 460);
    my $image_bin = $self->get_image;
    require Image::Magick;
    my $image = Image::Magick->new;
    $image->BlobToImage( $image_bin );
    my ($ox,$oy)= $image->Get('base-columns','base-rows');
    return unless $oy; #Если не смогли скачать, то ничего не делаем
    #print Dumper([$ox,$oy]);

    my $nx=int(($ox/$oy)*$hh); #вычисляем ширину
    if( $nx < $ox ){ #Не увеличиваем картинки
        $image->Resize( geometry=>'geometry', width=>$nx, height=>$hh ); #Делаем resize (изменения размера)
    }else{
        $nx = $ox;
    }

    if($nx>$ww) { #Если ширина получилась больше 200 
        my $nnx=int(($nx-$ww)/2); #Вычисляем откуда нам резать 
        $image->Crop(x=>$nnx, y=>0); #Задаем откуда будем резать 
        $image->Crop($ww.'x'.$hh); #С того места вырезаем 200х150
    } 
    my ($nox,$noy)= $image->Get('base-columns','base-rows');
    #print Dumper([$nox,$noy]);
    my $x = $image->Write($file); 
}

# возвращает хэш { $url => { meta => ..., avatars => ...} }
# размеры, как в старой ручке get_thumbnails: orig small big huge
sub get_avatars {
    my $self = shift;
    my $urls = shift;
    return {} if !@$urls;  # no need to call binary

    my $dirs = $self->proj->options->{dirs};
    my @binary_paths = (
        $dirs->{arcadia} . '/rt-research/bannerland/bin/avatars/avatars',  # native arcadia path
        $dirs->{root} . '/bin/avatars',  # in catalogia_publish resource
    );
    my $binary;
    for my $path (@binary_paths) {
        if (-f $path) {
            $binary = $path;
            last;
        }
    }
    die "Can't get avatars binary: not found in @binary_paths" unless $binary;

    # $binary = "$binary --no-read-cache --no-write-cache"; # Disable cache dyntable cache in hahn (sas)
    $self->log("run avatars binary: $binary ...");
    my $pid = IPC::Open2::open2(my $out_fh, my $in_fh, $binary);
    binmode $in_fh, ':utf8';
    binmode $out_fh, ':utf8';

    my %seen;
    for my $url (@$urls) {
        print $in_fh $url."\n" if !$seen{$url}++;
    }
    close $in_fh;

    my %result;
    my @sizes = qw(orig small big huge);
    while (<$out_fh>) {
        chomp;
        my $one_resp = $self->proj->json_obj->decode($_);
        while (my ($url, $response) = each %$one_resp) {
            my $ava = $response->{avatars};
            next if !$ava;  # bad image url
            $response->{avatars} = { map { $_ => $ava->{$_} } grep { $ava->{$_} } @sizes };
            $result{$url} = $response;
        }
    }
    close $out_fh;
    waitpid($pid, 0);

    return \%result;
}

use overload
    '""' => sub {
            my ($self) = @_;
            return $self->name." =-> ".$self->url;
        };

1;
