package BM::Pages::ImageList;

use utf8;
use open ':utf8';

use std;
use base qw(ObjLib::ListObj);

use Data::Dumper;

use Digest::MD5 qw(md5_hex);
use Encode;
use Utils::Sys qw(h2sa);

no warnings 'utf8';

########################################################
#Доступ к полям
########################################################

__PACKAGE__->mk_accessors(qw(
));

########################################################
#Методы
########################################################

#получение указателя на массив элементов
sub list_arrayref :CACHE {
    my ($self) = @_;
    return $self->data_arrayref;
}

sub new_listobj {
    my $self = shift;
    return $self->proj->image_list(@_);
}

sub list2text {
    my $self = shift;
    $self->images2text;   
}
 
sub site {
    my ($self) = shift;
    return ${$self->site_proxy_ref} if $self->site_proxy_ref;
    return '';
}

sub dbg {
    my ($self) = @_;
    return $self->{dbg} || ($self->site && $self->site->dbg);
}

sub site_proxy_ref {
    my ($self, $val) = @_;
    if(defined $val){
        $self->{'site_proxy_ref'} = $val;
        $_->{'site_proxy_ref'} = $val for @$self;
    }
    return $self->{'site_proxy_ref'};     
}

sub image {
    my ($self, $url, $name, $inf) = @_;
    my $p = $self->proj->image( $url, $name );
    return $p;
}

sub data_arrayref : CACHE {
    my ($self) = @_;
    my $proj = $self->proj;
    my $rf = ref $self->{data};
    my @arr = ();
    if( $rf eq 'ARRAY'){
        for my $el (@{$self->{data}}){
            my $rfel = ref($el);
            if( ! $rfel ){  #Массив строк
                push( @arr, $self->image($el, '') ) if ! $rfel;
            }elsif( $rfel eq 'ARRAY' ){ #Массив массивов
                push( @arr, $self->image($el->[0], $el->[1]) ) if $rfel eq 'ARRAY';
            }elsif( $rfel eq 'HASH' ){ #Массив хэшей
                push( @arr, $self->image($el->{url}, $el->{name}) ) if $rfel eq 'HASH';
            }else{ #Массив объектов
                push( @arr, $el );
            }
        }
    }elsif( (! $rf) ){
        @arr = map {/^\s*(.+) =-> (.+?)(?: =\*> (.*))?/ ?  $self->image($2, $1) : () } split "\n", $self->{data}; 
    }
    $self->{data} = undef; #Очищаем данные, так как результат кэшируется
    return \@arr;
}

sub images {
    my $self = shift;
    return $self->list;
}

sub delete_bad_urls {
    my $self = shift;
    return $self->lgrep(sub { $_->url })->lgrep(sub {! $_->is_bad_image});
}

sub get_best_image {
    my $self = shift;
    my $iml = $self->delete_bad_urls;
    return '' unless $iml->count;
    for my $img (@$iml){
        #$self->proj->dd([$img->url, $img->is_direct_good, $img->get_image_size]);
        return $img->url if $img->is_direct_good;
    }
    return '';
    #$self->proj->dd($iml);
    #my @arr = @$iml;
    #return $arr[0]->{url};  
}

sub images2text {
    my ($self, $pref, $debfn) = @_;
    $pref ||= '';
    my @arr = ();
    for my $el (@$self){
        my ($url, $name, $inf) = ($el->url, $el->name, $el->inf);
        $url =~ s/\n//g;
        $name =~ s/\n/ /g;
        $inf = " =*> $inf" if $inf;
        if( $debfn ){
            $_ = $el;
            my $debinf = " =-> ".$debfn->();
            push(@arr, "$pref$name$debinf =-> $url$inf\n");
        }else{
            push(@arr, "$pref$name =-> $url$inf\n");
        }
    }
    return join('', @arr); 
}

#Убираем повторы с точностью до текста и урла
sub nameurl_pack_urls {
    my ($self) = @_;
    my %h = ();
    $h{"$_"} = $_ for @$self;
    return $self->page_list([ values %h  ]);
}

#Убираем повторяющиеся ссылки
#Учитываем частоты текстов на странице
sub pack_urls {
    my ($self) = @_;
    my $h = $self->group_pages_by_urls;
    my $txt_counts = $self->text_counts;
    return $self->page_list([ map { $_->_get_the_best_url_name($txt_counts) } values %$h ]);
}

use overload
    "+" => sub {
             my ($self, $other, $swap) = @_;
             $other = $self->new_listobj($other) if (ref( $other ) eq 'ARRAY') || (! ref $other );
             return $self->new_listobj( [ @$self, @$other ] );
        },
    "*" => sub { #пересечение
             my ($self, $other, $swap) = @_;
             $other = $self->new_listobj($other) if (ref( $other ) eq 'ARRAY') || (! ref $other );
             my $flt = { map { $_->norm_url => 1 } @$other };
             return $self->pgrep(sub { $flt->{$_->norm_url} });
        },
    '@{}' => sub {
             my ($self) = @_;
             return [$self->list];
        },
    '""' => sub { 
             my ($self) = @_;
             return $self->list2text;
        },
    "-" => sub {
             my ($self, $other, $swap) = @_;
             $other = $self->new_listobj($other) if (ref( $other ) eq 'ARRAY') || (! ref $other );
             my $flt = { map { $_->norm_url => 1 } @$other };
             return $self->lgrep(sub { ! $flt->{$_->norm_url} });
        },
    "/" => sub {
             my ($self, $other, $swap) = @_;
             $other = $self->new_listobj($other) if (ref( $other ) eq 'ARRAY') || (! ref $other );
             my $flt = { map { $_->name.' => '.$_->norm_url => 1 } @$other };
             return $self->lgrep(sub { ! $flt->{$_->name.' => '.$_->norm_url} });
        };

1;
