package BM::Pages::Node;

use std;
use base qw(ObjLib::ProjPart);

use utf8;
use open ':utf8';
use Time::HiRes qw/time/;

use Scalar::Util qw(weaken);
use List::Util qw( shuffle max );

########################################################
#Доступ к полям
########################################################

__PACKAGE__->mk_accessors(qw(
    pg
    extndl
    site_proxy_ref
));

########################################################
# Интерфейс
########################################################

#    ndl_norm_url_hash         получить хэшь нормализованных урлов подразделов

#    get_subtree_text          получить текстовое представление поддерева разделов

########################################################
#Методы
########################################################

our $site_node_limit = 5000;

sub site {
    my ($self) = shift;
    my $sr = $self->site_proxy_ref;
    #return $self->proj->site unless defined $$sr;
    return $$sr if $sr;
    return '';
}

sub is_node { return 1; }

sub name :CACHE {
    my ($self) = shift;
    return $self->pg->name;
}

sub get_name_minicategs :CACHE {
    my ($self) = shift;
    return $self->proj->phrase($self->pg->name)->get_minicategs;
}

sub norm_url :CACHE {
    my ($self) = shift;
    return $self->pg->norm_url;
}

sub url :CACHE {
    my ($self) = shift;
    return $self->pg->url;
}

sub ndl_norm_url_hash {
    my ($self) = shift;
    return $self->ndl->norm_url_hash;
}

sub create_current_page_ndl {
    my ($self) = @_;
    my $s = $self->site // $self->proj->site($self->url);
    my $pgl = $self->pg->good_internal_subpages;
    my $ndl = $s->node_list( [ @$pgl ] );
    $self->pg->clear_cache; #Освобождаем данные кэша, чтобы сократить потребление памяти
    $self->proj->logger->debug("Node create_current_page_ndl:", scalar(@$ndl));
    return $ndl;
}


# TODO Для товарных подавлять "Уценённая техника", "Кредит", "Оплати кредит", "Доставка по России"
sub ndl { #Либо возвращаем внешний подсписок, либо генерим новый
    my ($self) = @_;
    return $self->{ndl} if defined($self->{ndl});
    my $ndl = $self->extndl || $self->create_current_page_ndl->delete_menu;
    my $nurl = $self->pg->norm_url;
    $ndl = $ndl->lgrep(sub { $_->pg->norm_url ne $nurl });

    #Убираем многократные фильтры, приводящие к комбинаторным взрывам количества урлов
    $ndl = $ndl->lgrep(sub { $_->pg->url !~ /filter.+filter/ }) if $self->pg->url !~ /filter.+filter/; #Фильтруем только если этого же свойства нет у исходного урла
    $ndl = $ndl->lgrep(sub { $_->pg->url !~ /filter(?:\[|\%5B)\d+/ }) if $self->pg->url !~ /filter(?:\[|\%5B)\d+/; #Удаляем цифровые фильтры
    $ndl = $ndl->lgrep(sub { $_->pg->url !~ /\/services\// }) if $self->pg->url !~ /\/services\//; #Убираем услуги там, где это не будет работать

    #Убираем урлы с фильтрами по вариантам
    $ndl = $ndl->lgrep(sub { $_->pg->url !~ /\/([-A-Za-z0-9_\.\'\`]+\|)+[-A-Za-z0-9_\.\'\`]+\// }); #Удалям фильтры через | (eldorado.ru)
    #Удаляем подурлы, полученные добавлением параметров отображения
    my $s = $self->site;
    $ndl = $ndl->lgrep(sub { ! $s->node_pair($self, $_)->viewparams_changes });
    #Прописываем родительский нод
    my $weak_ref = $self;
    weaken($weak_ref);
    $_->{parent_proxy_ref} = \$weak_ref for @$ndl;

    $self->{ndl} = $ndl;

    $self->delete_filter_combination_nodes; #Удаляем плохие цифры
    $self->proj->logger->debug("Node ndl:", scalar(@{$self->{ndl}}));
    return $self->{ndl};
}


sub parent {
    my ($self) = @_;
    my $r = $self->{parent_proxy_ref};
    #return $self->proj->site unless defined $$sr;
    return $$r if $r;
    return undef;
}

sub chndl { #Изменение подсписка нодов
    my ($self, $ndl) = @_;

    #Прописываем родительский нод
    my $weak_ref = $self;
    weaken($weak_ref);
    $_->{parent_proxy_ref} = \$weak_ref for @$ndl;

    $self->{ndl} = $ndl;
}

#Принудительно обновляем данные урла
sub renew_page_inf {
    my $self = shift;
    my $pg = $self->pg;
    my $prev = $pg->{no_cache};
    $pg->{no_cache} = 1;
    $pg->text;
    $pg->_url2inf($pg->url);
    $pg->{no_cache} = $prev;
}

#Тип категорий со специальной логикой обработки
sub get_special_node_categ_type :CACHE {
    my ($self) = @_;
    return 'media' if $self->is_media;
    return 'travel' if $self->is_travel;
    return 'vacancy' if $self->is_vacancy;
    return '';
}

#Проверяем, может ли этот урл быть подразделом
#our %badtypes = map {$_=>1} qw{ pager brand_exactly model brand qstn toponyms service personal_ads lang };
our %badtypes = map {$_=>1} qw{ pager model qstn toponyms service personal_ads lang }; #Разрешаем разделы брендов
sub subsection_filter_reason :CACHE {
    my ($self) = @_;
    return $self->get_special_node_categ_type if $self->get_special_node_categ_type;
    return '' if $self->pg->good_site_subsections->{$self->pg->name}; #Если текст есть в списке хороших названий разделов
    return '' if $self->pg->good_site_subsections_re_check($self->pg->name); #Если текст есть в списке хороших названий разделов
    my $url = $self->pg->url;
    my $name = $self->pg->name;
    return 'empty' if $self->pg->name =~ /\s+\(0\)$/; #Обычно признак того, что ничего не отберётся - нужно для мусорных фильтров
    return 'filterpager' if $self->pg->name =~ /^\d+\s*\-\s*\d+$/;
    return 'cost' if $self->pg->name =~ /\d+ руб(?:л|\.| |$|)/;
    return 'badformat' if $url =~ /\:.+( заказ| склад)/i; 
    return 'freq_url_texts' if $self->site->freq_url_texts->{$self->pg->name}; #Часто повторяющийся с разными урлами текст
    return 'pagertext' if $self->pg->name =~ /^(?:\d+|впер[её]д|назад|показать\sвс[её]|показать полный список)$/i;
    return 'users' if $url =~ /\/users?\/\w+/i;
    return 'pagerurl' if $url =~ /[\?\/\&]page=\d/i;
    return 'badlength' if length($self->pg->name) > 60;
    return 'badprodurl' if $url =~ /\/prod\d{4}/;
    return 'badprodurl2' if $url =~ /\/products_id\/\d+/;
    return 'badprodurl3' if $url =~ /\/item$/;
    return 'badprodurl4' if $url =~ /\/item\//;
    return 'badprodurl4' if $url =~ /\/store\/product\//;
    return 'brand' if $self->is_brand;
    return 'badtype '.$self->pg->get_type if $badtypes{ $self->pg->get_type };
    return 'discount' if $name =~ /скидка|скидки|^\-\d+\%\s/i;
    return 'letter' if $name =~ /^.$/; #Названия разделов не должны быть однобуквенными
    return 'flowers' if $name =~ /^букет из/i; #единственное число и конкретный состав букета, скорее всего это конкретный продукт, а не категория
    #Проверяем повторяемость параметров. Если один и тот же параметр встречается несколько раз, то это характерно для фильтров, но не для разделов
    my @prms = map { s/=.+/=/; $_ } split /\&/, $url; ##no critic
    my %h = ();
    $h{$_}++ for @prms;
    return 'badfreqprm' if grep {$_ > 2} values %h;
    # /
    return '';
}

#закрываем листы в дереве, чтобы больше не было углублений
sub terminate_tree {
    my $self = shift;
    if ( !defined $self->{ndl} ) {
        $self->chndl($self->site->node_list([]));
    }
    else {
        for my $nd ( @{$self->ndl} ) {
            $nd->terminate_tree;
        }
    }
}

sub fix_the_deep_problem { #Углубление только для текущего нода
    my ($self, $deep) = @_;
    my $dbg = 0;
    $self->ndl->debug_print('fix_the_deep_problem st1') if $dbg;
    $self->delete_bad_subsections; #Удаляем подразделы, которые не подходят по вложенности
    $self->ndl->debug_print('fix_the_deep_problem st2') if $dbg;
    my $subs = $self->subsections; #Подразделы (удалять дубли нужно до фильтрации подразделов, так как могут быть дублирующие широкие ссылки со списками переметров)
    $subs->debug_print('fix_the_deep_problem st3') if $dbg;
    $subs = $subs->lgrep(sub { ! $_->is_media }); #Убираем книги, так как они забивают всё
    $subs = $subs->lgrep(sub { ! $_->is_travel });
    $subs->debug_print('fix_the_deep_problem st4') if $dbg;
    #$subs = $subs->pack_urls; #Удаляем дубли
    #Если есть несколько урлов с одним названием и вложенностью друг в друга, то оставляем самый короткий
    $subs = $subs->page_list_method('shortest_with_the_same_name');
    $subs->debug_print('fix_the_deep_problem st5') if $dbg;
    my $others = $self->not_subsections; #Обычные урлы
    $others->debug_print('fix_the_deep_problem st6') if $dbg;
    $subs = $subs->fix_the_deep_problem($deep); #Получаем очищенный список подразделов
    $self->chndl($subs + $others); #Добавляем очищенный список разделов
    $self->ndl->debug_print('fix_the_deep_problem st7') if $dbg;
    return $subs;
}

#Проходит по иеррхии и увеличивает вложенность, если это необходимо
sub fix_the_deep_problem_tree {
    my ($self, $exurl) = @_;
    $exurl ||= {};
    my $proj = $self->proj;
    my $lvl = 1;
    my $dbg = $self->site->{dbg};

    my $begtime = time;
    my $timeout = 3600 * 24; #Ограничиваем время генерации дерева
    my $first_brand_ndl = $self->ndl->lgrep(sub { $_->is_brand });
    $first_brand_ndl->debug_print('first level brands') if $dbg;
    print STDERR "first level fix_the_deep_problem beg: ".$self->ndl->count." ".$proj->curtime."\n" if $dbg;
    $self->chndl( $self->ndl->lgrep(sub { ! $_->pg->is_catalog_url }) );
    #Важно использовать ndl, а не subsections, так как логика фильтрации для первого уровня немного изменена (parfum.kh.ua)
    $self->chndl( $self->ndl->fix_urlprefix_deep_filter($lvl) ); #Удаляем вложенные урлы для первого уровня
    print STDERR "\n=== fix_the_deep_problem === $self ==============\n\n" if $dbg;
    print STDERR "first level fix_the_deep_problem mdl: ".$self->ndl->count." ".$proj->curtime."\n" if $dbg;
    $self->fix_the_deep_problem($lvl); #Углубление для текущего нода
    print STDERR "first level fix_the_deep_problem end: ".$self->ndl->count." ".$proj->curtime."\n" if $dbg;
    my $subs = $self->ndl; #Получаем очищенный список подразделов
    $self->chndl( $first_brand_ndl + $self->ndl ); # если есть бренды, сначала получим goods по ним
    $exurl->{ $self->pg->norm_url }++;

    local $self->proj->{download_page_timeout} = 3600 * 24 * 7; # первый уровень обошли с дефолтным ttl, а следующие будем с увеличенным. Разделы сайта меняются очень редко, в этом случае можно брать более старые страницы
    my $global_count = 0; #Сколько нодов на всех уровнях
    #Обходим урлы текущего уровня и фильтруем их подурлы
    while($subs->count){
        $lvl++;
        $exurl->{ $_->norm_url }++ for @$subs;
        my @arr = ();
        my $total = $subs->count; #Сколько всего элементов на этом уровне
        $global_count += $total; #Учитываем текущие урлы

        $proj->log("fix_the_deep_problem_tree BEGIN LEVEL $lvl count: $total global_count: $global_count");

        if( $global_count > $site_node_limit ){ #Если узлов становится слишком много - прерываемся
            print STDERR "WARN: Too many nodes for site!\n";
            for my $nd (@$subs){
                $nd->chndl($self->site->node_list([]));
            }
            last;
        }

        my $curtime = time;
        if($curtime - $begtime > $timeout){ #Прерываемся при превышении таймаута
            print STDERR "WARN: Timeout exceeded in fix_the_deep_problem_tree\n";
            last;
        }

        $subs->get_pgl->zora_batch_download;
        print STDERR "TREE [$lvl] up_level_filter beg ".$subs->count." ".$proj->curtime."\n" if $dbg;
        $_->up_level_filter($exurl) for @$subs;
        print STDERR "TREE [$lvl] up_level_filter end ".$subs->count." ".$proj->curtime."\n" if $dbg;

        print STDERR "TREE [$lvl] the_best_prefix_filter beg ".$subs->count." ".$proj->curtime."\n" if $dbg;
        #Фильтруем по префиксам соседних урлов - решаем проблему комбинаторного взрыва при большом количестве подразделов
        my $the_best_prefix_filter = { map { $_->norm_url => 1 } @$subs };
        $_->the_best_prefix_subsection_filter($the_best_prefix_filter) for @$subs;
        print STDERR "TREE [$lvl] the_best_prefix_filter end ".$subs->count." ".$proj->curtime."\n" if $dbg;

        $subs->get_pgl->zora_batch_download;        
        #Получение урлов следующего списка вложенности
        #Нужно для алгоритмов быстрой фильтрации излишней вложенности
        print STDERR "TREE [$lvl] get subsubs list beg ".$proj->curtime."\n" if $dbg;
        my @sbarr = map { @{$_->subsections} } @$subs;
        my $subsubs = $self->site->node_list(\@sbarr);
        print STDERR "TREE [$lvl] get subsubs list count=".$subsubs->count."\n" if $dbg;
        print STDERR "TREE [$lvl] get subsubs list end ".$proj->curtime."\n" if $dbg;

        #Удаляем вложенность по префиксам
        print STDERR "TREE [$lvl] fix_urlprefix_deep_filter beg ".$subsubs->count." ".$proj->curtime."\n" if $dbg;
        $subsubs = $subsubs->fix_urlprefix_deep_filter($lvl); #Решаем проблему вложенных урлов
        print STDERR "TREE [$lvl] fix_urlprefix_deep_filter end ".$subsubs->count." ".$proj->curtime."\n" if $dbg;

        print STDERR "TREE [$lvl] fix_multinames_nodes_problem beg ".$subsubs->count." ".$proj->curtime."\n" if $dbg;
        $subsubs = $subsubs->fix_multinames_nodes_problem($exurl, $lvl); #Решаем проблему разных имён
        print STDERR "TREE [$lvl] fix_multinames_nodes_problem end ".$subsubs->count." ".$proj->curtime."\n" if $dbg;

        print STDERR "TREE [$lvl] delete_subsections_same_hierarchy_name beg ".$subsubs->count." ".$proj->curtime."\n" if $dbg;
        $subsubs = $subsubs->delete_subsections_same_hierarchy_name($exurl, $lvl); #Решаем проблему разных имён
        print STDERR "TREE [$lvl] delete_subsections_same_hierarchy_name end ".$subsubs->count." ".$proj->curtime."\n" if $dbg;

        print STDERR "TREE [$lvl] delete_subsections_same_params_filter_urls beg ".$subs->count." ".$proj->curtime."\n" if $dbg;
        $subs->delete_subsections_same_params_filter_urls; #Удаляет из подразделов те, которые получены добавлением одинакового частотного параметра
        print STDERR "TREE [$lvl] delete_subsections_same_params_filter_urls end ".$subs->count." ".$proj->curtime."\n" if $dbg;

        $subs->get_pgl->zora_batch_download;
        #Если не очень большое число узлов
        #Если кандидатов на разделы больше лимита, то не занимаемся углублением иерархии
        if( $global_count + $subsubs->count < $site_node_limit ){
            my $i = 0;
            for my $sb (@$subs){
                $i++;
                print STDERR "\n=== fix_the_deep_problem [$lvl][$i/$total] === $sb ==================\n\n" if $dbg;
                print STDERR "    fix_the_deep_problem [$lvl][$i/$total]   beg: ".$sb." ".$sb->ndl->count." ".$proj->curtime."\n" if $dbg;
                my $newsubs = $sb->fix_the_deep_problem($lvl);
                print STDERR "    fix_the_deep_problem [$lvl][$i/$total]   end: ".$sb." ".$sb->ndl->count." ".$proj->curtime."\n" if $dbg;
                push(@arr, @$newsubs);

                my $curtime = time;
                if($curtime - $begtime > $timeout){ #Прерываемся при превышении таймаута
                    print STDERR "WARN: Timeout exceeded in fix_the_deep_problem_tree\n";
                    last; #даем докинуть в дерево то, что успели
                }

            }

            $subs = $self->ndl->new_list(\@arr);
        }else{
            my @sbarr = map { @{$_->subsections} } @$subs;
            $subs = $self->site->node_list(\@sbarr);
        }
       
        print STDERR "TREE [$lvl] fix_multiparent_nodes_problem beg ".$subs->count." ".$proj->curtime."\n" if $dbg;
        $subs = $subs->fix_multiparent_nodes_problem; #Решаем проблему совпадающих подразделов, убирая дубли
        print STDERR "TREE [$lvl] fix_multiparent_nodes_problem end ".$subs->count." ".$proj->curtime."\n" if $dbg;
         

        $proj->log("END LEVEL $lvl fix_the_deep_problem_tree");
        #$subs = $self->ndl->new_list(\@arr)->pack_urls;
        #Раздел может попадать в несколько подразделов, нужно предусмотреть логику подавления
    }
    $self->terminate_tree;
}

# Возвращает ссылку на массив префиксов нормированного урла
# Например, для урла 'http://www.techport.ru/katalog/products/kompjuternaja-tehnika/igrovye-aksessuary/igrovye-kovriki-dlja-myshi'
# результат:
# ['/techport.ru', '/techport.ru/katalog', '/techport.ru/katalog/products',
# '/techport.ru/katalog/products/kompjuternaja-tehnyka',
# '/techport.ru/katalog/products/kompjuternaja-tehnyka/ygrovye-aksessuary']
sub urlprefix_arrayref :CACHE {
    my ($self) = @_;

    my $cururl = $self->norm_url;
    my @curarr = split(/\//, $cururl);

    my $txt = $curarr[0];
    my @arr = ($txt);

    for my $i (1 .. @curarr - 2){
        $txt  .= '/' . $curarr[$i];
        push(@arr, $txt);
    }
   
    return \@arr; 
}

#Если в хэше есть префиксы лучше, чем текущий - удаляем подразделы
sub the_best_prefix_subsection_filter {
    my ($self, $exth) = @_;
    my $cururl = $self->norm_url;

    my $flt = {};

    SLIST:
    for my $nd (@{$self->subsections}){
        for my $nurl (@{$nd->urlprefix_arrayref}){
            next SLIST if $nurl eq $cururl;
            if($exth->{$nurl}){
                $flt->{$nd->norm_url}++;
            }
        }
    }

    $self->chndl($self->ndl->lgrep(sub { ! $flt->{$_->norm_url} }));
} 

sub up_level_filter {
    my ($self, $exurl) = @_;
    $exurl ||= {};
    $self->chndl( $self->ndl->up_level_filter($exurl) );
    return $self;
}

sub delete_filter_combination_nodes {
    my ($self) = @_;
    my $pgl = $self->ndl->get_pgl->delete_filter_combination_pages($self->url);
    $self->chndl($self->site->node_list( [ @$pgl ] ));
    #return $self->site->node_list( [ @$pgl ] );
}

sub print_tree {
    my ($self, $pref, $exurl, $cc) = @_;
    unless($cc){
        my $v = 0;
        $cc = \$v;
    }
    #return if $$cc > 10;
    $pref ||= '';
    $exurl ||= {};
    my $fh = $self->site->{fh};
    if(defined($fh)){
        print $fh "$pref".'[+]'." $self\n";
#        print $fh "$pref".'        '."$_\n" for @{$self->not_subsections->add_pager_urls};
    }else{
        print "$pref".'[+]'." $self\n";
#        print "$pref".'        '."$_\n" for @{$self->not_subsections->add_pager_urls};
    }
    ${$cc}++;
    my $subs = $self->up_level_filter($exurl)->pack_urls->subsection_filter;
    $exurl->{ $_->pg->norm_url }++ for @$subs;
    $_->print_tree("$pref    ", $exurl, $cc) for @$subs; 
}

our $senderrorflag = 1;
sub _get_subtree_text {
    my ($self, $pref, $exurl, $cc) = @_;
    unless($cc){
        my $v = 0;
        $cc = \$v;     #Сколько элементов в результирующем дереве
    }
    #return if $$cc > 10;
    $pref ||= '';
    $exurl ||= {};
    
#    my $res = '';
#    $res .= "$pref".'[+]'." $self\n";
    my @res = ( "$pref".'[+]'." $self\n" );

    #my $subs = $self->up_level_filter($exurl)->delete_site_filters->pack_urls->subsection_filter;
    
    #my $subs = $self->up_level_filter($exurl)->subsections;
    if( length($pref)/4 < 12){ #Проверяем, что уровень вложенности не очень глубокий
        $self->up_level_filter($exurl); #Удаляем предыдущие подразделы
        my $subs = $pref ? $self->subsections :  $self->ndl; #Для первого уровня иная фильтрация

        $exurl->{ $_->pg->norm_url }++ for @$subs;

        #print STDERR "$pref".'[+]'." $self [".$subs->count."]\n";

        #$res .= $_->_get_subtree_text("$pref    ", $exurl, $cc) for @$subs;
        #return $res;
        push(@res, grep {$_} map {@$_} map { $_->_get_subtree_text("$pref    ", $exurl, $cc) } @$subs );
    }

    return \@res;
}

sub _get_subtree_text_mdrn {
    my ($self) = @_;
    #return if $$cc > 10;
    my $exurl ||= {};
    
    my @rarr = ();
    my @beg_list = map { [$_, []] } @{$self->ndl}; #Для первого уровня иная фильтрация
    my @lvl_list = @beg_list;
    my @new_list = ();
    for my $lvl (0 .. 6){
        for my $el ( @lvl_list ){
            $exurl->{ $el->[0]->norm_url }++;
        }
        for my $el ( @lvl_list ){
            my $subs = $el->[0]->subsections->lgrep(sub { ! $exurl->{$_->norm_url} });
            $el->[1] = [ map { [$_, []] } @$subs ];
            push(@new_list, @{ $el->[1] });
        }
        @lvl_list = @new_list;
        @new_list = ();
    }

    sub print_pref_tree {
        my ($pref, $el) = @_;
        return ("$pref".'[+]'." ".$el->[0]."\n", map { print_pref_tree("    $pref", $_) } @{$el->[1]});
    }

    my @res = map { print_pref_tree('', $_) } @beg_list;
   
    if(@res && !(grep{/^\s/} @res)) {
        @res = map{"    $_"} @res;
    }

    return \@res;
}
sub get_subtree_text {
    my ($self) = @_;
    $self->proj->log('get_subtree_text BEGIN');
    #my $res = $self->_get_subtree_text;
    my $res = $self->_get_subtree_text_mdrn;
    #my $res = [ @{$self->_get_subtree_text}, "========================= RRR =========================\n", @{$self->_get_subtree_text_mdrn}  ];
    $self->proj->log('get_subtree_text END');
    return join('', @$res);
}

sub subsections {
    my ($self) = @_;
    my $dbg = $self->{debug_subsections};
    return $self->site->node_list([]) if $self->is_brand; #Не работаем с иерархией для разделов брендов
    my $ndl = $self->ndl;

    if($self->pg->domain_2lvl eq 'ozon.ru'){ #Удаляем для озона всю помойку перекрёстных урлов
        $ndl = $self->site->site_subsections_filter($ndl); #Фильтрация разделов, специфичная для сайта
        return $ndl->pack_urls->subsection_filter;
    }

    #Если есть ярко выраженные подразделы, то оставляем только их
    my $gdndl = $ndl->lgrep(sub { $_->pg->url =~ /production.+division=[^\&]+$/ });
    if($gdndl->count > 0){
        $ndl = $gdndl; 
    }

    $ndl->debug_print("subsections filter1") if $dbg;
    $ndl = $ndl->delete_site_filters->pack_urls;
    $ndl->debug_print("subsections filter2") if $dbg;
    $ndl = $ndl->subsection_filter_with_parent($self->name);
    $ndl->debug_print("subsections filter3") if $dbg;
    $ndl = $ndl->freq_text_filter;
    $ndl->debug_print("subsections filter4") if $dbg;
    $ndl = $ndl->site_domain_filter;
    $ndl->debug_print("subsections filter5") if $dbg;
    
    #print STDERR "subsections filter html url ".$self->pg->url."\n";
    if( ( ! $self->pg->is_main_url ) && $self->pg->url !~ /\.html?$/) {
        $ndl = $ndl->lgrep(sub { $_->pg->url !~ /\.html?$/; });
    }

    return $ndl;
}

sub delete_bad_subsections { #Фильтрация неподходящих подурлов
    my ($self) = @_;
    my ($l_yes, $l_no) = $self->ndl->divide(sub { $self->site->node_pair($_, $self)->is_child == 1 }); #Получаем отношение урлов
    $self->chndl($l_no);
    return $self;
}

sub not_subsections {
    my ($self) = @_;
    my $dbg = 0;
    my $ndl = $self->ndl;
    if($self->pg->domain_2lvl eq 'ozon.ru'){ #Удаляем для озона всю помойку перекрёстных урловa
        $ndl = $self->site->site_goods_filter($ndl);
        return $ndl;
    }
    $ndl->debug_print('not_subsections flt1') if $dbg;
    $ndl = $ndl->delete_menu_all;
    $ndl = $ndl->delete_site_filters;
    $ndl->debug_print('not_subsections pack_urls') if $dbg;
    $ndl = $ndl->pack_urls;
    $ndl->debug_print('not_subsections flt2') if $dbg;
    $ndl = $ndl - $ndl->subsection_filter;
    $ndl->debug_print('not_subsections flt3') if $dbg;
    $ndl = $ndl->freq_text_filter;
    $ndl->debug_print('not_subsections flt4') if $dbg;
    $self->proj->logger->debug("Node not_subsections:", scalar(@$ndl));
    return $ndl;
}

sub get_nested_catalog_nodes {
    my $self = shift;
    my $norm_uri = $self->pg->norm_uri;
    $norm_uri =~ s/[\?\#].*$//;
    if ( $norm_uri =~ /\/[ck]atalog\/.+/ ) {
        $norm_uri .= '/' if $norm_uri !~ /\/$/;
        my $uri_len = length($norm_uri);
        return $self->ndl->lgrep(sub{  substr($_->pg->norm_uri, 0, $uri_len) eq $norm_uri });
    }
    else {
        return $self->site->node_list([]);
    }
}

#Получение списка товаров со страницы
sub goods {
    my ($self) = @_;

    my $goods_regexp = $self->site->get_site_goods_regexp;

    if (defined $goods_regexp) {
        $self->proj->log("Regexp for page ".$self->pg->url." goods: $goods_regexp");
        my $pgl = $self->pg->good_internal_subpages->add_pager_urls->lgrep(sub { $_->url =~ /$goods_regexp/ });
        my $ndl = $self->site->node_list( [ @$pgl ] );
        return $ndl;
    }

    my $norm_url = $self->pg->norm_url; #Урл текущего нода
    my $norm_url_re = $norm_url;
    $norm_url_re =~ s/([\[\]\(\)\{\}\\\.\.\<\>\?\+\*\&])/"\\".$1/eg;

    my $ndl = $self->not_subsections;
    $ndl = $ndl->add_pager_urls;
    my $sbsndl = $ndl->subsection_filter; #Разделы, которые могли прийти из листалки
    $ndl = $ndl - $sbsndl; #Удаляем разделы
    $ndl = $ndl + $self->get_nested_catalog_nodes;
    $ndl = $ndl->pack_urls;
    $ndl = $ndl->lgrep(sub {! $_->is_brand }); #Убираем бренды
    $ndl = $ndl->lgrep(sub { $_->pg->norm_url ne $norm_url }); #В листалке иногда появляется ссылка на исходную страницу с номером 1
    $ndl = $ndl->lgrep(sub { $_->pg->name !~ /^(?:1|вперед|назад|последняя)$/ }); #Бывают расхождения в транслитерации урлов
    $ndl = $ndl->freq_text_filter; #Фильтр частотных текстов
    $ndl = $ndl->delete_menu_all;
    $ndl = $self->site->site_goods_filter($ndl); #Специальная фильтрация для сайта
    $ndl = $ndl->lgrep(sub { ! $_->get_special_node_categ_type }); #Фильтруем ограничиваемые типы урлов
    eval { #Должно работать, но уже несколько раз наступали - перестраховываемся
        $ndl = $ndl->lgrep(sub { $_->pg->norm_url !~ $norm_url_re || $_->pg->url !~ /f\[\d\]\=field/ }); # удаление ссылок-фильтров
    };
    $ndl = $ndl->lgrep(sub { $_->pg->name !~ /^https?:\/\// }); #Подавляем урлы в тексте
    my $gss = $self->pg->good_site_subsections;
    $ndl = $ndl->lgrep(sub { ! $gss->{ $_->name } }); #Проверяем, что название товара не совпадает с каноническим названием категории

    #Фильтрация по типа урла
    if(1){
        $ndl = $ndl->lgrep(sub {
            my $nd = $_;
            my $type = $nd->pg->get_type;
            return 0 if $type eq 'toponyms';
            return 0 if $type eq 'brand_exactly';
            return 0 if $type eq 'brand';
            return 0 if $type eq 'lang';
            return 0 if $type eq 'service';
            return 0 if $type eq 'category';
            return 0 if $type eq 'qstn';
            return 1;
        });
    }

    if($ndl->count){ #Дополнительная логика фильтраций по общим префиксам
        my $cururi = $self->pg->norm_uri;
        if( $cururi =~ /^(\/[^\/]+\/(?:[^\/]+\/)?)/){ #Фильтруем товары по общему префиксу
            my $pref = $1;
            my $preflnth = length($pref);
            my $prfndl = $ndl->lgrep(sub { substr($_->pg->norm_uri, 0, $preflnth) eq $pref }); #У товаров такой же префикс
            if($prfndl->count / ($ndl->count + 1) > 0.8 ){ #У 80% товаров такой же префикс, что и у урла раздела
                $ndl = $prfndl;
            }
        }
        #Если большая часть урлов содержит типовую вставку, то подавляем другие
        my $lngt = length($norm_url);
        my $goodsndl = $ndl->lgrep(sub {
               $_->pg->url =~ /\/(?:goods|products?|items?)(?:\/|$)/  #Типовая вставка
            || (substr( $_->pg->norm_url, 0, $lngt ) eq $norm_url)    #Видна вложенность урлов
        });

        if($goodsndl->count){
            my $hmn = $self->pg->homonymy_names; #Фильтруем омонимичными названиями (сапоги, перчатки и т.д.)
            if($goodsndl->lgrep(sub {! $hmn->{$_->name}})->count / ($ndl->lgrep(sub {! $hmn->{$_->name}})->count + 1) > 0.70 ){
                $ndl = $goodsndl;
            }
        }
    }

    #Фильтрация товаров по формальным признакам
    $ndl = $ndl->lgrep(sub {
         my $nd = $_;
         my $name = $nd->name;
         return 0 if length($name) <= 4;
         return 1;
    });

    # # фильтрация для меню сайтов типа lazurit.com
    # if(grep{$_->pg->norm_url =~ /$norm_url_re\/\d+/} @$ndl) {
    #     $ndl = $ndl->lgrep( sub { return 1 if $_->pg->norm_url =~ /$norm_url_re/; } );
    # }

    #Убираем сайтовые фильтры
    $ndl = $ndl->delete_site_filters;

    if($ndl->count == 0){ #Если зафильтровали абсолютно все, то возможна ситуация, когда в ссылке не было названия товара
        my $pgl = $self->pg->get_internal_subpages->lgrep(sub { /^(?:ОПИСАНИЕ\s+ТОВАРА)/i });
        if($pgl->count){
            $pgl = $pgl->add_pager_urls;
            my $proj = $self->proj;
            my @arr = ();
            for my $pg (@$pgl){
                push(@arr, $proj->page($pg->url, $pg->title));
            }
            $ndl = $self->site->node_list( \@arr );
        }
    }

    $self->proj->logger->debug("Node goods:", scalar(@$ndl));
    return $ndl;
}

#возвращает категоризованный список офферов из goods. Категоризация оптимизирована для больших списков офферов в части обхода урлов.
sub categorized_goods_data {
    my ( $self, $path ) = @_;

    my %categs_hash = ();

    $path //= '/';
    #сначала пробуем категоризовать path, причем берем 2 последние секции path
    my @path_sections = split /\s*\/\s*/, $path;
    my $last_parts_count = 2;
    my @last_parts = ();
    if ( scalar(@path_sections) <= $last_parts_count ) {
        @last_parts = @path_sections;
    }
    else {
        @last_parts = splice(@path_sections, -$last_parts_count);
    }
    my $path_for_categorize = join(' ', @last_parts );
    my @path_categs_arr = $self->proj->phrase($path_for_categorize)->get_minicategs;
    my $path_categs = join('/', @path_categs_arr);
    foreach my $categ ( @path_categs_arr ) {
        $categs_hash{$categ} //= 0;
        $categs_hash{$categ}++;
    }

    my @categorized_arr = ();
    my @uncategorized_arr = ();

    my $ndl = $self->goods;

    #получение данных + первый контур: сразу пробуем вставить категоризацию path, а если ее нет - категоризацию name
    foreach my $nd (@$ndl) {
        my $data = {
            name => $nd->pg->name,
            url  => $nd->pg->url,
            categpath => $path,
            page => $nd->pg, #временное, удаляется перед возвратом
        };

        my $categs = $path_categs;
        if ( !$categs ) {
            my @categs_arr = $self->proj->phrase( $data->{name} )->get_minicategs;
            $categs = join('/', @categs_arr );
            foreach my $categ ( @categs_arr ) {
                $categs_hash{$categ} //= 0;
                $categs_hash{$categ}++;
            }
        }

        if ($categs) {
            $data->{minicategs} = $categs;
            push @categorized_arr, $data;
        }
        else {
            push @uncategorized_arr, $data;
        }
    }

    # второй контур: если не удалось нигде найти категории, категоризуем страницу раздела
    # раньше здесь была категоризация выборки лендингов, но это и медленно, и неэффективно, разделы категоризуются точнее
    if ( !%categs_hash && scalar(@uncategorized_arr) ) {
        my @node_categs = $self->pg->get_minicategs;
        foreach my $categ ( @node_categs ) {
            $categs_hash{$categ} //= 0;
            $categs_hash{$categ}++;
        }
    }

    #проставляем некатегоризованным офферам те категории, что нашли. Если ничего не нашли - проставляется разделитель, чтобы категоризация не делалась еще раз при обработке фида
    if ( scalar(@uncategorized_arr) ) {
        my $max_occur = max( map {$categs_hash{$_}} keys %categs_hash ) // 0;
        my @top_categs_arr = ();
        foreach my $categ ( keys %categs_hash ) {
            if ( $categs_hash{$categ} == $max_occur ) {
                push @top_categs_arr, $categ;
            }
        }
        my $top_categs = join('/', @top_categs_arr);
        $top_categs ||= '/';

        foreach my $data ( @uncategorized_arr ) {
            $data->{minicategs} = $top_categs;
            push @categorized_arr, $data;
        }
    }
    delete $_->{page} foreach @categorized_arr;
    return @categorized_arr;
}

######################################################################################################
# Типы нодов
######################################################################################################


sub is_brand {
    my ($self) = @_;
    return 1 if $self->pg->get_type eq 'brand_exactly';
    return 1 if $self->pg->get_type eq 'brand';
    return 1 if $self->pg->name =~ /^(?:[А-Яа-я]+\s+){1,2}[А-Яа-я]+[иы]\s+([A-Za-z]+|АТЛАНТ|GALAXY)$/; #Шаблон текстов типа ""
    if($self->pg->url =~ /\/([-_a-z]+)\/$/){
        my $proj = $self->proj;
        my $text = $1;
        $text =~ s/_/ /g;
        return 1 if $text =~ /^(?:prochie importnye|prochie otechestvennye|granit|start|idu|atlant|rbt|a4|galaxy|konstrukt|oka|keramika|feya|fb)$/;
        my $ph = $proj->phrase($text);
        my %h = $ph->parse;
        return 1 if $ph->snorm_phr eq $proj->phrase($h{brand})->snorm_phr;
    }
    return 0;
}

sub is_books :CACHE {
    my ($self) = @_;

    my $url = $self->url;
    return 1 if $url =~ /\/books\/|\/\/books\.|best_books|announce_books|context\/book\//; 
    return 1 if $url =~ /books.?catalog/;
    return 1 if $url =~ /\/knigi\//;

    my $name = $self->name;
    #return 1 if $name =~ /(?<!электронная)\s*книга|(?<!электронные)\s*книги|литература|Букинистические/i;
    return 1 if $name =~ /(?<!электронной\s)книги|литература|Букинистические/i;

    return 0;
}

sub is_media :CACHE {
    my ($self) = @_;

    return 1 if $self->is_books;

    my $url = $self->url;
    return 1 if $url =~ /\/digital\/music\/|context\/movie|\/movie\//; 

    my $name = $self->name;
    return 1 if ($name =~ /музыка|Рок и Альтернатива|World Music|Виниловые пластинки|Цифровые журналы|Зарубежный рок|Рок-н-ролл|Концерты/i) &&
        ($name !~ /музыкальны[ей]\sцентр/i);
    return 1 if $name =~ /Компьютерные игры|Скачать софт|Скачать игры|Обучающие программы|Видеоигры|игры для приставок|Софт для дома|Софт и игры|OZON\.digital/i;
    return 1 if $name =~ /Кино для|фильмы|Зарубежное кино|Отечественное кино|Видеопрограммы|DVD и Blu-ray|Видеоклипы|Видеоуроки|Сериалы/i;
    return 1 if $name =~ /мультфильм|Мультипликационные/i;
    return 1 if $name =~ /Познавательные программы|Спортивные программы|Развивающие программы|Театральные постановки/i;
    return 1 if $name =~ /Артхаус|Боевики|Драмы|Комедии|Приключения и фантастика|Триллеры|Мелодрамы/i;
    return 1 if $name =~ /^(?:(?:BBC|Discovery|National Geographic).*){2}/i;
    return 1 if $name =~ /Антиквариат, винтаж, искусство|Предметы искусства|Декоративно-прикладной антиквариат|Антикварная графика|Предметы коллекционирования|Подарочные VIP издания|Знаменитые граверы и художники|Винтажные предметы интерьера|Антикварная графика|Гравюры|Старинные фотографии|Знаменитые граверы|Антикварные открытки|Открытки, фотографии/i;
    return 1 if $name =~ /^(?:Билеты на спорт|билеты в театр)/i;

    return 0;
}

sub is_travel :CACHE {
    my ($self) = @_;

    my $url = $self->url;
    my $domain = $self->pg->domain;
    return 1 if $url =~ /\/travel_/; 
    return 1 if $domain =~ /avia\./ && $domain !~ /technoavia\.ru/; 
    return 1 if $domain =~ /\.travel$/;

    my $name = $self->name;
    return 1 if $name =~ /Авиабилеты|Бронирование гостиниц|Железнодорожные билеты|Страхование путешественников|Билеты на самол[ёе]т/i;

    return 0;
}

sub is_vacancy :CACHE {
    my ($self) = @_;

    my $url = $self->url;
    return 1 if $url =~ /\/vacancy\//; 
    return 1 if $self->pg->domain =~ /^job\./; 

    my $name = $self->name;
    return 1 if $name =~ /^РАБОТА В (МАГАЗИНЕ|ОФИСЕ)|Вакансии/i;

    return 0;
}

######################################################################################################
# / Типы нодов
######################################################################################################

sub delete_subnode {
    my ($self, $nd) = @_;
    $self->chndl( $self->ndl->lgrep(sub { $_->norm_url ne $nd->norm_url }) );
}

sub delete_from_parent {
    my ($self) = @_;
    if( defined $self->parent ){
        $self->parent->delete_subnode($self);
    }
}

sub parent_weight :CACHE {
    my ($self) = @_;
    my $npr = $self->site->node_pair($self->parent, $self);
    my $w = $npr->weight;
    #print STDERR "parent_weight: $w ".$self->parent." ===> $self\n"; 
    return $w; 
}

sub pager_nodes {
    my ($self) = @_;
    return $self->ndl->page_list_method('get_pager_urls');
}

use overload
    '""' => sub {
            my ($self) = @_;
            return $self->pg->name." =-> ".$self->pg->url;
            #return $self->pg->name." =-> ".$self->pg->get_type." =-> ".$self->pg->url;
        };

1;
