package BM::Pages::NodeList;

use std;
use base qw(ObjLib::ListObj);

use utf8;
use open ':utf8';
use Time::HiRes qw/time/;
use Utils::Urls;

########################################################
#Доступ к полям
########################################################

__PACKAGE__->mk_accessors(qw(
    pg
    extndl
    arr
    site_proxy_ref
));

########################################################
# Интерфейс
########################################################

# freq_text_filter              удаляет элементы с частотой текста в списке больше или равной 4

########################################################
#Методы
########################################################

sub dbg {
    my ($self) = @_;
    return $self->{dbg} if defined $self->{dbg};
    if(defined $self->site){
        return $self->site->{dbg};
    }
    return '';
}

sub site {
    my ($self) = shift;
    my $sr = $self->site_proxy_ref;
    return $$sr if $sr;
    return '';
}

#получение указателя на массив элементов
sub list_arrayref :CACHE {
    my ($self) = @_;
    $self->{arr} //= [];
    my $s = $self->site;
    #Если есть пейджи, а не ноды - создаём ноды
    $self->{arr} = [ map { $_->can('is_node') ? $_ : $s->node($_) } @{$self->{arr}} ];
    return $self->{arr};
}

sub new_listobj {
    my $self = shift;
    return $self->site->node_list(@_);
}

sub norm_url_hash :CACHE {
    my $self = shift;
    return { map { $_->norm_url => 1 } @$self };
}

sub _site_filters_re :GLOBALCACHE {
    my $self = shift;
    my $file = $self->proj->options->{site_filters};
    my $re = '';
    open(F, "< $file");
    while(<F>){
        chomp;
        $re .= '|' if $re;
        $re .= "$_";
    }
    close(F);
    return $re;
}

sub delete_site_filters {
    my $self = shift;
    my $re = $self->_site_filters_re;
#print "re: $re\n";
#print "$_ => ".[$_->pg->name =~ /($re)/, $1 ]->[1]."\n"  for map {@$_} $self->lgrep(sub { $_->pg->name =~ /$re/; });
    return $self->lgrep(sub { $_->pg->name !~ /$re/i; });
}

sub delete_menu {
    my ($self) = @_;
    my $mh = { %{ $self->site->menu_filter_hash } };
    #Убираем общее меню
    my @newarr = ();

    for my $nd (@$self){
        my $p = $nd->pg;
        $mh->{$p->norm_url}--;
        next if $mh->{$p->norm_url} >= 0; #Убираем общее меню
        push(@newarr, $nd);
    }
    return $self->new_listobj(\@newarr);
}

sub delete_menu_all {
    my ($self) = @_;
    my $mh = { %{ $self->site->menu_filter_hash } };
    return $self->lgrep(sub { ! ($mh->{$_->norm_url}) });
}

#Убирает те урлы, которые не могут быть подразделами
sub subsection_text_filter {
    my ($self, $parent_name) = @_;
    my $subs = $self->lgrep(sub { return ! $_->subsection_filter_reason; });
    my $models = $self->lgrep(sub { $_->subsection_filter_reason =~ "model" });
    if ($parent_name && $parent_name =~ /(З|з)апчасти/) {
        $models = $models->lgrep(sub { $self->proj->phrase($_->name)->is_subcategory('Автомобили') });
        $subs = $subs + $models;
    }
    return $subs;
}

sub subsection_filter_debug {
    my ($self) = @_;
    my @arr = ();
    my $tmpls = $self->site->elems_tmpls;
    print Dumper(['tmpls:', $tmpls]);
    my @good = ();
    for my $nd (@$self){
        print $nd->pg->url."\n";
        #print Dumper([grep {$nd->pg->compare_with_tmpl($_)} @$tmpls]);
        my @badtmpls = grep {$nd->pg->compare_with_tmpl($_)} @$tmpls;
        print "bad tmpl: ".$nd->pg->name." => ".join(" // ", @badtmpls)." => ".$nd->pg->url."\n" if @badtmpls;
        print "bad text: ".$nd->pg->name." => ".$nd->subsection_filter_reason." => ".$nd->pg->url."\n" if $nd->subsection_filter_reason;
        push(@good, $nd) unless @badtmpls || $nd->subsection_filter_reason;
    }
    print "\n\n";
    print "good: ".$_->pg->name." => ".$_->pg->url."\n" for @good;
    
}

sub subsection_tmpl_filter {
    my ($self) = @_;
    return $self->delete_tmpls_filter($self->site->elems_tmpls);
}

sub subsection_filter_with_parent {
    my ($self, $parent_name) = @_;
    my $ndl = $self;
    $ndl = $ndl->subsection_text_filter($parent_name);
    $ndl = $ndl->subsection_tmpl_filter;

    # Добавляем ссылки на бренды, если нашли слишком мало подразделов
    # Хорошо срабатывает для сайтов косметики или автомобильных запчастей,
    # но при построении дерева сайта может создавать много лишних нодов на нижних уровнях (techport.ru)
    # Пока отключил, но возможно стоит включить какую-то промежуточную логику. Например, добавлять ссылки на бренды
    # только в верхних уровнях дерева
#    my $brandndl = $self->lgrep(sub { $_->is_brand });
#    if ($ndl->count < 5 && $brandndl->count > 10) {
#        $ndl += $brandndl;
#    }

    return $ndl;
}

sub subsection_filter :CACHE {
    my ($self) = @_;
    my $ndl = $self;
    $ndl = $ndl->subsection_text_filter();
    $ndl = $ndl->subsection_tmpl_filter;

    my $brandndl = $self->lgrep(sub { $_->is_brand });
    if ($ndl->count < 5 && $brandndl->count > 10) {
        $ndl += $brandndl;
    }

    return $ndl;
}

sub first_level_filter {
    my ($self, $parent_name) = @_;
    my $bd = 'iPhone/iPad';
    my $hf = { map {$_=>1} grep { /\S/ } split "\n", $bd };
    my $ndl = $self->subsection_filter_with_parent($parent_name)->lgrep(sub { ! $hf->{$_->pg->name} });

    #Специальная логика для парфюмных сайтов, так как большая часть разделов там идёт просто по брендам (parfum.kh.ua)
    #Допускаем бренды на первом уровне
    my $brandndl = $self->lgrep(sub { $_->is_brand });
    $brandndl->debug_print("first_level_filter brands") if $self->dbg;
#print STDERR $_->name."\n" for @$ndl;
    $ndl += $brandndl;

    return $ndl;
} 

sub tmpls_filter {
    my ($self, $tmpls) = @_;
    my @arr = ();
    for my $nd (@$self){
        push(@arr, $nd) if grep {$nd->pg->compare_with_tmpl($_)} @$tmpls;
    }
    return $self->new_list(\@arr);
}

sub delete_tmpls_filter {
    my ($self, $tmpls) = @_;
    my @arr = ();
    for my $nd (@$self){
        push(@arr, $nd) unless grep {$nd->pg->compare_with_tmpl($_)} @$tmpls;
        #print Dumper([$nd->pg->url, [grep {$nd->pg->compare_with_tmpl($_)} @$tmpls],  $tmpls]);
    }
    #print "DDD: ".$_->pd->url."\n" for @arr;
    return $self->new_list(\@arr);
}

sub get_pgl {
    my ($self) = @_;
    return $self->site->page_list( [ map {$_->pg} @$self ] );
}

sub get_tmpl_grps {
    my ($self) = @_;
    return $self->get_pgl->get_tmpl_grps;
}

sub _get_the_best_url_name {
    my ($self, $txt_counts) = @_;
    return $self->lfirst if $self->count == 1;
    return $self unless $self->count;
    my $pg = $self->get_pgl->_get_the_best_url_name($txt_counts);
    for my $nd ( @$self ){
        if(! defined($pg)){ #Ловим странный баг с неопределённым значение pg
             print STDERR "_get_the_best_url_name bad pg !!!\n";
             next;
        }
        if(! defined($nd->pg)){
             print STDERR "_get_the_best_url_name bad nd->pg !!!\n";
             next;
        }
        return $nd if $nd->pg->name eq $pg->name;
    }
    return $self->lfirst; #Если что-то пошло не так, то просто отдаём первый элемент
} 

sub _join_names {
    my ($self) = @_;
    my $newname = join ' ', map { $_->name } @$self;    
    return $self->site->node($self->url, $newname);
}

sub pack_urls {
    my ($self) = @_;
    return $self if $self->count == 1;
    my $txt_counts = $self->get_pgl->text_counts;
    my $h = $self->split2hash(sub { $_->norm_url });
    $self->new_list([ map { $_->_get_the_best_url_name($txt_counts) } values %$h ]);
}

#Пакуем урлы, сжимая тексты в одну строку
sub pack_urls_grp {
    my ($self) = @_;
    return $self if $self->count == 1;
    my $h = $self->split2hash(sub { $_->norm_url });
    $self->new_list([ map { $self->_join_names } values %$h ]);
}

sub up_level_filter {
    my ($self, $exurl) = @_;
    return $self->lgrep(sub { ! $exurl->{$_->norm_url} });
}

#Решение проблемы углубления иерархии
sub fix_the_deep_problem {
    my ($self, $deep) = @_;
    my $proj = $self->proj;
    my $dbg = $self->site->{dbg};
    my @arr = @$self;
    my $childfilter = {}; #Заведомо дочерние урлы

    #Хэш урлов
    my $nuh = { map { $_ => 1 } map { s/-\d+$//; $_ } map { $_->norm_url } @arr }; ##no critic
    my $cc = 0;
    my $tcc = @arr;
    $self->get_pgl->zora_batch_download;
    for my $nd ( @arr ){
        $cc++;
        print STDERR "    dp2[$deep][".sprintf("%02d", $cc)."/$tcc][".$proj->curtime."]: ".$nd->name." => ".$nd->url."\n" if $dbg;
        #Подурлы, которые есть в соседях
        #Сознательно не фильтруем их для скорости
        #my $localfilter = $nd->ndl->lgrep(sub { $nuh->{$_->norm_url} } )->norm_url_hash;
        my $ll = $nd->ndl->lgrep(sub { $nuh->{$_->norm_url} } );
        my $localfilter = $ll->norm_url_hash;
        #Подсписок урлов, который есть в дочерних
        my @sbarr = grep { $localfilter->{ $_->norm_url } } @arr;
        for my $sbnd ( @sbarr ){
            my $is_child = $nd->site->node_pair($nd, $sbnd)->is_child;
            $childfilter->{ $sbnd->norm_url } = $nd->norm_url if $is_child == 1;
        }
        #Убираем уже удалённых соседей
        @sbarr = grep { $childfilter->{ $_->norm_url } } @sbarr;
    }

    return $self->new_list(\@arr);
}

#Решаем проблему, когда у одного урла несколько вариантов названий
#Частая проблема на Озоне, где включение и отключение фильтров происходит по урлам с одним и тем же текстом, но ведущих то на сам раздел, то на верхний раздел
sub fix_multinames_nodes_problem {
    my ($self) = @_;
    my $h = {};
    my @result = ();
    for my $nd (@$self){
        $h->{$nd->norm_url} ||= [];
        push( @{$h->{$nd->norm_url}}, $nd );
    }
    my @pages_for_download = ();
    for my $urlkey ( keys %$h ){ #Перебираем урлы
        my @arr = @{$h->{$urlkey}}; #Список нодов для урла
        if( @arr == 1 ){ #Один урл
            next;
        }
        my $hh = {};
        $hh->{$_->pg->norm_name}++ for @arr;
        my @names = keys %$hh;
        if( @names == 1 ){ #Одно название
            next;
        }
        push @pages_for_download, $arr[0]->pg;
    }

    $self->site->page_list(\@pages_for_download)->zora_batch_download;

    for my $urlkey ( keys %$h ){ #Перебираем урлы
        my @arr = @{$h->{$urlkey}}; #Список нодов для урла
        if( @arr == 1 ){ #Один урл
            push(@result, @arr);
            next;
        }
        my $hh = {};
        $hh->{$_->pg->norm_name}++ for @arr;
        my @names = keys %$hh; 
        if( @names == 1 ){ #Одно название
            push(@result, @arr);
            next;
        }
        my $title = $arr[0]->pg->title; #Заголовок страницы
        $title = lc($title);
        #print STDERR Dumper(['multinames', \@names, $arr[0]->url, $title]);
        my $goodname = '';
        for my $nm (@names){
            my $lnm = $nm;
            $lnm =~ s/\s*\d+\s*$//;
            my $lnth = length($lnm);
            next unless $lnth;
#print STDERR "$nm///$lnm///$lnth///".substr($title, 0, $lnth)."///\n";
            if(substr($title, 0, $lnth) eq $lnm){ #Если префикс заголовка совпал
                $goodname = $lnm; 
            }
        }
        unless($goodname){ #Не нашли подходящего заголовка
            push(@result, @arr);
            next;
        }
        for my $nd (@arr){
            my $lnm = $nd->pg->norm_name;
            $lnm =~ s/(?:\s*\d+)+\s*$//;
            if($lnm eq $goodname){
                push(@result, $nd);
                print STDERR "good multinames ($goodname): ".$nd->parent." ===> ".$nd."\n";
            }else{
                $nd->delete_from_parent;
                print STDERR "delete multinames ($goodname): ".$nd->parent." ===> ".$nd."\n";
            }
        }
    }
    return $self->site->node_list(\@result);
}

#Если у нода несколько родителей - оставляем только одного
sub fix_multiparent_nodes_problem {
    my ($self, $exurl) = @_;
    my $h = {};
    my @result = ();
    for my $nd (@$self){
        $h->{$nd->norm_url} ||= [];
        push( @{$h->{$nd->norm_url}}, $nd );
    }
    for my $urlkey ( keys %$h ){
        my @arr = @{$h->{$urlkey}};
        if( @arr == 1 ){
            push(@result, @arr);
            next;
        }
        my $best = undef;
        my $bestw  = 0;
        for my $nd (@arr){
            unless($best){
                $best = $nd;
                $bestw = $nd->parent_weight;
                next;
            }
            my $curw = $nd->parent_weight;
            if( $curw <= $bestw ){
                $nd->delete_from_parent;
            }else{
                $best->delete_from_parent;
                $best = $nd;
                $bestw = $curw;
            }            
        }
        push(@result, $best);
        #print STDERR "best: ".$best->parent." ===> ".$best."\n";
    }
    return $self->site->node_list(\@result);
}

#Удаляем урлы по включению, если есть более короткие
sub fix_urlprefix_deep_filter {
    my ($self, $deep) = @_;
    my $proj = $self->proj;

    my $dbg = $self->site->{dbg};
    my @arr = @$self;

    my $childfilter = {}; #Заведомо дочерние урлы

    # заполняем хэш урлами из листа. Используется для поиска потенциального родителя
    my $nuh = {};
    for my $nd (@arr) {
        next if $nd->pg->is_main_url;
        my $normurl = $nd->norm_url;
        $nuh->{$normurl} = $nd;
    }

    # смотрим, где есть совпадения более длинных урлов с более короткими, чтобы пачкой прокачать короткие
    # нужно, чтобы в следующем цикле получить от них ndl
    my @urls_for_download = ();
    my @potential_children_arr = ();
    for my $nd ( @arr ){
        my $arr = $nd->urlprefix_arrayref;
        my $potential_child = 0;
        for my $txt (@$arr){
            if($nuh->{$txt}){
                push @urls_for_download, $nuh->{$txt}->pg->url;
                $potential_child = 1;
            }
        }
        if ( $potential_child ) {
            push @potential_children_arr, $nd;
        }
    }
    $proj->page_list(\@urls_for_download)->zora_batch_download;

    #Фильтрация по вложенности
    for my $nd ( @potential_children_arr ){
        print STDERR " urltext[$deep][".$proj->curtime."]: ".$nd->name." => ".$nd->url."\n" if $dbg;

        my $arr = $nd->urlprefix_arrayref;
        for my $txt (@$arr){
            if($nuh->{$txt}){
                if(defined $nd->parent){ #Проверяем, есть ли эта же проблема у родителя
                    #Нужно, так как иерархия иногда перекашивается и корневые урлы могут появиться позже
                    my $parr = $nd->parent->urlprefix_arrayref;
                    if( grep { $_ eq $txt } @$parr ){
                        print STDERR " urltext filter saved by parent: ".$nd->norm_url." ==> ".$txt."\n";
                        print STDERR " parent: ".$nd->parent."\n";
                        next;
                    }
                }
                my $ndl = $nuh->{$txt}->ndl;
                # оставляем урл, если в сматченном урле на самом деле нет такого ребенка
                my %real_children_hash = map {$_->norm_url => 1} @$ndl;
                if ( !exists $real_children_hash{$nd->norm_url}) {
                    print STDERR " urltext filter saved by matching url check: ".$nd->norm_url." ==> ".$txt."\n";
                    next;
                }
                $childfilter->{$nd->norm_url} = $txt;
                print STDERR " urltext filter: ".$nd->norm_url." ==> ".$txt."\n";
                $nd->delete_from_parent;
                last;
            }
        }
    }
    @arr = grep { ! $childfilter->{$_->norm_url} } @arr;
    #/Фильтрация по вложенности

    return $self->site->node_list(\@arr);
}

#Удаляем частотные по повторам тексты
sub freq_text_filter {
    my ($self) = @_;
    my $ndl = $self->pack_urls; #Перед подсчётом частот текстов нужно удалить дублирующие технические урлы
    my %h = ();
    $h{$_->pg->name}{$_->pg->url}++ for @$ndl;
    $h{$_} = keys %{$h{$_}} for keys %h;
    delete($h{$_}) for grep { $h{$_} < 6 } keys %h;
    delete($h{$_}) for grep { ($_ =~ /^[а-я]+\s+[a-z]/i) || / (?:из|с|для|и) |женская|мужская/i } keys %h; #Для одежды частый кейс, когда все названия совпадают
    #delete($h{$_}) for grep { $self->proj->phrase($_)->get_minicategs > 0 } keys %h; #Если текст категоризуется, тогда не выкидываем
    delete($h{$_}) for grep { /\S+\s+\S+\s+\S/ } keys %h; #Если больше 2 слов - не выкидываем
    #print Dumper(\%h);
    return $self->lgrep(sub { ! $h{$_->pg->name} }); 
}

sub page_list_method {
    my ($self, $method) = @_;
    my $ndl = $self;
    my $pgl = $self->site->page_list([ map {$_->pg} @$ndl ]);
    $pgl = $pgl->$method();
    my $newndl = $self->site->node_list([ @$pgl ]);
    my $old = $ndl * $newndl; #Получаем список, чтобы сохранить кэшированные значения
    $newndl = $newndl - $ndl; #Удаляем те ноды, которые уже были
    $newndl = $old + $newndl; #Добавляем старый список
    return $newndl;
}

sub add_pager_urls {
    my ($self) = @_;
    my $ndl = $self;

    my $mh = { %{ $self->site->menu_filter_hash } }; #Получаем ссылки меню

    my $pgl = $self->site->page_list([ map {$_->pg} @$ndl ]);

    my $pager_filter = { map {$_->norm_url => 1} map {@$_} $pgl->get_pager_urls };
    #$pgl->get_pager_urls->debug_print("get_pager_urls");

    #Исправление ситуации со ссылками "Показать всё" от других разделов из обвязки
    my $allre = '(Показать|Посмотреть) (вс[её]|ещ[её])(\W|$)';
    my ($allpgl, $notallpgl) = $pgl->pack_urls->divide(sub { $_->name =~ /$allre/ });
    if($allpgl->count > 1){ #Больше одной ссылки на "Показать всё" - скорее всего приходят из обвязки
        if($allpgl->lgrep(sub { $_->uri =~ /^\/?[-A-Za-z_\.]+\/?$/ })->count == $allpgl->count ){ #Если все эти ссылки ведут на корневые разделы, то игнорируем их
            $pgl = $pgl->lgrep(sub { $_->name !~ /$allre/ });
            $ndl = $ndl->lgrep(sub { $_->pg->name !~ /$allre/ }); #Фильтруем и исходный список тоже, так как это не попадёт под фильтр листалки
        }
    }

    if (@$ndl) {
        my $nd = $ndl->[0];
        if ($nd->pg->url =~ /russian\.alibaba\.com/) {
            # Вручную задаем страницы pager-а для alibaba для быстрого обхода
            my @new_pages = ();
            for my $i (2 .. 300) {
                my $pg = $nd->pg->page($nd->parent->pg->url ."_$i");
                my $pgl2 = $pg->good_internal_subpages->delete_filter_combination_pages($pg->url);
                push @new_pages, @$pgl2;
            }
            $pgl = $self->site->page_list(\@new_pages)->pack_urls;
        } else {
            $pgl = $pgl->add_pager_urls($mh);
        }
    }

    my $newndl = $self->site->node_list([ @$pgl ]);
    $newndl = $newndl->freq_text_filter; #Удаляем частотные тексты как возможные технические урлы
    $newndl = $newndl - $ndl; #Удаляем те ноды, которые уже были
    $newndl = $newndl - $newndl->subsection_filter; #Удаляем ноды подразделов
    $newndl = $ndl + $newndl; #Добавляем старый список
    $newndl = $newndl->pack_urls; #Убираем повторы
    $newndl = $newndl->lgrep(sub { ! $pager_filter->{$_->pg->norm_url} });
    $newndl = $newndl->lgrep(sub { $_->pg->name !~ /$allre/ });
    return $newndl;
}

sub debug_print {
    my ($self, $prefix, $fh) = @_;
    #print "$prefix:  ".$_->pg->name." => ".$_->pg->url."\n" for @$self;
    #print "$prefix:  ".$_->pg->name." => ".$_->pg->get_type." => ".$_->pg->url."\n" for @$self;
    $prefix .= ":  " if $prefix =~ /\S/;
    my $i = 0;
    my $out_stream  = $fh;
    $out_stream  ||= *STDERR;

    print $out_stream  "=================== $prefix BEG ===================\n";
    for my $nd (@$self){
        $i++;
        #$self->proj->dd($nd);
        print $out_stream  "[DUMP]\t$i $prefix".$nd->pg->name." => ".$nd->pg->get_type." => ".$nd->pg->url."\n";
    }
    print $out_stream  "=================== $prefix END ===================\n";
    return $self;
}

sub _get_url_elems {
    my ($url) = @_;
    my @arr = $url =~ /(?:[-_a-z0-9]+=).+?(?=\&|\/|\.htm|$)/gi;
    return @arr;
}

sub _cmp_url_params {
    my ($url1, $url2) = @_;
    my $pref1 = $url1;
    $pref1 =~ s/\?.+//;
    my $pref2 = $url2;
    $pref2 =~ s/\?.+//;
    return ([], []) if $pref1 ne $pref2; #Не совпадают базовые части урлов
    my @arr1 = _get_url_elems($url1);
    my @arr2 = _get_url_elems($url2);
    my %h1 = map { $_ => 1 } @arr1;
    my %h2 = map { $_ => 1 } @arr2;
    my @del = grep { ! $h2{$_} } @arr1;
    my @add = grep { ! $h1{$_} } @arr2;
    return \@del, \@add; 
}

#Считаем количество параметров, которые одинаковые для изменения урла подраздела
#Удаляем частотные одинаковые параметры
#Нужно для фильтрации подразделов
#Если у многих подурлов добавляются одни и те же значения параметра, то это скорее всего значение фильтра
sub delete_subsections_same_params_filter_urls {
    my ($self) = @_;
    my $index = {};
    for my $nd (@$self){
        my $url1 = $nd->pg->url;
        my $sbndl = $nd->subsections;
        for my $snd (@$sbndl){
            my ($del, $add) = _cmp_url_params($url1, $snd->pg->url);
            if(( ! @$del )&&( @$add == 1 )){ #Добавление новых параметров
                for my $prm ( @$add ){
                    $index->{$prm} //= []; 
                    push(@{$index->{$prm}}, $snd);
                }
            }
        } 
    }
    for my $prm (values %$index){
        my $arr = $index->{$prm};
        my @unq = keys %{{ map { $_->pg->norm_url => 1 } @$arr }};
        if(@unq > 5){
            for my $nd ( @$arr ){
                $nd->delete_from_parent;
                print STDERR "delete_subsections_same_params_filter_urls: $nd <=== ".$nd->parent."\n";
            }
        }
    }
}

#Удаляем разделы, если по пути наверх были разделы с тем же названием
sub delete_subsections_same_hierarchy_name {
    my ($self) = @_;
    my @arr = (); 
    for my $snd (@$self){
        #print STDERR "snd: $snd\n";
        my $cur = $snd->parent;
        push(@arr, $snd), next unless defined($cur);
        my $good = 1;
        for(0 .. 5){
            #print STDERR "cur: $cur\n";
            if($cur->name eq $snd->name){
                $snd->delete_from_parent;
                print STDERR "delete_subsections_same_hierarchy_name: $snd <=== ".$cur."\n";
                $good = 0;
                last;
            }
            $cur = $cur->parent;
            last unless defined($cur);
        }
        if($good){
            push(@arr, $snd);
        }
    }
    return $self->site->node_list(\@arr);
}

sub get_tskv {
    my ($self) = @_;
    my @res = ();
    for my $gd ( @$self ){
        my $path = $gd->parent ? $gd->parent->pg->name : '';
        my $data = {
            name => $gd->pg->name,
            url  => $gd->pg->url,
            categpath => $path,
        };
        my $line = join("\t", map { $_.'='.$data->{$_} } keys %$data)."\n";
        push(@res, $line);
    }
    return join("", @res);
}

sub site_domain_filter {
    my ($self) = @_;
    #http://spb.beeline.ru
    my $domains_re = $self->site->domain_filter_regexp;
    return $self->lgrep(sub { lc($_->url) =~ /$domains_re/ || lc(url_to_punycode($_->pg->url)) =~ /$domains_re/ });
}

#Список разделов из словаря
sub gooddict_subsections {
    my ($self) = @_;
    my $flt = $self->proj->page->good_site_subsections;
    return $self->lgrep(sub { $flt->{$_->pg->name} });
}

use overload
    "+" => sub {
             my ($self, $other, $swap) = @_;
             $other = $self->new_list($other) if (ref( $other ) eq 'ARRAY') || (! ref $other );
             return $self->new_list( [ $self->list, $other->list ] );
        },
    "*" => sub { #пересечение
             my ($self, $other, $swap) = @_;
             $other = $self->new_list($other) if (ref( $other ) eq 'ARRAY') || (! ref $other );
             my $flt = { map { $_->pg->norm_url => 1 } @$other };
             return $self->lgrep(sub { $flt->{$_->pg->norm_url} });
        },
    '@{}' => sub {
             my ($self) = @_;
             return [$self->list];
        },
    '""' => sub { 
             my ($self) = @_;
             return join( '', map { "$_\n" } @$self );
        },
    "-" => sub {
             my ($self, $other, $swap) = @_;
             $other = $self->new_list($other) if (ref( $other ) eq 'ARRAY') || (! ref $other );
             my $flt = { map { $_->pg->norm_url => 1 } @$other };
             return $self->lgrep(sub { ! $flt->{$_->pg->norm_url} });
        },
    "/" => sub {
             my ($self, $other, $swap) = @_;
             $other = $self->page_list($other) if (ref( $other ) eq 'ARRAY') || (! ref $other );
             my $flt = { map { $_->pg->name.' => '.$_->pg->norm_url => 1 } @$other };
             return $self->lgrep(sub { ! $flt->{$_->pg->name.' => '.$_->pg->norm_url} });
        };

1;

