package BM::Pages::NodePair;

#Модуль для анализа взаимного отношения нодов
#Нужен, чтобы можно было эти отношения кэшировать

use std;
use base qw(ObjLib::ProjPart);

use utf8;
use open ':utf8';
use Time::HiRes qw/time/;

use Scalar::Util qw(weaken);

########################################################
#Доступ к полям
########################################################

__PACKAGE__->mk_accessors(qw(
    first
    second
));

########################################################
# Интерфейс
########################################################

########################################################
#Методы
########################################################

sub fix_url_format {
    my ($self, $url) = @_;
    $url =~ s/\/$//;
    $url =~ s/-\d+$//;
    $url .= '/';
    return $url;
}

sub cmpurl {
    my ($self, $url1, $url2) = @_;
    $url1 = $self->fix_url_format($url1);
    $url2 = $self->fix_url_format($url2);
    my $l1 = length($url1);
    my $l2 = length($url2);
    #return 0 if $l2 <= $l1;
    my $cmp1 = substr($url1, 0, $l2); 
    my $cmp2 = substr($url2, 0, $l1);
    #print Dumper([[$url1, $url2], [$l1, $l2], [$cmp1, $cmp2]]);
    return 1  if $url1 eq $cmp2;
    return -1 if $url2 eq $cmp1;
    return 0;
}

sub is_child {
    my ($self) = @_;
    #print "DD:".$self->cmpurl."\n";
    my $fx = $self->_tree_suburls_fix_data;
    if(defined($fx->{$self->first->pg->name}) && defined($fx->{$self->first->pg->name}{$self->second->pg->name})){
        return 1  if $fx->{$self->first->pg->name}{$self->second->pg->name} == 1; #В правильном порядке
#print "SSSS1\n";
        return -1 if $fx->{$self->first->pg->name}{$self->second->pg->name} == 0; #Запрещёное сочетание
    }
    if(defined($fx->{$self->second->pg->name}) && defined($fx->{$self->second->pg->name}{$self->first->pg->name})){
#print "SSSS2\n";
        return -1 if $fx->{$self->second->pg->name}{$self->first->pg->name} == 1; #Неправильный порядок
    }
    return 1  if ($self->first->pg->is_catalog_url) && (! $self->second->pg->is_catalog_url);
#print "SSSS3\n";
#print Dumper(['beg', $self->first->pg->is_catalog_url,  $self->second->pg->is_catalog_url,  $self->cmpurl($self->first->pg->url, $self->second->pg->url), 'end']);
    return -1 if $self->second->pg->is_catalog_url;
    return $self->cmpurl($self->first->pg->url, $self->second->pg->url); 
}

sub _tree_suburls_fix_data :GLOBALCACHE {
    my ($self) = @_;
    my $file = $self->proj->options->{site_tree_fix};
    #print "_tree_suburls_fix_data file '$file'\n";
    my %h = ();
    open(F, "<$file");
    while(defined(my $l = <F>)){
        my @a = split(/[\t\n]/, $l);
        $h{$a[0]}{$a[1]} = $a[2];
    }
    return \%h; 
}

#Старый метод, сейчас не используется
#Сравниваем тексты на похожесть
sub _cmpr_texts {
    my ($self, $text0, $text1) = @_;
    my $ph0 = $self->proj->phrase($text0);
    my $ph1 = $self->proj->phrase($text1);
    my $h = { map {$_ => 1} $ph0->snormwords };
    my $c = 0;
    $c++ for grep {$h->{$_}} $ph1->snormwords;
    return $c;
}

#Урлы отличаются только добавлением параметров отображения
sub viewparams_changes {
    my ($self) = @_;
    my $url1 = $self->fix_url_format($self->first->pg->url);
    my $url2 = $self->fix_url_format($self->second->pg->url);
    my $l1 = length($url1);
    my $l2 = length($url2);
    return 0 if $l1 >= $l2;
    my $tail = substr($url2, $l1-1, $l2 - $l1);
    return 1 if $tail =~ /^([\?\&](sort|viewType|rec)=[^\&]+)$/;
    return 0;
}

sub weight {
    my ($self) = @_;
    my $proj = $self->proj;
    my $w = 0;
    return 0 unless defined( $self->first ) && defined( $self->second );
    #Учёт родительских отношений
    my $chd = $self->is_child;
    return 0 if $chd == -1;
    if($chd == 1){
        $w += 1000;
    }

    my $ph1 = $proj->phrase($self->first->name);
    my $ph2 = $proj->phrase($self->second->name);

    #Учёт категорий
    my $ctree = $proj->categs_tree;
    my @ctg1 = $self->first->get_name_minicategs;   #Категории первого нода 
    my @ctg2 = $self->second->get_name_minicategs;  #Категории второго нода
    my $cth1 = { map {$_=>1} @ctg1 }; #Хэш категорий первого нода
    my $prntcth1 = { map { $ctree->get_minicateg_parent($_)=>1} @ctg1 }; #Хэш родителей категорий первого нода
    my $cth2 = { map {$_=>1} @ctg2 }; #Хэш категорий второго нода
    $w += 100 if grep { $cth1->{$_} } @ctg2; #Совпадают категории
    $w += 100 if grep { $cth1->{$_} } map { $ph2->get_cat_path($_) } @ctg2; #Дочерняя категория

    $w += 30 if grep { $prntcth1->{$_} } map { $ctree->get_minicateg_parent($_) } @ctg2; #Общие родители

    #Учёт пересечения текстов
    my $wdh = $ph1->snormwordshash;
    my @inrsw1 = grep { $wdh->{$_} } $ph2->notwidewords;
    $w += 20 if @inrsw1 > 0;
    my @inrsw2 = grep { $wdh->{$_} } $ph2->snormwords;
    $w += 10 if @inrsw2 > 0;
    #Учёт пересечения фрагментов урлов
    my $urlh = { map { $_ => 1 } split('/', $self->first->norm_url) };
    my @inrsu = grep { $urlh->{$_} } split('/', $self->second->norm_url);
    $w += 5 * @inrsu if @inrsu > 0;
    #Учёт длин вложенности урлов
    my $l1 = length($self->first->norm_url);
    my $l2 = length($self->second->norm_url);
    $w += ($l1 + 1) / ($l2 + 2);
    return $w;
}

1;
