package BM::Pages::PageList;

use utf8;
use open ':utf8';

use std;
#use base qw(ObjLib::ProjPart);
use base qw(ObjLib::ListObj BM::Pages::PageListCoro);
#use base qw(ObjLib::ListObj);

use Data::Dumper;

use Digest::MD5 qw(md5_hex);
use Encode;
use Utils::Sys qw(h2sa);

no warnings 'utf8';

# filter_metalinks              удаляем служебные урлы

# freqhash_filtered_urls        удаляем урлы по хэшу в соответствии с частотами
# get_urls_frequency            получаем частоты нормализованных урлов
# up_level_filter               удаляем все урлы, у которых совпадают norm_url с ключами хэше
# delete_bad_tmpls              удаляем группы урлов, соответствующих мусорным шаблонам
# pack_urls                     убираем повторяющиеся ссылки, учитывая частоты текстов на странице
# nameurl_pack_urls             убираем повторы с точностью до текста и урла 
# get_tmpl_grps                 получить сгруппированные по шаблону урлы
# get_pager_urls                получить страницы листалки
# add_pager_urls                заменяет страницы листалок на списки пейджей с них
# splice_pages                  параметры как у splice, но без указания массива, возвращает page_list
# shuffle_pages                 перетасовать страницы (использует _page_md5)
# get_rand_pages(100)           получить указанное количество пейджей

# get_freqhash_suburls          хэш частот внутренних нормализованных урлов для страниц (из списка урлов берётся 20 случайных и считается по ним)

# get_urls_by_prefix($url)      Получаем список пейджей, у которых указанный урл - префикс

# zora_hashes                   Получает хэш хэшей для фильтров, должно кэшироватья в KYOTO и забираться зорой. ключ хэша URL, ключи внутреннего хэша
#                                сontent      - plain HTML content of url
#                                normwords    - hash of normalized words
#                                normcontent  - every word normlized, all words to join(' ', @normwords), "normalized" content
#                                title        - page title
#                                normtitle    - like normcontent, content <=> title
#                                titlenormwords - hash of normalized words of title

########################################################
#Доступ к полям
########################################################

__PACKAGE__->mk_accessors(qw(
    name
    url
    url_filter
));

########################################################
#Методы
########################################################

#получение указателя на массив элементов
sub list_arrayref :CACHE {
    my ($self) = @_;
    return $self->pages_arrayref;
}

sub new_listobj {
    my $self = shift;
    return $self->page_list(@_);
}

sub list2text {
    my $self = shift;
    $self->pages2text;   
}
 
sub site {
    my ($self) = shift;
    return ${$self->site_proxy_ref} if $self->site_proxy_ref;
    return '';
}

sub dbg {
    my ($self) = @_;
    return $self->{dbg} || ($self->site && $self->site->dbg);
}

sub site_proxy_ref {
    my ($self, $val) = @_;
    if(defined $val){
        $self->{'site_proxy_ref'} = $val;
        $_->{'site_proxy_ref'} = $val for @$self;
    }
    return $self->{'site_proxy_ref'};     
}

sub page {
    my ($self, $url, $name, $inf) = @_;
    my $p = $self->proj->zpage(
        url           => $url, 
        name          => $name,
        user_agent    => $self->{opts}{user_agent} || {},
        site_proxy_ref => $self->{'site_proxy_ref'},
        inf => $inf,
        url_filter => $self->{'url_filter'},
    );
    #$p->url_filter($self->url_filter);
    return $p;
}

sub zora_batch_download {
    my $self = shift;
    my $client = ($self->{enable_zora_fast} || ($self->site && $self->site->{enable_zora_fast})) ? $self->proj->zora_fast_client : $self->proj->zora_client;
    my %urls = map {$_->clean_url => 1} grep {!$_->has_cached_page} @$self;
    return unless %urls;

    if ($ENV{BM_DISABLE_EXTERNAL_INTERNET}) {
        $self->proj->log("DISABLE_EXTERNAL_INTERNET for zora_batch_download bad_urls count: ".scalar keys %urls);
        return;
    }

    my $pack_size = 5;

    my $zora_params = @$self[0]->prepare_zora_params;
    my $t = time;
    my %packs = ();
    my $gen_ind = 1;
    for my $url (sort keys %urls) {
        $packs{$gen_ind} //= [];
        push @{$packs{$gen_ind}}, $url;
        if ( scalar @{$packs{$gen_ind}} >= $pack_size ) {
            $gen_ind++;
        }
    }
    if ( $gen_ind > 1 && exists $packs{$gen_ind} && @{$packs{$gen_ind}} && scalar @{$packs{$gen_ind}} < $pack_size ) {
        push @{$packs{$gen_ind-1}}, @{$packs{$gen_ind}};
        delete $packs{$gen_ind};
    }

    $self->log("ttbeg zora batch: " . scalar(keys %urls));
    for my $ind (sort keys %packs) {
        local $zora_params->{timeout} = 60 + 8 * scalar( @{$packs{$ind}} ); # 60 - 860
        my $res = $client->multi_get_hashref($packs{$ind}, $zora_params);
        for my $purl (@{$packs{$ind}}) {
            if ( $res->{$purl} && !$res->{$purl}->{download_error} ) {
                for my $pg ( grep {$purl eq $_->clean_url} @$self ) {
                    $pg->write_to_pagecache($pg->process_response_content($pg->save_zora_headers_return_text($res->{$purl})));
                }
                delete $urls{$purl};
            }
        }
    }
    $self->log("tt zora batch: ".(time - $t));

    # добиваем явно то, что не закэшировалось в батч-запросе
    # то, что успешно скачалось, не будет скачиваться повторно
    for my $pg ( grep {!$_->has_cached_page} @$self ) {
        $pg->refresh_expired_pagecache;
    }
}

sub shuffle_pages { 
    my ($self) = @_;
    return $self->page_list([
        map { $_->[1] } sort {$a->[0] cmp $b->[0]} 
        map { [ $_->_page_md5, $_ ] } @$self ]);
}

sub splice_pages {
    my $self = shift;
    return $self->splice_list(@_);
}

sub good_url_filter { return $_[0]->lgrep(sub { ! $_->is_bad_url } ); }

sub get_from_text {
    my ($self, $f) = @_;
    my @arr = map { $_->get_from_text($f) } @$self;
    return $self->proj->phrase_list(\@arr);
}

sub get_from_text_debug {
    my ($self, $f) = @_;
    my @arr = map { my $pref = "$_ >> "; map { "$pref $_" } $_->get_from_text($f) } @$self;
    return $self->proj->phrase_list(\@arr);
}

sub good_pages {
    my $self = shift;
    #return $self->lgrep(sub { ! $_->bad_page_reason } );
    return $self->filter_metalinks;
}

sub bad_pages_debug {
    my $self = shift;
    #return $self->lgrep(sub { $_->bad_page_reason } )->lmap(sub { $_->chname( $_->name.' >> ['.$_->bad_page_reason.'] ' ) } );
    return $self->filter_metalinks;
}

sub good_pages_debug {
    my $self = shift;
    #return $self->lmap(sub { $_->chname( $_->name.' >> '.$_->bad_page_reason ) } );
    return $self->filter_metalinks;
}

#Получаем указанное количество страниц
sub get_rand_pages {
    my $self = shift;
    return $self->rand_items(@_);
}

sub add_pages_histinf {
    my ($self, $dt, $oldpgl) = @_;
    $_->add_histinf($dt) for @$self;
    $self->add_pages_fltrsn($dt, $oldpgl) if $oldpgl;
    return $self;
}

sub add_pages_fltrsn {
    my ($self, $dt, $oldpgl) = @_;
    if($oldpgl){
        my $badpgl = $oldpgl - $self;
        $_->add_fltrsn($dt) for @$badpgl;
    }
    return $self;
}

sub pages2histinf {
    my ($self, $pref, $debfn) = @_;
    return $self->pages2text($pref, sub { ($debfn ? $debfn->().' ' : '').$_->histinf });
}

sub filtered_pages {
    my ($self) = @_;
    return $self->pgrep(sub { $_->fltrsn });
}

sub pages2fltdtext {
    my ($self, $pref, $debfn) = @_;
    return $self->filtered_pages->pages2text($pref, sub { ($debfn ? $debfn->().' ' : '')." BAD:".$_->fltrsn });
}

sub pages_arrayref : CACHE {
    my ($self) = @_;
    my $proj = $self->proj;
    my $rf = ref $self->{pages};
    my @arr = ();
    if( $rf eq 'ARRAY'){
        for my $el (@{$self->{pages}}){
            my $rfel = ref($el);
            if( ! $rfel ){  #Массив строк
                push( @arr, $self->page($el, '') ) if ! $rfel;
            }elsif( $rfel eq 'ARRAY' ){ #Массив массивов
                push( @arr, $self->page($el->[0], $el->[1]) ) if $rfel eq 'ARRAY';
            }elsif( $rfel eq 'HASH' ){ #Массив хэшей
                push( @arr, $self->page($el->{url}, $el->{name}) ) if $rfel eq 'HASH';
            }else{ #Массив объектов
                push( @arr, $el );
            }
        }
    }elsif( (! $rf) ){
        @arr = map {/^\s*(.+) =-> (.+?)(?: =\*> (.*))?/ ?  $self->page($2, $1) : () } split "\n", $self->{pages}; 
    }
    $self->{pages} = undef; #Очищаем данные, так как результат кэшируется
    return \@arr;
}

sub pages {
    my $self = shift;
    return @{$self->pages_arrayref};
}

sub page_list {
    my $self = shift;
    my $pgl = $self->proj->page_list(@_);
    $pgl->site_proxy_ref($self->site_proxy_ref);
    return $pgl;
}

sub pages2text {
    my ($self, $pref, $debfn) = @_;
    $pref ||= '';
    my @arr = ();
    for my $el (@$self){
        my ($url, $name, $inf) = ($el->url, $el->name, $el->inf);
        $url =~ s/\n//g;
        $name =~ s/\n/ /g;
        $inf = " =*> $inf" if $inf;
        if( $debfn ){
            $_ = $el;
            my $debinf = " =-> ".$debfn->();
            push(@arr, "$pref$name$debinf =-> $url$inf\n");
        }else{
            push(@arr, "$pref$name =-> $url$inf\n");
        }
    }
    return join('', @arr); 
}

sub pages2categstext {
    my ($self, $pref, $debfn) = @_;
    $pref ||= '';
    my @arr = ();
    for my $el (@$self){
        my ($url, $name, $inf) = ($el->url, $el->name, $el->inf);
        $url =~ s/\n//g;
        $name =~ s/\n/ /g;
        my $nmph = $self->proj->phrase($name);
        my $ctgs = join '/', $nmph->get_minicategs;
        $inf = $ctgs if $ctgs;
        $inf = " =*> $inf" if $inf;
        if( $debfn ){
            $_ = $el;
            my $debinf = " =-> ".$debfn->();
            push(@arr, "$pref$name$debinf =-> $url =*> $ctgs\n");
        }else{
            push(@arr, "$pref$name =-> $url =*> $ctgs\n");
        }
    }
    return join('', @arr); 
}

sub get_categs_phl {
    my ($self) = @_;
    my @result;

    for my $page (@$self) {
        push @result, join("/", $page->get_minicategs);
    }

    return $self->proj->phrase_list([ @result ]);
}

sub get_catids_phl {
    my ($self) = @_;
    my @result;

    for my $page (@$self) {
        push @result, join(",", grep{$_} map{$self->proj->categs_tree->get_minicateg_directid($_)} $page->get_minicategs);
    }

    return $self->proj->phrase_list([ @result ]);
}

#Сжимаем урлы, удаляя более длинные при наличии более коротких
sub long_pack_urls {
    my ($self) = @_;

    my $cur_exurl = { map { $_->norm_url => 1 } @$self }; #Текущий уровень для фильтрации

    my $badurls = {};
    #Если есть несколько уровней вложений на странице - углубляем иерархию
    #Вычищаем подурлы, если там есть урлы разного уровня вложенности
    for my $elurl (keys %$cur_exurl){
        my @u_arr = split '/', $elurl;
        pop @u_arr; #Удаляем последний элемент, чтобы не было совпадений с самим урлом
        my $cururl = '';
        for my $u_el (@u_arr){
            $cururl .= "/" if $cururl;
            $cururl .= $u_el;
            $badurls->{$elurl}++ if $cur_exurl->{$cururl};
        }
    }
     
    return $self->pgrep(sub { ! $badurls->{ $_->norm_url } });
}

#Частоты текстов
sub text_counts : CACHE {
    return $_[0]->get_list_stat( sub { $_->norm_name }, sub { $_->norm_url } ); 
}


#Группирует страницы по урлу с сортировкой по весу внутри урла
sub group_pages_by_urls {
    my ($self) = @_;
    return $self->split2hash(sub {$_->norm_url});
}

sub _debug_group_pages_by_urls {
    my ($self, $pref) = @_;
    $pref ||= '';
    my $hh = $self->group_pages_by_urls;
    my $text = '';
    for(keys %$hh){
        next if @{$hh->{$_}} == 1;
        $text .= "$pref $_\n";
        $text .= $hh->{$_}->pages2text("$pref    ");
    }
    return $text;
}

sub _is_common_name_prefix {
    my ($text) = @_;
    return 1 if $text =~ /^Купить/;
    return 1 if $text =~ /^Фото /;
    return 1 if $text =~ /^Фотография /;
    return 0;
}

#Возвращает одну страницу с наиболее разумным текстом
#Используется для сжатия повторяющихся урлов
#txt_counts - хэш частот текстов, который нужно учитывать при выборе 
sub _get_the_best_url_name {
    my ($self, $txt_counts) = @_;
    return @{$self}[0] unless $self->count > 1;

    my $dbg = 0;

    my $pgl = $self;

    #Если урлы указаны как альтернативные на других языках, то делаем это основным
    my ($alternateurl_pgl, $alternateurl_others_pgl) = $self->divide(sub {$_->name =~ /^_alternateurl_/});
    #$pgl->debug_print("alternateurl") if $alternateurl_pgl->count;
    return $alternateurl_pgl->lfirst if $alternateurl_pgl->count;

    #Удаляем мусорные численные урлы, если их несколько - обычно это разные размеры
    my ($dgtpgl, $otherspgl) = $self->divide(sub {$_->name =~ /^\d+$/});
    $pgl = $otherspgl if ($dgtpgl->size > 2) && ($otherspgl->size > 0);

    #print "_get_the_best_url_name:".$_->norm_url." => ".$_->name."\n" for sort { $a->norm_url cmp $b->norm_url } @$pgl;
    
    #Специальная фильтрация для мусорных текстов
    my $fltpgl = $pgl->lgrep(sub {
        my $name = $_->name;
           $name !~ /\:.*(?:\:|[Пп]од заказ|[Сс]клады)/ 
        && $name !~ /^\-\d+(\s|$)/ 
        && $name !~ /^[\-\.\d]+$/
        && $name !~ /^[0-9a-f]{16,}$/
        && $name !~ /^[A-Z]\d+(\s|$)/ # http://svostoka.com/catalog/rubric/stoliki/
        && $name !~ /^Артикул: \d+$/ 
        && $name !~ /^Код: \d+$/
        && $name !~ /\d фото$/i
        && $name !~ /^(?:dsc|img)_\d+(?:\s+\(\d+\))?$/i
        && $name !~ /^image \(\d+\)$/i
        && $name !~ /^видео$/i
        && $name !~ /^\W+$/i
        && $name !~ /^\d+\-\d{2,}x\d{2,}/i  # newkids.by
        && $name !~ /^\d{6,}_\d$/i  # newkids.by
        && $name !~ /^[\.\-x0-9a-f]{20,}$/i  # newkids.by
        && $name !~ /^[А-Я]{1,2}\d{0,3}\s(?:\w*\s)?(?:\(\d+\))?$/i  # newkids.by
        && $name !~ /^\s*\d+\s*\/\s*\d+\s*$/  # Названия вида '1 /8', '1/8' для количества картинок
        && !($name =~ /[A-Za-z]\d/ && $name =~ /\d[A-Za-z]/ && $name =~ /^[A-Za-z0-9_\-]{10,}(\s\(\d+\))?$/) # newkids.by
        && !($name =~ /[A-Z][a-z]/ && $name =~ /[a-z][A-Z]/ && $name =~ /^[A-Za-z0-9_\-]{10,}(\s\(\d+\))?$/) # newkids.by
    });
    $pgl = $fltpgl if $fltpgl->count > 0;
  
    #Удаляем обрезанные тексты, если есть полные
    my $shtpgl = $pgl->lgrep(sub { $_->name =~ /\.\.\.$|\([^)]*$/ });
    if($shtpgl->count){
        my $badtext = {};
        for my $sht (@$shtpgl){
            my $clname = $sht->name;
            $clname =~ s/\.\.\.$//;
            my $lng = length( $clname );
            for my $pg (@$pgl){
                next if $pg->name eq $sht->name;
                if($clname eq substr($pg->name, 0, $lng)){
                    $badtext->{$sht->name}++;
                    last;
                }
            }
        }
        if(keys %$badtext){
            $pgl = $pgl->lgrep(sub { ! $badtext->{ $_->name } });
        }
    }

    my @stree = map {$_->[0]}
             sort {($b->[1] <=> $a->[1]) || ($a->[2] <=> $b->[2])}
             map {[$_,$txt_counts->{$_->norm_name}, length($_->norm_name)]}
             @$pgl;

    #Учитываем частоты текстов на странице
    my $words_counts = {};
    $words_counts->{$_}++ for map { split ' ', $_->name } @stree;

    my $prev = undef;
    my $bad = '';

    for my $t ( @stree ){
        #print "prevbad: $bad\n" if $dbg;
        print STDERR "gbst: $t\n" if $dbg;
        $bad = '';
        #Если одинаковые частоты текстов на странице
        if($prev && ($txt_counts->{$t->norm_name} == $txt_counts->{$prev->norm_name})){
            my $name = $t->name;
            my $prname = $prev->name;
            $name =~ s/^\s+|\s+$//g;
            $prname =~ s/^\s+|\s+$//g;
            $name =~ s/\s+\([^\)]+\)$//g;
            $prname =~ s/\s+\([^\)]+\)$//g;

            #Если есть разумный текст и длинный - выкидываем длинный
            #my $bad = '';
            $bad .= "params," if $name =~ /\:.*(?:\:|[Пп]од заказ|[Сс]клады)/; #Зацепили перечисления параметров
            next if $bad;
            $bad .= "lngth," if (length($name) > 180) && $prname !~ /^\d+$/; #текущая фраза очень длинная
            next if $bad;
            print STDERR "1 \n" if $dbg;

            my $prevlnth = length($prname);

            #Если у модели добавляется префикс, то это не страшно
            if($prev->is_model && ($prname eq substr($name, -$prevlnth, $prevlnth )) && ! _is_common_name_prefix($name)){
                $prev = $t;
                next;
            }
            print STDERR  "2 \n" if $dbg;
            #Часто ссылкой может быть не модель, а название типа - отдаём предпочтение ссылкам с моделью
            if((! $prev->is_model) && ($prname eq substr($name, 0, $prevlnth ))){
                $prev = $t;
                next;
            }
            print STDERR "3 \n" if $dbg;

            #Добавляется префикс
            if($prname eq substr($name, -$prevlnth, $prevlnth) && ! _is_common_name_prefix($name)){
                my $lnth = length($t->name);
                my $pref = substr($name, 0, $lnth-$prevlnth);
                if($pref =~ /^(?:[-\.A-Za-zА-Яа-я0-9]+\s*){1,4}$/){ #Если префикс не более чем из 4 слов - допускаем
                    $prev = $t;
                    next;
                }
            }
            print STDERR "33 \n" if $dbg;

            #ранее уже была более короткая фраза, похожая на модель
            $bad .= "prmodel[".$prname."]," if $prev->is_model && !($prname =~ /\.\.\.$/ && $t->is_model);
            next if $bad;
            print STDERR "4 \n" if $dbg;
            $bad .= "beglst," if $name =~ /^\&\#8226;/; #начинается с символа для перечисления
            next if $bad;
            print STDERR "5 \n" if $dbg;

            my $ww1 = 0;
            $ww1 += 1/($words_counts->{$_}+2) for split ' ', $prname;
            my $ww2 = 0;
            $ww2 += 1/($words_counts->{$_}+2) for split ' ', $name;
            $bad .= 'frwords,' if $ww2 > $ww1  && $prname !~ /^\d+$/;
            next if $bad;
            print STDERR "6 \n" if $dbg;
        }
        $prev = $t;
    }

    $prev = pop(@stree) unless $prev; #Решаем проблему, когда все варианты отфильтровались
    #print "good: $prev\n";

    $pgl->debug_print('_get_the_best_url_name') if $dbg;
    print STDERR "result: $prev\n" if $dbg;
    return $prev;    
}

#Убираем повторы с точностью до текста и урла
sub nameurl_pack_urls {
    my ($self) = @_;
    my %h = ();
    $h{"$_"} = $_ for @$self;
    return $self->page_list([ values %h  ]);
}

#Убираем повторяющиеся ссылки
#Учитываем частоты текстов на странице
sub pack_urls {
    my ($self) = @_;
    my $h = $self->group_pages_by_urls;
    my $txt_counts = $self->text_counts;
    return $self->page_list([ map { $_->_get_the_best_url_name($txt_counts) } values %$h ]);
}

sub get_pager_urls {
    my ($self) = @_;

    #Явно прописанная в коде листалка
    my ($htmlpgl, $badhtmlpgl) = $self->divide(sub { $_->name eq '_pagerurl_' });

    #Выделяем урлы листалки
    my ($pagerpgl, $notpagerpgl) = $self->divide(sub { $_->is_a_pager });
    my ($goodpgl, $badpgl) = $pagerpgl->divide(sub { $_->url =~ /(?<!\?on_)pa?ge(?:num)?=|\/page\/?\d|start=\d|\/page-\d+/ || $_->url =~ /[\;\?\&]PAGEN_\d=\d/ });
    $goodpgl += $htmlpgl;
    return $goodpgl if $goodpgl->count;

#    ($goodpgl, $badpgl) = $pagerpgl->divide(sub { $_->url =~ /[\?\&]p=\d/ });
#    return $goodpgl if $goodpgl->count;
    #На странице не должно быть более 1 "Показать все"
    my ($allpgl, $notallpgl) = $pagerpgl->pack_urls->divide(sub { 
           $_->name =~ /(Показать|Посмотреть) (вс[её]|ещ[её])(\W|$)/ 
        && $_->url !~ /\/\/[^\/]+(?:\/[-a-z]+)?$/i #Убираем явную ссылку на другой раздел 
    });
#    $allpgl->debug_print("allpgl pagers");
#    return $notallpgl if @$allpgl > 1;
    if(@$allpgl > 1){ #Больше одной ссылки на "Показать всё" - скорее всего приходят из обвязки
        if($allpgl->lgrep(sub { $_->uri =~ /^\/?[-A-Za-z_\.]+\/?$/ })->count == $allpgl->count ){ #Если все эти ссылки ведут на корневые разделы, то игнорируем их
            $pagerpgl = $notallpgl;
        }else{
            $pagerpgl = $notallpgl + [ [ sort { $a->url cmp $b->url } @$allpgl ]->[0] ]; #Оставляем самый короткий вариант
        }
    }

    #Решаем проблему вспомогательных урлов, похожих на листалку, но ведущих на страницы комментариев с добавлением перехода по # к обычному урлу
    #14 =-> http://www.220-volt.ru/catalog-174688/
    #Тостер BOSCH TAT3A014 =-> http://www.220-volt.ru/catalog-174688/
    #Тостер BOSCH TAT3A014 =-> http://www.220-volt.ru/catalog-174688/
    #Разделяем урлы на те, у которые есть более длинные тексты, и обычные
    my $flt = { map { $_->norm_url => 1 } @$notpagerpgl }; #Фильтр урлов, которые встречаются не у листалок
    my ($mltpgl, $notmltpgl) = $pagerpgl->pack_urls->divide(sub { $flt->{ $_->name } }); 
    if($mltpgl->count){
        my %tmpltypes = map { $self->get_page_tmpl($_) => 1 } @$notmltpgl;
        my ($good, $bad) = $pagerpgl->pack_urls->divide(sub { $tmpltypes{ $self->get_page_tmpl($_) } }); 
        $pagerpgl = $good;
    }
#    my $pagerpgl = $self->lgrep(sub {  $_->is_a_pager });

    #Особо обрабатывает ряд чисел, которые могуть быть и не листалками
    #Требуем, чтобы шаблон урлов совпадал с шаблонами других урлов листалки
    my %spec = map {$_=>1} qw{ 7 12 13 21 23 555 666 777 999 };
    my ($spcpgl, $notspcpgl) = $pagerpgl->pack_urls->divide(sub { $spec{ $_->name } }); 
    if(@$spcpgl){
        my %tmpltypes = map { $self->get_page_tmpl($_) => 1 } @$notspcpgl;
        my ($spcpglgood, $spcpglbad) = $pagerpgl->pack_urls->divide(sub { $tmpltypes{ $self->get_page_tmpl($_) } }); 
        $pagerpgl = $spcpglgood;
    }
    return $pagerpgl;
}

sub add_pager_urls {
    my ($self, $fh) = @_;

    my $urlcnt = {}; #Считаем, сколько раз ссылки встретились на страницах

    my $pagercount = 0;
    my $newpgl = $self;
    my $pager_urls = {}; #Сохраняем ссылки на урлы пейджера

    my $pager_tmplts = {}; #Шаблоны урлов листалки, чтобы найти страницы даже со странными названиями
    my $not_pager_tmplts = {}; #Шаблоны урлов, не являющихся урлами листалки
    my $iter_limit = 100;
    $iter_limit = $self->{iter_limit} if $self->{iter_limit};
    for my $c (1 .. $iter_limit){ #Делаем несколько итераций
        if( $pagercount > $iter_limit * 10 ){ #Прерываемся, если получается очень большое количество урлов листалки
            $self->proj->log("Too big pager");
            last;
        }
        my $pagerurls = $newpgl->get_pager_urls;
        $pagerurls += $newpgl->pgrep(sub { $pager_tmplts->{$_->digits_norm_url} })
                             ->pgrep(sub { ! $not_pager_tmplts->{$_->digits_norm_url} });
        $pagerurls = $pagerurls->pgrep(sub {! $pager_urls->{$_->norm_url} });
        $pagerurls = $pagerurls->pack_urls;
        last unless @$pagerurls;
        $pagerurls = $pagerurls->lhead(100) if $pagerurls->count > 100; #Ограничиваем слишком большое возможное число урлов
        $pager_tmplts->{$_->digits_norm_url}++ for @$pagerurls; #Получаем шаблоны урлов листалок
        my $not_pagerurls = $newpgl->pgrep(sub {! $pager_urls->{$_->norm_url} }) - $pagerurls;
        $not_pager_tmplts->{$_->digits_norm_url}++ for @$not_pagerurls; #Получаем шаблоны урлов, не относящихся к листалкам
        $pagerurls->zora_batch_download;
        for my $p ( @$pagerurls ){
            my $subpgl = $p->good_internal_subpages;
            $subpgl = $subpgl->delete_filter_combination_pages($p->url);
            $subpgl = $subpgl->freqhash_filtered_urls($fh) if $fh;
            my $htmlpgl;
            ($htmlpgl, $subpgl) = $subpgl->divide(sub { $_->name eq '_pagerurl_' });
            $subpgl = $subpgl->pack_urls;
            $urlcnt->{$_->norm_url}++ for @$subpgl;
            $subpgl -= $newpgl;
            $newpgl += $subpgl;
            #html-листалки могут теряться при упаковке урлов, так как могут те же урлы, но с другим названием
            #так как статус листалки может меняться
            #принудительно их возвращаем
            $newpgl += $htmlpgl;
            $pagercount++;
            $pager_urls->{$p->norm_url}++;
        }
    }

    #Убираем листалки и удаляем повторы
    $newpgl = $newpgl->pgrep(sub { ! $pager_urls->{$_->norm_url} })->pack_urls;
    $newpgl = $newpgl->pgrep(sub { ($urlcnt->{$_->norm_url} || 0) < 5 }) if $self->{clear_pager};
    return $newpgl;
}

sub get_urls_frequency {
    my ($self) = @_;
    return $self->get_list_stat(sub { $_->norm_url });
}

sub get_brands_pages {
    my ($self) = @_;
    return $self->pgrep(sub { $_->get_type eq 'brand_exactly' });
}

sub brand_filtered :FLTR {
    my ($self) = @_;
    return $self->pgrep(sub { $_->get_type ne 'brand_exactly' })->add_pages_fltrsn('brand_filtered');    
}

sub get_frequenti_all_suburls_arr {
    my ($self) = @_; 
    my $chkd_pgl = $self->get_rand_pages(20);
    $chkd_pgl->zora_batch_download;
    my @chkd = $chkd_pgl->pages;

    #Считаем, что только те урлы относятся к меню, которые втречались и на целевых старницах
    my $exturls = {};
    for my $p (@chkd){
        my $hh = {};
        my $subpgl = $p->good_internal_subpages->filter_pager_urls;
        $hh->{$_->norm_url}++ for @$subpgl;
        for my $url (keys %$hh){
            $exturls->{$url}{$_}++ for 1 .. $hh->{$url};
        }
    }    

    my @ma = ();

    for my $url (keys %$exturls){
        my @counts = sort { ($b->[1] <=> $a->[1])||($b->[0] <=> $a->[0]) } map { [$_, $exturls->{$url}{$_}] } keys %{$exturls->{$url}};
        #next if $counts[0][1] < @chkd * 0.6; #меньше 60% урлов с таким количеством ссылок
        push(@ma, $url.' => '.$counts[0][0].' => '.$counts[0][1]." < ".(@chkd * 0.6) );
    }

    return [ map {"$_"} @chkd ], \@ma;
#print Dumper($exturls);
}

sub get_frequent_suburls_arr : CACHE {
    my ($self) = @_; 
 
#    my @chkd = @$self; #Ограничиваем количество анализируемых урлов
#    if( $#chkd > 20 ){
#        @chkd = map { $_->[1] } sort {$a->[0] cmp $b->[0]} map { [ md5_hex('_menu_arr'.encode_utf8($_->nrmurl)), $_ ] } @chkd;
#        $#chkd = 20;
#     }
    my $chkd_pgl = $self->get_rand_pages(20);
    $chkd_pgl->zora_batch_download;
    my @chkd = $chkd_pgl->pages;

    #Считаем, что только те урлы относятся к меню, которые втречались и на целевых старницах
    my $exturls = {};
    for my $p (@chkd){
        my $hh = {};
        my $subpgl = $p->good_internal_subpages;
        $p->clear_cache;
        $hh->{$_->norm_url}++ for @$subpgl;
        for my $url (keys %$hh){
            $exturls->{$url}{$_}++ for 1 .. $hh->{$url};
        }
    }    

    my @ma = ();

#print Dumper($exturls);
    
    for my $url (keys %$exturls){
        my @counts = sort { ($b->[1] <=> $a->[1])||($b->[0] <=> $a->[0]) } map { [$_, $exturls->{$url}{$_}] } keys %{$exturls->{$url}};
        next if $counts[0][1] < @chkd * 0.6; #меньше 60% урлов с таким количеством ссылок
        push(@ma, $url, $counts[0][0]);
    }

    return \@ma;
}

#Кэшируем исходные данные, а не результат, так как хэш может меняться в процессе обработки
sub get_freqhash_suburls {
    my ($self) = @_;
    return { @{ $self->get_frequent_suburls_arr } };  
}

#удаляем урлы по хэшу в соответствии с частотами
sub freqhash_filtered_urls :FLTR {
    my ($self, $fh) = @_;

    my %mh = %$fh;

    #Убираем общее меню
    my @newarr = ();
    for my $p (@$self){
        $mh{$p->norm_url}--;
        next if $mh{$p->norm_url} >= 0; #Убираем общее меню
        push(@newarr, $p);
    }
    
    return $self->page_list(\@newarr);
}

##Разделение урла на шаблонные части
#sub _split_url_for_tmpl {
#    my ($self, $url) = @_;
#    return grep {/\S/} map { s/^(\D|[-A-Za-z0-9]+=)?\d+$/${1}_digits/; $_ } split( /[\/\?\&]/, $url );
#}

#Пытаемся найти фрагменты урлов, соответствующие брендам
#Если в похожих шаблонах на одних и тех же местах были бренды и что-то ещё, то это что-то ещё тоже назначаем брендом
#Это делается, так как мы можем знать не обо всех брендах
sub group_brand_tmpl_elems {
    my ($self) = @_;
    my @brandtmpl = ();
#    my $brflt = $self->proj->phrase->_get_brands_hash;
#    for my $lst ( map {[$_->split_url_for_tmpl]} @$self ){
    #Находим повторяющиеся части
    my $prts = {};  #Частоты частей урла
    $prts->{$_}++ for map {$_->split_url_for_tmpl} @$self;
    $prts->{$_} = $prts->{$_} > 3 ? $_ : '_words' for keys %$prts;
    #/Находим повторяющиеся части
    #Получаем шаблоны брендовых урлов
    push(@brandtmpl, $_->_get_split_url_for_tmpl_with_brands) for @$self;
    #@brandtmpl = map { [ map { $prts->{$_} }  @$_ ] } @brandtmpl;
    #/Получаем шаблоны брендовых урлов
    #Получаем новые бренды исходя из похожести на шаблоны брендовых урлов
    my $brnds = {};
    for my $p ( @$self ){
        my $lst = [ $p->split_url_for_tmpl ];
        for my $btmpl ( @brandtmpl ){
            next unless @$btmpl == @$lst;
            my $bad = 0;
            my $i = 0;
            my @newbrands = ();
            for my $tel (@$btmpl){
                if( $tel eq '_brand_' ){
                    push(@newbrands, $lst->[$i++]);
                    next;
                }elsif( ($prts->{$tel} || '') eq ($prts->{$lst->[$i++]} || '') ){
                    next;
                }else{
                    $bad = 1;
                    last;
                }
            }
            #print "brand_tmpl_elems: ".join("/", @$lst)." => ".join("/", @$btmpl)." => $bad\n";
            unless( $bad ){
                $brnds->{$_}++ for @newbrands;
            }
        }
    }
    return $brnds;
}

#Получить сгруппированные по шаблону урлы
sub get_tmpl_grps :CACHE {
    my ($self) = @_;
    my $dbg = 0;
    my $pgl = $self->pack_urls; #Удаляем дубли урлов
    my $htmpl = {}; #Шаблоны с принадлежащими им пейджами
    my $prts = {};  #Частоты частей урла
    #Считаем частоты частей урла
#    $prts->{$_}++ for map { $self->_split_url_for_tmpl($_) } map {$_->norm_url} @$pgl;
    my $brndtmpl = $pgl->group_brand_tmpl_elems;
    $prts->{$_}++ for map { $brndtmpl->{$_} ? '_brand_' : $_ } map {$_->split_url_for_tmpl} @$pgl;
    #Получаем шаблоны для урлов
    for my $p ( @$pgl ){
        my $urltmpl = join( "/",
#            map { $_ eq '_brand_' ? '_words' : $_ } 
            map { ($prts->{$_} || 0 ) > 3 ? $_ : '_words' } 
#            map { $brndtmpl->{$_} ? '_brand_' : $_ } 
            map { $brndtmpl->{$_} ? '_words' : $_ } 
            $p->split_url_for_tmpl ); 
        $urltmpl ||= 'UNKN'; #В урле не оказалось шаблонных частей
        $htmpl->{$urltmpl} ||= [];
        push(@{$htmpl->{$urltmpl}}, $p);
    }
    $htmpl->{$_} = $self->page_list($htmpl->{$_}) for keys %$htmpl;
    return $htmpl;
}

sub tmpls_filter :FLTR {
    my ($self, $tmpls) = @_;
    my $pgl = $self->page_list;
    for my $tt (@$tmpls){
        $pgl += $self->pgrep(sub { $_->compare_with_tmpl($tt) });
    }
    return $pgl->pack_urls; 
}

sub delete_tmpls_filter :FLTR {
    my ($self, $tmpls) = @_;
    return $self - $self->tmpls_filter($tmpls);
}

#Возвращает соответствие пейджа и шаблона
sub _url_tmpl_hash :CACHE {
    my ($self) = @_;
    my $h = $self->get_tmpl_grps;
    my $res = {};
    for my $tmpl ( keys %$h ){
        $res->{$_->norm_url} = $tmpl for @{$h->{$tmpl}};
    }
    return $res;
}

sub get_grps {
    my ($self, $fnc) = @_;
    return $self->split2hash($fnc);
}

#Получить сгруппированные по шаблону урлы
sub get_domain_grps :CACHE {
    my ($self) = @_;
    return $self->get_grps(sub { my $d = $_->domain; $d =~ s/^www\.//; $d }); 
}

#Возвращаем шаблон урла для конкретного пейджа
sub get_page_tmpl {
    my ($self, $p) = @_;
    return $self->_url_tmpl_hash->{$p->norm_url};
}

#Удаляем группы урлов, соответствующих мусорным шаблонам
sub delete_bad_tmpls :FLTR {
    my ($self) = @_;
    my $tmpls = $self->get_tmpl_grps;
    my @ll = values %$tmpls;
    #Удаляем шаблоны со списком стран
    @ll = grep { (grep { $_->name =~ /^(Германия|Италия|Франция|Испания|Россия|США|Чехия|Беларусь|Казахстан|Турция|Великобритания|Япония|Индия|Украина)$/i } @$_) < 3 } @ll;
    my $pgl = $self->page_list;
    $pgl += $_ for @ll;
    return $pgl;
}

sub delete_vendorlike_pages {
    my ($self) = @_;
    my $bad = {};
    for my $vc ( grep { /^[A-Za-zА-Яа-я]+(?:\s+[A-Za-zА-Яа-я]+)?(?:\s+\(\s*\d+\s*\))?\s*$/ } map {$_->name} @$self ){
        my $v = $vc;
        $v =~ s/\s+\(\s*\d+\s*\)\s*$//;
        $bad->{$vc}++ if (grep { /$v/ } map {$_->name} @$self) > 2;
    }
    return $self->pgrep(sub { ! $bad->{ $_->name } });
}

#Определяем брендовые урлы
sub is_brand_group {
    my ($self) = @_;
    my @arr = map {$_->name} @$self;
    return 0 unless @arr;
    my $brands = 0;
    my $prefix = {};
    for my $t (@arr){
        $t =~ s/\(\d+\)\s*$//;
        if($t =~ s/(\w+)\s*$// ){
            my $lastword = $1;
            $brands++ if $self->proj->phrase($lastword)->is_brand;
        }
        $prefix->{$t}++;
    }
    my @top = h2sa($prefix);
    #Если более чем в 70% названий на конце бренд и при этом более 80% префиксов совпадают
    return 1 if ($brands / @arr > 0.7) && ($top[0][1] / @arr > 0.8);
    return 0;
}

#Определяем модельные урлы
sub is_models_group {
    my ($self) = @_;
    my $mdls = 0;
    for my $p (@$self){
        $mdls++ if $p->get_type eq 'model';
    }
    return 1 if $mdls / @$self > 0.7;
    return 0;
}

#Фильтруем сгруппированные пейджи
sub _freq_tmpl_filter {
    my ($self, $h) = @_;
    my @goodtmpls = keys %$h;
    @goodtmpls = grep {! $h->{$_}->is_brand_group} @goodtmpls;
    my @mdlgrps = grep { $h->{$_}->is_models_group } @goodtmpls;
    @goodtmpls = @mdlgrps if @mdlgrps && ( grep { $h->{$_}->count > 6 } @mdlgrps );
    return { map { $_ => $h->{$_} } @goodtmpls };    
}

#Возвращает общий префикс текстов, если он есть
sub get_list_prefix {
    my ($self) = @_;
    my $phl = $self->proj->phrase_list( [ map {$_->name} @$self ] );
    return $phl->get_list_prefix;
}

#Возвращаем только те урлы, которые соответствуют самому частотному шаблону
sub most_freq_tmpl_urls {
    my ($self, $suburl) = @_;
    return $self unless $self->count; #Возвращаем изначальный список, если нет элементов
    my $hh = $self->get_tmpl_grps;
    $hh = $self->_freq_tmpl_filter($hh);

    return $self->proj->phrase_list([ @$self ]) unless keys %$hh;

    my $mxcnt = 0;
    my @maxarr = (); #Список фрейзлистов, у которых максимальное количество урлов - могут совпадать
    for my $pgl ( values %$hh ){
        if( $pgl->count > $mxcnt ){
            @maxarr = ($pgl);
            $mxcnt = $pgl->count;
        }elsif( $pgl->count == $mxcnt ){
            push(@maxarr, $pgl);
        }
    }
    my $res;
    if( @maxarr == 1 ){
        $res = $maxarr[0];
    }else{
        #Если несколько выборок, то выбираем ту, где меньшая частота текстов
        @maxarr = map {$_->[0]} sort { $b->[1] <=> $a->[1] } map { [ $_, 0 + (keys %{{ map { $_->name =>1 } @$_ }} ) ] } @maxarr;
        $res = $maxarr[0];
    }
    #Дополнительная логика, так как товары иногда могут дробиться по подтипам
    if( $res->get_list_prefix ){
        my $pref = $res->get_list_prefix;
        my $nres = $self->page_list;
        for my $pgl ( values %$hh ){
            if( $pgl->get_list_prefix eq $pref ){
                $nres += $pgl;
            }
        }
        $res = $nres;
    }
    #Пропускаем все шаблоны, совпадающие с путём раздела
    sub cmptmpl {
        my ($tml1, $tml2) = @_;
        my $ll = length($tml1);
        my $tml22 = substr($tml2, 0, $ll);
        return $tml1 eq $tml22;
    }
    if( $suburl ){
        for my $tt ( grep { cmptmpl($suburl, $_) } keys %$hh ){
            $res += $hh->{$tt};
        }
    }    
    return $res;
}

#Возвращаем только те урлы, которые соответствуют самому частотному шаблону
sub most_freq_tmpl_urls_old {
    my ($self) = @_;
    my $pgl = $self->pack_urls; #Удаляем дубли урлов
    my $hu = {};    #Соответствие урла и шаблона
    my $htmpl = {}; #Частоты шаблонов
    my $prts = {};  #Частоты частей урла
    #Разделение урла на шаблонные части
    sub split_url { return map { s/^(\D)?\d+$/${1}_digits/; $_ } split( /\//, $_[0] ) } ##no critic
    #Считаем частоты частей урла
    $prts->{$_}++ for map { split_url($_) } map {$_->norm_url} @$pgl;
    #Получаем шаблоны для урлов
    for my $u ( map {$_->norm_url} @$pgl ){
        my $urltmpl = join( "/", grep { $prts->{$_} > 3 } split_url($u) ); 
        next unless $urltmpl; #В урле не оказалось шаблонных частей
        $hu->{$u} = $urltmpl; #Сохраняем соответствие урла и шаблона
        $htmpl->{$urltmpl}++; #Считаем частоты шаблонов
    }
    #Получаем ТОП самых частотных шаблонов
    my @toptmpl = sort { $htmpl->{$b} <=> $htmpl->{$a} } grep { $htmpl->{$_} > 3 } keys %$htmpl;
    if($self->dbg){
        print "toptmpl:".$toptmpl[0]."\n";
    }
    return $self->page_list unless @toptmpl; #Если нет частотного шаблона, возвращаем пустой список
    #Оставляем урлы, соответствующие самому частотному шаблону
    my $goodurlsh = { map {$_=>1} grep { $hu->{$_} eq $toptmpl[0] } keys %$hu };
    $pgl = $pgl->pgrep(sub { $goodurlsh->{ $_->norm_url } });
#    print Dumper([ map { $_." => ".$htmpl->{$_} } grep { $htmpl->{$_} > 3  } keys %$htmpl ] );
#    print Dumper($hu);
    return $pgl;
}

sub filter_bad_urls :FLTR {
    my ($self) = @_;
    #return $self->pgrep(sub { ! $_->bad_page_reason });    
    return $self->filter_metalinks;    
}

sub pgrep($&) {
    my $self = shift;
    return $self->lgrep(@_);
}

sub pmap($&) {
    my $self = shift;
    return $self->lmap(@_);
}

#Заглушка для переопределения
sub context_badre_filter {
    return shift @_;
}

sub filter_metalinks :FLTR {
    my ($self) = @_;
    return $self->lgrep(sub { ! $_->is_metalinks_url })->lgrep(sub { ! $_->is_metalinks_text }); 
}

sub filter_metalinks_for_page {
    my ($self, $page) = @_;
    my $url = $page->url;
    my $url_reason = $page->is_metalinks_url;
    my $redir_url_reason = '';
    if ( $page->redir_location ) {
        # Может быть ситуация, когда с урла, который не определился как металинк, произошел редирект на металинк. В этом случае не амнистируем дочерние урлы с таким же результатом проверки на металинки
        $redir_url_reason = $self->proj->page( $page->redir_location )->is_metalinks_url;
        if ( $redir_url_reason && $redir_url_reason ne $url_reason ) {
            $url_reason = '';
        }
    }

    my $text_reason = $page->is_metalinks_text;
    my $pgl = $self;
    #Выбрасывание ссылок с добавлением сортировок
    $pgl = $pgl->lgrep( sub {
         if( $_->url =~ /^(.+)[\?\&]sort=[A-Za-z0-9]+$/ ){
             return 0 if $1 eq $url;
         }
         return 1;
    });    
    return $pgl->
        lgrep(sub { ! $_->is_metalinks_url || $_->is_metalinks_url eq $url_reason || ( $_->is_metalinks_url =~ /^url_geo/ && $_->domain eq $page->domain ) })->
        lgrep(sub { ! $_->is_metalinks_text || $_->is_metalinks_text eq $text_reason }); 
}

sub filter_metalinks_debug  {
    my ($self) = @_;
    my $res = '';
    for my $p (@$self){
        if($p->is_metalinks_url || $p->is_metalinks_text){
            $res .= 'filter_metalinks_debug: ['.$p->is_metalinks_url.'/'.$p->is_metalinks_text.'] '.$p."\n";
        }
    }
    return $res;
}

sub filter_pager_urls :FLTR {
    my ($self) = @_;
    return $self->lgrep(sub { ! $_->is_a_pager }); 
} 

sub filter_web_wideurlnames :FLTR {
    my ($self) = @_;
    return $self->lgrep(sub { ! $_->is_web_wideurlname });
}

#Оставляет из списка только самый короткий урл, если названия совпадают, а урлы вложены друг в друга
sub shortest_with_the_same_name {
    my ($self) = @_;
    my $ht = {};
    for my $p (@$self){
        $ht->{$p->name}{$p->norm_url}++;
    }
    my $filter = {};
    for my $k (keys %$ht){
        #Подавляем вложенные урлы, так как это частый случай для некоторых сайтов (rbt.ru)
        my @list = keys %{$ht->{$k}};
        next if @list < 2;
        my $shotest = '';
        my $shotestlng = 0;
        for my $t (@list){
            my $newlng = length($t);
            next if $shotestlng && ($shotestlng < $newlng);
            $shotestlng = $newlng;
            $shotest = $t;
        }
        for my $t (@list){ #Заполняем фильтр для вложенных урлов
            next if $t eq $shotest; #Оставляем короткий урл
            $filter->{"$k $t"}++ if substr($t, 0, $shotestlng) eq $shotest; 
        } 
    }
#print Dumper(['shortest_with_the_same_name', $ht, $filter]);
#print "[[[[ ".$self->lgrep(sub {$filter->{$_->name." ".$_->norm_url}})." ]]]]";
    
    return $self->lgrep(sub {! $filter->{$_->name." ".$_->norm_url}});     
}

sub get_urls_by_prefix { #Получаем список пейджей, у которых указанный урл - префикс
    my ($self, $url) = @_;
    my $prefix = $self->proj->page($url)->norm_url;
    my $lnth = length($prefix);
    my $pgl = $self->lgrep(sub { substr($_->norm_url, 0, $lnth) eq $prefix });
    return $pgl; 
}

sub _join_names {
    my ($self) = @_;
    my $newname = join ' ', map { $_->name } @$self;    
    return $self->proj->page($self->[0]->url, $newname);
}

#Пакуем урлы, сжимая тексты в одну строку
sub pack_urls_grp {
    my ($self) = @_;
    return $self if $self->count == 1;
    my $h = $self->split2hash(sub { $_->norm_url });
    $self->new_list([ map { $_->_join_names } values %$h ]);
}

###################################################################
# delete_filter_combination_pages
###################################################################

#Специальный массив префиксов полей перед подчёркиванием
#http://vrasmer.ru/shoes/woman/company_allure-loretta-josesaenz/
our @smpl_url_pref_arr = qw{ company material2 material color colour heel season size brand brend autorepl };
our $smpl_url_pref = '(?:'.join('|', @smpl_url_pref_arr).')';
our $smpl_url_pref_lookbeh = '(?:'.join('|', map { "(?<=$_)" } @smpl_url_pref_arr).')'; #Нельзя, чтобы заглядывание назад было разной длины - делаем несколько заглядываний назад
#Упрощенное описание урла без значения параметров
sub _smpl_url {
    my ($url) = @_;
    $url =~ s/\&count=\d+$//; #Считаем параметр количества отображаемых элементов незначимым при сравнении
    $url =~ s/(?:=|${smpl_url_pref_lookbeh}[-_]).+?(?=\&|\/|\.htm|$)/=AAA/g;
    #$url =~ s/(\?.+)/join("&", split( '[&\/]', $1 ))/e;
    return $url;
}

sub _chgd_elms {
    my ($url) = @_;
    $url =~ s/\/(\d+(?:\-\d+)+)\//\/autorepl_$1\//; #Исправление для случая, когда перечисления без префикса
    my @arr = $url =~ /(?:[-_a-z0-9]+=|${smpl_url_pref}[-_]).+?(?=\&|\/|\.htm|$)/gi;
    my @elms = ();
    for my $prm (@arr){
        my ($name, $val) = split(/=|${smpl_url_pref_lookbeh}[-_]/, $prm);
        my @vls = split(/[-, _|:;\.\+]|\%2C/, $val);
        push(@elms, map { $name.'='.$_ } @vls);
    }
    return @elms;
}

#Удаляем урлы, которые подозреваем в случайном сочетании фильтров со страницы
#Если в каком-то параметре просто добавляется значение через разделитель, то считаем это комбинаторным фильтром и подавляем
#$url = 'http://spok.ua/avtotreki-i-zheleznyie-dorogi/c073/producer=bambi%2Cbig%2Cbig-motors%2Cgolden-bear%2Couaps%2Cpoli/';
#$url = 'http://www.ozon.ru/catalog/1159661/?numinpack=37733,37726,37730,61919';
#http://lasecrets.ru/detskaya-odezhda/sort/size-30_50_50_70_70_130.html
sub delete_filter_combination_pages {
    my ($self, $exturl) = @_;
    my $surl = _smpl_url($exturl);
    #my ($strange, $good) = $self->ndl->divide(sub { print Dumper([$_->url, _smpl_url($_->url), $surl]); _smpl_url($_->url) eq $surl; });
    my ($strange, $good) = $self->divide(sub { _smpl_url($_->url) eq $surl; });
    #$strange->debug_print("ddd");
    #$good->debug_print("good");
    my @prntels = _chgd_elms($exturl); #Параметры исходного урла
    my %prnth = map { $_ => 1 } @prntels;
    my @fgood = ();
    my $dbg = 0;
    for my $pg (@$strange){
        #print "chkd: $nd\n";
        my @curels = _chgd_elms($pg->url);
        my %curh = map { $_ => 1 } @curels;
        my @addels = grep {! $prnth{$_}} @curels;
        my @delels = grep {! $curh{$_}} @prntels; 
        if( @delels && @addels ){ #Часть значений пропала, это хорошо
        #if( @delels ){ #Часть значений пропала, это хорошо
            push(@fgood, $pg);
        #    next;
            print STDERR "good: $pg <===> $exturl\n" if $dbg;
        #}elsif(@addels){ #Если это не так, то урлы совпадают
        }else{
            print STDERR "bad: $pg <===> $exturl\n" if $dbg;
        } 
        print STDERR Dumper(["$pg",  _smpl_url($pg->url),  $surl,  \@prntels, \@curels, \@addels, \@delels]) if $dbg;
    }
    return $self->page_list([ @$good, @fgood ]); 
}

###################################################################
# / delete_filter_combination_pages
###################################################################

sub debug_print {
    my ($self, $pref, $fh) = @_;
    $pref ||= 'dpnt';
    $fh ||= *STDERR;
    #print $fh "=================== $pref BEG ===================\n";
    my $i = 1;
    if(defined $fh){
        print $fh $i++." $pref: $_\n" for @$self;
    }else{
        print $i++." $pref: $_\n" for @$self;
    }
    #print $fh "=================== $pref END ===================\n";
    return $self;
}

use overload
    "+" => sub {
             my ($self, $other, $swap) = @_;
             $other = $self->page_list($other) if (ref( $other ) eq 'ARRAY') || (! ref $other );
             return $self->page_list( [ $self->pages, $other->pages ] );
        },
    "*" => sub { #пересечение
             my ($self, $other, $swap) = @_;
             $other = $self->page_list($other) if (ref( $other ) eq 'ARRAY') || (! ref $other );
             my $flt = { map { $_->norm_url => 1 } @$other };
             return $self->pgrep(sub { $flt->{$_->norm_url} });
        },
    '@{}' => sub {
             my ($self) = @_;
             return [$self->pages];
        },
    '""' => sub { 
             my ($self) = @_;
             return $self->pages2text;
        },
    "-" => sub {
             my ($self, $other, $swap) = @_;
             $other = $self->page_list($other) if (ref( $other ) eq 'ARRAY') || (! ref $other );
             my $flt = { map { $_->norm_url => 1 } @$other };
             return $self->pgrep(sub { ! $flt->{$_->norm_url} });
        },
    "/" => sub {
             my ($self, $other, $swap) = @_;
             $other = $self->page_list($other) if (ref( $other ) eq 'ARRAY') || (! ref $other );
             my $flt = { map { $_->name.' => '.$_->norm_url => 1 } @$other };
             return $self->pgrep(sub { ! $flt->{$_->name.' => '.$_->norm_url} });
        };

1;
