package BM::Pages::PageListHierarchy;

use utf8;
use open ':utf8';

use std;
use base qw(BM::Pages::PageList);

########################################################
#Доступ к полям
########################################################

__PACKAGE__->mk_accessors(qw(
));

########################################################
# Интерфейс
########################################################

# good_pages_for_hierarchy         хорошие пейджи с точки зрения иерархии (без брендов, листалок стран и т.д.)

########################################################
#Методы
########################################################

#Устанавливаем прокси на родителя и прокидываем до детей
sub set_prnt_proxy_ref {
    my ($self, $ref) = shift;
    if($ref){
        $self->{prnt_proxy_ref} = $ref;
        $_->{prnt_proxy_ref} = $ref for @$self;
    }
}

sub prnt {
    my ($self) = shift;
    if(@_){
        my $prnt = $_[0];
        weaken($prnt);
        $self->set_prnt_proxy_ref(\$prnt);
    }
    return ${$_->{prnt_proxy_ref}} if $_->{prnt_proxy_ref}; 
    return '';
}

#Добавляем прокидывание родителя
sub page_list {
    my $self = shift;
    my $pgl = $self->SUPER::page_list(@_);
    $pgl->set_prnt_proxy_ref($self->{prnt_proxy_ref}) if $self->{prnt_proxy_ref};
    return $pgl;
}

#Группирует страницы по урлу с сортировкой по весу внутри урла
sub group_pages_by_url_and_prnt {
    my ($self) = @_;
    my %hh = ();
    for my $el (@$self){
        my $k = ($el->prnt ? $el->prnt->norm_url : '' ).' => '.$el->norm_url;
        $hh{$k} ||= [];
        push(@{$hh{$k}}, $el);
    }
    $hh{$_} = $self->page_list($hh{$_}) for keys %hh;
    return \%hh;
}

sub prnt_pack_urls :FLTR {
    my ($self) = @_;
    my $h = $self->group_pages_by_url_and_prnt;
    my $txt_counts = $self->text_counts;
#    return $self;
    return $self->page_list([ map { $_->_get_the_best_url_name($txt_counts) } values %$h ])->add_pages_histinf('prnt_pack_urls');
#    return $self->page_list([ map { $_->_get_the_best_url_name($txt_counts) } values %$h ]);
}

#Убирает те урлы, которые не подходят для корня иерархии
sub first_level_filter :FLTR {
    my ($self) = @_;
    my $bd = 'iPhone/iPad';
    my $hf = { map {$_=>1} grep { /\S/ } split "\n", $bd };
    return $self->subsection_filter->pgrep(sub { ! $hf->{$_->name} });
}


#Убирает те урлы, которые не могут быть подразделами
sub subsection_text_filter :FLTR {
    my ($self) = @_;
    return $self->pgrep(sub { ! $_->subsection_filter_reason });
=h
    my %badtypes = map {$_=>1} qw{ pager brand_exactly model brand qstn };
    return $self->pgrep(sub { ! $badtypes{ $_->get_type } }) # ->add_pages_fltrsn('page_type', $self)
                ->pgrep(sub { length( $_->name ) < 60 }) # ->add_pages_fltrsn('length', $self)
                ->pgrep(sub { $_->url !~ /\/prod\d{4}/ }) #->add_pages_fltrsn('proddgst', $self)  #Убираем товароподобные урлы
           ;
=cut
}

sub subsection_tmpl_filter :FLTR {
    my ($self) = @_;
    my @goodstmpls = keys %{$self->site->freq_tmpl_stat};
    return $self->delete_tmpls_filter(\@goodstmpls);
}

sub subsection_filter {
    my ($self) = @_;
    return $self->subsection_text_filter->subsection_tmpl_filter;
}

sub up_level_filter :FLTR {
    my ($self, $h) = @_;
    return $self->pgrep(sub { ! $h->{$_->norm_url} });
}

sub _catalog_re {
    my ($self) = @_;
    return '\:\/\/[^\/]+\/(catalog|katalog)\/?$';
}

#Возвращает, имеет ли список страниц урлы, похожие на каталог
sub has_catalog_regexp_in_urls :CACHE {
    my ($self) = @_;
    my $prev_value = $self->{dont_use_fltr_log};
    $self->{dont_use_fltr_log} = 1; #отключаем логирование фильтрации
    my $ctlgs = $self->catalog_regexp_filter;
    my $catflt = 0;
    if(@$ctlgs){
        #Проверяем, действительно ли у сайта структура со словом catalog в урлах
        #Считаем количество подурлов с таким префиксом
        my $sbpctlgs = $ctlgs->pmap(sub { $_->get_internal_filtered_subpages })->catalog_regexp_filter->pack_urls;
        $catflt = 1 if @$sbpctlgs > 20;
    }
    $self->{dont_use_fltr_log} = $prev_value;
    return $catflt;
}

sub catalog_regexp_filter :FLTR {
    my ($self) = @_;
    my $cat_re = $self->_catalog_re;
    return $self->pgrep( sub { $_->url =~ /$cat_re/ }); 
}

sub subsites_filter :FLTR {
    my ($self) = @_;
    return $self unless $self->site && $self->site->subsites;
    return $self->pgrep( sub { ! $self->site->subsites->{$_->domain} });
}

sub get_hierarchy_text {
    my ($self, $pref) = @_;
    my $text = '';
    for my $p (@$self){
        $text .= "$pref [".($p->{lastlvl}?'lst,':'').( $p->chlrn ? "c:".$p->chlrn->count : '')."] $p\n";
        $text .= $p->chlrn->get_hierarchy_text("    $pref") if $p->chlrn;
    }
    return $text;
}

sub dumper_text_lite {
    my ($self) = @_;
    $_[0] = \@$self;
    return @_;
}

sub good_pages_for_hierarchy {
    my ($self, $pgc) = @_;
    my $pgl = $self->filter_bad_urls;
    $pgl = $pgl->context_badre_filter($pgc) if $pgc;
    return $pgl->brand_filtered->delete_bad_tmpls->prnt_pack_urls;
}

our $cnxt_fltrs = [
    #Убираем города, так как часто это региональные представительства (например, у холодильника)
    qr'/(russia|tver|volgograd|obninsk|tula|kaluga|sankt-peterburg|krasnoyarsk)(/|$)',
];

sub context_badre_filter {
    my ($self, $pgc) = @_;
    
    my ($namec, $urlc) = ($pgc->name, $pgc->url);
    $namec =~ tr/A-ZА-ЯЁ/a-zа-яё/;
    $urlc  =~ tr/A-ZА-ЯЁ/a-zа-яё/;
    my (@good, @bad) = (); 
    for my $pg (@$self){
        my ($name, $url) = ($pg->name, $pg->url);
        $name =~ tr/A-ZА-ЯЁ/a-zа-яё/;
        $url  =~ tr/A-ZА-ЯЁ/a-zа-яё/;
        my $badpg = 0;
        for my $re (@$cnxt_fltrs){
            if( $urlc !~ /$re/ && $url =~ /$re/ ){
                $badpg = 1;
                push(@bad, $pg);
                last;
            }
        }
        push(@good, $pg) unless $badpg; 
    }
    return $self->page_list(\@good);
}


1;
