package BM::Pages::PageLite;

use utf8;
use open ':utf8';

use std;
use base qw(BM::Pages::Page);

use Data::Dumper;

use Digest::MD5 qw(md5_hex);

use Encode;

use open ":utf8";
no warnings 'utf8';

########################################################
#Доступ к полям
########################################################

########################################################
# Интерфейс
########################################################

#    url                  =>   урл страницы
#    domain               =>   домен, получаемый из урла
#    pagetext             =>   текст страницы

########################################################
# Инициализация
########################################################

our $CCC = 0;
sub init {
    my ($self) = @_;
    $CCC++;
    $self->SUPER::init;
}

sub DESTROY {
    my $self = shift;
    $CCC--;
}

sub get_CCC {
    return $CCC;
}

########################################################
#Вспомогательные методы
########################################################

sub _url2inf {
    my $self = shift;
    my $url = shift;

    return '' unless $url;

    my $timeout = 3600 * 24 * 2; #Время жизни кэша

    my $url_bytes = Encode::encode('UTF-8', $url);
    my $md5 = md5_hex($url_bytes);
    my $curdir = $self->curdir."info/";
    -d $curdir || mkdir $curdir;
#    my $filename = $curdir."pagelite_tmpprx_$md5";
    my $filename = $curdir."pagelite_$md5";
    print "pagelite filename: $filename\n" if $self->{dbg};

    if((! $self->{'no_cache'}) && (! $self->proj->{'no_cache_subpages'}) && (! $self->{'no_cache_subpages'})){
        if( -e "$filename" ){
          if( time - (stat $filename)[9] < $timeout ){
#print "beg2 ".time."\n";
#print "$url\n";
            if( open(F, "< $filename") ){
                my @a = <F>;
                close(F);
#print "end2 ".time."\n";
                return join("", @a);
            }else{
                $self->tlog("pinff: $!");
            }
          }
        }
    }

    my $text = '';

    print "prinf:$url\n" if $self->{dbg};

#$self->proj->dd($self->SUPER::get_internal_subpages);

    my $nocache = $self->{'no_cache'};
    if($nocache){ #Если отключено кэширование
        $self->SUPER::title; #Скачиваем текст страницы
        $self->{'no_cache'} = 0; #Включаем кэширование, чтобы страница не качалась на каждый вызов
    }
    
    $self->{raw_data} = { #Сырые данные, так как они могут использоваться во вложенных кэшируемых вызовах
        url => $url,
        title => $self->SUPER::title,
        get_internal_subpages => [ map { [$_->name, $_->url] } map {@$_} $self->SUPER::get_internal_subpages ],
        links_to_himself => [ map { [$_->name, $_->url] } map {@$_} $self->SUPER::links_to_himself ], 
    };
    #Важно, чтобы было отдельным вызовом, так как использует get_internal_subpages 
    $self->{raw_data}{good_internal_subpages} = [ map { [$_->name, $_->url] } map {@$_} $self->SUPER::good_internal_subpages ];

    if($nocache){ #Снова отключаем кэширование
        $self->{'no_cache'} = $nocache;
    }

    $text = $self->proj->json_obj->encode( $self->{raw_data} );

    if( open(F, "> ${filename}_tmp")){ 
        print F $text;
        close(F);
    }
    rename("${filename}_tmp", $filename); #Решаем проблему недописанных файлов

    return $text;
}

sub _url_inf {
    my ($self, $url) = @_;

    my $text = $self->_url2inf($url);
    my $data;
    eval {
        $data = $self->proj->json_obj->decode($text);
    };
    unless($data){ #Если данные были битые, то перепарсим
        $self->{'no_cache_subpages'} = 1;
        $text = $self->_url2inf($url);
        $data = $self->proj->json_obj->decode($text);
    }

    return $data;
}

########################################################
#Методы
########################################################

sub clear_cache { #Удаляем промежуточные данные для экономии памяти
    my ($self) = @_;
    delete($self->{raw_data});
}

sub info {
    my ($self) = @_;
    return $self->{raw_data} if $self->{raw_data}; #Отдаёт данные ещё заполняемого кэша
    return $self->_url_inf($self->url);
}

sub title {
    my ($self) = @_;
    return $self->info->{'title'};
}

sub title_src {
    my ($self) = @_;
    return $self->SUPER::title;
}

sub _infotext2arr {
    my ($self, $name) = @_;
    my @pages = map { $self->page($_->[1], $_->[0]) } map {@$_} $self->info->{$name};
#    my $url_filter = $self->{url_filter};
#    $_->{url_filter} = $url_filter for @pages; 
    return @pages;
}

sub _infotext2pgl {
    my ($self, $name) = @_;
    my @arr = $self->_infotext2arr($name);
    return $self->page_list(\@arr);
}

#Получить урлы со странице, ведущие на тот же домен
sub get_internal_subpages { my ($self) = @_;  return $self->_infotext2pgl('get_internal_subpages')->lmap(sub{$_->set_forbid_outgoing_redirects(1)}); }

sub good_internal_subpages { my ($self) = @_;  return $self->_infotext2pgl('good_internal_subpages')->lmap(sub{$_->set_forbid_outgoing_redirects(1)}); }

sub links_to_himself {
    my ($self) = @_;
    return $self->_infotext2pgl('links_to_himself');    
}

=h
#Получить урлы со странице, ведущие на тот же домен
sub get_subpages {
    my ($self) = @_;
    #временная заглушка, так как у старого варианта этот список не кэшировался
    return $self->SUPER::get_subpages if $self->info->{'sbpgstext'} && ! $self->info->{'sbpgsalltext'}; 
    my @pages = map { $self->page($_->[1], $_->[0]) } map { [split ' => ', $_ ] } split ' // ', $self->info->{'sbpgsalltext'};
    my $url_filter = $self->url_filter;
    $_->url_filter($url_filter) for @pages; 
    return @pages;
#    return @{$self->info->{'internal_subpages'} || []};
}
=cut


1;
