package BM::Pages::PageSnippet;

use utf8;
use open ':utf8';
use Time::HiRes qw/time/;
use MIME::Base64;

use IO::Socket::SSL qw( SSL_VERIFY_NONE );

use Digest::MD5 qw(md5_hex);
use Utils::Array qw(in_array);
use Data::Dumper;

########################################################
# Интерфейс
########################################################
sub get_tag_value_pairs {
    my ($self, %hpar ) = @_;
    my $tags_whitelist = $hpar{tags_whitelist} || '';
    my $tags_blacklist = $hpar{tags_blacklist} || '';
    my $values_match_re = $hpar{values_match} || '';
    my @res = ();
    my @data = ();
    my $text = $self->proj->phrase($self->text)->replace_html_spec->text;
    $text =~ s/\n/ /g;
    $text =~ s/<script(?: |\>).*?<\/script>//ig;
    $text =~ s/<noscript(?: |\>).*?<\/noscript>//ig;
    # удаляем теги a, только если они не нужны
    $text =~ s/<a(?: |\>).*?<\/a>//ig if ($tags_whitelist !~ /(\s|^)a(\s|$)/i );
    @data = $text =~ /<([^\s\>]+)\s*[^>]*>([^<>]+?)<\/\1/gi;
    my @tvpairs = map{[$data[2 * $_], $data[2 * $_ + 1]]} 0..(scalar(@data) / 2 - 1);
    for my $pair ( @tvpairs ){
        $pair->[0] =~ s/\s+/ /g; $pair->[0] =~ s/(^\s+|\s+$)//g;
        $pair->[1] =~ s/\s+/ /g; $pair->[1] =~ s/(^\s+|\s+$)//g;
        next if ( $tags_whitelist && !in_array( $pair->[0], [ map{$_=lc $_; $_||()} (split/\s+/,$tags_whitelist) ] ) ); ##no critic
        next if ( $tags_blacklist &&  in_array( $pair->[0], [ map{$_=lc $_; $_||()} (split/\s+/,$tags_blacklist) ] ) ); ##no critic
        next unless ( !$values_match_re || ($pair->[1]) =~ /(?:$values_match_re)/i );
        push @res, $pair;
    }
    return \@res;
}

my $ban_re = '';

sub filter_tag_value_pairs {
    my ($self, $tvp) = @_;
    my @res = ();
    unless ( $ban_re ){
        open F, "< /home/sergio/broadmatching/dicts/dict_badtags500";
        $ban_re = join("|", grep { /\S/ } map { chomp; $_} <F>);
    }
    for my $pair ( @$tvp ){
        my $value = $pair->[1];
        next unless $value;
        my $normvalue = $self->proj->phrase( $value )->norm_phr || '';
        next unless $normvalue;
        my $badtext = '';
        if ( $normvalue =~ /(?:^|\s+)($ban_re)(?:\s+|$)/ ){
            $badtext = $1;
            $normvalue =~ s/(?:^|\s+)$badtext(?:\s+|$)/ /g;
        }
        $normvalue =~ s/\s+/ /g;
        $normvalue =~ s/(^\s|\s$)//g;
#        print STDERR Dumper ([$value, "<$normvalue>", "<$badtext>"]);
#        push @res, $pair;
#        push @res, $pair if ( !$badtext || $normvalue && scalar(split/\s+/,$normvalue)>1 );
        push @res, $pair if ( !$badtext );
    }
#    print $_->[1]."\n" for @res;
    return \@res;
}

sub get_snippet {
    my ($self) = @_;
    my $tvp = $self->get_tag_value_pairs( tags_blacklist => 'option style', values_match => '[a-zа-яё]{4,}' );
    $tvp = $self->filter_tag_value_pairs( $tvp );
    my %snorms_freq = ();
    my @sentences = map { split /(?:\.|\!|\?)(?: |\.|\!|\?)*/,$_->[1] } @$tvp;
    for my $sentence ( @sentences ){
        $snorms_freq{$_}++ for ( split /\s+/, $self->proj->phrase($sentence)->snorm_phr );
    }
    my %rating = ();
    for my $sentence ( @sentences ){
        my $sum = 0;
        $sum += $snorms_freq{$_} for ( split /\s+/, $self->proj->phrase($self->proj->phrase($sentence)->pack_phr)->snorm_phr );
        $rating{$sentence} = $sum;
    }
    @sorted = sort { $rating{$b}<=>$rating{$a} } keys %rating;
    print "$_ => ".$rating{$_}."\n" for @sorted;
}

# TODO
# убрать глаголы
# повысить вес существительных
# при подсчете метрики делить на количество слагаемых (но не на длину предложения)

# 1. выделяем именные группы, состоящие из существительных, прилагательных и союзов и-или, союзы удаляем, располагаем сущ-прил справа от опорного слова
# 2. парадигматическия матрица (по всему тексту): ab abc, количество_общих_слов/длину_второго_концеата, ab->abc = 2/3, abc->ab = 2/2
# 2.5 здесь надо учитывать сильные связи (через опорное слово) и более слабые (через определители опорного слова), для к-рых ввести понижающий коэффициент
# 3. синтагматическая матрица (по каждому предложению): концепт А, концепт Б. А=>Б: Берем количество предложений, в которое входит А и Б, делим на количество предложений, в которое входит А
# 4. для каждого коцепта перемножаем веса 2 и 3 и составляем рейтинг предложений

1;
