package BM::Pages::PageText;

use std;
use base qw(ObjLib::ProjPart);

use URI;
use URI::_punycode;
use URI::_idna;

use utf8;
use open ':utf8';
use Time::HiRes qw/time/;
use MIME::Base64;
use File::Basename qw(basename dirname);
use File::Copy;

use Encode;
use Encode qw{_utf8_on _utf8_off};

use ObjLib::UserAgent;

use IO::Socket::SSL qw( SSL_VERIFY_NONE );

use Digest::MD5 qw(md5_hex);

use Utils::Sys qw(switch_to_ipv4 switch_to_ipv6 make_good_utf_string get_tempfile transform_v4_ip is_ipv4_host uncompress_web_file);
use Utils::Funcs qw(content_is_text);
use Utils::Urls qw(url_to_domain check_lwp_whitelist is_internal_yandex_url canonical_url);
use Utils::LWP::Override qw(lwp_override_mode :mode);

use Net::INET6Glue::FTP;
use Net::FTP;
use File::Slurp qw(write_file);

#Работа с содержимым страницы


#  text                              Текст страницы, подвергается предварительной обработке
#  tt                                Получение текста урла без обработки
#  tt_post($postdata)                Получение текста страницы с передаванием данных постом

#  pagebase                          Получение базы для урлов со страницы. Меняется редко, но инога может быть изменена в html

#  get_from_text($func)              Выполнить какое-либо действие над текстом страницы в переменной $_ и вернуть результат

#  title                             Получить значение тега title
#  htags                             Получить список тегов <h[1-6]>

#  text_goods_count                  Если на странице упоминалось количество товаров - возвращаем

#  get_all_images                    Получить все урлы картинок со страницы в виде массива
#  get_images                        Получает урлы картинов в виде объекта image_list
#  get_page_image                    Возвращает лучшую из картинов со страницы, которая подходит под условия Директа

#  get_page_phrases_arr              Получение списка фраз со страницы
#  phrase_list                       Объект над списком
#  phrases                           Массив объектов Phrase

#  get_subpages                      Получить все ссылки со страницы
#  _normurl                          Служебная нормализация урла - приведение к абсолютному пути
#  get_internal_domain_regexp        Регулярка для проверки внутренности ссылки
#  get_external_subpages             Получение внешний ссылок
#  get_internal_subpages             Получение внутренних ссылок

#  good_internal_subpages            Отфильтрованные от служебных урлов внутренние ссылки

#  get_freqhash_suburls              Получение частотности подурлов

#  get_deleted_menu_subpages         Подавление меню

#########################################################################
# Скачивание
#########################################################################

__PACKAGE__->mk_accessors(qw(
    forbid_outgoing_redirects
));

our $name_prefilter;

sub load_name_prefilter :GLOBALCACHE {
    my ($self) = @_;

    unless($name_prefilter){
        my $proj = $self->proj;
        if($proj->options->{site_name_prefilter}){
            my @list = $proj->file($proj->options->{site_name_prefilter})->lines;
            s/ =>.*$// for @list; #Удаляем перевод
            $name_prefilter = join '|', grep {/\S/} map { s/^\s+|\s+$//g; $_ } @list; ##no critic
            @list = grep {/\S/} map { s/^\s+|\s+$//g; $_ } @list; ##no critic
            my @beg_end = grep { /^\^.*\$$/ } @list;
            $name_prefilter = join '|', grep {! /^\^.*\$$/} @list;
            s/^\^|\$$//g for @beg_end;
            $name_prefilter .= ($name_prefilter ? '|' : '').'^(?:'.join('|',@beg_end).')$' if @beg_end;
            $name_prefilter = lc($name_prefilter);
            $name_prefilter = qr/$name_prefilter/i;
        }
    }
    return 1;
}

our $urifix;

sub load_urifix :GLOBALCACHE {
    my ($self) = @_;

    unless($urifix){
        $urifix = {};
        my $proj = $self->proj;
        if($proj->options->{site_urifix}){
            my @list = $proj->file($proj->options->{site_urifix})->lines;
            s/ =>.*$// for @list; #Удаляем перевод
            for my $l (@list){
                if( $l =~ /^(\S+)\s+(.+)/){
                    $urifix->{$1} = $2;
                }
            }
        }
    }
    return 1;
}

sub get_name_prefilter_re :GLOBALCACHE {
    my ($self) = @_;
    $self->load_name_prefilter;
    return $name_prefilter;
}

#Директория для кэширования
sub curdir {
    my $self = shift;
    my $domain = $self->domain;
    $domain =~ s/^http\:\/\///;
    my @arr = split /\./, $domain;
    $domain = $arr[-2].'.'.$arr[-1].'/'.$domain if @arr > 2; #Собираем домены 3-го уровня в одной директории
    my $curdir = $self->{opts}{cache_dir}."/$domain/";
    if( $curdir =~ /(.+)\/[^\/]+\//){ #Нужно проверять, есть ли такая категория
        my $sbdir = $1;
        -d $sbdir || mkdir $sbdir;
    }
    -d $curdir || mkdir $curdir;
    return $curdir;
}

our $ua_name = 'Mozilla/5.0 (compatible; YandexDirectDyn/1.0; +http://yandex.com/bots)';
#our $ua_name = 'Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:49.0) Gecko/20100101 Firefox/49.0';
sub ua :GLOBALCACHE {
    my $self = shift;

    #my $ua_opts = { ssl_opts => { verify_hostname => 0, SSL_verify_mode => SSL_VERIFY_NONE, } };
    my $ua_opts = { ssl_opts => { verify_hostname => 0, SSL_verify_mode => IO::Socket::SSL::SSL_VERIFY_NONE, } };
    $ua_opts->{agent} = $ua_name;

    my $ua = ObjLib::UserAgent->new(%$ua_opts);
    $ua->init;
    return $ua;
}

sub ua_coro :GLOBALCACHE {
    my $self = shift;

    my $ua_opts = { ssl_opts => { verify_hostname => 0, SSL_verify_mode => SSL_VERIFY_NONE, }, agent => 'Coro', };
    $ua_opts->{agent} = $ua_name;

    my $ua = ObjLib::UserAgent->new(%$ua_opts);
    $ua->init;
    return $ua;
}

sub redir_location :FILECACHE(3600*24*7) {
    my $self = shift;
    if ( ! exists $self->{location} ) {
        # вызываем метод с кэшированием, чтобы иметь возможность взять location из файла
        $self->text;
    }
    my $location = $self->{location};
    return $location;
}

#таймаут на общее время скачивания
sub _get_hard_timeout {
    my ($self) = @_;
    my $timeout = 60;
    if(defined $self->{timeout}) {
        $timeout = $self->{timeout};
    } elsif($self->site) {
        my $site_timeout = $self->site->timeout;
        if ( defined $site_timeout ) {
            $timeout = $site_timeout;
        }
    }
    return $timeout;
}

#таймаут на активность в сокете
sub _get_ua_timeout {
    my ($self) = @_;
    my $timeout = 300;
    my $hard_timeout = $self->_get_hard_timeout;
    if ( $hard_timeout < $timeout ) {
        $timeout = $hard_timeout;
    }
    return $timeout;
}

sub result_file {
    my ($self, $file) = @_;
    $self->{result_file} = $file;
    $self->{'no_cache'} = 1; #Отключаем кэширование, так как оно идёт через возвращаемый текст
}

sub clean_url :CACHE {
    my $self = shift;
    my $url = $self->url;
    $url =~ s/[\r\n\x00]//g; #Удаляем специальные символы из урла
    return $url;
}

sub refresh_expired_pagecache {
    my $self = shift;
    local $self->{no_cache} = 0;
    local $self->{dont_read_from_filecache} = 0;
    if (!$self->has_cached_page) {
        $self->text;
        return 1;
    }
    return 0;
}

sub prepare_zora_request_hashref {
    my $self = shift;
    my $url = $self->clean_url;
    my $request_hashref = { url => $url };
    if ($self->{result_file}) {
        $request_hashref->{result_file} = $self->{result_file};
    }
    if ( exists $self->{login} && exists $self->{pass} ) {
        $request_hashref->{login} = $self->{login} // '';
        $request_hashref->{pass} = $self->{pass} // '';
    }
    return $request_hashref;
}

sub prepare_zora_params {
    my $self = shift;
    my $zora_big_files = $self->{zora_big_files} // '';
    my $zora_params = {
        timeout => $self->_get_hard_timeout,
        no_error => 1,
        light => 1,
        zora_big_files => $zora_big_files,
    };
    return $zora_params;
}

sub save_zora_headers_return_text {
    my ($self, $response) = @_;

    $self->{httpcode} = $response->{httpcode} // undef;
    $self->{location} = $response->{location} // undef;
    if ($response->{download_error} eq "SITE_ERROR") {
        $self->{download_failed} = "Feed's page returned error.";
        $self->{download_failed_ru} = "Страница фида вернула ошибку.";
    } elsif ($response->{download_error} eq "REDIRECT") {
        $self->{download_failed} = "Feed's page returned redirect, please use feed's URL after all redirects.";
        $self->{download_failed_ru} = "Страница фида вернула редирект, пожалуйста используйте URL фида после всех редиректов.";
    } else {
        $self->{download_failed} = '';
    }
    return $response->{content};
}

sub process_response_content {
    my ($self, $text) = @_;
    $text = $self->_invalidate_if_failed($text);
    $text = $self->_postprocess_downloaded_text($text);
    return $text;
}

sub download_zora_text {
    my ($self) = @_;
    my $url = $self->clean_url;
    my $client = ($self->{enable_zora_fast} || ($self->site && $self->site->{enable_zora_fast})) ? $self->proj->zora_fast_client : $self->proj->zora_client;
    my $try = 1;
    my $deadline_reject_count = 0;
    my $text = "";
    while($try < 3) {
        my $t = time;
        $self->log("ttbeg zora try $try: $url");
        my $request_hashref = $self->prepare_zora_request_hashref;
        my $zora_params = $self->prepare_zora_params;
        my $res = $client->multi_get_hashref([ $request_hashref ], $zora_params );

        $text = $self->save_zora_headers_return_text($res->{$url});
        my $download_error = $res->{$url}{download_error} // "";
        $self->log("tt zora try $try: ".(time - $t));
        if ($self->had_server_response || $download_error eq 'FATAL_NORETRY') {
            last;
        }
        if ( $self->{httpcode} == 1031 ) {
            if ( $deadline_reject_count++ < 3 ) {
                $self->log('deadline reject from zora, additional retry '. $deadline_reject_count . ' in 15 seconds');
                sleep 15;
                next;
            }
        }
        $try++;
    }
    if ($try == 3 || !$self->had_server_response ) {
        $self->{download_failed} = "Can't download feed.";
        $self->{download_failed_ru} = "Не удаётся скачать фид.";
    }

    return $text;
}

sub download_text {
    my ($self, $post) = @_;

    my $url = $self->clean_url;

    my $proj = $self->proj;
    #$self->proj->ddst('download_text');

    my $t = time;
    $self->log("ttbeg $url") if !$self->{do_not_log};

    # ловим баг с ARRAY
    if($url =~ /ARRAY\(\d/) {
        $proj->ddst("BAD_URL '$url'");
    }

    my $ua;
    if($self->{opts}{user_agent}){ #Если указаны специфические опции
        my $ua_opts = $self->{opts}{user_agent} || { ssl_opts => { verify_hostname => 0, SSL_verify_mode => SSL_VERIFY_NONE, } };
        $ua_opts->{agent} ||= $ua_name;

        my @coro = $self->{coro} ? ( agent => 'Coro' ) : (); #Использовать ли корутины
        $ua = ObjLib::UserAgent->new(%$ua_opts, @coro);
    }elsif($self->{coro}){
        $ua = $self->ua_coro;
    }else{
        $ua = $self->ua;
    }
    #$ua->cookie_jar( {} );
    if($self->curdir){ #Если указана категория для кэширования
        require HTTP::Cookies;
        $ua->cookie_jar(HTTP::Cookies->new(file => $self->curdir."/cookies", Autosave => 1));
    }

    if ($post) {
        #при пост-запросе ставим таймаут на активность в сокете, равный общему, чтобы не отвалиться при отсутствии активности на сокете
        #нужно для экспорта в контент-систему движка
        $ua->timeout( $self->_get_hard_timeout );
    }
    else {
        #при гет-запросе ставим стандартный таймаут на активность в сокете, чтобы, если нет активности при скачивании, сразу отвалиться
        $ua->timeout( $self->_get_ua_timeout );
    }
    #таймаут на общее время скачивания, чтобы не зависали долгие урлы
    my $hard_timeout = $self->_get_hard_timeout;
    eval { $ua->hard_timeout($hard_timeout) } if $hard_timeout;

    my $text = $self->_get_url_text_safely($ua, $post);
    $text //= ''; #Иногда бывает undef, а length в этом случае тоже возвращает undef
    if(length($text) < 1000){ #Если страница очень маленькая
        my $tcnt = 3;
        #Если стоит автоматическое обновление страницы
        #Некоторые сайты зачем-то иногда отдают обновляемую страницу вместо реальной
        while(($tcnt > 0)&&( $text =~ /\<META HTTP-EQUIV="Refresh" CONTENT="\d(?:\.\d+)?"\>/ )){
            $tcnt--;
            $self->log(" WARN: The Refresh page text was reloaded.");
            sleep(1);
            $text = $self->_get_url_text_safely($ua, $post);
        }
    }

    #$self->proj->ddst("tt: ".(time - $t)." $url\n");
    $self->log("tt ".(time - $t)) if !$self->{do_not_log};
    return $text;
}

#Настройка, исправляющая проблему с LWP  "500 Header line too long"
#Один из проблемных сайтов homeme.ru
sub _fix_lwp_header_problem :GLOBALCACHE {
    my ($self) = @_;
    push(@LWP::Protocol::http::EXTRA_SOCK_OPTS, MaxLineLength => 16*1024);
    push(@LWP::Protocol::http::EXTRA_SOCK_OPTS, MaxHeaderLines => 4*1024);
    return 1;
}

# todo: replace with Test::LWP::UserAgent or something similar
sub _mock_request {
    my $self = shift;
    my $mock_requests = shift;
    my $url = shift;

    return undef unless $mock_requests && $url;

    for my $mock_pair (@$mock_requests) {
        my ($url_re, $response) = @$mock_pair;
        if ($url =~ m{$url_re}) {
            $self->proj->log("Request to '$url' mocked") if defined $response;
            return $response;
        }
    }

    return undef;
}

sub _process_result_file {
    my ($self, $resp, $file, $result_file) = @_;
    $self->{result_file_raw_size} = -s $file;
    uncompress_web_file($file, $file, $resp->content_encoding);
    if ( content_is_text($resp->content_type) ) {
        my $content_charset = $resp->content_type_charset;
        my @charset_candicates = $self->proj->detect_charset->detect_file_charset_candidates($file, $resp->content_type);
        unshift( @charset_candicates, $content_charset ) if $content_charset;
        $self->proj->detect_charset->file_charsets2utf8($file, $result_file, \@charset_candicates);
    }
    else {
        File::Copy::move($file, $result_file);
    }
}

sub _get_ua_resp {
    my ($self, $ua, $post, $override_mode) = @_;
    my $raw_url = $self->clean_url;
    my $resp;

    $self->_fix_lwp_header_problem;
    eval {
    	lwp_override_mode($override_mode);
    	#временное изменение настройки блокирования внешних редиректов
    	if (defined $self->forbid_outgoing_redirects) {
        	local $ua->{forbid_outgoing_redirects} = $self->forbid_outgoing_redirects;
    	}
    	my $params = $self->proj->options->{UserAgent_params};
    	my $mock_get_requests = $params->{mock_get_requests};
    	my $mock_post_requests = $params->{mock_post_requests};

    	my $additional_headers = $self->{additional_headers} // {};

    	my $url = $raw_url;

    	if ($self->{login}) {
        	$resp = $self->_mock_request($mock_get_requests, $raw_url) if defined $mock_get_requests;
        	unless (defined $resp) {
            	my $req = HTTP::Request->new( GET => $url, [ %$additional_headers ] );
            	$req->authorization_basic($self->{login}, $self->{pass});
            	if ($self->{result_file}) { # Пишем результат в файл
                    my $result_file_raw = get_tempfile('result_file_raw', UNLINK => 1);
                	$resp = $ua->request($req, $result_file_raw);
                    $self->_process_result_file($resp, $result_file_raw, $self->{result_file});
                    unlink $result_file_raw;
            	} else {
                	$resp = $ua->request($req);
            	}
        	}
    	} elsif($post) {
        	_utf8_off($post);
        	my @args = ($url, Content => $post, %$additional_headers);
        	$resp = $self->_mock_request($mock_post_requests, $raw_url) // $ua->post(@args);
        	_utf8_on($post);
    	} else {
        	my %params = (%$additional_headers, 'Accept' => '*/*'); # добавляем Accept: */*, например, сайт iherb.com отдает 403 без этого заголовка
            my $result_file_raw;
            if ($self->{result_file}) {
                $result_file_raw = get_tempfile('result_file_raw', UNLINK => 1);
        	    $params{':content_file'} = $result_file_raw; # Пишем результат в файл
            }
        	$resp = $self->_mock_request($mock_get_requests, $raw_url) // $ua->get($url, %params);
            if ($self->{result_file}) {
                $self->_process_result_file($resp, $result_file_raw, $self->{result_file});
                unlink $result_file_raw;
            }
    	}
    };
    my $exception = $@;
    lwp_override_mode(LWP_OVERRIDE_NONE);
    die $exception if $exception;
    return $resp;
}

sub had_server_response {
    my $self = shift;
    return $self->{httpcode} && $self->{httpcode} < 1000; # больше 1000 - внутренняя ошибка зоры
}

sub _get_url_text_ftp {
    my ($self, $url_obj) = @_;
    my $host = $url_obj->host;
    my $port = $url_obj->_port;
    my $path = $url_obj->path;
    if (is_ipv4_host($host)) {
        my $new_host = transform_v4_ip($host);
        $self->log("Will connect to '$new_host' instead of '$host'");
        $host = $new_host;
    }
    $host .= ":$port" if $port;
    my $ftp = Net::FTP->new($host, Debug => 1, Passive => 1);
    unless ($ftp) {
        $self->log("Cannot connect to $host: $@");
        return '';
    }

    my $login = 'anonymous';
    my $pass = "";
    if ($self->{login}) {
        $login = $self->{login};
        $pass = $self->{pass};
    }
    unless ($ftp->login($login, $pass)) {
        $self->log("Cannot login: ".$ftp->message);
        return '';
    }
    $ftp->binary;

    my $text;
    if ($self->{result_file}) {
        $ftp->get($path, $self->{result_file});
        $text = "";
    } else {
        my $tmp_file = get_tempfile('ftp_content', UNLINK => 1);
        $ftp->get($path, $tmp_file);
        $text = $self->proj->file($tmp_file)->text;
    }
    $ftp->quit;
    return $text;
}

sub _get_url_text {
    my ($self, $ua, $post) = @_;
    my $url = $self->clean_url;
    delete $self->{download_failed};
    my $text;
    my $url_obj = URI->new($url);
    if ($url_obj->scheme eq 'ftp') {
        $text = $self->_get_url_text_ftp($url_obj);
    }
    else {
        my $can_use_lwp = 1;
        if ( $self->{enable_lwp_whitelist} || ( $self->site && $self->site->{enable_lwp_whitelist} ) ) {
            $can_use_lwp = check_lwp_whitelist($url);
        }

        # в режиме вайтлиста (когда заблокирован lwp и выбора нет) пробуем скачать зорой все (есть риск не скачать что-то, что на самом деле внешнее и может скачаться)
        # если lwp можно использовать, то не ходим зорой на яндексовые урлы (такой режим работает, например, для обращений к внутренним апи)
        my $can_use_zora = !$post && ( !$can_use_lwp || !is_internal_yandex_url($url) );

        if ( $can_use_zora ) {
            delete $self->{download_failed};
            $text = $self->download_zora_text;
            if ( !$self->had_server_response ) {
                $self->proj->log("can't download via zora, falling back to lwp: $url");
            }
        }

        if ( $can_use_lwp && ( !$can_use_zora || !$self->had_server_response ) ) {
            delete $self->{download_failed};
            $text = $self->_get_url_text_lwp($ua, $post);
            if ( $can_use_zora && $self->had_server_response ) {
                $self->proj->log("lwp fallback succeeded: $url");
            }
        }
        elsif (!$can_use_lwp) {
            $self->proj->log("lwp forbidden for url: $url");
        }
    }
    return $text;
}

sub _invalidate_if_failed {
    my ($self, $text) = @_;
    if ( $self->{download_failed} ) {
        # инвалидируем все, что скачали, если ошибка
        $text = "";
        if ( $self->{result_file} && -f $self->{result_file} ) {
            truncate $self->{result_file}, 0;
        }
    }
    return $text;
}

sub _get_url_text_lwp {
    my ($self, $ua, $post) = @_;
    my $url = $self->clean_url;
    my $resp = $self->_get_ua_resp($ua, $post, LWP_OVERRIDE_V6);

    my $text;
    if(!$resp->is_success) {
        my $status_line = $resp->status_line;
        #print STDERR Dumper $resp;
        _utf8_on($status_line);
        my $has_network_problems = 0;
        # при скачивании по ipv6 с урлов, в которых явно задан ipv4, могут возникнуть проблемы из-за неверных настроек клиента
        if($status_line =~ /refused|route|отказано|connect to|Нет маршрута до узла|502 Bad Gateway/ || is_ipv4_host($self->proj->page($url)->domain)) {
            $has_network_problems = 1;
            $self->log($status_line . ", trying ipv4");
	        $self->log("Can't switch to IPv4!") if not switch_to_ipv4;
            $resp = $self->_get_ua_resp($ua, $post, LWP_OVERRIDE_V4);
            $self->log("Can't switch to IPv6!") if not switch_to_ipv6;
            unless ($resp->is_success) {
                # Это может быть сервер с включенным dns64, который не отдает ipv4, если есть ipv6
                # При этом ipv6 на сайте клиента настроен неправильно
                # Поэтому получаем ipv4 через dns.yandex.ru
                # Достаточно заменить на ipv4, если нужна замена ipv4 на ipv6, то это происходит внутри метода _get_ua_resp
                $self->log("trying force ipv4");
                $resp = $self->_get_ua_resp($ua, $post, LWP_OVERRIDE_V4TOV6);
            }
        }
        elsif ($status_line =~ /400 Bad Request/) { # && $resp->_content =~ /Cookie Too Large/) {
            # превысили максимальный размер cookie, установленный на сайте
            # мувим cookie в cookie_old (вдруг понадобится?...)
            #### не смотрим на content, так как сообщения могут быть разными
            $self->log('cookies too large, removing');
            $self->proj->do_sys_cmd('mv '.$self->curdir.'/cookies '.$self->curdir.'/cookies_old');
            $ua->cookie_jar(undef);
            # еще попытка
            $resp = $self->_get_ua_resp($ua, $post, LWP_OVERRIDE_V6);
        }

        if(!$resp->is_success) {
            my $status_line = $resp->status_line;
            _utf8_on($status_line);
            $self->log("can't download url '".$url."': ".$status_line);
            $self->{download_failed} = "Feed's page returns error '".$status_line."'.";
            $self->{download_failed_ru} = "Страница фида возвращает ошибку '".$status_line."'.";
            $self->{error_text} = $resp->content;
            return "";
        }
    }

    # костыль для beget
    if($resp->decoded_content && (length($resp->decoded_content) < 1000) && $resp->decoded_content =~ /beget=begetok/) {
        $self->log("trying beget cookie");

        my $jar = HTTP::Cookies->new;
        $jar->set_cookie(0, "beget", "begetok", "/", $self->domain);
        $ua->cookie_jar($jar);
        $resp = $self->_get_ua_resp($ua, $post, LWP_OVERRIDE_V6);

        if(!$resp->is_success) {
            $self->log("beget cookie workaround failed!");
            return "";
        }
    }

    if ($self->{assert_content_length} && $resp->header('Content-Length')) {
        # проверяем, совпадает ли длина ответа с длиной, заявленной в заголовке (если он есть)
        # если не совпадает, то мы подозреваем, что что-то недокачали

        my $expected_length = int($resp->header('Content-Length'));
        my $actual_length = $self->{result_file} ? ($self->{result_file_raw_size}) : length($resp->content());

        if ($expected_length == $actual_length) {
            $self->log("Content-Length check for url '$url': ok, $expected_length bytes");
        } else {
            $self->log("Content-Length check for url '$url': mismatch, expected $expected_length, got $actual_length");
            $self->{download_failed} = "Content-Length mismatch";
        }
    }

    $self->{httpcode} = $resp->code;

    my $location;
    $location = $resp->previous->header('location') if $resp->previous;
    $self->{location} = $location;
    $text = $resp->decoded_content;
    if( (! $text) || $self->{fix_page_charset} ){
        $text = $resp->content;
        $text = $self->proj->detect_charset->text2utf8($text);
    }
    $text = '' unless $text;

    return $text;
}

#Не падаем, если страницу не удалось скачать
sub _get_url_text_safely {
    my $self = shift;
    my $text = '';
    eval {
        $text = $self->_get_url_text(@_);
    };
    if($@){
        my $msg = $@;
        die $msg if $msg =~ /do_safely alarm/; # если таймаут, то вызываем повторно
        $msg =~ s/ERROR/WARN/g;  # т.к. мы не падаем, то и не хотим собирать ERROR-ы в логах   https://a.yandex-team.ru/commit/2607048
        $self->log("Can't download url $_[0] => $msg");
    }
    return $text;
}

sub _get_cache_filename :CACHE {
    my $self = shift;
    my $url = $self->clean_url;
    $url = canonical_url($url);
    my $url_bytes = Encode::encode('UTF-8', $url);
    my $md5 = md5_hex($url_bytes);
    my $curdir = $self->curdir."texts/";
    -d $curdir || mkdir $curdir;
    my $filename = $curdir."page_$md5";
    print "page filename: $filename\n" if $self->{dbg};
    return $filename;
}

sub has_cached_page {
    my ($self) = @_;
    unless($self->{'no_cache'} || $self->{dont_read_from_filecache}){
        my $filename = $self->_get_cache_filename;
        if( -e "$filename" ){
            my $timeout = $self->proj->{download_page_timeout} // (3600 * 24 * 2);
            my $file_age = time - (stat $filename)[9];
            if( $file_age < $timeout ){

                if ( $file_age >= 3600 * 18 ) {
                    # если страница в кэше пустая, то возвращаем ее, если прошло
                    # не больше 18 часов; это сделано, чтобы не слишком часто
                    # запрашивать плохие страницы и не слишком долго их хранить

                    #если в файле меньше 3 строк, то кэш пустой
                    open(F, "< $filename") or warn "pf: $!";
                    my $line_count = 0;
                    while( my $line = <F>) {
                        $line_count++;
                        last if $line_count > 2;
                    }
                    close(F);
                    # файл пустой и лежит больше положенного для пустых файлов времени
                    return 0 if $line_count < 3;
                }
                #файл есть и не устарел
                return 1;
            }
        }
    }
    #или кэш отключен, или файл устарел, или его нет вообще
    return 0;
}

sub _read_from_pagecache {
    my ($self) = @_;
    my $url = $self->clean_url;
    if ( $self->has_cached_page ) {
        my $filename = $self->_get_cache_filename;
        no warnings "utf8";
        open(F, "< $filename") or warn "pf: $!";
        #binmode(F);
        my @a = <F>;
        close(F);
        $self->{location} = $1 if $a[1] && $a[1] =~ /^location:(.+)\n$/; #Заполняем данные о том, был ли редирект

        #отрезаем служебные строки
        splice(@a,0,2);
        return join("", @a);
    }
    return undef;
}

sub write_to_pagecache {
    my ($self, $text) = @_;
    my $url = $self->clean_url;
    unless($self->{'no_cache'}){
        my $filename = $self->_get_cache_filename;
        # $filename в директории $curdir, она уже создана
        my $tmp_file = $self->get_tempfile(basename($filename), DIR => dirname($filename), UNLINK => 1);
        if( open(F, '>', $tmp_file )){
            #binmode(F);
            no warnings "utf8";
            print F "$url\n";
            print F "location:".($self->{location}||'')."\n"; #Сохраняем данные о редиректе
            print F $text;
            close(F);
            rename($tmp_file, $filename); #Решаем проблему недописанных файлов
        }else{
            warn "pf svd: $!";
        }
    }
}

sub _postprocess_downloaded_text {
    my ($self, $text) = @_;

    $text = make_good_utf_string($text);

    #Часть контента викимарта спрятана под js
    if((! $self->{'no_dynamics_js'} )&&( $text =~ /src="(http:\/\/[^"]+\/js_dynamics2\/([^"><]+\.js))"/ )){
        my $jj = $self->page($1, $2);
        $jj->{'no_dynamics_js'} = 1; #защита от зацикливания
        my $jtext = $jj->text;
        $jtext =~ s/\s+/ /g;
        if( $jtext =~ /seoContent = \{([^\}]+)\}/){
            my $data = [ map {[ split ':', $_]} split ',', $1 ];
            $_->[1] = $self->proj->detect_charset->text2utf8( decode_base64($_->[1]) ) for @$data;
            $_->[1] =~ s/href\s+=\s+"http/href="http/g for @$data;
            $text .= "\n<== js_dynamics2 ==>\n".join(' ', map {$_->[1]} @$data);
        }

    }

    #JSON
    if($text =~ /^\s*\{/){
        use JSON::XS;
        my $json = JSON::XS->new;
        $json->utf8(0);  # оставляем Unicode
        $json->indent(0);
        eval {
            my $data = $json->decode($text);
            $text = Dumper( $json->decode($text) );
            if(ref($data) eq 'HASH'){
                for my $kk (keys %$data){
                    $text .= '<a href="'.$data->{$kk}.'">'.$kk.'</a>' if $data->{$kk} =~ /^(http:\/\/\S+|\/[-A-Za-z0-9]+[\/\?]\S*)$/;
                }
            }
        }
    }
    return $text;
}

sub _url2text {
    my ($self, $post, $smpl) = @_;
    #$post  #Опционально можно отправить POST-запрос  !!! не тестировался
    #$smpl  #Опционально, сразу вернуть полученный текст без постпроцессинга и кэширования

    my $url = $self->clean_url;
    if ($ENV{BM_DISABLE_EXTERNAL_INTERNET} and !is_internal_yandex_url($url)) {
        $self->proj->log("DISABLE_EXTERNAL_INTERNET for url : '$url'");
        return "";
    }
    if ( !$url or length($url) > 4096 ) {
        return '';
    }
    my $text;
    $text = $self->_read_from_pagecache unless $smpl;
    return $text if defined $text;

    $text = '';

    print "dnld:$url\n" if $self->{dbg};
    $text = $self->download_text($post);
    $text = $self->_invalidate_if_failed($text);
    return $text if $smpl;

    $text = $self->process_response_content($text);

    $self->write_to_pagecache($text);

    return $text;
}

sub _get_proxies {
    my ($self) = @_;

    my $ua = ObjLib::UserAgent->new(agent => $ua_name);
    my $resp = $ua->get("http://proxylist.hidemyass.com/search#listable");
    my $text;

    if($resp->is_success) {
        $text = $resp->decoded_content;
    } else {
        $self->log("ERROR in _get_proxies: ".$resp->status_line);
        return ();
    }

    my @result;
    $text = join " ", split("\n", $text);

    my @trs = $text =~ /<tr class="" [^>]+>(.+?)<\/tr/g;
    for my $tr (@trs) {
        next if $tr !~ /High/;
        my @tds = $tr =~ /<td>(.+?)<\/td/g;
        my $port = $tds[1];
        $port =~ s/ //g;
        my ($style, $spans) = $tds[0] =~ /<style>(.+?)<\/style>(.+)/;

        my @styles = $style =~ /\.([^{]+)\{([^\}]+)/g;
        my %good;
        my %bad;
        for (my $i = 0; $i < @styles; $i += 2) {
            $good{$styles[$i]}++ if $styles[$i + 1] !~ /none/;
            $bad{$styles[$i]}++ if $styles[$i + 1] =~ /none/;
        }
        my $re_good = "(".join("|", keys %good).")";
        my $re_bad = "(".join("|", "none", keys %bad).")";

        my ($ip) = $spans =~ /^([^<]*)/;
        my @tags = $spans =~ /<(div|span)([^>]*)>([^<]*)<[^>]+>([^<]*)/g;
        for (my $i = 0; $i < @tags; $i += 4) {
            my ($tag, $class, $data, $add) = @tags[$i..($i+3)];
            my $is_good = (!$class || $class =~ /inline/ || $class !~ /$re_bad/);
            $ip .= $data if $is_good;
            $ip .= $add;
        }

        push @result, "http://$ip:$port" if $ip !~ /^\./;
    }

    return @result;
}

sub _link_text_clnr {
    my ($self, $atxt, $a_title) = @_;
    $atxt //= '';
    $a_title //= '';
    $atxt =~ s/\<(style|script)[^>]+[^\/]>.+?<\/(style|script)>/ /g;
    $atxt =~ s/\s+/ /g;
    $atxt =~ s/\&nbsp;/ /g;
    $atxt =~ s/\&quot;/"/g;
    $atxt =~ s/код товара\:?//gi;

    # для traektoria.ru (DYNSMART-311)
    # если накопится много костылей, то нужно завести отдельный словарь или изменить алгоритм
    $atxt =~ s/добавить в избранное//gi;
    $atxt =~ s/выберите цвет и размер//gi;
    $atxt =~ s/\-?\d{1,2}\%//gi;

    
    $a_title =~ s/^(?:(?:описание|цены на)[, ]+)+//i;

    # если внутри текста ссылки есть разметка, пытаемся выделить заголовки
    my ($header) = $atxt =~ /\<h\d\>([^<]+)\<\/h\d\>/;
    $atxt = $header if $header;

    # если тайтл встречается внутри тэга, то берём его
    if($a_title && index($atxt, ">$a_title<") > -1) {
        $atxt = $a_title;
    }

    my $t1 = $atxt;
    $t1 =~ s/\<.+?\>/ /g; #удаляем тэги
    # Если текст плохой, то зануляем, чтобы он дальше попытался выпарсится из картинки.
    $t1 = '' if $self->proj->page('')->check_badre_text($t1);

    if($t1 !~ /\S/){ #eсли после удаления тегов ничего не осталось
        if($a_title) {
            $t1 = $a_title;
        } elsif($atxt =~ /<img [^>]*title=(['"])(.*?)\1/){ #пробуем взять описание от картинки
            my $t2 = $2;
            if( $t2 =~ /\S/ ){
                $t1 = $t2;
            }
        } elsif($atxt =~ /<img [^>]*alt=(['"])(.*?)\1/){ #пробуем взять описание от картинки
            my $t2 = $2;
            if( $t2 =~ /\S/ ){
                $t1 = $t2;
            }
        }
    }

    #В тайтле более подробное описание
    my $ltht1 = length($t1);
    if($ltht1 < length($a_title)){
        #print Dumper(['_link_text_clnr', $t1, $a_title, substr($a_title, 0, $ltht1), substr($a_title, -$ltht1, $ltht1)]);
        if((substr($a_title, 0, $ltht1) eq $t1)||(substr($a_title, -$ltht1, $ltht1) eq $t1)){ #Если префикс или постфикс совпадает с текстом ссылки, берём более длинный вариант
            $t1 = $a_title;
        }
    }
    #print Dumper(['_link_text_clnr', $atxt, $a_title, $t1]) if $a_title;

    #Возможна ситуация, когда в значениях атрибутов встречалась закрывающая угловая скобка
    #Удаляем префикс, который может из-за этого получиться
    if($t1 =~ /\>/){
        $t1 =~ s/^[^"]*"(?:\s+[-_A-Za-z0-9]+=(?:"[^"]+"|'[^']+'|[^'" \n\t\r]+))*\s*\>//;
    }

    $t1 =~ s/^\s+|\s+$//g;
    return $t1;
}

sub _text2imgs {
    my $self = shift;
    my $text = shift;
    $text =~ s/\s+/ /g;
    $text =~ s/\<script[ >].*?<\/script>//ig;
    $text =~ s/\<style[ >].*?<\/style>//igs;
    $text =~ s/\<div class="subnav.*?\<\/div\>//ig;

    #для тэга <a>
    my @arr = ();
    for my $ltxt ($text =~ /<img[^>]* (?:data[-_])?(?:[a-z0-9]+="[^"]+")?src=[^\>]+\>/igms){
        #print "FF: $ltxt\n";
	if( $ltxt =~ /src=(['"])?([^\>'"]+?)\1/im ){
            #print "FGG:$2\n";
            my $aurl = $2;
            push(@arr, [$aurl, '']);
        }
    }

    for my $ltxt ($text =~ /url\(.*?\)/igm){
        next unless $ltxt =~ /jpg|jpeg|png|gif/i;
        #print "FF: $ltxt\n";
	if( $ltxt =~ /\((.+)\)/im ){
            my $aurl = $1;
            push(@arr, [$aurl, '']);
        }
    }

    #json
=h
$text =~ s/>/>\n/g;
print "$text\n============================\n";
    for my $ltxt ($text =~ /:\s*['"]http.*?['"]/igm){
print "RRR: $ltxt\n";
        next unless $ltxt =~ /jpg|jpeg|png|gif/i;
        #print "FF: $ltxt\n";
	if( $ltxt =~ /['"](.+)['"]/im ){
            my $aurl = $1;
            push(@arr, [$aurl, '']);
        }
    }
=cut

    #$text =~ s/>/>\n/g;
    #print "$text\n============================\n";
    for my $ltxt ($text =~ /<link rel="apple-touch-icon" href="(.*?)"/igm){
        #print "RRR: $ltxt\n";
        next unless $ltxt =~ /jpg|jpeg|png|gif/i;
        #print "FF: $ltxt\n";
	#if( $ltxt =~ /href=['"](.+)['"]/im ){
            my $aurl = $ltxt;
            push(@arr, [$aurl, 'apple-touch-icon']);
        #}
    }

    #print "DDD\n";
    #my $ttt = $text;
    #$ttt =~ s/\>/>\n/g;
    #print $ttt;
    for my $ltxt ($text =~ /<a[^>]* href=[^\>]+/igms){
        next unless $ltxt =~ /jpg|jpeg|png|gif/i;
        #print "FF: $ltxt\n";
	if( $ltxt =~ /href=(['"])?([^\>'"]+?)\1/im ){
            #print "FGG2:$2\n";
            my $aurl = $2;
            push(@arr, [$aurl, '']);
        }
    }
#print Dumper(\@arr);
#print "\n$text\n";
#exit;

    return @arr;
}

sub _special_url {
    my ($self, $url) = @_;
    #Специальные урлы, которые нужно переработать в нормальные (получены из парсинга форм)
    my $origurl = $self->url;
    $origurl =~ s/\#.*//;
    my $rurl = $url;
    $rurl =~ s/\d+/\\d+/g;
    $origurl =~ s/\&?$rurl//;
    $url = $origurl . ( $origurl =~ /\?/ ? '&'.$url : "?$url" );
    return $url;
}

sub _text2rfrs :CACHE {
    my $self = shift;
    my $text = $self->text;
    $text =~ s/\s+/\ /g;
    $text =~ s/\<script[ >].*?<\/script>//igs;
    $text =~ s/\<style[ >].*?<\/style>//igs;
    $text =~ s/\<\!\-\-.*?\-\-\>//sg;
#    my @arr = map { /href=([^\>]+)\>(.*?)<\/a>/m; [$1,$2] } $text =~ /href=[^\>]+\>[^\<]*/g;

    my @arr = ();

    # костыль для topbrands (листалка сделана через <a data-page>), должен подойти и для mediamarkt
    for my $ltxt ($text =~ /<a [^>]*data-page="\d+"/igm){
        if($ltxt =~ /^<a [^>]*data-page="(\d+)"/){
            push(@arr, [ $self->_special_url('page='.$1), $1 ]);
        }
    }

    # Skipping links for select sort order in dropdowns
    $text =~ s/<a [^>]*sort-dropdown.*?<\/a>//ig;

    # костыль для озона -- убираем ссылку "товар дня"
    $text =~ s/<td class="eExtSubMen_DayItemTD">(.+?)<\/td>/ /ig;

    # костыль для озона -- убираем рекомендуемые товары
    $text =~ s/<a class="eShelfTile(.+?)<\/a>/ /ig;

    # вырезаем кнопки, потому что в них могут быть слова вроде Купить, В корзину (http://kyocera-mita.spb.ru/)
    $text =~ s/<button(.+?)<\/button>/ /ig;

    # костыль для Маркета, так как у них данные в ява-скрипте
=h
    my @arr_market = ();
    if($text =~ /(mvc\.map\("model-list",\s*\[\[([^\]]+)\]\s*,\s*\[([^\]]+)\]\])/){
        my $fields = $2;
        my $models = $3;
        my @flds = $fields =~ /"([^"]+)"(?:,|$)/g;
        my @mdls = $models =~ /("[^"]*"|\d+)(?:,|$)/g;
        s/^"|"$//g for @mdls;
        s/\\(.)/$1/g for @mdls;
        my @mdlpages = ();
        while( my @arr = splice( @mdls, 0, @flds+1 ) ){
            my %h = ();
            my $id = shift @arr;
            @h{@flds} = @arr;
            push(@arr_market, ["http://market.yandex.ru/model?modelid=".$id, $h{title}]);
        }
    }
=cut

    #для тэга <area>
    my @arr_area = map { $_->[1] =~ /\ (alt|title)=(["'])(.+?)\2/i; [$_->[0], $3] } map { /href=['"]?((?:[^\>](?=[^'"]))+)[^\>]*\>/im; [$1, $_] } $text =~ /<area[^\>]+>/igm;
    $_->[1] = $self->_link_text_clnr($_->[1]) for @arr_area;

    #для тэга <a>
    my $prev_img_alt = '';
    for my $ltxt ($text =~ /<a [^>]*(?<= )href\s*=\s*[^\>]+\>.*?(?:<\/a>|(?=<a ))|<img [^\>]*alt=(?:"[^"]+"|'[^']+')/igm){
        #print "ltxt:[[ $ltxt ]]\n";
        if($ltxt =~ /^<img /){ #Дополнительная обработка картинок, в них могут быть правильные описания моделей
            if( $ltxt =~ /\ alt=['"]([^'"]+)['"]/ ){
                $prev_img_alt = $1;
            }
            next;
        }
        next if $ltxt =~ /related_category_id=/i;
        $ltxt =~ s/ style="[^"]+"/ /g; #В стилях могут встречаться угловые скобки
        $ltxt =~ s/ [-_A-Za-z0-9]+?="[^"]*?\>[^"]*?"/ /g; #Удаляем атрибуты с угловыми скобками
        #print "ltxt: $ltxt\n" if $ltxt =~ 30017912;

        my ($aurl, $atxt);
        if(      $ltxt =~ / href\s*=\s*('[^']*')[^\>]*?\>(.*?)<\/a>/im ){
            ($aurl, $atxt) = ($1, $2);
            #$aurl =~ s/'//;
        } elsif( $ltxt =~ / href\s*=\s*("[^"]*")[^\>]*?\>(.*?)<\/a>/im ){
            ($aurl, $atxt) = ($1, $2);
            #$aurl =~ s/"//;
        } elsif( $ltxt =~ / href\s*=\s*([^ \>]+)[^\>]*\>(.*?)<\/a>/im ){
            ($aurl, $atxt) = ($1, $2);
        } elsif ( $ltxt =~ / href\s*=\s*([^ \>]+)[^\>]*\>(.*)/im ) {
            ($aurl, $atxt) = ($1, $2);
        }

        if ($aurl) {
            my $a_title = "";
            if( $ltxt =~ /<a [^>]*(?:title|data-name|data-gtm-name)=(["'])([^\>]+?)\1/i ){ #Пытаемся взять поле title из ссылки
                $a_title = $2;
                #print Dumper(['testeeeee', $aurl, $atxt, $a_title, $self->_link_text_clnr($atxt, $a_title)]);
            }
            #print Dumper(['testeeeee', $aurl, $atxt, $a_title, $prev_img_alt, $self->_link_text_clnr($atxt, $a_title)]);
            #print Dumper(['atxt', $atxt]);

            $atxt = $self->_link_text_clnr($atxt, $a_title);

            if( $prev_img_alt && $ltxt =~ /class="(?:detail|area-link)"/ ){
                $atxt = "$prev_img_alt ".($atxt || $a_title);
            }

            #print Dumper(['atxt res', $atxt]);
            push(@arr, [$aurl, $atxt]);
        }
    }

    #для тэга <div>
    #my @arr_div = ();
    for my $ltxt ($text =~ /(<div [^>]*onclick="[^"]+location.href='(?:[^'">]+)'"[^>]*\>(?:.*?)<\/div>)/igm){
        $ltxt =~ /<div [^>]*onclick="[^"]+location.href='([^'">]+)'"[^>]*\>(.*?)<\/div>/igm;
        my $aurl = $1;
        my $atxt = $2;
        $atxt = $self->_link_text_clnr($atxt);
        push(@arr, [$aurl, $atxt]);
    }

    #Специальная обработка тегов Link rel=next и rel=prev
    #<link rel="next" href="http://www.n11.com/kadin-abiye-C1243/ara?page=2"/>
    for my $ltxt ($text =~ /(<link[^>]+rel=["']?(?:next|prev)["']?[^>]+)/igm){
	if( $ltxt =~ /href=((['"])([^\>]+)\2|[^'"\> ]+)/im ){
            my $aurl = $1;
            my $atxt = '_pagerurl_';
            push(@arr, [$aurl, $atxt]);
        }
    }

    #Специальная обработка тегов Link rel=next и rel=prev
    #<link rel="next" href="http://www.n11.com/kadin-abiye-C1243/ara?page=2"/>
    for my $ltxt ($text =~ /(<link[^>]+rel=["']?(?:alternate)["']?[^>]+)/igm){
	if( $ltxt =~ /href=((['"])([^\>]+)\2|[^'"\> ]+)/im ){
            my $aurl = $1;
            my $lang = 'unkn';
            if( $ltxt =~ /hreflang=((['"])([^\>]+)\2|[^'"\> ]+)/im ){
                $lang = $1;
                $lang =~ s/['"]//g;
            }
            my $atxt = '_alternateurl_'.$lang;
            push(@arr, [$aurl, $atxt]);
        }
    }

    # ссылки в тэгах <option> (пример: fawhowo.ru)
    my @arr_option = $text =~ /<option\s+value=["'](https?:\/\/[^"']+)["']\s*>([^<]+)/ig;
    push @arr, [$arr_option[$_ * 2], $arr_option[$_ * 2 + 1]] for 0..(scalar(@arr_option) / 2 - 1);

    @arr = (@arr, @arr_area);
#    $_->[1] =~ s/\<.+?\>/ /g for @arr;
#    $_->[1] =~ s/^\s+|\s+$//g for @arr;

    #Специальный фикс, когда нет текстов, но по тексту урла можно понять раздел
    #print STDERR Dumper([ grep { $_->[1] !~ /\S/ } @arr ]);
    for my $elem (@arr) {
        $elem->[0] //= '';
        $elem->[1] //= '';
    }
    my @empty = grep { $_->[1] !~ /\S/ } @arr;
    if(@empty){
        $self->load_urifix;
        for my $el ( @empty ){
            #print STDERR Dumper(['empty', $el]);
            if( $el->[0] =~ /(?:^|\/|")([^\/"]+?)\/?"?$/){
                my $fr = $1;
                if($urifix->{$fr}){
                    $el->[1] = $urifix->{$fr};
                }else{
                    if(0){ #всегда ходить дорого, отладочная печать для site_urifix
                        #$el->[1] = 'badtext';
                        my $nurl = $self->_normurl($el->[0]);
                        my $ptext = $self->proj->page($nurl)->text;
                        my $title = '';
                        $title = $1 if $ptext =~ /<title>(.*?)<\/title>/;
                        $title =~ s/\|.+//;
                        my $t = $fr."   ".$title;
                        #$t =~ s/^\S+\///;
                        #$t =~ s/\|.+//;
                        print STDERR "ttt: $t\n";
                    }
                }
                #print STDERR Dumper(['el', $el->[0], $1, $urifix->{$1} ]);
            }
        }
    }

    # чистка заголовков
    $_->[1] =~ s/\s*(\&\w+;)\s*/ /g for @arr;
    $_->[0] =~ s/^['"]?\s+|\s+['"]?$//g for @arr;
    $_->[0] =~ s/ /%20/g for @arr;

    @arr = grep { $_->[1] =~ /\S/ } @arr;
    return @arr;
}

# текст одной строкой (без \n)
sub one_line_text :CACHE {
    my ($self) = @_;
    my $text = join " ", split("\n", $self->text);

    return $text;
}

#########################################################################
# Методы для работы с содержимым страницы
#########################################################################

#База страницы, может меняться в html
sub pagebase :CACHE {
    my ($self) = shift;
    #<base href="http://www.nano-sport.ru/"/>
    return $2 if $self->text =~ /<base\s+href=(["'])([^<>]+)\1/;
    my $pb = $self->domain_dir;
    $pb .= '/' unless $pb =~ /\/$/; #Не добавляем повторный слэш
    return $pb;
}

#Выполнить обработку текста и вернуть результат
sub get_from_text {
    my ($self, $f) = @_;
#    $_ = $self->tt;
    $_ = $self->text;
    return $f->();
}


#Разделение текста на логические кускки
#Выделяет из текста мусорные фрагменты
sub divide_good_and_bad_text {
    my ($self) = @_;
    my $text = $self->text;
    my $bad_text = '';
    my $ttl = length($text);
    my $fltr = 'Товар дня|Акции и спецпредложения';
    #my $fltr = 'Акции и спецпредложения|Товар дня';
    while($text=~s/(<(?<tg1>div|span|a)[^>]*>\s*(?<name>$fltr)\s*:?\s*<\/\k<tg1>>([^<>]*+<(?<tg2>div|span|ul)[^>]*+>((?4)|[^<>]*+|<\/?(?!div|span|ul)[^>]*+>)*<\/\k<tg2>>)*)/ /i){
        my $tt = $1;
        my $crnt = length($tt);
        my $rt = $crnt/$ttl;
        if($rt < 0.1){ #Контролируем, что не должно срезаться слишком много
            $bad_text .= "\n\n=== ".$+{name}." => rt=".$rt." ===\n$tt";
        }
    }
    return ($text, $bad_text);
}

sub bad_text {
    my ($self) = @_;
    my ($good, $bad) = $self->divide_good_and_bad_text;
    return $bad;
}

sub good_text {
    my ($self) = @_;
    my ($good, $bad) = $self->divide_good_and_bad_text;
    return $good;
}

sub title :CACHE {
    my ($self) = @_;
    my $text = $self->text;
    return $1 if $text =~ /<title>(.*?)<\/title>/;
    return '';
}

sub htags :CACHE {
    my ($self) = @_;
    my $text = $self->text;
    return $1 if $text =~ /<h[1-6]>(.*?)<\/h[1-6]>/;
    return '';
}


#Количество товаров, написанное на странице
sub text_goods_count {
    my ($self) = @_;
    my $text = $self->text;
    return $1 if $self->text =~ /Найдено (\d+) товар/;
    return $1 if $self->text =~ /Товаров: (\d+)/;
}

#Не кэшируем, так как оно сильно жрёт память на больших массивах урлов
sub text {
    my ($self) = @_;
    return $self->{pagetext} if defined $self->{pagetext};
    my $text = $self->_url2text;
    return $text;
}

#Получение текста урла без обработки
sub tt {
    my ($self) = @_;
    my $text = $self->_url2text(undef, 1);
    return $text;
}

sub tt_post {
    my ($self, $post) = @_;
    my $text = $self->_url2text($post, 1);
    return $text;
}

#########################################################################
# Методы для получения фраз со страницы
#########################################################################

sub get_page_phrases_arr {
    my ($self) = @_;
    my @arr = ();
    my $title = $self->title;
    my $name = $self->name;

    my $rusw = '\b[-А-Яа-я]+\b'; #русское слово
    my $engw = '\b[-A-Za-z]+\b'; #английское слово
    my $mrus = '\b([А-Яа-я][-А-Яа-я]*\d[-А-Яа-я0-9]*|\d+[-А-Яа-я0-9]*[А-Яа-я][-А-Яа-я0-9]*)\b'; #русские буквы и цифры
    my $meng = '\b([A-Za-z][-A-Za-z]*\d[-A-Za-z0-9]*|\d+[-A-Za-z0-9]*[A-Za-z][-A-Za-z0-9]*)\b'; #английские буквы и цифры
    my $mmeng = '\b[-A-Za-z0-9]*[A-Za-z][-A-Za-z0-9]*\b'; #английские буквы с допустимыми цифрами

    if( $title =~ /[A-Za-z]/ && $title =~ /[А-Яа-я]/ ){ #В случае смеси русского и английского текста вытаскиваем английский
        $title =~ s/\&\w+;//g;

        push(@arr, $1) if $title =~ /(($mmeng\s+)+$mmeng)/; #последовательности английских слов
        push(@arr, $1) if $title =~ /(($engw\s+){1}$meng)/;   #английская модель и слово перед ним
        push(@arr, $1) if $title =~ /(($rusw\s+){1}$mrus)/;   #русская модель и слово перед ним
        push(@arr, $1) if $title =~ /(($rusw\s+){1,2}$engw)/;   #русская модель и слово перед ним

    }
    return @arr;
}

sub phrase_list :CACHE {
    my ($self) = @_;
    my @phs = $self->get_page_phrases_arr;
    my $phl = $self->proj->phrase_list({phrases_arr => \@phs});
    return $phl;
}

sub phrases :CACHE {
    my ($self) = @_;
    return $self->phrase_list->phrases;
}


#########################################################################
# Методы для работы с картинками
#########################################################################


sub get_image_info {
    my ($self, $imgurl) = @_;

    return Dumper( $self->proj->image($imgurl)->get_image_info );
}

sub get_all_images { #Получаем все урлы картинок
    my ($self) = @_;
    my @arr = $self->_text2imgs( $self->text );
    $_->[0] = $self->_normurl($_->[0]) for @arr; #Приводим  урлы к классическому виду
    @arr = grep { $_->[0] } @arr; #Выкидываем проблемные урлы
    @arr = map {$_->[0]} @arr;
    return @arr;
}

sub get_images { #Получаем все урлы картинок
    my ($self) = @_;
    my @arr = $self->_text2imgs( $self->text );
    @arr = map {$_->[0]} @arr;
    #print Dumper(\@arr);
    @arr = grep { $_ } @arr; #Выкидываем проблемные урлы
    if($self->site){
        my $flt = $self->site->design_images_hash;
        @arr = grep {! $flt->{$_} } @arr;
    }
    #@arr = $self->_delete_bad_imgs(@arr);
    @arr = map { $self->_normurl($_) } @arr; #Приводим  урлы к классическому виду
    return $self->proj->image_list(\@arr);
}

sub get_frd_images { #Получаем все урлы картинок
    my ($self) = @_;
    my $mn = undef;
    if(! $self->site ){
        my $mp = $self->proj->page( $self->domain );
        my $pgl = $mp->get_internal_subpages->rand_n(20);
        $mn = $mp->get_images;
        $mn += $_->get_images for @$pgl;
    }else{
        $mn = $self->site->get_common_image_list;
    }

#$self->proj->dd($mn);
#$self->proj->dd($self->get_images);
    return $self->get_images - $mn;
}

sub _get_page_image_v04 :FILECACHE(3600*24*7) {
    my ($self) = @_;

    my $res = '';

    if(!$res){
        my $iml = $self->get_frd_images;
        $res = $iml->get_best_image;
    }

    if(!$res){
        my $txt = $self->text;
        #<meta property="og:image" content="http://cdn.e96.ru/assets/images/thumbs/catalog/kitchen_appliance/large/holodilniki/834867/130x105/834867-indesit-df-4160-w_3839705.jpg">
        if($txt =~ /\<meta property="og:image" content="(.*?)"\>/){
            $res = $1;
        }
    }

#    if(!$res){
#        my $pgurls = $self->get_deleted_menu_subpages->get_pager_urls;
#        if($pgurls->count){ #Если есть листалка, то ожидаем, что можно взять картинку первого товара
#            my $s = $self->proj->site($self->url);
#            my $nd = $s->node($self->url);
#            my $gds = $nd->goods;
#            if($gds->count()){
#                $res = $gds->[0]->get_frd_images->get_best_image;
#            }
#        }
#    }
    return $res;
}

sub get_page_image :CACHE {
    my ($self) = @_;
    return $self->_get_page_image_v04;
}

#sub _get_page_logo_v01 :FILECACHE(3600*24*7) {
sub _get_page_logo_v01 {
    my ($self) = @_;

    my $res = '';

    my @iml = $self->_text2imgs($self->text);
    if(!$res){
        for my $im (@iml){
            if($im->[0] =~ /logo/i){
                $res = $im->[0];
                last;
            }
        }
    }

    if(!$res){
        for my $im (@iml){
            #$self->proj->dd($im);
            if($im->[1] eq 'apple-touch-icon'){
                $res = $im->[0];
                last;
            }
        }
    }

=h
    if(!$res){
        my $dmn = $self->domain;
        $dmn =~ s/^www\.//i;
        $dmn =~ s/\.[^\.]+$//i;
        #print "[[[ $dmn ]]]\n";

        my $iml = $self->get_images;
        for my $im (@$iml){
            #if($im->url =~ /${dmn}[^\/]*\.(png|jpe?g|gif)/i){
            #    print $im->url."\n";
            if($im->url =~ /$dmn/i){
                $res = $im->url;
                #last;
            }
        }
    }
=cut
#    if(!$res){
#        my $pgurls = $self->get_deleted_menu_subpages->get_pager_urls;
#        if($pgurls->count){ #Если есть листалка, то ожидаем, что можно взять картинку первого товара
#            my $s = $self->proj->site($self->url);
#            my $nd = $s->node($self->url);
#            my $gds = $nd->goods;
#            if($gds->count()){
#                $res = $gds->[0]->get_frd_images->get_best_image;
#            }
#        }
#    }
    return $res;
}
sub get_page_logo :CACHE {
    my ($self) = @_;
    return $self->_get_page_logo_v01;
}

#########################################################################
# / Методы для работы с картинками
#########################################################################

#########################################################################
# Методы для работы со ссылками
#########################################################################

sub _normurl {
    my ($self, $url) = @_;

    #print "_normurl beg: $url\n";

    return $url if $url =~ /^(?:["'])?callto:/;
    return $url if $url =~ /^(?:["'])?mailto:/;
    return $url if $url =~ /^(?:["'])?tel:/;
    return $url if $url =~ /^(?:["'])?skype:/;
    return $url if $url =~ /^(?:["'])?viber:/;
    return $url if $url =~ /^(?:["'])?tg:/;
    return $url if $url =~ /^(?:["'])?whatsapp:/;
    return $url if $url =~ /^(?:["'])?javascript:/;

    $url =~ s/^\\"(.*)\\"$/'"'.$1.'"'/ge;

    #print "nrm:$url\n";
    if( $url !~ /^["']([^"']+)["']/ ){ # случай, когда урл не был в кавычках
        $url = $1 if $url =~ /^(\S+)(\s|\>)/;
    }
    $url = $1 if $url =~ /^["']([^"']+)["']/;
    $url =~ s/\s+\///g; #удаляем пробелы, которые могут появиться при склеивании директорий (было на intervesp-stanki.ru)
    return '' unless $url =~ /^\// || $url =~ /^https?:\/\// || $url =~ /^\S+$/ || $url =~ /^\?/;

    $url =~ s/^\/\//http:\/\//g; #Если урл начинается с // , то это урл без указания протокола - подставляем http
    $url =~ s/(?<!:)\/+/\//g;
    $url =~ s/^\.\///g;

    $url =~ s/\?(.+)\?/\?$1\&/; #Исправляем проблему, когда на странице битые ссылки с двумя ?

    eval {
        $url =~ s/(^https?:\/\/)([^\/\?\:]+\.[^\/\?\:\.]+)/$1.URI::_idna::decode($2)/e; #Приведение имён к кириллическим, если они были закодированы
    };
    return '' if $@;

    return '' if $url =~ /^#/;
    return '' if $url =~ /^"#"$/;
    return '' if $url =~ /^""$/;
    return '' if $url =~ /^\.\/(?:#|$)/;
=h
    if( $url =~ /^\.\.\// ){ #Если используются вложенности для урлов
        my $nurl = $self->url;
        $url =~ s/^(\.\.\/)//;
        my $c = length($1)/3;
        if($nurl =~ /(http\:\/\/[^\/]+)((/[\/\?]+)+)/){
           my $dd = $1
           my @w = split /\//, $2;
           $url = $ddi.'/'.join('/', @w[0..(@w-1-$c)]).'/'.$url;
        }
    }
=cut
    #print "pagebase".$self->pagebase."\n";
    my $protocol = $self->is_https_url()? 'https' : 'http';
    $url = $self->domain_path.$url if $url =~ /^\?/;
    $url = "$protocol:".$url if $url =~ /^\/\//;
    $url = "$protocol://".$self->domain.$url if $url =~ /^\//;
    if ($url !~ /^https?\:\/\//) {
        if ($url =~ /^\// || $self->pagebase =~ /\/$/) {
            $url = $self->pagebase.$url;
        } else {
            $url = $self->pagebase.'/'.$url;
        }
    }
    $url = "$protocol://".$self->domain.$url if $url =~ /^\//; # снова, потому что / мог появиться в $self->pagebase
    #$url = $self->domain_dir.'/'.$url if $url !~ /^https?\:\/\//;
    $url = "$protocol://".$self->domain.'/'.$url if $url !~ /^https?\:\/\//;
    $url =~ s/\&amp;/&/g; #На некоторых сайтах так сделано
    $url =~ s/\#.*//; #Удаляем всё, что после решётки

    #Персональный костыль, так как на сайте целый раздел оказался битым
    $url =~ s/icatalog\/(?!categories|products)(?=.+?\/)/icatalog\/categories\// if $url =~ /^http:\/\/www\.dochkisinochki\.ru/;
    #print "res:$url\n";
    #print "_normurl end: $url\n";
    return $url;
}

sub _normtext {
    my ($self, $text) = @_;
    # &#1055;&#1086;&#1076;&#1076;&#1077;&#1088;&#1078;&#1082;&#1072;
    $text =~ s/\&\#(\d+);/chr($1)/eg;
    my $re = $self->get_name_prefilter_re;
    $text =~ s/$re/ /ig;
    $text =~ s/&quot;/"/g if $text =~ /^\s*\&quot;/; #Если строка начинается с кавычек - преобразуем их к нормальному виду
    return $text;
}

#sub get_subpages { #Получаем все урлы, до которых можем дотянуться
#    my ($self) = @_;
#    my @arr = $self->_text2rfrs( $self->text );
#    $_->[0] = $self->_normurl($_->[0]) for @arr; #Приводим  урлы к классическому виду
#    @arr = grep { $_->[0] } @arr; #Выкидываем проблемные урлы
#    my @pages = map { $self->page($_->[0], $_->[1]) } @arr;
#    return @pages;
#}

#Получаем все урлы, до которых можем дотянуться
sub get_subpages {
    my ($self) = @_;
    my @arr = $self->_text2rfrs;
    my $pg = $self;

    # При скачивании мог произойти редирект на другой сайт, и домен мог измениться - это нужно учесть в нормализации урлов
    $pg = $self->page($self->{location}, $self->name) if $self->{location} && $self->{location} =~ /^http/;
    # функция _normurl идет в контент страницы за pagebase, сохраняем текст, чтобы не качать его же еще раз
    $pg->{pagetext} = $self->text;

    my $pgl = $self->page_list( [ grep {$_->[0]} map { [ $pg->_normurl($_->[0]), $pg->_normtext($_->[1]) ] } @arr ] );
    $self->proj->logger->debug("Page get_subpages:", scalar(@$pgl));
    return $pgl;
}

our $more_sbp = {
    'Подробнее' => 1,
};
sub get_more_fixed_subpages {
    my ($self) = @_;
    return $self->get_subpages unless $self->url =~ /ecco-shoes\.ru|maximum-auto\.ru/;
    my $proj = $self->proj;
    my $pgl = $self->get_subpages;
    my ($flrd, $others) = $pgl->divide(sub { $more_sbp->{ $_->name } });
    #print STDERR "DDDD:".$flrd->count." ".$self->url."\n";
    if($flrd->count){
        $flrd->zora_batch_download;
        return $self->page_list([ (map {
            my $pg = $_;
            my $ttl = $pg->title_src;
            $ttl =~ s/^(.{30}.*?) \|.*$/$1/; #Срезаем конец заголовка
            $self->page($pg->url, $ttl);
        } @$flrd),  @$others ]);
    }else{
        return $self->get_subpages;
    }
}

sub is_same_url {
    my ($a, , $b) = @_;
    $a = substr $a, 0, -1 if $a =~ /\/$/;
    $b = substr $b, 0, -1 if $b =~ /\/$/;
    return $a eq $b;
}

sub get_good_subpages {
    my ($self) = @_;
    #my $pgl = $self->get_subpages
    my $pgl = $self->get_more_fixed_subpages
        ->lgrep(sub { ! $_->is_bad_url_format})
#        ->lgrep(sub { ! $_->is_https_url})
        ->lgrep(sub { ! is_same_url($self->url, $_->url) } )
        ->lgrep(sub { ! $_->is_main_url});
    if ($self->domain ne 'autosot.ru') {
        $pgl = $pgl->lgrep(sub { ! $_->is_search_url}) if ! $self->is_search_url;
    }
    $self->proj->logger->debug("Page get_good_subpages:", scalar(@$pgl));
    return $pgl;
}

sub get_internal_domain_regexp {
    my ($self) = @_;
    my $domain_re = $self->domain;
    $domain_re = $1 if $domain_re =~ /([^\.]{4,}\.[^\.]{2,})$/;
    $domain_re .= '|'.URI::_idna::encode($domain_re) if $domain_re =~ /[А-Яа-я]/;
    $domain_re =~ s/^www\.//;
    $domain_re =~ s/\./\\./g;
    return $domain_re;
}

#функция для маппера в get_internal_subpages
sub set_forbid_outgoing_redirects {
    my ($self, $status) = @_;
    $self->forbid_outgoing_redirects($status);
    return $self;
}

#Получить урлы со странице, ведущие на тот же домен
sub get_internal_subpages {
    my ($self) = @_;
    my $pgl = $self->get_good_subpages;
    my $domain_re = $self->get_internal_domain_regexp;
    $pgl = $pgl->lgrep(sub { $_->domain =~ /$domain_re/ || $_->domain_encoded =~ /$domain_re/ });
    $pgl = $pgl->lmap(sub{ $_->set_forbid_outgoing_redirects(1) });
    return $pgl;
}

sub get_external_subpages {
    my ($self) = @_;
    my @pages = $self->get_good_subpages;
    my $domain_re = $self->get_internal_domain_regexp;
    @pages = grep { $_->domain !~ /$domain_re/ } @pages;
    return @pages;
}

sub good_internal_subpages {
    my ($self) = @_;
    return $self->get_internal_subpages->filter_metalinks_for_page($self);
}

sub good_internal_subpages_without_menu {
    my ($self) = @_;
    return $self->get_internal_subpages->filter_metalinks_for_page($self);
}

#Удаляет массив меню из массива урлов
sub get_deleted_menu_subpages {
    my ($self) = @_;

    my $mh = { @{ $self->url_filter } };

    print "menu: ".@{ $self->url_filter }."\n" if $self->{dbg};

    #Убираем общее меню
    my @newarr = ();
    my $pgl = $self->get_internal_subpages;

    #print "deleted_menu_subpages beg tt: \n".(join '', map {"menuflt: ".$_->name." => ".$_->url."\n"} @pages)."\n" if $self->{dbg};
    #print "deleted_menu_subpages beg: ".@pages."\n" if $self->{dbg};
    for my $p (@$pgl){
        $mh->{$p->url}--;
        next if $mh->{$p->url} >= 0; #Убираем общее меню
        push(@newarr, $p);
    }
    #print "deleted_menu_subpages end: ".@newarr."\n" if $self->{dbg};

    return $self->page_list(\@newarr);
}

sub get_freqhash_suburls {
    my ($self) = @_;
    #return $self->get_internal_subpages->filter_metalinks->get_freqhash_suburls;
    return $self->good_internal_subpages->get_freqhash_suburls;
    #return $self->good_internal_subpages->download_and_parse_pages->get_freqhash_suburls;
}

sub get_mainpage_freqhash_suburls :CACHE {
    my ( $self ) = @_;
    my $site = $self->site || $self->proj->site($self->url);
    return $site->menu_filter_hash;
}

#our $pages_cache = {};

#Накладываем часть фильтров на урлы
sub get_internal_filtered_subpages {
    my ($self) = @_;

    return $self->get_deleted_menu_subpages->add_pager_urls;

    #my $url = $self->url;

#    return @{ $pages_cache->{$url} } if $pages_cache->{$url};

    #my @pages = $self->get_deleted_menu_subpages;

    #@pages = $self->_add_pager_urls(@pages);

    #@pages = $self->_delete_bad_urls(@pages);

    #$pages_cache->{$url} = \@pages;
    #return @pages;
}

#########################################################################
# / Методы для работы со ссылками
#########################################################################

#########################################################################
# Методы для фильтрации фраз
#########################################################################

#Служебные слова, не дающие обоснования в пересечении
our $check_phrase_flt_unimp = { map { $_ => 1 } qw{ набор продажа магазин косметика } };
#Важные слова, наличие которых проверяется
our $check_phrase_flt_imp = { map { $_ => 1 } qw{ часы обуви туризм } };
sub check_phrase {
    my ($self, $ph) = @_;
    my $proj = $self->proj;

    my $tph = $proj->phrase( $self->title );
    my $tft = $tph->wflt;

    my @mdls = grep { /^(\d*[a-zа-я]\d+|\d+|\d+[a-zа-я]\d*)$/i } $ph->normwords;

    if(@mdls){ #Если есть околомодельные фразы
        #print Dumper(\@mdls);
        my @tmdl = grep { $tft->{$_} } @mdls;
        #проверяем, что они есть в заголовке страницы
        return 0 unless @tmdl;
    }

    my @impt = grep { $check_phrase_flt_imp->{$_} } $ph->normwords;
    if(@impt){ #Бракуем, если важных слов нет в заголовке
       return 0 unless grep { $tft->{$_} } @impt;
    }

    my @twds = grep { $tft->{$_} } grep { ! $check_phrase_flt_unimp->{$_} } $ph->normwords;
    return 1 if @twds; #Нет пересечений с тайтлом

    return 0;
}

1;
