package BM::Pages::Site;

use utf8;
use 5.010;
use open ':utf8';

use std;
use base qw(ObjLib::ProjPart);

use Data::Dumper;

use Encode;
use Encode qw{_utf8_off};

use URI::Escape;
use LWP::UserAgent;

use Scalar::Util qw(weaken);

use Digest::MD5 qw(md5_hex);

use File::Copy;
use List::Util qw(min max shuffle);

use Utils::Sys qw( h2top );
use Utils::Urls;

use URI::_punycode;
use URI::_idna;

use IO::Socket;
use Socket;
use Socket qw{ inet_pton inet_ntop };
use Net::Ping;

use BM::Pages::Node;
use BM::Pages::NodeList;
use BM::Pages::NodePair;

no warnings 'utf8';

########################################################
#Доступ к полям
########################################################

__PACKAGE__->mk_accessors(qw(
    name
    url
    subsites
    timeout
));


########################################################
# Интерфейс
########################################################

#    mainnode                   корневой узел иерархии

#    freq_tmpl_stat             самые частотные шаблоны сайта - предположительно это урлы товаров
#    elems_tmpls                указатель на массив шаблонов элементов

#    main_mirror                получить из Директа главное зеркало

#    url                        урл страницы
#    domain                     домен, получаемый из урла
#    subsites                   доступ к хэше подсайтов по домену
#    make_subsites              выделяет подсайты
#    get_subsites_domains       получить список доменов подсайтов

#    get_ip                     получение ip-адреса
#    ping                       пингует домен

#    get_minicategs             возвращает категории доменов
#    get_minicategs_flags       возвращает флаги категорий

########################################################
# Инициализация
########################################################

sub init {
    my ($self) = @_;

    my $weak_ref = $self;
    weaken($weak_ref);
    $self->{proxy_ref} = \$weak_ref;
}

########################################################
#Вспомогательные методы
########################################################


########################################################
#Методы
########################################################

sub moderate_domain {
    my ($self) = @_;
    my $proj = $self->proj;

    my $curl = 'http://'.$self->domain;

    my $url = "http://direct-modback.yandex.ru:3200/performanceModerate";
    #my $c = new JSON::RPC::Legacy::Client(1000); # таймаут
    my $callobj = {
        method => "performanceModerate",
        id => "6090734613760090670".int(rand(10000000)),
        jsonrpc => "2.0",
        params => [
            [
            {
                "DataMD5" => 2100084637522,
                "ObjectID" => JSON::null(),
                "TargetURL" => {
                    "URL" => $curl,
                },
            },
            ]
        ],
    };

    my $json = $proj->json_obj;
    my $data = $json->encode($callobj);

    my $page = $self->proj->page($url);
    my $res = $page->tt_post($data);
    if ($page->{download_failed}) {
        # иногда не отвечает, ждем некоторое время и пробуем снова
        sleep(60);
        $page = $self->proj->page($url);
        $res = $page->tt_post($data);
        die("moderate service doesn't response") if $page->{download_failed};
    }

    #my $res = $c->call($url, $callobj);
    $self->proj->dd([$curl, $res]);

    my $pdata = $proj->j2d($res);
    $self->{moderate_log} = $res;
#print Dumper($data);
    my $status = $pdata->{result}[0]{Status};
    return 0 if ($status eq 'PreModerate') && ($status eq 'Reject');
    return 1;
}

sub mainpage_redir_location :FILECACHE(3600*24*2) {
    my ($self) = @_;
    return $self->mainpage->redir_location;
}

sub check_redir {
    my ($self) = @_;
    my $location = $self->mainpage_redir_location;
    #print STDERR "location: $location\n";
    return $self unless $location && ( $location =~ /^http/ );
    my $newdomain = $self->proj->page($location)->domain_2lvl;
    if($newdomain && ($newdomain ne $self->mainpage->domain_2lvl)){
        my $ns = $self->proj->site($newdomain);
        $ns->{mainpage_location} = $location;
        print STDERR "mainpage_location:$location\n";
        return $ns;
    }
    return $self;
}

sub cache_id :CACHE {
    my ($self) = @_;
    my $d = $self->domain;
    $d =~ s/^www\.//i;
    $d =~ s/[^-_A-Za-z0-9А-Яа-яЁё\.]//g; #На всякий случай удаляем все символы, которые не похожи на доменные
    return $d;
}

#sub main_mirror :FILECACHE(3600*24*7) {
sub main_mirror {
    my ($self) = @_;
    my $proj = $self->proj;
    my $json_obj = $proj->json_obj;
    my $murl = $proj->options->{'domain_mirrors_url'};
    my $p = $proj->page($murl);
    my $req = '{"method":"get_domain_filter_for_bs","params":["'.$self->domain.'"]}';
    _utf8_off($req);

    my $res = $p->tt_post( $req );
    #{"jsonrpc":"2.0","id":null,"result":["xn--j1ail.xn--p1ai"]}
    $res = $json_obj->decode($res);
    $res = $res->{result}[0];
    return $res;
}

sub yabs_domain_id {
    my ($self) = @_;
    my $proj = $self->proj;
    my $id_page = $proj->page($proj->options->{domain_ids_url});
    $id_page->{timeout} = 120;
    $id_page->{additional_headers} = { 'Content-Type' => 'application/json' };
    my $req_domain = Utils::Urls::safe_punycode_encode($self->domain);
    my $req = { domains => [ $req_domain ] };
    $req = $self->proj->d2j($req);
    my $res = $id_page->tt_post($req);
    if ($res) {
        my $h = {};
        eval { $h = $self->proj->j2d($res) };
        if ($@) {
            my $error = (split /\n/, $@)[0];
            $proj->log("malformed response from domain_ids_url: $error");
        }
        my $id =  shift @{ $h->{ids} || [] };
        return $id;
    }
    return undef;
}

sub node {
    my ($self, $pg, $ndl) = @_;
    $pg = $self->site_page($pg, '') if defined($pg) && ! ref($pg) && $pg =~ /^http/; #Если вместо объекта передали урл
    return BM::Pages::Node->new({ site_proxy_ref => $self->proxy_ref, proj => $self->proj,  pg => $pg, ndl => $ndl, });
}

sub node_list {
    my ($self, $arr) = @_;
    return BM::Pages::NodeList->new({ site_proxy_ref => $self->proxy_ref, proj => $self->proj, arr => $arr, });
}

sub node_pair {
    my ($self, $f, $s) = @_;
    return BM::Pages::NodePair->new({ site_proxy_ref => $self->proxy_ref, proj => $self->proj, first => $f, second => $s, });
}

sub get_remotecache_id {
    my ($self) = @_;
    return 'get_remotecache_id:'.$self->domain;
}

sub dbg {
    my ($self) = @_;
    return $self->{dbg};
}

sub urlpage :CACHE {
    my ($self) = @_;
    return $self->proj->page($self->url);
}

sub domain :CACHE {
    my ($self) = @_;
    my $d = $self->urlpage->domain;
    $d = URI::_idna::encode($d);
    return $d;
}

sub domain_2lvl :CACHE {
    my ($self) = @_;
    my $d = $self->urlpage->domain_2lvl;
    $d = URI::_idna::encode($d);
    return $d;
}

sub redirect_domain :CACHE {
    my ($self) = @_;
    my $page = $self->proj->page($self->domain);

    $page->{no_cache} = 1;
    $page->text;

    if($page->{location}) {
        return $self->proj->page($page->{location})->domain;
    }

    return "";
}

sub punycode_domain :CACHE {
    my ($self) = @_;
    my $url = url_to_punycode($self->domain);

    return $self->proj->page($url)->domain;
}

sub get_ip :CACHE {
    my ($self) = @_;

    my ( $err, @addrs ) = Socket::getaddrinfo( $self->domain, 0, { 'protocol' => Socket::IPPROTO_TCP, } );
    return '' if $err;

    my $ip = '';
    for my $addr (@addrs) {
        my ( $err, $host ) = Socket::getnameinfo( $addr->{addr}, Socket::NI_NUMERICHOST );
        if ($err) { warn $err; next }
        $ip .= "$host / ";
    }
    return $ip;
}

sub ping {
    my ($self) = @_;
    my $h = $self->domain;
    my $p = Net::Ping->new();
    if ($p->ping($h,1)){
        return 1;
    }else{
        return 0;
    }
}

sub page_list {
    my $self = shift;
    my $pgl = $self->proj->page_list(@_);
    $pgl->site_proxy_ref($self->proxy_ref);
    return $pgl;
}

sub proxy_ref {
    my ($self) = @_;
    return $self->{proxy_ref};
}

sub site_page {
    my ($self, $url, $name) = @_;
    my $p = $self->proj->zpage(
        url => $url,
        name => $name || '',
        site_proxy_ref => $self->proxy_ref,
    );
    $p->timeout($self->timeout) if $self->timeout;
    return $p;
}

sub mainpage :CACHE {
    my ($self) = @_;
    my $mainurl = 'http://'.$self->domain;
    $mainurl = $self->{mainpage_location} if $self->{mainpage_location};
    my $p = $self->site_page($mainurl, 'main page');
    return $p;
}

sub mainnode :CACHE {
    my ($self) = @_;

    my $ndl = $self->node_list([@{$self->menu_pages}]);
    $ndl = $ndl->pack_urls;

    $ndl->debug_print("stage 1") if $self->{dbg};

    #Если нет меню - берём ссылки с первой страницы
    my $firstpage_ndl = $self->node_list([@{$self->mainpage->good_internal_subpages}]);
    if( $ndl->count < 3 ){
        $ndl = $firstpage_ndl;
    } elsif( ($ndl->count < 10) && ( $ndl->site_domain_filter->count < 3 ) ) {
        # много ссылок на другие поддомены (stock.ulmart.ru)
        $ndl = $firstpage_ndl;
    }

    # good_internal_subpages фильтрует бренды. Добавляем их явно
    $ndl += $self->node_list([@{ $self->mainpage->get_internal_subpages->pack_urls->lgrep(sub { $_->is_metalinks_url =~ /brand/ }) }]);

    $ndl->debug_print("stage 2") if $self->{dbg};

    $ndl = $ndl->pack_urls;

    my $bef = $ndl;
    $ndl = $ndl->first_level_filter;
    my $flrd = $bef - $ndl;
    if($self->{dbg}){
        print STDERR "mainnode result report:\n";
        print STDERR "first_level_filter: ".$_->subsection_filter_reason." => $_\n" for @$flrd;
        $self->proj->dd($self->elems_tmpls);
        $ndl->debug_print('first_level_goodnodes');
    }

    $ndl->debug_print("stage 3") if $self->{dbg};

    my @caturls = map { "http://".$self->domain."/$_/", "http://".$self->redirect_domain."/$_/"} qw{ gr cat catalog catalogue katalog category }; #Список предположительных урлов каталога
    #На некоторых сайтах на страницах меню догружается скриптами (например rbt.ru)
    #Пробуем взять разделы с первой страницы, если там есть много страниц с типичными префиксами
    if(1){
        my $catpgl;
        for my $url (@caturls){
            $catpgl = $self->mainpage->good_internal_subpages->pack_urls->get_urls_by_prefix($url);
            last if $catpgl->count > 5;
        }
        if($catpgl->count > 5){
            #Фильтруем разделы, так как иногда встречается мусор
            #на http://kupi-kolyasku.ru с префиксом категории были только разделы брендов
            my $newndl = $self->node_list([ @$catpgl ])->first_level_filter;
            $ndl += $newndl;
        }
    }


    $ndl->debug_print("stage 4") if $self->{dbg};

    #Если на первой странице нет ссылки на каталог, а на других часто встречается - принудительно добавляем
    if(1){
        my $mh = $self->menu_filter_hash;
        $ndl += [ grep { $mh->{$_->norm_url} } map { $self->proj->page($_, 'Каталог') } @caturls ];
    }
    $ndl = $ndl->pack_urls;
    #Если в меню мало урлов, но есть каталог - пробуем взять урлы из него
    if(1){
        if($ndl->count < 10){ #Мало урлов в корне
            my $ctlndl = $ndl->lgrep(sub { ($_->name eq 'Каталог') || ($_->url =~ /\/[ck]at(?:alog(?:ue)?)?\/?$/) });
            if($ctlndl->count){ #Есть урлы каталога
                my @arr = map { @$_ } map { $_->pg->good_internal_subpages->pack_urls } @$ctlndl;
                $ndl += $self->node_list(\@arr)->first_level_filter;
                $ndl = $ndl->pack_urls;
            }
            $ndl->debug_print("stage 5 cat") if $self->{dbg};
        }
    }

    # могли перепутать список брендов с конкретными брендами. Пробуем посмотреть внутри страниц, определенных как бренды
    if(1) {
        my $brands_ndl = $bef->lgrep(sub { $_->is_brand });
        if($brands_ndl->count && $brands_ndl->count < 10) {
            for my $nd (@$brands_ndl) {
                my $pgl = $nd->pg->get_internal_subpages->pack_urls->lgrep(sub { $_->is_metalinks_url =~ /brand/ });
                $ndl += $self->node_list($pgl)->first_level_filter($nd->pg->name);
            }
            $ndl = $ndl->pack_urls;
        }
        $ndl->debug_print("stage 6 brand") if $self->{dbg};
    }

    # пытаемся взять страницы моделей (могут быть бренды распознаны как модели)
    if($ndl->count < 10) {
        my $brands_ndl = $bef->lgrep(sub { $_->pg->get_type eq "model" });
        if($brands_ndl->count) {
            for my $nd (@$brands_ndl) {
                my $pgl = $nd->pg->good_internal_subpages->pack_urls;
                $pgl += $nd->pg->get_internal_subpages->pack_urls->lgrep(sub { $_->is_metalinks_url =~ /brand/ });
                $ndl += $self->node_list($pgl)->first_level_filter($nd->pg->name);
            }
            $ndl = $ndl->pack_urls;
        }
    }

    # пытаемся взять страницы, в урлах которых есть category
    if($ndl->count < 10) {
        my $categs_pgl = $self->mainpage->good_internal_subpages->pack_urls->lgrep(sub { $_->url =~ /category/ });
        $ndl += $self->node_list($categs_pgl)->first_level_filter;
    }

    $ndl = $ndl->pack_urls;

    my $mainnd = $self->node($self->mainpage, $ndl);
    if($self->{dbg}){
        $mainnd->ndl->debug_print("mainnode ndl");
        print STDERR "mainnodesubpage count: ".$ndl->count."\n";
        print STDERR "mainnodesubpage: ".$_->pg->url."\n" for @$ndl;

        my $subs = $mainnd->subsections;
        $subs->debug_print('mainnode subsections');
    }
    return $mainnd;
}

sub mainpage_subpages { return $_[0]->mainpage->get_subpages; }

#sub menu_filter_hash :REMOTECACHE {
sub menu_filter_hash {
    my ($self) = @_;
    return { @{$self->_menu_arr} };
}

sub menu_pages {
    my ($self) = @_;
    my $mh = $self->menu_filter_hash;
    my $subpgl = $self->page_list([map{$self->proj->page($_, $mh->{$_})} grep{/\/catalog\//} keys %$mh]);
    $subpgl += $self->mainpage->good_internal_subpages;
    $subpgl = $subpgl->filter_pager_urls->lgrep(sub { $mh->{ $_->norm_url } });
    return $subpgl;
}

sub design_images_hash :CACHE {
    my ($self) = @_;
    my $pgl = $self->mainpage->get_internal_subpages->get_rand_pages(20);
    my $h = {};
#    $h->{$_}++ for map { keys %{{ map {$_->[0]=>1} $_->get_images }} } @$pgl;
    for my $p (@$pgl){
        my @imgs = keys %{{ map {$_=>1} $p->get_all_images }};
        $h->{$_}++ for @imgs;
    }
    $h = { map { $_ => $h->{$_} } grep { $h->{$_} > 2 } keys %$h };
    return $h;
}

#Является ли этот сайт сервисным сайтом
sub is_service_site :CACHE {
    my ($self) = @_;
    return 1 if $self->mainpage->title =~ /ремонт|обслужив|чинит|почин|сервис|гарант/i;
    return 0;
}

#Возвращаем массив урлов, которые относятся к меню
sub _menu_arr :CACHE {
    my ($self) = @_;
    my $h = $self->mainpage->get_freqhash_suburls;
    return [%$h];
}

sub freq_tmpl_stat :FILECACHE(3600*24*2) {
    my ($self) = @_;
    my $subpgl = $self->menu_pages->pack_urls;
    $subpgl = $subpgl->subsection_text_filter;
    my $menu_pages = $subpgl; #Запоминаяем, чтобы позже на них проверить фильтрацию
    my $exurl = {};
    my $ttlpgl = $self->page_list;
    my $lvlpgl = $subpgl->get_rand_pages(100);
    my $nextlvl = $self->page_list;
    for my $lvl (0 .. 4){
        $nextlvl = $self->page_list;
        $exurl->{$_->norm_url}++ for @$lvlpgl;
#print "dd1\n";
        #$lvlpgl->download_and_parse_pages;
        $lvlpgl->zora_batch_download;
        for my $p ( @$lvlpgl ){
#print "    $p\n";
#            my $pgl = $p->get_internal_subpages->pack_urls;
            my $pgl = $p->good_internal_subpages;
            $p->clear_cache;
            $pgl = $pgl->up_level_filter($exurl);
            $pgl = $pgl->get_rand_pages(10);
            $nextlvl += $pgl;
            #$nextlvl += $p->get_internal_subpages->up_level_filter($exurl)->shuffle_pages->splice_pages(0,10);
        }
#print "dd2\n";
        $nextlvl = $nextlvl->pack_urls->get_rand_pages(100);
        $ttlpgl += $nextlvl;
        $lvlpgl = $nextlvl;
#        $res->{$lvl} = [ keys %{$nextlvl->get_tmpl_grps} ];
#print "dd3\n";
#return $res;
    }
    my $res = $ttlpgl->get_tmpl_grps;
    $res->{$_} = $res->{$_}->count for keys %$res;

    #Считаем суммарное количество
    my $total = 0;
    $total += $res->{$_} for keys %$res;

    #if(defined( $self->{fh} )){
    #    delete($res->{$_}) for grep { $res->{$_} == 1 } keys %$res; #Удаляем с частотой 1
    #    print Dumper($res);
    #    exit;
    #}

    #print Dumper(['111', $res]);
    delete($res->{$_}) for grep { /^[^\/]+\/[^\/]+(?:\/_words)+$/ } keys %$res; #Удаляем шаблоны с простым перечислением вложенности
    delete($res->{$_}) for grep { /^[^\/]+\/[^\/]+\/cat(?:alog(?:ue)?)?\/(?:_digits|_words)$/ } keys %$res; #Нетипичный шаблон для товаров (eldorado.ru, ulmart.ru)
    delete($res->{$_}) for grep { /^[^\/]+\/[^\/]+\/(?:dygytal_tech|domestyc|small_domestyc|kuhonnaya_tehnyka|tehnyka_dlya_doma|komputery_y_orgtehnyka)\/_words$/ } keys %$res;
    delete($res->{$_}) for grep { /^[^\/]+\/[^\/]+(?:\/_words)\/_digits$/ } keys %$res;
    delete($res->{$_}) for grep { /^[^\/]+\/[^\/]+(?:\/_words)\/_digits$/ } keys %$res;
    delete($res->{$_}) for grep { /^[^\/]+\/[^\/]+\/c\/_digits\/_words$/ } keys %$res; #Типичен для lamoda.ru
    delete($res->{$_}) for grep { /^[^\/]+\/[^\/]+\/categ(?:ory)?\/_words$/ } keys %$res; #
    delete($res->{$_}) for grep { /^[^\/]+\/[^\/]+\/catalog\/goods\/_words$/ } keys %$res; #
    delete($res->{$_}) for grep { /IID=_digits\/SECTIONID=_digits/ } keys %$res; # Проблемы для http://www.mans-gift.ru - разделы и товары имеют один и тот же тип
    delete($res->{$_}) for grep { /categ(?:ory|oryes)?\/_words$/ } keys %$res; #
    delete($res->{$_}) for grep { /\/tag\/_words$/ } keys %$res; #
    delete($res->{$_}) for grep { /\/yndex\.[a-z]+[\/\?]_words$/ } keys %$res; #
    # у technopoint.ru очень большой каталог, если будет повторяться с другими сайтами, то возможно стоит увеличить глубину дерева или придумать другой алгоритм
    delete($res->{$_}) for grep { /technopoynt\.ru\/catalog/ } keys %$res; #
    #print STDERR Dumper(['222', $res]);
    $res = { map { @$_ } h2top($res, 0.7, 0.5, 3) };
    my $fltrd = $menu_pages->delete_tmpls_filter([ keys %$res ]);
    #print "fltrd ".$menu_pages->count." - ".$fltrd->count."\n";
    $res = {} if $fltrd->count / ($menu_pages->count + 1) < 0.5; #Если срезаем больше половины меню, то с фильтром что-то не так
    #print STDERR Dumper(['333', $res]);
    #exit;

    #Удаляем слишком низкочастотные в процентном отношении варианты
    print STDERR Dumper(['freq_tmpl_stat', $total, $res]);
    delete($res->{$_}) for grep { $res->{$_} / ($total + 1) < 0.2 }  keys %$res;
    print STDERR Dumper(['freq_tmpl_stat filtered', $res]);

    return $res;
}

sub elems_tmpls :FILECACHE(3600*24*2) {
    my ($self) = @_;
    return [ keys %{$self->freq_tmpl_stat} ];
}

#Алгоритм подавления урлов товаров при наличии урлов разделов
sub special_goods_url_filter_re :FILECACHE(3600*24*2) {
    my ($self) = @_;
    my $catre = '(cat|categs?|category|categories|catalog|catalogue)'; #Регулярка для категорий
    my $goodsre = '(goods?|products?)'; #Регулярка для товарных урлов
    my $pgl = $self->get_representative_pgl; #Получаем выборку урлов
    my $ctgs = $pgl->lgrep(sub { ($_->url =~ /\/$catre\//) && ($_->url !~ /\/$goodsre\//) }); #Берём категорийные
    my $goodscount = 0;
    for my $ct (@$ctgs){
        my $spgl = $ct->good_internal_subpages;
        $goodscount += $spgl->lgrep(sub { ($_->url !~ /\/$catre\//) && ($_->url =~ /\/$goodsre\//) })->count; #Считаем количество товарных урлов на категорийных
    }
    return '\/'.$goodsre.'\/' if $goodscount > 5;
    return '';
}

#Получаем частоты названий текстов для разных урлов
sub freq_url_texts :FILECACHE(3600*24) {
    my ($self) = @_;
    my $pgl = $self->get_representative_pgl;
    $pgl->zora_batch_download;
    $pgl += [ map { @{$_->good_internal_subpages} } @$pgl ]; #Добавляем подурлы
    $pgl = $pgl->shortest_with_the_same_name; #Удаляем вложенные, так как подразделы иногда называются так же, как и раздел
    my $ht = {};
    my $dpref = $self->domain;
    for my $p (@$pgl){
        my $url = $p->norm_url;
        $url =~ s/([a-z0-9]+\.)?$dpref//; #Удаляем из урлов вариации поддоменов, чтобы сравнивать только изменения путей
        $ht->{$p->name}{$url}++;
    }
    #print STDERR Dumper(['EEEEE', $ht]);
    #exit;
    for my $k (keys %$ht){
        $ht->{$k} = keys %{$ht->{$k}};
        if( $ht->{$k} < 6 ){ #Мало вариантов - убираем
            delete($ht->{$k});
            next;
        }
    }
    return $ht;
}

#Получаем частоты названий текстов для разных урлов
sub gen_site_tree :FILECACHE(3600*24*2) {
    my ($self) = @_;

    my $nd = $self->mainnode;
    $nd->fix_the_deep_problem_tree; #Вносим исправления в иерархию разделов

    my $text = $nd->get_subtree_text; #Получаем текст иерархии
    return $text;
}

sub gen_site_tree_debug {
    my ($self) = @_;

    my $prev = $self->{dbg};
    $self->{dbg} = 1;
    my $nd = $self->mainnode;
    print STDERR "mainnode: $nd\n";
    print STDERR  "main subnodes bef: $_\n" for @{$nd->ndl};
    #my $ndl = $nd->ndl->lgrep(sub { $_->name =~ /КОБАЛЬТ/ });
    #$ndl += $nd->ndl->lhead(10);
    #$nd->chndl($ndl);
    print STDERR  "Begin fix_the_deep_problem_tree\n";
    $nd->fix_the_deep_problem_tree; #Вносим исправления в иерархию разделов
    print STDERR  "main subnodes aft: $_\n" for @{$nd->ndl};
    print STDERR  "End fix_the_deep_problem_tree\n";

    my $text = $nd->get_subtree_text; #Получаем текст иерархии

    $self->{dbg} = $prev;
    return $text;
}

sub get_representative_pgl :CACHE {
    my ($self) = @_;
    #print "sbpgs1:$_\n" for map {@$_} $self->mainpage->get_subpages;
    #print "sbpgs2:$_\n" for map {@$_} $self->mainpage->get_internal_subpages;
    return $self->mainpage->get_internal_subpages
        #->debug_print('intsbp')
        ->lgrep(sub { ! $_->check_badre_text($_->name) })
        #->debug_print('check_badre_text')
        ->lgrep(sub { $_->name !~ /^\d+$|^\s*$/ })
        #->debug_print('deldgt')
        ->get_rand_pages(60)
        + [ $self->mainpage ];
}

#Удаляем данные парсинга страниц и кэш методов сайта
sub delete_parse_cache {
    my ($self) = @_;
    my $proj = $self->proj;
    my $dir = $proj->options->{dirs}{temp}.'/FileCache/BM/Pages/Site';
    my $cache_dir = $self->mainpage->curdir;
    my $cmd = "cd $dir; find ./ -iname data_".$self->cache_id." | xargs -i rm {} ; cd -; rm -r $cache_dir; cd -;";
    eval {
        print STDERR "delete_parse_cache: $cmd\n";
        $proj->do_sys_cmd_bash($cmd);
    };
    $self->log("delete_parse_cache done");
}

sub get_url_tskv_feed {
    my ($self, $url, $name) = @_;
    $name //= '';
    my $p = $self->proj->page($url, $name);
    $p->{'no_cache'} = 1;
    my $nd = $self->node($p);
    my @res = ();
    my @offers = $nd->categorized_goods_data("$name/");
    for my $offer ( @offers ) {
        my $line = join("\t", map { $_.'='.$offer->{$_} } keys %$offer)."\n";
        push(@res, $line);
    }
    return join("", @res);
}

sub debug_url_inf {
    my ($self, $url, $name) = @_;
    $name ||= '';
    my $nd = $self->node($self->proj->page($url, $name));
    my $s = $nd->site;

    $nd->pg->get_internal_subpages->debug_print('get_internal_subpages');
    $nd->pg->get_internal_subpages->debug_print('good_internal_subpages');
    print $nd->pg->get_internal_subpages->filter_metalinks_debug;
    $s->node_list( [ @{ $nd->pg->good_internal_subpages } ] )->debug_print('node_list');
    $s->node_list( [ @{ $nd->pg->good_internal_subpages } ] )->delete_menu->debug_print('delete_menu');
    $nd->ndl->debug_print('ndl');
    $nd->site->site_goods_filter($nd->ndl)->debug_print('site_goods_filter');
    my $pgrndl = $nd->ndl->add_pager_urls - $nd->ndl;
    $pgrndl->debug_print('pager urls');
    $nd->subsections->debug_print('subsections');
    $nd->not_subsections->debug_print('not_subsections');
    $nd->goods->debug_print('goods');
}

sub get_site_tskv_feed :FILECACHE(3600*48) {
    my ($self) = @_;
    my $proj = $self->proj;
    my $dbg = $self->{dbg};
    my $tree = $self->gen_site_tree;
    my $prevdeep = 0;
    my $path = '';
    my @res = ();

    for my $line (grep {$_} split "\n", $tree){
        if($line =~ /^(\s*)\[\+\]\s(.+?) =-> (\S*)/){
            my ($deep, $name, $url) = ($1, $2, $3);
            $name =~ s/\// /g;
            if(length($prevdeep) >= length($deep)){
                $path =~ s/\/[^\/]+$// for 0 .. ((length($prevdeep) - length($deep)) / 4);
            }
            $path .= '/'.$name;
            $prevdeep = $deep;

            my $nd = $self->node($self->proj->page($url, $name));
            my $ndl = $nd->goods;
            for my $gd ( @$ndl ){
                my $data = {
                    name => $gd->pg->name,
                    url  => $gd->pg->url,
                    categpath => $path,
                };
                my $line = join("\t", map { $_.'='.$data->{$_} } keys %$data)."\n";
                push(@res, $line);
            }
        }
    }

    return join("", @res);
}

sub get_site_tskv_feed_file {
    my ($self, $filename, $begtime) = @_;
    $begtime //= time; # сюда можно передать время начала работы над tskv. Помогает считать правильный таймаут, если gen_site_tree вызывался ранее

    my $proj = $self->proj;
    my $timeout = 3600 * 30; #Ограничиваем время генерации tskv

    open(F, "> ".$filename."_tmp");

    my $tree = $self->gen_site_tree;
    my $prevdeep = 0;
    my $path = '';
    for my $line (grep {$_} split "\n", $tree){
        my $curtime = time;
        if($curtime - $begtime > $timeout){ #Прерываемся при превышении таймаута
            $self->{tskv_timeout} = 1;
            last;
        }
        if($line =~ /^(\s*)\[\+\]\s(.+?) =-> (\S*)$/){
            my ($deep, $name, $url) = ($1, $2, $3);
            $name =~ s/\// /g;
            if(length($prevdeep) >= length($deep)){
                $path =~ s/\/[^\/]+$// for 0 .. ((length($prevdeep) - length($deep)) / 4);
            }
            $path .= '/'.$name;
            $prevdeep = $deep;

            my $nd = $self->node($proj->page($url, $name));
            my @offers = $nd->categorized_goods_data("$path");
            print STDERR "node count: [".scalar(@offers)."] $nd\n";
            for my $offer ( @offers ) {
                my $line = join("\t", map { $_.'='.$offer->{$_} } keys %$offer)."\n";
                print F $line;
            }
        }
    }

    close(F);

    move($filename."_tmp", $filename); #Кладём результат в правильное место
    unlink($filename."_tmp"); #Удаляем временный файл
}

sub get_debug_site_info {
    my ($self) = @_;

    my $s = $self;
    my $nd = $s->mainnode; #Получение главного нода

    #Печатаем отладочную информацию по сайту
    my $fhi = *STDERR;

    print $fhi "dmn: ".$self->domain."\n";
    print $fhi "mainpage: ".$nd->pg."\n";
    print $fhi "\n=== menu ===\n";
    $s->menu_pages->debug_print("menupages", $fhi);
    print $fhi "=== /menu ===\n\n";
    print $fhi "\n=== mainpage subsections ===\n";
    $nd->subsections->debug_print("subsections", $fhi);
    print $fhi "=== / mainpage subsections ===\n\n";
    print $fhi "\n=== mainpage not_subsections ===\n";
    $nd->not_subsections->debug_print("not_subsections", $fhi);
    print $fhi "=== / mainpage not_subsections ===\n\n";
    print $fhi "\n=== mainpage nodes ===\n";
    $nd->ndl->debug_print("mpnodes", $fhi);
    print $fhi "=== / mainpage nodes ===\n\n";
    print $fhi "\n=== freq_tmpl_stat ===\n";
    print $fhi Dumper($s->freq_tmpl_stat);
    print $fhi "=== / freq_tmpl_stat ===\n\n";
    print $fhi "\n=== freq_url_texts ===\n";
    print $fhi Dumper($s->freq_url_texts);
    print $fhi "=== / freq_url_texts ===\n\n";
    print $fhi "\n=== mainpage good_internal_subpages ===\n";
    $nd->pg->good_internal_subpages->debug_print("gis", $fhi);
    print $fhi "=== / mainpage good_internal_subpages ===\n\n";
    print $fhi "\n=== freqhash_suburls ===\n";
    print $fhi Dumper($s->mainpage->get_freqhash_suburls);
    print $fhi "=== / freqhash_suburls ===\n\n";
    #print $fhi "\n=== freqhash_suburls src ===\n";
    #print $fhi Dumper($s->mainpage->get_internal_subpages->filter_metalinks->get_frequenti_all_suburls_arr);
    #print $fhi "=== / freqhash_suburls src ===\n\n";

    print $fhi "\n=== mainpage metalinks ===\n";
    my $pgl = $nd->pg->get_internal_subpages;
    my $fpgl = $pgl->filter_metalinks;
    my $mpgl = $pgl - $fpgl;
    $mpgl->debug_print("mpmetalinks", $fhi);
    print $fhi "=== / mainpage metalinks ===\n\n";

    print $fhi "\nspecial_goods_url_filter_re='".$s->special_goods_url_filter_re."'\n\n";

    #close($fhi);
    #/Печатаем отладочную информацию по сайту
}

############################################################################################
# Работа с категориями
############################################################################################

sub domain_categs :GLOBALCACHE {
    my ($self) = @_;
    my %h = ();
    open(F, "<".$self->proj->options->{domain_categs} );
    while(<F>){
        my ($d, $ctgs) = split(/[\t\n]/, $_);
        $h{$d} = $ctgs;
    }
    return \%h;
}

#возвращает хэш, так как в зависимых функциях есть модификации хэша
sub get_minicategs_freqhash :FILECACHE(3600*24*2) {
    my ($self) = @_;
    my %h = ();
    $h{$_}++ for map {$_->get_minicategs_without_hrefs} map { @$_ } $self->get_representative_pgl;
    return %h;
}

#Получить категорию сайта
sub get_minicategs :FILECACHE(3600*24*2) {
    my ($self) = @_;
    my $maindomain = $self->mainpage->domain;
    return $self->domain_categs->{$maindomain} if $self->domain_categs->{$maindomain};
    my $maintitle = $self->mainpage->title;
    return "Бытовая техника" if $maintitle =~ /Интернет[- ]?магазин бытовой техники/i;
    return "Универсальные магазины" if $maintitle =~ /книг.+электроник.+бытов.+техник/i;
    return "доски объявлений" if $maintitle =~ /доска объявлений/i;

    my $h = { $self->get_minicategs_freqhash };

    if(keys %$h > 20){ #Если много разных категорий, то пробуем обобщить до более высокого уровня
        my $ct = $self->proj->categs_tree;
        $h->{$_}++ for grep { /^Товары|Услуги|Оборудование|Информация$/ } map {$ct->get_minicateg_parent($_)} keys %$h;
    }
    my $res = { map { @$_ } h2top($h, 0.74, 0.7, 1) };
    return keys %$res;
}

sub get_minicategs_flags {
    my ($self) = @_;
    my $ct = $self->proj->categs_tree;
    my %h = map {$_=>1} map { keys %$_ } map { $ct->get_minicateg_flags($_) } $self->get_minicategs;
    return keys %h;
}

sub get_minicategs_debug {
    my ($self) = @_;
    my $h = {};
    my $pgl = $self->get_representative_pgl;
    for my $p (@$pgl){
        my $dbg = $p->get_minicategs_debug_inf;
        $self->proj->dd('dbginf:',$p, [$p->get_minicategs], $dbg);
    }
}

sub get_minicategs_debug_report {
    my ($self) = @_;
    my $h = {};
    my $pgl = $self->get_representative_pgl;
    for my $p (@$pgl){
        my $dbg = $p->get_minicategs_debug_inf;
        for my $l (@$dbg){
            next unless @{$l->[2]};
            $h->{$l->[1].' => '.$_ }++ for @{$l->[2]};
        }
    }
    return $h;
}

############################################################################################
# / Работа с категориями
############################################################################################

sub diag {
    my ($self) = @_;
    my $res = {};
    my $mp = $self->mainpage;
    my $errors = [];
    $res->{errors} = $errors;
    my $adderr = sub { push(@{$errors}, $_[0]) };
    my $fist_page_size = length($mp->text);
    if($fist_page_size < 400){
        $adderr->("Err7001: The first page is too small.");
    }
    my @ctgs = $self->get_minicategs;
    $res->{ctgs} = \@ctgs;
    return Dumper($res);
}

sub site_goods_filter {
    my ($self, $ndl) = @_;
    if($self->domain_2lvl eq 'ozon.ru'){ #Удаляем для озона всю помойку перекрёстных урлов
        $ndl = $ndl->lgrep( sub {
            my $nd = $_;
            my $url = $nd->pg->url;
            return 1 if $url =~ m!/context/detail/id/\d+/?(\?.*)?$!;
            return 1 if $url =~ m!/product/[_\-\w]+/?(\?.*)?$!;
            return 1 if $url =~ /\/catalog\/\d+\/\?page=\d+$/;
            return 0;
        });
    }
    return $ndl;
}

sub site_subsections_filter {
    my ($self, $ndl) = @_;
    if($self->domain_2lvl eq 'ozon.ru'){ #Удаляем для озона всю помойку перекрёстных урлов
        $ndl = $ndl->lgrep( sub {
            my $nd = $_;
            my $url = $nd->pg->url;
            return 1 if $url =~ /\/catalog\/\d+\/?(?:\?typeapparel=\d+)?$/;
            return 1 if $url =~ /\/context\/[-A-Za-z_]+\/$/;
            return 1 if $url =~ /\/context\/catalog\/id\/\d+\/?$/;
            return 0;
        });
    }
    return $ndl;
}


#Определяем, русский ли это сайт
sub is_rus :CACHE {
    my ($self) = @_;
    my @a = $self->mainpage->get_internal_subpages_rechck;
    return 0 unless @a;
    my @rus = grep { $_->name =~ /[А-Яа-я]/ } @a;
    return 1 if (@rus > 5) && (@rus/@a > 0.1);
    return 0;
}

sub get_whois_inf :FILECACHE(3600*24*7) {
    my ($self) = @_;
    return '' unless $self->domain;
    my $cmd = 'whois '.$self->domain;
    my $str = join "/", sort `$cmd`;
    $str =~ s/\n//g;
    $str =~ s/(domain:|Last updated on)[^\/]+\///g;
    print STDERR "get_whois_inf ".$self->domain."\n";
    sleep(1);
    return $str;
}

#Регулярка, проверяющая соответствию домену в разных вариантах записи
sub domain_filter_regexp :CACHE {
    my ($self) = @_;
    my @domains = ($self->domain);

    if($self->redirect_domain && $self->redirect_domain ne $self->domain) {
        push @domains, $self->redirect_domain;
    }

    if($self->punycode_domain ne $self->domain) {
        push @domains, $self->punycode_domain;
    }

    my @domain_res;
    for my $domain (@domains) {
        my $domain_re = lc($domain);
        $domain_re =~ s/^https?:\/\///;
        $domain_re =~ s/\/$//;
        $domain_re =~ s/www\.//;
        push @domain_res, $domain_re;
    }

    my $domains_re = join("|", @domain_res);
    $self->proj->log("site domain filter regex: /$domains_re/");
    #return grep{lc($_->url) =~ /$domains_re/} @$offers;
    return $domains_re;
}

sub get_site_goods_regexp :CACHE {
    my ($self) = @_;
    open(my $fh, $self->proj->options->{dicts}.'/dict_goods_regexp');
    while (my $row = <$fh>) {
        chomp $row;
        if ($row =~ /([^#]+)\t(.+)/) {
            my $regexp = $2;
            if ($self->domain =~ /(^|\.)$1$/) {
                return $regexp;
            }
        }
    }
    return undef;
}

sub get_common_image_list :CACHE {
    my ($self) = @_;
    my $mp = $self->proj->page( $self->domain );
    my $pgl = $mp->get_internal_subpages->rand_n(20);
    my $mn = $mp->get_images;
    $mn += $_->get_images for @$pgl;
    return $mn;
}

1;
