package BM::PhraseCategs;

use utf8;
use open ':utf8';

use std;
use JSON qw(to_json);
use base qw(BM::Phrase);
use Time::HiRes qw(tv_interval gettimeofday);
use List::Util qw(min max sum);
use Utils::Sys qw(md5int uniq print_err);

use BM::Banners::LBannerDirect;

use BM::Categories::Layer;

use Data::Dumper;
use Scalar::Util qw(openhandle);

use Utils::Words;
use Utils::Array;
use Data::Dumper;
use Storable qw/dclone/;

########################################################
# Интерфейс
########################################################

#    get_minicategs            =>   Получить миникатегории фразы
#    get_minicategs_directids  =>   Получить номера категорий для Директа
#    get_minicateg_directid_by_catid
#    get_minicategs_flags      =>   Получить массив _флагов категорий
#    get_minicategs_flags_with_asocial      =>   Получить массив _флагов категорий плюс asocial
#    get_norm_categ_from_text  =>   Если текст - название категории, то нормализуем его
#    get_norm_minicategs_text  =>   Список нормализованных названий категорий, склеенный в строку через /

#    get_categs_phrases        =>   Возвращает лог категоризации - указатель на массив пар (массивов) категория-фраза
#    get_categs_phrases_hlist  =>   Возвращает лог категоризации в формате массива хэшей

########################################################
# Инициализация класса
########################################################

my $phrase_minuswords = {};

my $categid2minicateg = {};
my $minicateg2categid = {};
my $minicateg2directid = {};
my $videodirectgroup2directid = {};
my $categ2videodirectgroup = {};
my $directid2minicateg = {};
my $normcateg2minicateg = {};
my $minicateg2normcateg = {};
my $minicateg2words = {};
my $minicateg2phrases = {};
my $minicateg2children = {};
my $root_minicategs = [];
my $tree = {};
my $minicategs_flags = {};
my $minicategs_not_flags = {};
my $flags_description = {};
my $minicategs_diff_hash;
my $minicategs_not_minus = {};
my $all_minicategs_not_minus = {};
my $minicategs_minus_old = {};
my $minicategs_minus = {};
my $minicategs_siblings_info = {};
my $siblings_groups;
my (%never_pair, %never_any);
my $minicategs_nephews = {};
my $deleted_categs = {};

my %good_words_wide_snorms;

# слой моделей
my $layer_models = 0;

my $layer_digits;

# виртуальные категории
my $virtual2id = {};
my $id2virtual = {};
my $virtual_add = {};
my $virtual_add_once = {};
my $virtual_add_flags = {};
my $virtual_del = {};
my $virtual_flags = {};
my $virtual_antiflags = {};
my $virtual2instances = {};

my $code_atoms = {};
our $atom_words = {};
my $empty_atoms = {};

our $never_write_categs_cache = 1;  # никогда не сохранять категории в кэш
our $never_read_categs_cache = 1;   # всегда принудительно проводить категоризацию
our $always_spdiff = 0;             # никогда не использовать подавление категорий по длине фраз
our $never_suppress_categs = 0;     # никогда не подавлять категории
our %lang_caddphrs = ();            # источники дополнительных фраз для категорий на разных языках
our $use_virtual_categs = 1;        # использование виртуальных категорий
our $use_categs_biwords = 1;        # использование бивордов для категоризации
our $dont_use_catalysts = 0;        # не использовать катализаторы для категорий
our $categs_experiment_norm = 0;    # при категоризации нормализованные формы важнее снормализованных
our $use_uncertain_minicategs = 0;  # всегда использовать второй слой
our $use_freq_words_filter = 1;     # использовать фильтр частотных слов при категоризации
our $use_sentences_filter = 0;
our $expand_atom_codes = 1;
our $freq_filter_snorms = 0;

our %grammar;

# хеши по словарю ключевых слов категорий dict_categskeys_with_minuswords
our %h_keyscategs = ();
our %h_keysminuswords = ();
our $phl_keys;


# локальный кэш
my $cache_get_minicategs_subtree = {};

our %dynbanners_categs_mapping = ();

our $compute_phrase_analysis = 0; # Нужно ли при категоризации заполнять поле  $self->{analysis}

sub class_init :RUN_ONCE {
    my ($class, $opt) = @_;
    my $log = $opt->{logger};
    my $proj = $opt->{'proj'};
    
    # минус-слова на фразу
    $log->log('minuswords');
    open (F, $opt->{'minuswords'}) or die ("Cannot open $opt->{minuswords} ($!)");
    while (<F>) {
        chomp;
        my ($ph, $w) = split "\t";
        ($phrase_minuswords->{$proj->phrase($ph)->snorm_phr} ||= {})->{$_}++ for split /\s*,\s*/, $w;
    }
    close(F) or die "close failed ($!)";
    $log->log('/ minuswords');

    # категории
    _load_minicategs($class, $opt) if $proj->{load_minicategs} || $proj->{load_minicategs_light};

    # для категоризации по ключевым словам категорий
    $log->log('dict_categskeys_with_minuswords');
    if ( $opt->{dict_categskeys_with_minuswords} ){
        open F, $opt->{dict_categskeys_with_minuswords} or die ("ERROR: Cannot open $opt->{dict_categskeys_with_minuswords} ($!)");
        while ( <F> ){
            chomp;
            next if /^[#]/;
            my ( $catname, $key, $minuswords ) = split /\t/;
            $h_keyscategs{$key} = $catname;
            $h_keysminuswords{$key} = $proj->phrase_list( {phrases_text=>$minuswords} ) if ($key && $catname && $minuswords);
        }
        close F or die "close failed ($!)";
    }
    $phl_keys = $proj->phrase_list( { phrases_arr => [ keys %h_keyscategs ] } );
    $log->log('/ dict_categskeys_with_minuswords');

    # маппинг из minicategs в product_type в BL
    $log->log('dynbanners_categs_mapping');
    my $dynbanners_categs_mapping_file = $proj->options->{dynbanners_categs_mapping};
    open F, $dynbanners_categs_mapping_file or die ("Cannot open $dynbanners_categs_mapping_file ($!)");
    while ( <F> ){
        chomp;
        next if /^[#]/;
        my ( $minicateg, $product_type ) = split /\t/;
        $dynbanners_categs_mapping{$minicateg} = $product_type;
    }
    close F or die "close failed ($!)";
    $log->log('/ dynbanners_categs_mapping');

    $videodirectgroup2directid = $proj->videodirectgroups->group2directid;
    $categ2videodirectgroup = $proj->videodirectgroups->categ2group;
}

sub _init_minicategs_hier {
    my ($opt) = @_;
    my $log = $opt->{logger};
    my $proj = $opt->{'proj'};

    # заполняем minicateg2children
    $proj->log('minicateg2children');
    for my $ct (keys %$minicateg2categid) {
        my $p = get_minicateg_parent($ct);

        if(!defined($p)) {
            $log->log("WARNING: parent for categ '$ct' is not defined");
            next;
        }

        if(!$p) {
            push @$root_minicategs, $ct;
        } else {
            push @{$minicateg2children->{$p} ||= []}, $ct;
        }
    }
    $proj->log('/ minicateg2children');

    # прокидываем флаги вниз по иерархии
    $proj->log('flags_to_children');
    my @flags_to_children = qw(popl vendor _software badadaptive _filter_for_dynamic _dynamic_homonymy allow_smart_banners no_regular_geotargeting);
    my @q = map{[$_, []]} @$root_minicategs;
    while(@q) {
        my ($ct, $flags) = @{pop @q};
        $minicategs_flags->{$ct}{$_}++ for grep{!$minicategs_flags->{$ct}{"un$_"}} @$flags;
        $flags = {map{$_=>1} @$flags};
        $flags->{$_}++ for grep{$minicategs_flags->{$ct}{$_}} @flags_to_children;
        push @q, map{[$_, [keys %$flags]]} @{$minicateg2children->{$ct} ||= []};
    }
    $proj->log('/ flags_to_children');

    # прокидываем флаги Каталогии (через апы)
    for my $ct (keys %$minicateg2children) {
        my @flags = grep{/^_/ && !($minicategs_not_flags->{$ct} || {})->{$_}} keys %{$minicategs_flags->{$ct} || {}};
        if(@flags) {
            for my $ch (grep{($minicategs_flags->{$_} || {})->{up}} @{$minicateg2children->{$ct}}) {
                $minicategs_flags->{$ch}{$_}++ for @flags;
            }
        }
    }

    # таблица подавления категорий
    my $transform_function = sub {
        my ($source_file, $target_file) = @_;

        my $minicategs_diff = {};
        open(F2, '<', $source_file) or die ("Cannot open $source_file ($!)");
        my $get_diff_tree = sub {
            my ($c1, $c2) = @_;
            my @arr;
            my @q = ($c1);

            while(@q) {
                my $categ = pop @q;
                next if $categ eq $c2;
                push @arr, $categ;
                push @q, $_ for get_minicateg_children($categ);
            }

            return @arr;
        };
        my $add_categs_diff;
        $add_categs_diff = sub {
            my ($c1, $c2, $is_weak, $orig) = @_;
            return if $c1 eq $c2 or $minicategs_diff->{$c1}{$c2};
            for my $unk (grep{not get_minicateg_id($_)}($c1, $c2)) {
                $log->log("WARNING: unknown category $unk in categs diff");
                return;
            }

            # категории с nodiff никогда не подавляются
            if(($minicategs_flags->{$c2} || {})->{nodiff}) {
                return;
            }

            if(($minicategs_diff->{$c2} || {})->{$c1}) {
                $log->log("WARNING: minicategs $c1/$c2 suppress each other (from '$orig')");
            }

            my @left = $get_diff_tree->($c1, $c2);
            my @right;
            if($is_weak) {
                @right = ($c2);
            } else {
                @right = $get_diff_tree->($c2, $c1);
            }

            for my $ch (@left) {
                for my $suppressed (@right) {
                    if(($minicategs_diff->{$suppressed} || {})->{$ch}) {
                        next;
                    }

                    ($minicategs_diff->{$ch} ||= {})->{$suppressed}++;
                }
            }
        };
        while(my $line = <F2>) {
            chomp $line;

            # skip line containing MD5
            next if $line =~ /^CATEGORIES_TREE_MD5/;

            my ($cts1, $cts2) = split "\t", $line;

            next if !$cts1;

            if(!$cts2) {
                $proj->log("WARNING: categs '$cts1' suppress nothing in diff");
                next;
            }

            for my $c (split "/", $cts1) {
                $add_categs_diff->($c, $_, 0, $line) for split("/", $cts2);
            }
        }
        close(F2) or die "close failed ($!)";
        for my $ct (grep{$minicategs_flags->{$_}{weakdiff}} keys %$minicategs_flags) {
            $add_categs_diff->($_, $ct, 1, "WEAKDIFF") for @{$minicateg2children->{$ct}};
        }

        open(my $target_file_handle, '>', $target_file) or die ("Cannot open > $target_file ($!)");
        for my $category (keys %$minicategs_diff) {
            print $target_file_handle "$category\t";
            print $target_file_handle join('/', sort keys %{$minicategs_diff->{$category}}) . "\n";
        }
        close $target_file_handle or die "close failed ($!)";
    };

    my $categories_suppression_params = $Utils::Common::options->{'categories_suppression_params'};
    my $categs_diff_source = $categories_suppression_params->{'dict'};
    my $categories_suppression_szmap = $categories_suppression_params->{'szmap_dict'};
    $proj->log('categs_diff');
    $minicategs_diff_hash = $proj->{'use_sandbox_categories_suppression_dict'} ?
                            StaticZmap->new($categories_suppression_params->{'sandbox_szmap_dict'}) :
                            StaticZmap::build(
                                $categs_diff_source,
                                transform_function  => $transform_function,
                                id                  => 'categories_diff',
                                target_file         => $categories_suppression_szmap,
                            );
    $proj->log('/ categs_diff');

    # плюс-слова для категорий
    my $hplus = {};
    open F2, $opt->{categs_plus} or die ("Cannot open $opt->{categs_plus} ($!)");
    while(<F2>) {
        chomp;
        my ($ct, $words) = split "\t";

        if($ct && !get_minicateg_id($ct)) {
            $log->log("WARNING: unknown category $ct in categs plus");
        } else {
           ($hplus->{$ct} ||= {})->{$_}++ for split ",", $words;
        }
    }
    close F2 or die "close failed ($!)";

    $all_minicategs_not_minus = { map { $_ => 1 } keys %{$hplus->{"0"}} };
    for my $ct (get_minicategs_list()) {
        $minicategs_not_minus->{$ct}{$_}++ for keys %{$hplus->{$ct} || {}};
    }

    # минус-слова для категорий
    # пока отключаем, т.к. устарело и не используется
    if(0) {
    for ([$opt->{categs_minus}, $minicategs_minus], [$opt->{categs_minus_old}, $minicategs_minus_old]) {
        my ($f, $h) = @$_;
        open F2, $f or die ("Cannot open $f ($!)");
        while(<F2>) {
            chomp;
            my ($ct, $words) = split "\t";

            if(!get_minicateg_id($ct)) {
                $log->log("WARNING: unknown category $ct in categs minus");
            } else {
                unless(is_minicateg_nominus($ct)) {
                    ($h->{$ct} ||= {})->{$_->[0]} = ($_->[1] || 1) for grep {
                        !$minicategs_not_minus->{$ct}{$_->[0]} && !$all_minicategs_not_minus->{$_->[0]}
                    } map{[split ":"]} split ",", $words;
                }
            }
        }
        close F2 or die "close failed ($!)";
    }
    }

    # идентификаторы для Директа
    open F2, $opt->{categs_direct_ids} or die ("Cannot open $opt->{categs_direct_ids} ($!)");
    while(<F2>) {
        chomp;
        my ($id, $ct) = split "\t";
        $minicateg2directid->{$ct} = $id;
        $directid2minicateg->{$id} = $ct;
    }
    close F2 or die "close failed ($!)";

    # категории, которые не должны быть сиблингами/нефьюзами
    open F2, $opt->{categs_never_sibl} or die ("Cannot open $opt->{categs_never_sibl} ($!)");
    while (<F2>) {
        chomp;
        next if /^\s*#/ or /^\s*$/;  # комментарии
        my ($ctg1, $ctg2) = split /\t/;
        if ($ctg2 eq 'any') {
            $never_any{$ctg1} = 1;
        } else {
            $never_pair{$ctg1}{$ctg2} = 1;
            $never_pair{$ctg2}{$ctg1} = 1;
        }
    }
    close F2 or die "close failed ($!)";
    $log->log("siblings");
    open F2, $opt->{categs_siblings} or die ("Cannot open $opt->{categs_siblings} ($!)");
    while(<F2>) {
        chomp;
        next if /^\s*#/ or /^\s*$/;  # комментарии
        my ($name, $cts) = split "\t";
        my @cts;

        if(!$cts) {
            $log->log("WARNING: bad siblings line '$_'");
            next;
        }

        for my $categ (split "/", $cts) {
            if(get_minicateg_id($categ)) {
                push @cts, $categ;
            } elsif($virtual2instances->{$categ}) {
                # виртуальная категория -- добавляем все сгенерированные по ней категории
                push @cts, $virtual2instances->{$categ}{$_} for keys %{$virtual2instances->{$categ}};
            } else {
                $categ =~ s/^\s+|\s+$//g;
                if(get_minicateg_id($categ)) {
                    push @cts, $categ;
                } else {
                    $proj->log("WARNING: unknown categ '$categ' in siblings");
                }
            }
        }

        _add_siblings_cluster($name, \@cts);
    }
    close F2 or die "close failed ($!)";

    if ($proj->experiment->{add_siblings}) {
        $proj->log("loading additional siblings ...");
        # дополнительные родственные категории
        open F2, $opt->{categs_siblings_add} or die ("Cannot open $opt->{categs_siblings_add} ($!)");
        while(<F2>) {
            chomp;
            next if /^\s*#/ or /^\s*$/;  # комментарии
            my ($name, $cts) = split "\t";
            my @cts = grep{get_minicateg_id($_)} split "/", $cts;

            $log->log("WARNING: unknown category $_ in categs siblings") for grep{!get_minicateg_id($_)} split "/", $cts;

            _add_siblings_cluster($name, \@cts);
        }
        close F2 or die "close failed ($!)";
        $proj->log("loading additional siblings done!");
    }

    # родственные категории из апов
    # флаг uptree - старая логика апов - сиблингами становится всё up-поддерево
    for my $ct (keys %$minicateg2children) {
        next if $minicategs_flags->{$ct}{uptree};

        # поддерево апнутых категорий
        my @up;
        my @q = @{$minicateg2children->{$ct}};
        while(@q) {
            my $child = pop @q;
            next if !$minicategs_flags->{$child}{uptree};
            push @up, $child;
            push @q, @{$minicateg2children->{$child} || []};
        }

        # новые сиблинги, полученные из апов
        if(@up) {
            _add_siblings_cluster("UP_Tree $ct", [$ct, @up]);
        }
    }

    # родственные категории из апов
    # новая логика - сиблингами становится путь по дереву up-категорий
    for my $ct (keys %$minicateg2categid) {

        next if !$minicategs_flags->{$ct}{up};
        my @q = @{$minicateg2children->{$ct} // []};
        next if grep { $minicategs_flags->{$_}{up} } @q;

        my $curr = $ct;
        my @path = ($curr);
        while ($minicategs_flags->{$curr}{up}) {
            $curr = get_minicateg_parent($curr);
            push @path, $curr;
        }

        # новые сиблинги, полученные из апов
        if(@path) {
            _add_siblings_cluster("UP_Path $path[0]...$path[-1]", \@path);
        }
    }
    $log->log("/ siblings");

    # родственные категории
    open F2, $opt->{categs_nephews} or die ("Cannot open $opt->{categs_nephews} ($!)");
    while(<F2>) {
        chomp;
        next if /^\s*#/ or /^\s*$/;  # комментарии
        my ($uncle, $nephews) = split "\t";
        my @badcts = grep{!get_minicateg_id($_)} ($uncle, split("/", $nephews));

        if(@badcts) {
            $log->log("WARNING: unknown category $_ in categs nephews") for @badcts;
        }

        ($minicategs_nephews->{$_} ||= {})->{$uncle}++ for split "/", $nephews;
    }
    close F2 or die "close failed ($!)";

    # чистка нефьюзов по never_sibl
    for my $c1 (keys %$minicategs_nephews) {
        if ($never_any{$c1}) {
            $proj->log("deleting any nephews for $c1");
            delete $minicategs_nephews->{$c1};
            next;
        }
        for my $c2 (keys %{$minicategs_nephews->{$c1}}) {
            if ($never_pair{$c1}{$c2}) {
                delete $minicategs_nephews->{$c1}{$c2};
            }
        }
    }
}

# сплит по запятой (с учётом фигурных скобок)
sub split_phrases_text {
    my ($phrases, %opts) = @_;
    my @result;

    if ( $phrases =~ tr/,{}// ) {
        if ( $phrases =~ tr/{}// ) {
            # фразы с фигурными скобками (внутри которых могут быть запятые)
            my @a = $phrases =~ /([^,{]*\{[^}]+\}[^,]*)/g;
            push @result, @a;
        
            # фразы без фигурных скобок
            $phrases =~ s/([^,{]*\{[^}]+\}[^,]*)//g;
        }
        push @result, grep{$_} split ",", $phrases;
    }
    else {
        push @result, $phrases if $phrases;
    }

    # удаление лишних пробелов
    if(!$opts{keep_spaces}) {
       @result = map{s/^\s+|\s+$//g; $_} grep{defined($_)} @result; ##no critic
    }

    return @result;
}

sub _parse_atom_phrases_simple {
    my ($proj, $ins_categ, $lang, $arr, $is_silent) = @_;

    if(!get_minicateg_id($ins_categ)) {
        $proj->log("WARNING: unknown atom '$ins_categ'") if !$is_silent;
    } elsif($lang->{minicateg2phrases}{$ins_categ}) {
        push @$arr, grep{$_} map{_parse_multiwords($_, $lang)} keys %{$lang->{minicateg2phrases}{$ins_categ}};
    } else {
        push @$arr, grep{$_} map{$lang->phrase(_parse_multiwords($_, $lang))->snorm_phr} $lang->get_category_raw_phrases($ins_categ);
    }
}

# разваливание строки с записью атома на массив фраз
# с учётом именованных атомов
sub _parse_atom_phrases {
    my ($proj, $atom, $lang, $is_silent) = @_;
    my @arr;

    $atom =~ s/\/(\s*\/)+/\//g; # не допускаем маркеры пустых строк в середине списка

    for my $text (split "/", "$atom ") {
        $text =~ s/^(\s+)|(\s+)$//g;
        if(!$text) {
            push @arr, "";
        } elsif($text =~ /^\./) {
            my $ins_categ = $lang->category_to_ru($text);
            _parse_atom_phrases_simple($proj, $ins_categ, $lang, \@arr, $is_silent);
        } elsif($text =~ /^hier\./) {
            my $categ_name = $text;
            $categ_name =~ s/^hier//;

            my @q = ($categ_name);
            while(@q) {
                my $ins_categ = pop @q;

                _parse_atom_phrases_simple($proj, $ins_categ, $lang, \@arr, $is_silent);

                push @q, $_ for get_minicateg_children($ins_categ);
            }
        } else {
            push @arr, _parse_multiwords($text, $lang);
        }
    }

    return @arr;
}

sub search_phrase_antiwords {
    my ($self, $cat_name) = @_;

    my $antiwords_phl = $self->language->{minicateg2antiwordsphl}{$cat_name};
    return $antiwords_phl ? $antiwords_phl->search_subphrases_in_phrase($self) : [];
}

sub add_to_categ_antiwords {
    my ($self, $cat_name) = @_;
    my $antiwords_phl = $self->language->{minicateg2antiwordsphl}{$cat_name} || $self->proj->phrase_list;
    my $add_phl = $self->proj->phrase_list([ $self ]);

    $self->language->{minicateg2antiwordsphl}{$cat_name} = $antiwords_phl + $add_phl;
}

# по названию миникатегории получить ИД миникатегории
sub wget_minicateg_id {
    my ($self, $name) = @_;
    return get_minicateg_id($name);
}

# по ИД миникатегории получить название миникатегории
sub wget_minicateg_by_id {
    my ($self, $id) = @_;
    return get_minicateg_by_id($id);
}

# получить ИД родительской миникатегории (по названию миникатегории)
sub wget_minicateg_parent_id {
    my ($self, $name) = @_;
    return get_minicateg_parent_id($name);
}

# получить имя родительской миникатегории по ИД миникатегории
sub wget_minicateg_parent {
    my ($self, $name) = @_;
    return get_minicateg_parent($name);
}

# перевод названий категорий (для вызова через ProjServer)
sub category_from_ru {
    my ($self, $categ) = @_;
    return $self->language->category_from_ru($categ);
}

sub category_to_ru {
    my ($self, $categ) = @_;

    return $self->language->category_to_ru($categ);
}

# замена угловых скобок на мультислова
sub _parse_multiwords {
    my ($phrase, $lang) = @_;

    # ищем генераторы мультислов
    while($phrase =~ /\</) {
        my ($begin, $mw, $end) = $phrase =~ /([^<]*)\<([^>]*)\>(.*)/;

        if(!defined($end)) {
            $lang->proj->log("WARNING: bad phrase $phrase");
        }

        my $mw_phr = $lang->phrase($mw);
        my $mw_glued = $lang->proj->multiwords->add_phrase($mw_phr);
        if($mw_glued) {
            $lang->layer_multiwords->add_phrase($mw_phr, $mw_glued);
            $phrase = join (" ", $begin, $mw_glued, $end);
        } else {
            return "";
        }
    }

    return $phrase;
}

#снормализуем слово с отрицательным префиксом
sub _snormalize_negation {
    my ($self, $word ) = @_;
    my $prefix = "__no_";
    my ($begin, $negated) = $word =~ /^($prefix)(.*)/;
    return $word unless $begin;
    my $snorm = $self->proj->phrase($negated)->snorm_phr;
    return "$prefix$snorm";
}

#снормализация отрицательных слов во фразе
sub _snormalize_negations {
    my ($self, $text) = @_;
    return $self->proj->phrase(join ' ', map { $self->_snormalize_negation($_) } split /\s+/, "$text");
}

sub _get_atom_code {
    my ($lang, $atom) = @_;
    return sprintf "__atom_code_%s_%s", $lang->name, md5int($atom);
    #my $s = sprintf "__atom_code_%s_%s", $lang->name, md5int($atom);
    #print_err "_get_atom_code($lang, $atom) = $s";
    #return $s;
}

sub _add_siblings_cluster {
    my ($name, $cluster) = @_;
    my %h = map{$_=>1} @$cluster;

    # чистка по never_any/never_pair
    for my $categ (@$cluster) {
        if($never_any{$categ}) {
            $h{$categ} = 0;
        } elsif ($never_pair{$categ}) {
            my @bad_pairs = grep{$never_pair{$categ}{$_}} @$cluster;

            if(@bad_pairs) {
                $h{$_} = 0 for $categ, @bad_pairs;
            }
        }
    }

    my $filtered = [ grep{$h{$_}} keys %h ];

    if(@$filtered > 1) {  # нет смысла добавлять кластер из одной категории
        $siblings_groups->{$name} = $filtered;
        push @{$minicategs_siblings_info->{$_}}, [ $filtered, $name ] for @$filtered;
    }
}

sub get_norm_categ_from_text {
    my ($self) = @_;
    return norm_categ($self->text);
}

sub norm_categ {
    my ($categ) = @_;
    $categ =~ s/,/ /g;
    $categ =~ s/\s+/ /g;
    $categ =~ s/^\s+|\s+$//g;
    #$categ = lc($categ);
    return $categ;
}

sub get_normed_categ {
    my ($self, $categ) = @_;
    return norm_categ($categ);
}

# добавление атома в категорийный слой
sub _add_atom {
    my ($proj, $atom, $lang, $is_silent) = @_;

    unless($lang->atom_codes->{$atom}) {
        my $code = _get_atom_code($lang, $atom);
        my @texts = _parse_atom_phrases($proj, $atom, $lang, $is_silent);
        my @arr;

        for my $text (@texts) {
            if(!$text) {
                $empty_atoms->{$code}++;
                next;
            }
            my $pobj = $lang->phrase($text);
            $pobj = $lang->phrase(join " ", $pobj->uniqsnormwords);

            if(!$pobj->snorm_phr) {
                next;
            } else {
                push @arr, $pobj;
                ($atom_words->{$code} ||= {})->{$_}++ for $pobj->snormwords;
            }
        }

        for my $ph (@arr) {
            my $curr_data = $lang->layer_atoms->get_phrase_data($ph);
            $lang->layer_atoms->add_phrase($ph, $curr_data ? "$curr_data/$code" : $code);
        }
        $lang->atom_codes->{$atom} = $code;
        $lang->code_atoms->{$code} = "[$atom]";
    }

    return $lang->atom_codes->{$atom};
};

# преобразование строки с квадратными скобками в массив с развёрнутыми атомами
sub _expand_atoms {
    my ($proj, $ph, $lang, $is_silent) = @_;
    my $curr_text = $ph;

    my ($begin, $templ, $end) = $ph =~ /([^\[]*)\[([^\]]+)\](.*)/;

    if(grep{!defined($_)} ($begin, $templ, $end)) {
        return ( $ph );
    }

    # фраз больше 5 слов избегаем (чтобы избежать комбинаторного взрыва с пустыми атомами)
    my $curr_words = "$begin $end";
    $curr_words =~ s/\[([^\]]+)\]/ /g;
    $curr_words =~ s/\{[^\}]+\}/ W /g; # фикс для катализаторов
    my @a = $proj->phrase($curr_words)->pluswords;
    if(scalar(@a) > 4) {
        return ();
    }

    my @parsed = _parse_atom_phrases($proj, $templ, $lang, $is_silent);
    my $code = _add_atom($proj, $templ, $lang, $is_silent);
    my @result;
    push @result, _expand_atoms($proj, "$begin $code $end", $lang, $is_silent);
    push @result, _expand_atoms($proj, "$begin $end", $lang, $is_silent) if grep{!$_} @parsed;

    return @result;
}

# преобразование строки с квадратными скобками в массив с развёрнутыми атомами без кодирования атомов
# если в результате разворачивания получается более max_phrases фраз, то возвращает пустой массив
sub _expand_atoms_without_codes {
    my ($proj, $ph, $lang, $max_phrases, $is_silent) = @_;
    my @atoms = $ph =~ /\[([^\]]+)\]/g;
    my @atoms_data = map{[_parse_atom_phrases($proj, $_, $lang)]} @atoms;
    my $num_phrases = 1;
    my $const_ph = $ph;
    $const_ph =~ s/\[([^\]]+)\]/ /g;

    if(!@atoms) {
        $proj->log("WARNING: bad phrase $ph") if !$is_silent && $ph =~ /[\[\]]/;
        return ();
    }

    # вычисление количества фраз
    for my $atom (@atoms_data) {
        $num_phrases *= scalar(@$atom);
    }
    if(@atoms_data > 1 && $num_phrases > $max_phrases) {
        return ();
    }

    # разворачивание атомов
    my @inds = map{0} @atoms_data;
    my @result;
    while($inds[-1] < scalar(@{$atoms_data[-1]})) {
        push @result, join(" ", $const_ph, map{$atoms_data[$_]->[$inds[$_]]} 0..$#inds);

        for my $i (0..$#inds) {
            $inds[$i]++;

            if($inds[$i] < @{$atoms_data[$i]}) {
                last;
            } else {
                $inds[$i] = 0 if $i < $#inds;
            }
        }
    }

    return @result;
}

sub _encode_subphraser_value {
    my ($self, $categ, @antiwords) = @_;
    my $code = $categ;
    $code .= join(" ", "\@aw", map {$self->_snormalize_negation($_)} @antiwords) if @antiwords;
    return $code;
}

sub _category_from_catalyst_code {
    my ($code) = @_;
    my ($id) = $code =~ /^__categ_(.+)/;
    return get_minicateg_by_id($id) if $id;
    return "";
}

sub _category_to_catalyst_code {
    my ($categ) = @_;
    my $id = get_minicateg_id($categ);
    return "__categ_$id" if $id;
    return "";
}

sub _encode_catalyst_phrase {
    my ($proj, $phrase, $orig, $lang, @categs) = @_;

    # переводим категории, если нужно
    if(!$lang->is_default) {
        @categs = grep{$_} map{$lang->category_to_ru($_)} @categs;
    }

    my @codes;
    for my $from_categ (@categs) {
        my $code = _category_to_catalyst_code($from_categ);

        if(!$code) {
            $proj->log("WARNING: bad category '$from_categ' in '$orig'");
            return;
        } else {
            push @codes, $code;
        }
    }

    return join " ", $lang->phrase(join(" ", _parse_multiwords($phrase, $lang), @codes))->uniqsnormwords;
};

sub _parse_catalyst_phrase {
    my ($proj, $phrase, $orig, $lang) = @_;
    my @result;
    my @categs = $phrase =~ /\{([^}]+)\}/g;
    $phrase =~ s/\{([^}]+)\}/ /g;

    # разворачивание иерархии категорий
    my @hiered = grep{/^hier /} @categs;
    if(@hiered > 1) {
        $proj->log("WARNING: more than one 'hier' in phrase '$orig'");
        return;
    } elsif(@hiered == 1) {
        @categs = grep{$_ ne $hiered[0]} @categs;
        $hiered[0] =~ s/^hier\s+//;

        if(!get_minicateg_id($hiered[0])) {
            $proj->log("WARNING: unknown category '$hiered[0]' in phrase '$orig'");
            return;
        }

        my @q = ($hiered[0]);
        while(@q) {
            my $parent = pop @q;

            push @result, _encode_catalyst_phrase($proj, $phrase, $orig, $lang, $parent, @categs);

            push @q, $_ for get_minicateg_children($parent);
        }
    } else {
        push @result, _encode_catalyst_phrase($proj, $phrase, $orig, $lang, @categs);
    }

    return @result;
}

sub _add_catalyst {
    my ($proj, $phrase, $categ, $orig, $lang) = @_;

    $lang ||= $proj->default_language;
    $orig ||= $phrase;

    my @snorms = _parse_catalyst_phrase($proj, $phrase, $orig, $lang);
    for my $snorm (@snorms) {
        my $curr_data = $lang->layer_catalysts2->get_text_data($snorm);

        $lang->layer_catalysts2->set_orig_phrase($categ, $snorm, $orig);
        $lang->layer_catalysts2->add_text($snorm, $curr_data ? "$curr_data/$categ" : $categ);
    }
};

sub _load_minicategs {
    my ($class, $opt) = @_;
    my $phrases_to_expand = [];
    my $log = $opt->{logger};
    my $proj = $opt->{'proj'};
    my $is_local = !$proj->is_subphraser_used;

    # описание флагов категорий
    open F, $opt->{categs_flags} or die ("Cannot open $opt->{categs_flags} ($!)");
    $flags_description->{$_->[0]} = ($_->[1] || "") for map{chomp $_; [split "\t"]} <F>; ##no critic
    close F or die "close failed ($!)";

    # удалённые флаги
    my $deleted_flags = {};
    open F, $Utils::Common::options->{categs_deleted_flags} or die ("Cannot open ".$Utils::Common::options->{categs_deleted_flags}." ($!)");
    while(<F>) {
        chomp;
        my ($categ, $flags) = split "\t";
        $deleted_flags->{$categ} = { map{$_ => 1} grep{$_} split ",", $flags };
    }
    close F or die "close failed ($!)";

    # изменение родительских категорий
    my $parent_fix = {};
    open F, $Utils::Common::options->{categs_parents} or die ("Cannot open ".$Utils::Common::options->{categs_parents}." ($!)");
    while(<F>) {
        chomp;
        my ($categ, $pid) = split "\t";
        $parent_fix->{$categ} = $pid;
    }
    close F or die "close failed ($!)";

    # удалённые фразы
    if($is_local) {
        for my $lang ($proj->get_languages_list) {
            my $lang_name = $lang->name;
            my $source = $Utils::Common::options->{categs_web_deleted}{$lang_name};

            open F, $source or die ("Cannot open $source ($!)");
            while(<F>) {
                chomp;
                my ($categ, $phrases) = split "\t";
                $lang->set_deleted_phrase($categ, $_) for $lang->parse_phrases($phrases);
            }
            close F or die "close failed ($!)";
        }
    }

    # виртуальные категории
    open F, $opt->{categs_virtual} or die ("can't open virtual categs file $opt->{categs_virtual} ($!)");
    while(<F>) {
        chomp;
        my ($params, $name, $phrases) = split "\t";
        next if !$name;

        if($virtual2id->{$name}) {
            $log->log("WARNING: duplicate virtual categ $name");
            next;
        }

        my ($id, $flags) = split ":", $params;

        if($id2virtual->{$id}) {
            $log->log("WARNING: duplicate virtual categ id $id");
            next;
        }

        if($flags) {
            # флаги виртуальной категории
            $virtual_flags->{$name} = {};
            for my $flag (split ",", $flags) {
                if($flag =~ /^\-/) {
                    ($virtual_antiflags->{$name} ||= {})->{substr($flag, 1)}++;
                } elsif(!$flags_description->{$flag}) {
                    $log->log("WARNING: unknown flag $flag");
                } else {
                    $virtual_flags->{$name}{$flag}++;
                }
            }
        }

        $virtual2id->{$name} = $id;
        $id2virtual->{$id} = $name;
        $proj->default_language->set_virtual_translation($name, $name);

        if($is_local) {
            $proj->default_language->set_virtual_phrases($name, $phrases);
        }
    }
    close F or die "close failed ($!)";

    my $digits2categs = {};
    my $add_phrase;
    my $checked_antiwords = {};
    $add_phrase = sub {
        my ($phrase, $categ, $orig, $lang) = @_;

        $orig ||= $phrase;
        $lang ||= $proj->default_language;

        if(!$categ) {
            $log->log("WARNING: add_phrase $phrase, categ is empty");
            return;
        }
        return if !$phrase;
        return if $lang->is_phrase_deleted($categ, $orig);  # пропускаем, если фраза была удалена

        # настраиваемое преобразование фразы
        if($phrase eq $orig && $proj->{categ_phrase_transform}) {
            my $new_phr = $proj->{categ_phrase_transform}->($categ, $lang->phrase($orig));

            if($new_phr) {
                $orig = $new_phr->text;
                $phrase = $orig;
                return if !$phrase;
            } else {
                return;
            }
        }

        # проверка на совместимость с антисловами
        my $antiwordsphl = $lang->{minicateg2antiwordsphl}{$categ};
        if($antiwordsphl && $lang->is_default && !($checked_antiwords->{$categ} ||= {})->{$orig}) {
            my $phl = $antiwordsphl->search_subphrases_in_phrase($proj->phrase($orig));

            if(@$phl) {
                $log->log("WARNING: phrase '$orig' in '$categ' suffers from antiwords '".join(",", map{$_->text} @$phl)."'");
            }

            $checked_antiwords->{$categ}{$orig} = 1;
        }

        if ($phrase =~ /\[/) {
            push @$phrases_to_expand, [$phrase, $categ, $orig, $lang];
        } elsif($phrase =~ /\{/) {
            _add_catalyst($proj, $phrase, $categ, $orig, $lang);
        } else {
            my @snorms;
            my @antiwords;

            if($phrase =~ /^"[^"]+"$/) {
                # фраза в двойных кавычках
                my $pobj = $lang->phrase($phrase);
                push @snorms, $pobj->get_wholephrase_multiword;
            } else {
                $phrase = _parse_multiwords($phrase, $lang);
                return if !$phrase;

                my $pobj = $lang->phrase($phrase);
                $pobj = $pobj->_snormalize_negations($pobj);
                @antiwords = $pobj->snormminuswords; # антислова на фразу
                push @snorms, (join(" ", $pobj->uniqsnormwords));

                if($phrase =~ /хотеть_продавать/) {
                    $log->log("phrase='$phrase' pobj='$pobj' pobj->snorm_phr=" . $pobj->snorm_phr);
                    $log->log("snorms: " . join(",", @snorms));
                }
            }

            for my $snorm (grep{$_} @snorms) {
                my $layer = $lang->layer_categs;
                if($categ =~ /^\./) {
                    $layer = $lang->layer_atoms_named;
                    $lang->layer_atoms->set_orig_phrase($categ, $snorm, $orig);
                } elsif($minicategs_flags->{$categ}{dim2}) {
                    $layer = $lang->layer_dim2;
                }

                my $pobj = $lang->phrase($snorm);
                my $curr_data = $layer->get_phrase_data($pobj);
                my $code = $pobj->_encode_subphraser_value($categ, @antiwords);
                $layer->add_phrase($pobj, ($curr_data ? "$curr_data/$code" : $code));
                $layer->set_orig_phrase($categ, $snorm, $orig);

                ($minicateg2phrases->{$categ} ||= {})->{$snorm}++;
                ($lang->{minicateg2phrases}{$categ} ||= {})->{$snorm}++;

                # превращение модельных слов в конструкции с digits
                if($proj->{use_digits_layer}) {
                    my $digitized = $snorm;
                    $digitized =~ s/\b([^\d\s]{2,})\d+\b/$1_digits/g;
                    $digitized =~ s/\b\d+([^\d\s]{2,})\b/digits_$1/g;
                    if($digitized =~ /digits/ && $digitized =~ / /) {
                        my $pobj = $lang->phrase($digitized);
                        ($digits2categs->{$pobj->snorm_phr} ||= {})->{$categ}++;
                    }
                }

                # информация о словах
                for my $w (split " ", $snorm) {
                    my $real_words = $atom_words->{$w} || {map{$_ => 1} $proj->multiwords->multiword2words($w)};
                    ($minicateg2words->{$categ} ||= {})->{$_}++ for keys %$real_words;
                    ($lang->{snorm2minicategs}{$_} ||= {})->{$categ}++ for keys %$real_words;
                }
            }
        }
    };

    my $add_categ = sub {
        my ($my_id, $parent_id, $ct) = @_;

        if($parent_fix->{$ct}) {
            $parent_id = $parent_fix->{$ct};
        }

        if($tree->{$ct}) {
            $log->log("WARNING: duplicate minicateg $ct");
            return 0;
        }

        if($categid2minicateg->{$my_id}) {
            $log->log("WARNING: duplicate categ_id $my_id");
            return 0;
        }

        if(!defined($parent_id)) {
            $log->log("WARNING: bad parent_id for categ '$ct'");
            return 0;
        }

        if($parent_id eq $my_id) {
            $log->log("WARNING: minicateg $ct can't be its own parent");
            return 0;
        }

        # категория была удалена через веб-интерфейс
        if($deleted_categs->{$ct}) {
            return 0;
        }

        $tree->{$ct} = $my_id;
        $tree->{$my_id} = $parent_id;
        $minicateg2categid->{$ct} = $my_id;
        $categid2minicateg->{$my_id} = $ct;
        $minicategs_flags->{$ct} ||= {};

        for my $lang ($proj->get_languages_list) {
            $lang->set_category_translation($ct, $ct);
        }

        return 1;
    };

    my $add_categ_flags = sub {
        my ($ct, $flags) = @_;

        $flags =~ s/\s//g if $flags;
        if ($flags) {
            for my $flag (grep{!($deleted_flags->{$ct} || {})->{$_}} split ",", $flags) {
                my $h = ($flag =~ s/^\-//g) ? $minicategs_not_flags : $minicategs_flags;
                ($h->{$ct} ||= {})->{$flag}++;
            }

            $log->log("WARNING: unknown minicateg flag $_")
                for grep{!$flags_description->{$_} && !/^\_/} keys %{$minicategs_flags->{$ct}};
        }
    };

    # категории, которые были удалены через веб-интерфейс
    open F, $Utils::Common::options->{categs_deleted} or die ("Cannot open ".$Utils::Common::options->{categs_deleted}." ($!)");
    while(<F>) {
        chomp;
        my ($categ) = split "\t";
        $deleted_categs->{$categ}++;
    }
    close F or die "close failed ($!)";

    # категории из именованных атомов
    for my $lang ($proj->default_language, grep{!$_->is_default} $proj->get_languages_list) {
        for my $atom ($lang->get_atoms_list) {
            # для русскоязычного атома создаём новую категорию,
            # а для остальных языков -- задаём перевод существующей категории
            if($lang->is_default) {
                $add_categ->($atom->id, $atom->parent_id, $atom->name);
            } else {
                my $curr_id = get_minicateg_id($atom->ru_name);

                # при необходимости создаём фейковую категорию, переводом которого является данный атом
                $add_categ->($atom->id . "__for__" . $lang->name, "abase", $atom->ru_name) if !$curr_id;

                $lang->set_category_translation($atom->ru_name, $atom->name);
            }

            if($is_local) {
                $add_phrase->($_->text, $atom->ru_name, $_->text, $lang) for $atom->phrase_list->phrases;
            }
        }
    }

    # описание категорий
    $log->log('minicategs');
    my $last_categ = "";
    my $add_categ2phrases = {};
    open(FC, $opt->{'minicategs'}) or die ("$!");
    while(my $str = <FC>){
        next if $str =~ /^\#/;
        chomp $str;
        next if not $str;

        # информация о виртуальной категории
        if($str =~ /^\*/) {
            next if !$use_virtual_categs || $deleted_categs->{$last_categ};

            my ($marker, $name, $phrases) = split "\t", $str;

            if(!$virtual2id->{$name}) {
                $log->log("WARNING: unknown virtual categ $name");
                next;
            }

            ((($str =~ /^\*\-/) ? $virtual_del : $virtual_add)->{$last_categ} ||= {})->{$name} = [split(",", $is_local ? ($phrases || "") : "")];

            # флаги виртуальной категории
            my ($flags) = ($marker =~ /:(.+)\s*/);
            ($virtual_add_flags->{$last_categ} ||= {})->{$name} = $flags if $flags;

            next;
        }

        my ($my_id, $info, $ct, $phrases) = split("\t", $str);
        $phrases ||= "---";
        if(!$my_id || $info eq "" || !$ct) {
            $log->log("WARNING: bad minicateg line $str");
            next;
        }

        # запоминаем текущую категорию (для последующего добавления вирт. категорий)
        $last_categ = $ct;

        my ($parent_id, $flags) = split ":", $info;

        next if !$add_categ->($my_id, $parent_id, $ct);
        $add_categ_flags->($ct, $flags);

        # парсинг фраз (если нужно)
        if($is_local) {
            $add_categ2phrases->{$ct} = $phrases;
        }
    }
    close(FC) or die "close failed ($!)";

    # дополнительные флаги
    open F, $Utils::Common::options->{categs_add_flags} or die ("$!");
    while(<F>) {
        chomp;
        my ($categ, $flags) = split "\t";

        if(!$minicateg2categid->{$categ} && $categ !~ / _ /) {
#            $log->log("WARNING: unknown category '$categ' in the flags file");
        } else {
            $add_categ_flags->($categ, $flags);
        }
    }
    close F or die "close failed ($!)";

    # привязка виртуальных категорий
    open F, $Utils::Common::options->{categs_virtual_gen} or die ("can't open virtual_gen ($!)");
    while(<F>) {
        chomp;
        my ($categ, $virt, $cmd) = split "\t";

        if(!$virtual2id->{$virt}) {
            $log->log("WARNING: unknown virtual categ '$virt' in virtual-gen");
            next;
        }

        if(!$minicateg2categid->{$categ}) {
            $log->log("WARNING: unknown categ '$categ' in virtual-gen");
            next;
        }

        if($cmd eq "add") {
            # применить $virt к $categ и всем её потомкам
            ($virtual_add->{$categ} ||= {})->{$virt} = [];
        } elsif($cmd eq "add_once") {
            # применить $virt к $categ
            ($virtual_add_once->{$categ} ||= {})->{$virt} = [];
        } elsif($cmd eq "delete") {
            # снять $virt с $categ и её потомков
            ($virtual_del->{$categ} ||= {})->{$virt} = [];
        } else {
            $log->log("WARNING: unknown command '$cmd' in virtual-gen");
        }
    }
    close F or die "close failed ($!)";

    # создание виртуальных категорий
    $log->log("virtual categs");
    my @curr_categs = keys %$minicateg2categid;
    for my $categ (@curr_categs) {
        my @parents;
        for(my $par = $categ; $par; $par = get_minicateg_parent($par)) {
            push @parents, $par;
        }

        # прослеживание меток/антиметок по цепочке родителей
        my $virth = {};
        my $flagsh = {};
        my $has_virt_parent = {};
        for my $par (reverse @parents) {
            for my $vc (keys %{$virtual_add->{$par}}) {
                $virth->{$vc} = $virtual_add->{$par}{$vc};

                # дополнительные флаги
                my $flags = ($virtual_add_flags->{$par} || {} )->{$vc};
                $flagsh->{$vc} = $flags if $flags;
            }

            for my $vc (grep{$virth->{$_}} keys %{$virtual_del->{$par}}) {
                delete $has_virt_parent->{$vc};
                delete $virth->{$vc};
            }

            # проверка флага virtparent
            for my $vc (keys %$virth) {
                if(get_minicateg_flags("$vc _ $par")->{virtparent}) {
                    $has_virt_parent->{$vc} = $par;
                }
            }
        }

        # виртуальные категории, добавленные без иерархии
        $virth->{$_} = $virtual_add_once->{$categ}{$_} for keys %{$virtual_add_once->{$categ} || {}};

        for my $name (keys %$virth) {
            my $categ_id = $minicateg2categid->{$categ};
            my $parent_id = get_minicateg_parent_id($categ);
            my $new_id = $virtual2id->{$name}.$categ_id;
            my $new_name = "$name _ $categ";

            # если где-то у предков был флаг virtparent, то наследуемся от виртуалки родителя
            if($has_virt_parent->{$name}) {
                my $new_parent_id = $virtual2id->{$name}.$parent_id;
                $parent_id = $new_parent_id if get_minicateg_by_id($new_parent_id);
            }

            next if !$add_categ->($new_id, $parent_id, $new_name);

            ($minicategs_nephews->{$new_name} ||= {})->{$categ}++;
            ($minicategs_flags->{$new_name} ||= {})->{$_}++
                for grep{$_ &&
                        !($deleted_flags->{$new_name} || {})->{$_} &&  # не добавляем удалённые флаги
                        !($virtual_antiflags->{$name} || {})->{$_}} (  # не добавляем антифлаги
                    keys %{$virtual_flags->{$name} || {}},      # флаги шаблона виртуальной категории
                    keys %{$minicategs_flags->{$categ} || {}},  # флаги самой категории
                    split(",", ($flagsh->{$name} || ""))        # флаги конкретной реализации виртуальной категории
                );

            if($is_local) {
                for my $ph ($proj->default_language->get_virtual_phrases($name)) {
                    # пустые фразы пропускаем
                    next if !$proj->phrase($ph)->snorm_phr;

                    $add_phrase->("$ph {$categ}", $new_name, "$ph {$categ}");
                }

                # дополнительные фразы для конкретной реализации виртуальной категории
                if($virtual_add->{$categ}) {
                    $add_phrase->($_, $new_name, $_) for @{$virtual_add->{$categ}{$name} || []};
                }
            }

            # запоминаем, какие категории были созданы
            ($virtual2instances->{$name} ||= {})->{$categ} = $new_name;

            # при наличии флага twin создаём кластер сиблингов
            if(($virtual_flags->{$name} || {})->{twin}) {
                _add_siblings_cluster("TWIN $new_name", [$categ, $new_name]);
            }

            # при наличии флага uncle прописываем связь uncle-nephew
            if(($virtual_flags->{$name} || {})->{uncle}) {
                ($minicategs_nephews->{$categ} ||= {})->{$new_name}++;
            }

        }
    }
    $log->log("/ virtual categs");

    # антислова для категорий
    $log->log("categs antiwords");
    for my $lang ($proj->get_languages_list) {
        my $lang_name = $lang->name;
        my $source = $Utils::Common::options->{categs_antiwords}{$lang_name};

        open F2, $source or die ("can't open $source ($!)");
        while(<F2>) {
            chomp;
            my ($ct, $words) = split "\t";

            if(!get_minicateg_id($ct)) {
                $log->log("WARNING: unknown category $ct in '$source'");
            } else {
                for my $p (map{$proj->phrase($_)} split ",", $words) {
                    my @syns = snorm2allsyns($p->snorm_phr);
                    for my $syn (@syns) {
                        ($lang->{minicategs_antiwords}{$syn} ||= {})->{$ct}++;
                        ($lang->{minicateg2antiwords}{$ct} ||= {})->{$syn}++;
                    }
                }
            }
        }
        close F2 or die "close failed ($!)";
        for my $ct (keys %{$lang->{minicateg2antiwords}}) {
            $lang->{minicateg2antiwordsphl}{$ct} = $proj->phrase_list({ phrases_arr => [keys %{$lang->{minicateg2antiwords}{$ct}}] });
        }
    }
    $log->log("/categs antiwords");

    # отношения между категориями
    $log->log("categs hier");
    _init_minicategs_hier($opt);
    $log->log("/categs hier");

    # парсинг фраз (если нужно)
    if($is_local) {
        for my $ct (keys %$add_categ2phrases) {
            my $phrases = $add_categ2phrases->{$ct};
            $add_phrase->($_, $ct, $_) for $proj->default_language->parse_phrases($phrases);
        }
    }

    # версии категорий для разных языков
    for my $lang ($proj->get_languages_list) {
        my $lang_name = $lang->name;
        my $source = $Utils::Common::options->{categs_languages}{$lang_name};

        if(!$source) {
            next;
        }

        $proj->log("loading $lang_name categs");

        # категории
        my $phrases_to_add = {};
        open FL, $source or die ("can't open $source for reading ($!)");
        while(<FL>) {
            chomp;
            my @a = split "\t";
            if(@a != 5 && @a != 4) {
                $proj->log("WARNING: line starting with $a[0] has ".scalar(@a)." fields ($lang_name)");
            }

            my ($id, $parent_id, $ru_name, $name, $phrases) = split "\t";

            next if $deleted_categs->{$ru_name};

            $phrases ||= "";

            my $curr_id = get_minicateg_id($ru_name);
            my $parent = get_minicateg_parent($ru_name);
            my $curr_parent_id = $parent ? get_minicateg_id($parent) : 0;

            if(!$curr_id) {
                $proj->log("WARNING: unknown categ '$ru_name' in $source");
                next;
            }

            $lang->set_category_translation($ru_name, $name);

            if($is_local) {
                $phrases_to_add->{$ru_name} = $phrases;
            }
        }
        close FL or die "close failed ($!)";

        # загружаем фразы
        if($is_local) {
            for my $ru_name (keys %$phrases_to_add) {
                $add_phrase->($_, $ru_name, $_, $lang) for $lang->parse_phrases($phrases_to_add->{$ru_name});
            }
        }

        # виртуальные категории
        if($Utils::Common::options->{categs_virtual_languages}{$lang_name}) {
            open FL, $Utils::Common::options->{categs_virtual_languages}{$lang_name} or die ("$!");
            while(<FL>) {
                chomp;
                my @a = split "\t";

                my ($id, $ru_name, $name, $phrases) = @a;

                # проверки
                if(($id2virtual->{$id} || "") ne $ru_name || ($virtual2id->{$ru_name} || "") ne $id) {
                    $proj->log("WARNING: bad virtual categ $id $ru_name");
                    next;
                }

                $lang->set_virtual_translation($ru_name, $name);

                if($is_local) {
                    $lang->set_virtual_phrases($ru_name, $phrases);
                }

                my $h = $virtual2instances->{$ru_name} || {};
                for my $ru_categ (keys %$h) {
                    my $tr_categ = $lang->category_from_ru($ru_categ);

                    # виртуальные категории применяются только для переведённых категорий
                    if(!$lang->has_category($ru_categ)) {
                        next;
                    }

                    # перевод названия новой категории
                    $lang->set_category_translation(
                        $h->{$ru_categ},
                        "$tr_categ _ $name"
                    );

                    # фразы
                    if($is_local) {
                        for my $ph ($lang->get_virtual_phrases($ru_name)) {
                            next if $ph =~ /^\s*$/;
                            my $new_ph  = "$ph {$tr_categ}";
                            $add_phrase->($new_ph, $h->{$ru_categ}, $new_ph, $lang);
                        }
                    }
                }
            }
            close FL or die "close failed ($!)";
        }

        # источники дополнительных фраз
        next if !$is_local;

        my @add_files = (
            { file => $proj->{options}{ModelsCategories_params}{categs_file}, remove_phrases_with_stopwords => 1 },
            { file => $proj->{options}{categs_web}{$lang_name}, },
        );

        my $lang_caddphrs_arr = ($proj->{lang_caddphrs} || {})->{$lang_name};
        if($lang_caddphrs_arr) {
            $log->log(scalar(@$lang_caddphrs_arr)." additional files for $lang_name categs");
            push @add_files, map {{ file => $_ }} @$lang_caddphrs_arr;
        }

        my $fn_add = $lang_caddphrs{$lang_name};
        push @add_files, map {{ file => $_ }} ($fn_add)   if $fn_add;

        for my $add_file (grep{$_->{file}} @add_files) {
            my $fn = $add_file->{file};
            $log->log("add_file: $fn " . ($add_file->{remove_phrases_with_stopwords} // 0));
            if(open FL, $fn) {
                while(<FL>) {
                    chomp;
                    my ($ru_name, $phrases) = split "\t";
                    if(!get_minicateg_id($ru_name)) {
                        $proj->log("WARNING: unknown categ '$ru_name' in $fn");
                        next;
                    }

                    my @parsed = $lang->parse_phrases($phrases);
                    if ($add_file->{remove_phrases_with_stopwords}) {
                        @parsed = grep { not $lang->phrase($_)->has_stopwords } @parsed;
                    }
                    $add_phrase->($_, $ru_name, $_, $lang) for @parsed;
                }
                close FL or die "close failed ($!)";
            } else {
                die ("can't open $fn for reading ($!)");
            }
        }
    }

    # для локальной версии категорий -- дополнительные источники фраз
    if($is_local) {

        # TODO не используется, удалить ?
        # слой моделей
        if($proj->{models_layer}) {
            $layer_models = $proj->create_layer(name => "models");
            open FC, $proj->{models_layer} or die ("$!");
            while(<FC>) {
                chomp;
                my ($ct, $phrs) = split "\t";

                next if !$phrs;

                if (!$minicateg2categid->{$ct}) {
                    $log->log("WARNING: bad categ $ct in the uncertain categs file");
                    next;
                }

                for my $orig ($proj->default_language->parse_phrases($phrs)) {
                    my $ph = $proj->phrase(_parse_multiwords($orig, $proj->default_language));
                    next if !$ph->snorm_phr;
                    my $curr_data = $layer_models->get_phrase_data($ph);
                    $layer_models->set_orig_phrase($ct, $ph->snorm_phr, $orig);
                    $layer_models->add_phrase($ph, ($curr_data ? "$curr_data/$ct" : $ct));
                }
            }
            close FC or die "close failed ($!)";
            $layer_models->prepare;
        }

        # дополнительные фразы для категорий
        my @caddphr_files = ($opt->{categs_addphr}, $proj->options->{categs_web}{ru}, $Utils::Common::options->{MoviesCategories_params}{categs_file});
        if($proj->{caddphrs}) {
            $log->log(scalar(@{$proj->{caddphrs}})." additional files for categs");
            push @caddphr_files, @{$proj->{caddphrs}};
        }
        for my $fn (@caddphr_files) {
            open(FC, $fn) or die ("can't open $fn for reading ($!)");
            while(my $str = <FC>){
                next if $str =~ /^\#/;
                chomp $str;
                my @a = split("\t", $str);

                next if scalar @a < 2;
                if (@a > 2 || (!$tree->{$a[0]} && !$deleted_categs->{$a[0]})) {
                    my $errtype = scalar @a > 2 ? "too many fields ".@a : "can't find categ";
                    $log->log("WARNING: file [$fn] error [$errtype] bad line in minicategs file near [".$a[0]."]");
                    next;
                }
                $add_phrase->($_, $a[0], $_) for $proj->default_language->parse_phrases($a[1]);
            }
            close(FC) or die "close failed ($!)";
        }

        # сомнительные фразы для категорий
        my @unc;
        open(FC, $opt->{'categs_uncertain'}) or die ("Cannot open $opt->{categs_uncertain} ($!)");
        while(<FC>){
            chomp;
            my ($ct, $phrs) = split "\t";

            next if !$phrs;

            if (!$minicateg2categid->{$ct}) {
                $log->log("WARNING: bad categ $ct in the uncertain categs file");
                next;
            }

            for my $ph (grep{$_->snorm_phr} map{$proj->phrase($_)} $proj->default_language->parse_phrases($phrs)) {
                my $curr_data = $proj->default_language->layer_uncertain->get_phrase_data($ph);
                $proj->default_language->layer_uncertain->add_phrase($ph, ($curr_data ? "$curr_data/$ct" : $ct));
            }
        }
        close(FC) or die "close failed ($!)";

        # фразы атомов добавляем в первую очередь
        @$phrases_to_expand = sort{($a->[1] =~ /^\./) ? -1 : (($b->[1] =~ /^\./) ? 1 : 0)} @$phrases_to_expand;

        # разворачиваем фразы с шаблонами
        my $big_atoms = [];
        for my $phr_data (@$phrases_to_expand) {
            my ($ph, $categ, $orig, $lang) = @$phr_data;
            my $is_expanded = 0;

            # не разворачиваем именованные атомы, если установлен соответствующий флаг
            if(!$proj->{dont_expand_atoms} || $ph !~ /\./) {
                my @expanded = _expand_atoms_without_codes($proj, $ph, $lang, 1000);

                # не разворачиваем, если получается слишком много фраз
                if(@expanded) {
                    $add_phrase->($_, $categ, $orig, $lang) for @expanded;
                    next;
                }
            }

            push @$big_atoms, [$ph, $categ, $orig, $lang];
        }
        $phrases_to_expand = $big_atoms;
        while (@$phrases_to_expand) {
            my ($ph, $categ, $orig, $lang) = @{pop @$phrases_to_expand};
            my @expanded = _expand_atoms($proj, $ph, $lang);

            for my $snorm (@expanded) {
                if($snorm =~ /\[|\]/) {
                    $log->log("WARNING: bad atom phrase '$orig' in categ '$categ'");
                    next;
                }

                $add_phrase->($snorm, $categ, $orig, $lang);
            }
        }

        # генерируемые словари категорий
        $log->log("gen-dicts categs");
        for my $fn (
            $proj->{options}{ModelsCategories_params}{categs_file},
        ) {
            if(open(F, $fn)) {
                while (<F>) {
                    chomp;
                    my ($ct, $phrases) = split "\t";
                    next if !get_minicateg_id($ct);
                    $add_phrase->($_, $ct) for $proj->default_language->parse_phrases($phrases);
                }
                close F or die "close failed ($!)";
            } else {
                die ("can't open $fn ($!)");
            }
        }
        $log->log("/ gen-dicts categs");
    }

    # слой с цифровыми фразами
    if($proj->{use_digits_layer}) {
        $layer_digits = $proj->create_layer(name => "digits");
        for my $snorm (sort keys %$digits2categs) {
            my @cts = keys %{$digits2categs->{$snorm}};
            next if @cts != 1;

            my $code = $cts[0];
            my $pobj = $proj->phrase($snorm);
            $layer_digits->add_phrase($pobj, $code);
        }
        $layer_digits->prepare;
    }

    for my $lang ($proj->get_languages_list) {
        $lang->prepare_layers;
    }

    for my $cct (keys %$minicateg2categid){
        for my $lang_name ('ru', keys %{$Utils::Common::options->{categs_languages}}) {
            my $source = $Utils::Common::options->{categs_languages}{$lang_name};
            my $lang = $proj->languages->{$lang_name};
            next unless $lang;
            my $ct = $lang->category_from_ru($cct);
#            my $ct = $cct;
            my $tct = norm_categ( $ct );
            $normcateg2minicateg->{$tct} = $ct;
            $minicateg2normcateg->{$ct} = $tct;
            $ct =~ s/\s+$//;
            $minicateg2normcateg->{$ct} = $tct; #Есть проблема с названиями категорий, у которых пробелы на конце
        }
    }
    $log->log('/ minicategs');
}


########################################################
#Методы
########################################################

sub normcateg2categ {
    my ($self) = @_;
    return $self->proj->categs_tree->get_minicateg_by_norm(norm_categ("$self"));
}

sub do_categs_method {
    my ($self, $mth, @prms) = @_;
    no strict 'refs';
    return $mth->(@prms);
}

sub add_to_subphraser {
    my ($self, $data, $layer_name, %opts) = @_;

    $layer_name ||= "categs";

    # убираем html-форматирование
    my $clean_text = $self->text;
    $clean_text =~ s/\&lt;/</g;
    $clean_text =~ s/\&gt;/>/g;
    $clean_text =~ s/\&quot;/"/g;

    # мультислова
    my $text = $clean_text;
    if($text =~ /^"[^"]+"$/) {
        # фраза в двойных кавычках
        $text = $self->get_wholephrase_multiword;
    } else {
        $text = _parse_multiwords($text, $self->language);
    }

    # атомы
    my @expanded = _expand_atoms($self->proj, $text, $self->language, 1);
    my $layer = $self->language->{"layer_$layer_name"};
    for my $final_text (@expanded) {
        $final_text = $self->proj->phrase($final_text)->snorm_phr;

        # если фразу нужно удалить из категории, то проверяем, не образуется ли такой же снорм другими фразами
        if($opts{del_orig_categ}) {
            my $curr_orig = $layer->get_orig_phrases($opts{del_orig_categ}, $final_text);

            $layer->remove_orig_phrase($opts{del_orig_categ}, $final_text, $clean_text);

            if(grep{$_ ne $clean_text} @$curr_orig) {
                next; # есть другие версии этого снорма -- не удаляем его
            }
        }

        $layer->add_phrase($self->language->phrase($final_text), $data);
        $layer->set_orig_phrase($opts{set_orig_categ}, $final_text, $clean_text) if $opts{set_orig_categ};
    }
}

sub update_subphraser {
    my ($self, $categ, $is_add) = @_;
    my @layers_codes;

    if($categ =~ /^\./) {
        @layers_codes = (
            ["atoms_named", $self->_encode_subphraser_value($categ, $self->snormminuswords)],
            ["atoms", _get_atom_code($self->language, $categ)]
        );
        my $current_category = $categ;
        while ($current_category) {
            push @layers_codes, (['atoms', _get_atom_code($self->language, "hier$current_category")]);
            $current_category = get_minicateg_parent($current_category);
        }
    } elsif($self->text =~ /\{/) {
        @layers_codes = (["catalysts2", $categ]);
    } else {
        @layers_codes = (["categs", $self->_encode_subphraser_value($categ, $self->snormminuswords)]);
    }

    # убираем html-форматирование
    my $clean_text = $self->text;
    $clean_text =~ s/\&lt;/</g;
    $clean_text =~ s/\&gt;/>/g;
    $clean_text =~ s/\&quot;/"/g;

    my $text = $clean_text;
    #$self->log("update_subphraser: $is_add '$categ' '$text'");
    if($text =~ /^"[^"]+"$/) {
        # фраза в двойных кавычках
        $text = $self->get_wholephrase_multiword;
    }

    # атомы
    my @expanded = _expand_atoms($self->proj, $text, $self->language, 1);
    push @expanded, _expand_atoms_without_codes($self->proj, $text, $self->language, 1000, 1);

    # катализаторы
    my @expanded_final = ();
    for my $text (@expanded) {
        if($text =~ /\{/) {
            my @snorms = _parse_catalyst_phrase($self->proj, $text, $clean_text, $self->language);
            push @expanded_final, @snorms;
        } else {
            push @expanded_final, $text;
        }
    }

    # мультислова
    @expanded_final = map{_parse_multiwords($_, $self->language)} @expanded_final;

    #отрицательные слова
    @expanded_final = map { $self->_snormalize_negations($_) } @expanded_final;

    for my $final_text (@expanded_final) {
        $final_text = $self->proj->phrase($final_text)->snorm_phr;

        for my $layer_code (@layers_codes) {
            my ($layer_name, $categ_code) = @$layer_code;
            my $layer = $self->language->{"layer_$layer_name"};

            # если фразу нужно удалить из категории, то проверяем, не образуется ли такой же снорм другими фразами
            if(!$is_add) {
                my $curr_orig = $layer->get_orig_phrases($categ, $final_text);

                $layer->remove_orig_phrase($categ, $final_text, $clean_text);

                if(grep{$_ ne $clean_text} @$curr_orig) {
                    $self->log("WARN: update_subphraser: Do not delete. clean_text: '$clean_text', curr_orig: " . join(", ", @$curr_orig));
                    next; # есть другие версии этого снорма -- не удаляем его
                }
            }

            my %curr_categs = map{$_ => 1} grep{$_} split "/", ($self->language->{"layer_$layer_name"}->get_phrase_data($self) || "");
            if($is_add) {
                $curr_categs{$categ_code}++;
            } else {
                $self->log("WARN: update_subphraser: no categ, curr_categs: " . join("/", sort keys %curr_categs))  unless $curr_categs{$categ_code};
                delete $curr_categs{$categ_code} if $curr_categs{$categ_code};
            }

            $layer->add_phrase($self->language->phrase($final_text), join("/", keys %curr_categs));
            $layer->set_orig_phrase($categ, $final_text, $clean_text) if $is_add;
        }
    }
}

sub add_subphraser_category {
    my ($self, $categ) = @_;

    return if !$categ;

    $self->update_subphraser($categ, 1);
}

sub delete_subphraser_category {
    my ($self, $categ) = @_;

    return if !$categ;

    $self->update_subphraser($categ, 0);
}

sub generate_minuswords :CACHE {
    my ($self) = @_;
    return keys %{$phrase_minuswords->{$self->snorm_phr} || {}};
}

sub get_wholephrase_multiword {
    my ($self) = @_;
    return $self->proj->multiwords->words2multiword("wholephrase", sort $self->normwords);
}

sub get_search_categs_minuswords_light {
    my ($self, @bcts) = @_;
    @bcts = $self->get_minicategs_rltd unless @bcts;
    return () unless @bcts;
    my $h = $self->get_search_tail;
    my @tls = grep { $h->{$_} > 10 } keys %$h;
    return () unless %$h;
    my $w2ph = {}; #Хэш соответствия слова из хвостика и фразы с добавлением этого слова
    for my $w (@tls){
        $w2ph->{$w} = $self->proj->phrase("$self $w");
    }
    my $addphl = $self->proj->phrase_list([ values %$w2ph ]);
    $addphl->cache_cdict_minicategs unless $never_read_categs_cache; #Кэшируем категоризацию

    my %cth = map {$_ => 1} @bcts; #get_minicategs_subtrees(@bcts);
    my @bad = ();
    for my $w (@tls){
        my $sph = $w2ph->{$w};
        my @badctgs = grep{ ! $cth{$_} } $sph->get_minicategs; #Категории, которых нет в разрешенном списке
        #$self->proj->dd([$self.' -> '.$w, \@badctgs, [ $sph->get_minicategs ]]) if @badctgs;
        push(@{$self->{_minuswords_log_data}||=[]}, [$sph->text, \@badctgs]) if $self->{_minuswords_log} && @badctgs;
        push(@bad, $w) if @badctgs;
    }
    #$self->proj->dd(\@bad);
    return @bad;
}

sub add_search_categs_minuswords {
    my ($self) = @_;
    return $self->proj->phrase( $self.join("", map {" -$_"}  $self->get_search_categs_minuswords_light)  );
}

sub add_search_categs_minuswords_without_cache {
    my ($self, @bcts) = @_; #Может быть передан внешний хэш категорий для фильтрации
    my $prev = $never_read_categs_cache; #Сохраняем предыдущее значение параметра
    $never_read_categs_cache = 1;
    my $res = $self->proj->phrase( $self.join("", map {" -$_"}  $self->get_search_categs_minuswords_light(@bcts))  );
    $never_read_categs_cache = $prev; #Возвращаем предыдущее значение параметра
    return $res;
}

sub get_search_categs_minuswords_strict { #Минусуем только пропадание изначальной категории
    my ($self, @bcts) = @_;
    @bcts = $self->get_minicategs_rltd unless @bcts;
    return () unless @bcts;

    my %cth = map {$_ => 1} @bcts; #get_minicategs_subtrees(@bcts);
    $cth{$_} = 1 for $self->get_minicategs; #Не фильтруем исходные категории фразы

    if($self->{tail2categs}){ #Специальный вариант кэширования данный в CDICT'е
        my @bad = ();
        for my $w (keys %{$self->{tail2categs}}){
            my @arr = @{$self->{tail2categs}{$w}};
            next unless @arr;
            my @goodctgs = grep{ $cth{$_} } @arr; #Категории, которые есть в разрешенном списке
            next if @goodctgs;
#$self->proj->dd('WWWWW', \@arr, \@goodctgs, $self->{tail2categs}{$w});
#$self->proj->dd('WWWW', $self, $w, \@arr, \%cth);
            push(@bad, $w);
        }
#$self->proj->dd('WWWW2', $self, \@bcts, $self->{tail2categs}, \@bad);
        return @bad;
    }

    my $h = $self->get_search_tail;
    my @tls = grep { $h->{$_} > 10 } keys %$h;
    return () unless %$h;
    my $w2ph = {}; #Хэш соответствия слова из хвостика и фразы с добавлением этого слова
    for my $w (@tls){
        $w2ph->{$w} = $self->proj->phrase("$self $w");
    }
    my $addphl = $self->proj->phrase_list([ values %$w2ph ]);
    #$addphl->cache_cdict_minicategs unless $never_read_categs_cache; #Кэшируем категоризацию

    my @bad = ();
    for my $w (@tls){
        my $sph = $w2ph->{$w};
        my @badctgs = grep{ ! $cth{$_} } $sph->get_minicategs; #Категории, которых нет в разрешенном списке
        my @goodctgs = grep{ $cth{$_} } $sph->get_minicategs; #Категории, которые есть в разрешенном списке
        next if @goodctgs;
        #$self->proj->dd(['QQQQQQQ', $self.' -> '.$w, \@badctgs, [ $sph->get_minicategs ], \%cth]) if @badctgs;
        push(@{$self->{_minuswords_log_data}||=[]}, [$sph->text, \@badctgs]) if $self->{_minuswords_log} && @badctgs;
        push(@bad, $w) if @badctgs;
    }
    #$self->proj->dd(\@bad);
    return @bad;
}

sub add_search_categs_minuswords_without_cache_strict { #Учитываем только пропадание родной категории
    my ($self, @bcts) = @_; #Может быть передан внешний хэш категорий для фильтрации
    my $prev = $never_read_categs_cache; #Сохраняем предыдущее значение параметра
    $never_read_categs_cache = 1;
    my $res = $self->proj->phrase( $self.join("", map {" -$_"}  $self->get_search_categs_minuswords_strict(@bcts))  );
    $never_read_categs_cache = $prev; #Возвращаем предыдущее значение параметра
    return $res;
}

sub add_search_categs_minuswords_strict { #Учитываем только пропадание родной категории
    my ($self, $bcts) = @_; #Может быть передан внешний хэш категорий для фильтрации
    my $res = $self->proj->phrase( $self.join("", map {" -$_"}  $self->get_search_categs_minuswords_strict(@{$bcts || []}))  );
    return $res;
}

sub get_minicateg_by_norm {
    my ($categ) = @_;
    return $normcateg2minicateg->{$categ};
}

sub get_minicateg_id {
    my ($categ) = @_;
    return $minicateg2categid->{$categ};
}

sub get_minicateg_by_id {
    my ($categ_id) = @_;
    return defined($categ_id) ? $categid2minicateg->{$categ_id} : '';
}

my $marker_atoms_hash;
sub marker_atoms_hash {
    unless ( defined $marker_atoms_hash ) {
        $marker_atoms_hash = { map { $categid2minicateg->{$_} => 1 } grep { $_ =~ /^amarker/ } keys %$categid2minicateg };
    }
    return $marker_atoms_hash;
}

sub get_virtual_categs_list {
    return sort keys %$virtual2id;
}

sub get_virtual_categ_flags {
    return sort keys %{$virtual_flags->{$_[0]}};
}

sub get_virtual_categ_id {
    my ($categ) = @_;

    return $virtual2id->{$categ};
}

sub get_virtual_categ_by_id {
    my ($id) = @_;
    return $id2virtual->{$id};
}

sub get_minicateg_directid {
    my ($categ) = @_;
    my $id = $minicateg2directid->{$categ};
    $id = $minicateg2directid->{"$categ "} if !defined($id); #TODO: вынуть костыль
    return $id;
}

sub get_videodirectgroup_directid {
    my ($vdgroup) = @_;
    my $id = $videodirectgroup2directid->{$vdgroup};
    $id = $videodirectgroup2directid->{"$vdgroup "} if !defined($id); #TODO: вынуть костыль
    return $id;
}


sub get_minicateg_by_directid {
    my ($categ_id) = @_;
    return $directid2minicateg->{$categ_id};
}

sub get_minicateg_directid_by_catid {
    my ($catid) = @_;
    my $categ = $categid2minicateg->{$catid};
    my $id = $minicateg2directid->{$categ};
    return $id;
}

sub get_minicateg_parent_id {
    my ($categ) = @_;

    return undef if !$tree->{$categ};

    return $tree->{$tree->{$categ}} || 0;
}

sub get_minicateg_parent {
    my ($categ) = @_;

    return undef if !$tree->{$categ};

    my $parent_id = $tree->{$tree->{$categ}};
    return 0 unless $parent_id;
    return $categid2minicateg->{$parent_id};
}

sub up_minicateg {
    my ($categ) = @_;
    my $parent;

    for($parent = $categ; check_minicategs_flag($parent, "up"); $parent = get_minicateg_parent($parent)) {}

    return $parent;
}

sub get_minicateg_children {
    my ($categ) = @_;
    return @{$minicateg2children->{$categ} || []};
}

sub _get_minicategs_subtree {
    my $ctg = shift;
    if (!$cache_get_minicategs_subtree->{$ctg}) {
        my %result;
        my @q = ($ctg);
        while(@q) {
            my $parent = pop @q;
            $result{$parent} = 1;
            push @q, $_ for get_minicateg_children($parent);
        }
        $cache_get_minicategs_subtree->{$ctg} = [ sort keys %result ];
    }
    return @{$cache_get_minicategs_subtree->{$ctg}};
}

sub get_minicategs_subtrees {
    my %result = map { $_ => 1 } map { _get_minicategs_subtree($_) } uniq(@_);
    return sort keys %result;
}

sub get_minicategs_list {
    return keys %$minicateg2categid;
}

# NB: устарело, следует пользоваться объектом Language
sub get_minicateg_phrases {
    my ($categ) = @_;
    return keys %{$minicateg2phrases->{$categ}};
}

sub get_minicateg_words {
    my ($categ) = @_;
    return keys %{$minicateg2words->{$categ}};
}

sub get_minicateg_wordshash {
    my ($categ) = @_;
    return $minicateg2words->{$categ};
}


# по списку категорий выдаёт href { sibl => info }
sub get_minicategs_siblings_info {
    my @ctg = @_;
    my %info;
    for my $ctg (@ctg) {
        for my $h (@{$minicategs_siblings_info->{$ctg} // []}) {
            my ($cluster, $name) = @$h;
            $info{$_} = $name for @$cluster;
        }
    }
    return \%info;
}

sub get_minicateg_siblings {
    return get_minicategs_siblings(@_);
}
sub get_minicategs_siblings {
    return sort keys %{get_minicategs_siblings_info(@_)};
}

sub get_siblings_hash {
    return $siblings_groups;
}

sub get_minicateg_nephews {
    my ($categ) = @_;
    return sort keys %{$minicategs_nephews->{$categ} || {}};
}

sub get_image_nephews {
    my ($cat_name) = shift;
    return keys %{$minicategs_nephews->{$cat_name}};
}

sub get_domain_nephews {
    my ($cat_name) = shift;
    my @domain_nephews = ();
    for my $domain (keys %$minicategs_nephews) {
        push @domain_nephews, $domain if grep {$_ eq $cat_name} keys %{$minicategs_nephews->{$domain}};
    }
    return @domain_nephews;
}

# NB: устарело, следует пользоваться объектом Language
sub get_minicateg_atom_by_code {
    my ($code) = @_;
    return $code_atoms->{$code};
}

sub get_minicateg_minus_words_hash {
    my ($categ) = @_;
    return $minicategs_minus->{$categ} || {};
}

sub get_minicateg_minus_words {
    my ($categ) = @_;
    return %{$minicategs_minus->{$categ} || {}};
}

sub get_minicateg_not_minus_words_hash {
    my ($categ) = @_;
    return $minicategs_not_minus->{$categ} || {};
}

sub get_all_minicateg_not_minus_words_hash {
    my ($categ) = @_;
    return $all_minicategs_not_minus || {};
}

sub _cat_path {
    my $ctg = shift;
    my @path = ();
    while($ctg){
        $ctg = get_minicateg_parent($ctg);
        last unless $ctg;
        push(@path, $ctg);
    }
    return @path;
}

sub get_cat_path {
    my ($self, $ctg) = @_;
    return _cat_path($ctg);
}

#Получить список категорий с их родителями
sub get_upcategs :CACHE {
    my ($self) = @_;
    #Категории баннера
    my @ctgs = $self->get_minicategs;
    #Категории с подъёмом наверх
    my @upctgs = keys %{{ map {$_=>1} map { $_, _cat_path($_) } @ctgs }};
    return @upctgs;
}

sub is_minicateg_nominus {
    my ($ct) = @_;
    my $nominus = 0;

    for (my $par = $ct; $par && !$nominus; $par = get_minicateg_parent($par)) {
        $nominus = 1 if check_minicategs_flag($par, "nominus");
    }

   return $nominus;
}

sub is_minicateg_weakest {
    my ($categ) = @_;
    return check_minicategs_flag($categ, "weakest");
}

sub hier_minicategs {
    my %cthash =  map{$_ => 1} @_;

    # разворачиваем иерархию там, где стоит флаг hier
    my $hiered = {};
    do {
        $hiered = {};
        for my $ct (grep{$minicategs_flags->{$_}{hier}} keys %cthash) {
            my @chl = grep{!check_minicategs_flag($_, "unhier")} get_minicateg_children($ct);
            $hiered->{$_}++ for grep{!$cthash{$_}} @chl ;
        }
        $cthash{$_}++ for keys %$hiered;
    } while(%$hiered);

    return sort keys %cthash;
}

sub check_minicateg_flag {
    my ($categ, $flag) = @_;
    return ($minicategs_flags->{$categ} || {})->{$flag};
}

sub check_minicategs_flag {
    my ($categs, $flag) = @_;
    return grep{($minicategs_flags->{$_} || {})->{$flag}} split "/", ($categs || "");
}

sub set_minicateg_flag {
    my ($categ, $flag) = @_;
    ($minicategs_flags->{$categ} ||= {})->{$flag}++;
}

sub get_minicateg_flags {
    my ($categ) = @_;
    return $minicategs_flags->{$categ} || {};
}

sub get_flags_list {
    my ($flag) = @_;
    return keys %$flags_description;
}

sub get_flag_description {
    my ($flag) = @_;
    return $flags_description->{$flag} || "";
}

sub get_catalogia_flags {
    my $h = {};
    for my $ct (@_) {
        $h->{$_}++ for map{substr $_, 1} grep{/^\_/} keys  %{$minicategs_flags->{$ct} || {}};
    }
    return sort keys %$h;
}

sub get_catalogia_flags_with_asocial {
    my $h = {};
    for my $ct (@_) {
        $h->{$_}++ for map{s/^_//;$_} grep{/(^_|^asocial$)/} keys  %{$minicategs_flags->{$ct} || {}}; ##no critic
    }
    return sort keys %$h;
}

sub get_regions_flags {
    my $self = shift;

    my %region_to_flag = (
        '.region Белоруссия'    => '_region_rb',
        '.region Казахстан'     => '_region_kz',
        '.region Россия'        => '_region_ru',
        '.region Украина'       => '_region_ua',
    );
    my %regions_flags_set = ();
    my @regions_info = $self->get_regions_fast();
    for my $region_info (@regions_info) {
        if ($region_info->{'name'} eq 'Турция') {
            $regions_flags_set{'_region_tr'} = 1;
        } elsif ($region_info->{'is_world'}) {
            $regions_flags_set{'_region_others'} = 1;
        } else {
            my $category = ".region $region_info->{'name'}";
            while ($category && get_minicateg_parent($category) ne '.regions_rus') {
                $category = get_minicateg_parent($category);
            }
            $regions_flags_set{$region_to_flag{$category}} = 1 if $category && defined($region_to_flag{$category});
        }
    }

    return (sort keys %regions_flags_set);
}

sub check_directmod_dict_flag {
    my $self = shift;

    my $directmod_dict = '.Модерация Директа';
    my $phrase_to_named_atoms = $self->search_atoms_snorm();
    my $result = 0;
    for my $phrase (keys %$phrase_to_named_atoms) {
        for my $named_atom (keys %{$phrase_to_named_atoms->{$phrase}}) {
            do {
                $result = 1 if $named_atom eq $directmod_dict;
                $named_atom = get_minicateg_parent($named_atom);
            } while ($named_atom);
        }
    }

    return $result;
}

sub get_minicategs_flags {
    my ($self) = @_;
    return get_catalogia_flags( $self->get_minicategs );
}

sub get_minicategs_flags_with_asocial {
    my ($self) = @_;
    return get_catalogia_flags_with_asocial( $self->get_minicategs );
}

# рассматриваем фразу как текст баннера и возвращаем флаги модерации
sub get_banner_catalogia_flags {
    my ($self) = @_;
    my $bnr = BM::Banners::LBannerDirect->new({
        proj    => $self->proj,
        title   => $self->text,
        body    => "",
        phrases => "",
        url     => "",
        lang    => $self->lang,
    });

    return $bnr->get_catalogia_flags;
}

sub get_banner_catalogia_flags_analysis {
    my ($self) = @_;
    my $bnr = BM::Banners::LBannerDirect->new({
        proj    => $self->proj,
        title   => $self->text,
        body    => "",
        phrases => "",
        url     => "",
        lang    => $self->lang,
    });

    return $bnr->get_catalogia_flags_analysis;
}


sub clean_minicategs_list_by_diff {
    return @_ if $never_suppress_categs;

    my @arr = ();
    my $not_weakest = grep{!is_minicateg_weakest $_} @_;

    for my $c (@_) {
        next if is_minicateg_weakest($c) && $not_weakest;
        my $greped = 0;
        for my $category (@_) {
            if ($minicategs_diff_hash->at($category) =~ m{(^|/)$c(/|$)}) {
                $greped = 1;
                last;
            }
        }
        push @arr, $c if not $greped;
    }
    return @arr;
}

sub get_cdict_minicategs :CACHE {
    my ($self) = @_;

    my $tails = $self->get_search_tail;
    my %categs;

    for my $phr (map{$self->language->phrase($self->text . " $_")} keys %$tails) {
        $categs{$_}++ for $phr->get_minicategs;
    }

    return sort keys %categs;
}

# возвращает href { $ctg => $sum_counts }
sub get_cdict_minicategs_counts :CACHE {
    my $self = shift;

    my $tails = $self->get_search_tail;
    my %ctg_count;
    while (my ($tail, $count) = each %$tails) {
        my $phr = $self->language->phrase($self->text.' '.$tail);
        $ctg_count{$_} += $count for $phr->get_minicategs;
    }
    return \%ctg_count;
}

# Дописываем к тексту фразы мультислова ( в виде __mw_...)
sub preprocess_for_atoms :CACHE {
    my ($self) = @_;

    # мультислова
    if(!$self->{mw_codes}) {
        my $phl = $self->{categs_pack} || $self->proj->phrase_list({ phrases_list => [$self]});
        $self->language->layer_multiwords->search_subphrases_data_for_phl($phl, "mw_codes");
    }

    my $text = $self->text;

    if(%{$self->{mw_codes}}) {
        my %wh = map{$_=>1} $self->normwords;

        $wh{$self->{mw_codes}{$_}}++ for keys %{$self->{mw_codes}};
        my $ph = $self->language->phrase(join " ", keys %wh);

        $text = $ph->text;
    }

    #отрицательные слова
    $text = join(' ', $text, $self->get_negations_arr);

    # восклицательные знаки и плюсы
    $text =~ s/[\!\+]/ /g;
    return $self->language->phrase($text);
}

sub preprocess_for_categs :CACHE {
    my ($self) = @_;
    my $ph = $self->preprocess_for_atoms;

    if(!$self->{atom_codes}) {
        if($self->{categs_pack}) {
            my @phrases = ($self->{categs_pack} ? $self->{categs_pack}->phrases : $self);
            my $phl = $self->proj->phrase_list({ phrases_list => [map{$_->preprocess_for_atoms} @phrases]});
            $self->language->layer_atoms->search_subphrases_data_for_phl($phl, "atom_codes");
            $_->{atom_codes} = $_->preprocess_for_atoms->{atom_codes} for @phrases;
        } else {
            $self->{atom_codes} = $self->language->layer_atoms->search_subphrases_data($ph);
        }
    }
    # слова-атомы
    my $atoms2phrases = {};
    for my $atom_ph (keys %{$self->{atom_codes}}) {
        my @new_words;
        for my $code (split "/", $self->{atom_codes}{$atom_ph}) {
            my $current_ph = $atoms2phrases->{$code};
            # для каждого атома находим подфразы, которые входят в него
            # из списка оставляем только самую длинную, в случае нескольких таких - какую повезет
            if($current_ph) {
                next if $current_ph eq $atom_ph;
                # если атом определился по нескольким фразам, выбираем самую длинную
                my @curr_words = split " ", $current_ph;
                @new_words = split " ", $atom_ph if !@new_words;
                $atoms2phrases->{$code} = $atom_ph if @new_words > @curr_words;
            } else {
                $atoms2phrases->{$code} = $atom_ph;
            }
        }
    }
    $self->{atoms2phrases} = $atoms2phrases;

    # для каждого атома собираем подфразы, вошедшие в него
    my $atomcode2phrases = {};
    for my $phrase (keys %{$self->{'atom_codes'}}) {
        push(@{$atomcode2phrases->{$_}}, $phrase) for split('/', $self->{'atom_codes'}{$phrase});
    }
    # убираем дубли
    for my $phrase (keys %{$self->{'atomcode2phrases'}}) {
        $atomcode2phrases->{$phrase} = [Utils::Array::uniq_array(@{$atomcode2phrases->{$phrase}})];
    }
    $self->{'atomcode2phrases'} = $atomcode2phrases;

    my @new_words;

    # для фраз в двойных кавычках
    push @new_words, $self->get_wholephrase_multiword;

    # слова с буквами и цифрами
    for my $w ($ph->uniqnormwords) {
        my $num_digits = $w =~ tr/0-9//;
        next unless $num_digits;

        my ($prefix) = $w =~ /^(\D*)\d+$/;
        push @new_words, $prefix."_digits" if defined($prefix);

        my ($suffix) = $w =~ /^\d+(\D+)$/;
        push @new_words, "digits_".$suffix if $suffix;

        my @middles = $w =~ /^\d+(\D+)\d+$/g;
        push @new_words, "digits_".$_."_digits" for @middles;

        push @new_words, "many_digits" if $num_digits >= 5;
    }

    # даты
    push @new_words, "_date" if $ph->text =~
        /[0-9]{1,2}[\s\.\/\\](([01]?[0-9])|(января|февраля|марта|апреля|мая|июня|июля|августа|сентября|октября|ноября|декабря|янв|фев|апр|авг|сент|окт|нояб|дек))[\s\.\/\\]\d{2,4}/;

    return $self->language->phrase(join(" ", sort($ph->snormwords, keys(%$atoms2phrases), @new_words)), snormed => 1);
}

sub _check_distance_between_words {
    my ($pos_word, $max_dist, $found_words, $needed_count, $curr_index, $last_pos) = @_;

#    print "AT $curr_index (last_pos=$last_pos)\n";
#    print Dumper($found_words);

    if(scalar(keys %$found_words) == $needed_count) {
        return 1;
    }

    return 0 if $curr_index >= @$pos_word;

    my ($pos, $word) = @{$pos_word->[$curr_index]};
    return 0 if $last_pos >= 0 && $pos - $last_pos > $max_dist;

    if($last_pos < 0 || !$found_words->{$word}) {
        $found_words->{$word} = 1;

        return 1 if _check_distance_between_words($pos_word, $max_dist, $found_words, $needed_count, $curr_index + 1, $pos);

        delete $found_words->{$word};
    }

    return _check_distance_between_words($pos_word, $max_dist, $found_words, $needed_count, $curr_index + 1, $last_pos);
}

sub transform_subphraser_data {
    my $layer = shift;
    my $phrase2categories = shift;
    my $result = {};
    for my $phrase (keys %$phrase2categories) {
        my @categories;
        if (ref($phrase2categories->{$phrase}) eq 'HASH') {
            @categories = keys %{$phrase2categories->{$phrase}};
        } else {
            for my $category_data (split /\//, $phrase2categories->{$phrase}) {
                my $category = ($category_data =~ /^([^@]*)/)[0];
                next if !defined($minicateg2categid->{$category});
                push @categories, $category;
            }
        }
        for my $category (@categories) {
            my $orig_phrase = $layer->get_orig_phrase($category, $phrase);
            $result->{$orig_phrase}{$category} = 1;
        }
    }
    return $result;
}

sub expand_atom_codes {
    my $self = shift;
    my $phrase2categories = shift;

    my $result = {};
    my $expanded_phrase2orig_phrase = {};
    for my $phrase (keys %$phrase2categories) {
        my @words = split(' ', $phrase);
        my @atoms_phrases = map {$self->{'atomcode2phrases'}{$_} // [$_]} @words;

        my $cartesian_product_size = 1;
        $cartesian_product_size *= scalar @{$_}  for @atoms_phrases;
        my $max_cartesian_product_size = 1000;
        if ($cartesian_product_size > $max_cartesian_product_size) {
            $self->log("ERROR: Too large cartesian_product_size: $cartesian_product_size"
                . " (" . join(",", map {scalar @{$_}} @atoms_phrases) . ")"
                . " phrase: '$phrase' text: '" . $self->text . "' "
                . " atoms_phrases: ( " . join(", ", map { join(" ", @{$_}) } @atoms_phrases) . " )"
            );
            # TODO не разваливать только эту фразу
            return $phrase2categories;
        }

        my @cartesian_product = Utils::Array::cartesian_product(@atoms_phrases);

        #$self->log("expand_atom_codes: cartesian_product: $cartesian_product_size " . (scalar @cartesian_product) . " phrase: '$phrase' text: " . $self->text );
        #if (@cartesian_product >= 10) {
        #    # TODO remove this debug print
        #    $self->log("expand_atom_codes: cartesian_product: " . (scalar @cartesian_product) . " phrase: '$phrase' text: " . $self->text );
        #}

        for my $expanded_phrase_array (@cartesian_product) {
            my $expanded_phrase = join(' ', sort(Utils::Array::uniq_array(@$expanded_phrase_array)));
            push(@{$result->{$expanded_phrase}}, $_) for split('/', $phrase2categories->{$phrase});
            push(@{$expanded_phrase2orig_phrase->{$expanded_phrase}}, $phrase);
        }
    }
    for my $expanded_phrase (keys %$result) {
        $result->{$expanded_phrase} = join('/', Utils::Array::uniq_array(@{$result->{$expanded_phrase}}));
        $expanded_phrase2orig_phrase->{$expanded_phrase} = [
            Utils::Array::uniq_array(@{$expanded_phrase2orig_phrase->{$expanded_phrase}})
        ];
    }

    # $self->{'expanded_phrase2orig_phrase'} - сейчас не используем, но будет нужно для отображения фраз в интерфейсе
    # TODO: если будем использовать, то нужно поправить, чтобы можно было вызывать expand_atom_codes несколько раз?
    $self->{'expanded_phrase2orig_phrase'} = $expanded_phrase2orig_phrase;

    return $result;
}

sub _decode_phrase {
    my ($self, $encoded_phrase, %prm) = @_;

    # atoms2phrases может вернуть фразу состоящую из более, чем одного слова
    # стало быть ключами в хеше могут быть не только слова, но и фразы
    # это способствует ложным срабатываниям би/мульти вордов
    my $words = [
        map {
            $prm{snorm} ? norm2snorm($_) : $_
        } map {
            $self->proj->multiwords->multiword2words($_)
        } map {
            split(/ /, $self->{atoms2phrases}{$_} // $_)
        } split(/ /, $encoded_phrase)
    ];
    if ($prm{return_hash}) {
        return { map { $_ => 1 } @$words };
    }
    return $words;
}

sub _check_broken_multiwords {
    my ($phrase_snormwords_hash, $multiwords_hashes) = @_;

    for my $mwh (@$multiwords_hashes) {
        if((grep{$phrase_snormwords_hash->{$_}} keys %$mwh) && (grep{!$phrase_snormwords_hash->{$_}} keys %$mwh)) {
            return $mwh;
        }
    }
    return;
}

sub remove_categs_subphrases {
    my ($self, $ph2cats) = @_;

    push @{$self->{analysis}}, {
        description => 'remove_categs_subphrases ph2cats',
        data        => dclone($ph2cats),
    } if $compute_phrase_analysis;

    my $filter_categs_subphrases_functions = {
        # эксперименты с позициями слов
        by_experiment_word_position => sub {
            my ($encoded_phrases, $encoded2decoded_phrases) = @_;

            my $encoded_phrases_new = [];
            for my $enc_ph (0 .. $#$encoded_phrases) {
                my $ph = $encoded2decoded_phrases->{ $enc_ph };
                my $word_count = scalar keys %$ph;
                my $max_dist = $Utils::Common::options->{experiment_word_position}{$word_count};

                if($max_dist) {
                    my @pos_word;
                    for my $snorm (keys %$ph) {
                        push @pos_word, [$_, $snorm] for @{$self->{snorm2pos}{$snorm}};
                    }
                    @pos_word = sort{$a->[0] <=> $b->[0]} @pos_word;
                    if(!_check_distance_between_words(\@pos_word, $max_dist, {}, $word_count, 0, -1)) {
                        next;
                    }
                }
                push @$encoded_phrases_new, $enc_ph;
            }
            return ($encoded_phrases_new);
        },

        # фильтрация мультисловами (включая биворды)
        by_multiwords => sub {
            my ($encoded_phrases, $encoded2decoded_phrases) = @_;
            my $encoded_phrases_new = [];
            my $analysis = { description => 'Разрывы в мультивордах', data => [], };
            my $categs_test_inf = "";

            for my $enc_ph (@$encoded_phrases) {
                my $phrase_snormwords_hash = $encoded2decoded_phrases->{$enc_ph};
                if (my $broken_mwh = _check_broken_multiwords($phrase_snormwords_hash, [$self->get_multiwords_hashes])) {
                    my $broken_multiword_str = join(" ", sort keys %$broken_mwh);
                    my $ph = $self->decode_minicateg_subphrase($enc_ph);
                    $categs_test_inf = "phrase '$ph' breaks multiword '$broken_multiword_str'";
                    push @{$analysis->{data}}, { phrase => $ph, broken_multiword => $broken_multiword_str, };
                } else {
                    push @$encoded_phrases_new, $enc_ph;
                }
            }

            return ($encoded_phrases_new, $analysis, $categs_test_inf);
        },

        # выкидываем строгие подфразы
        by_strict_subphrases => sub {
            my ($encoded_phrases, $encoded2decoded_phrases) = @_;
            my $analysis = { description => 'Список строгих подфраз', data => [], };
            my $categs_test_inf = "";

            my $is_filtered = [map {0} @$encoded_phrases];
            for my $i1 (0 .. $#$encoded_phrases) {
                for my $i2 (0 .. $#$encoded_phrases) {
                    next if $i1 == $i2 || $is_filtered->[$i2];

                    my $swh = $encoded2decoded_phrases->{ $encoded_phrases->[$i1] };
                    my $big_swh = $encoded2decoded_phrases->{ $encoded_phrases->[$i2] };

                    if(scalar(keys %$swh) < scalar(keys %$big_swh) && (!grep{!$big_swh->{$_}} keys %$swh)) {
                        $is_filtered->[$i1] = 1;
                        push @{$analysis->{data}}, {
                            phrase      => join(' ', sort keys %$big_swh),  # или $encoded_phrases->[$i2] ?
                            subphrase   => join(' ', sort keys %$swh),  # или $encoded_phrases->[$i1] ?
                        };
                        last;
                    }
                }
            }
            my $encoded_phrases_new = [ @{$encoded_phrases}[ grep { ! $is_filtered->[$_] } (0 .. $#$encoded_phrases) ] ];
            return ($encoded_phrases_new, $analysis, $categs_test_inf);
        },
    };

    my $encoded_phrases = [ sort keys %$ph2cats ];
    my $encoded2decoded_phrases = {map { $_ => $self->_decode_phrase($_, snorm => 1, return_hash => 1,) } @$encoded_phrases};

    if ($Utils::Common::options->{experiment_word_position}) {
        ($encoded_phrases) = $filter_categs_subphrases_functions->{by_experiment_word_position}->($encoded_phrases, $encoded2decoded_phrases);
    }

    my $categs_test_inf;
    my $analysis;

    if($use_categs_biwords) {
        ($encoded_phrases, $analysis, $categs_test_inf) = $filter_categs_subphrases_functions->{by_multiwords}->($encoded_phrases, $encoded2decoded_phrases);
        push @{$self->{analysis}}, $analysis    if $compute_phrase_analysis;
        print {$self->{categs_test_inf}} $categs_test_inf  if($self->{categs_test_inf});
    }

    ($encoded_phrases, $analysis) = $filter_categs_subphrases_functions->{by_strict_subphrases}->($encoded_phrases, $encoded2decoded_phrases);
    push @{$self->{analysis}}, $analysis    if $compute_phrase_analysis;


# TODO
    # эксперимент с предложениями
    if($use_sentences_filter && @$encoded_phrases) {
        my @sentences = @{$self->sentences};
        my $word2sentences = {};
        my $encoded_phrases_new = [];

        for my $i (0..$#sentences) {
            ($word2sentences->{$_} ||= {})->{$i + 1}++ for $sentences[$i]->snormwords;
        }

        for my $enc_ph (@$encoded_phrases) {
            my $sentences_set = undef;
            for my $word (keys %{$encoded2decoded_phrases->{$enc_ph}}) { # TODO атомы, мультислова
                my $word_sentences = $word2sentences->{$word} || {};

                if(!$sentences_set) {
                    $sentences_set = { map{$_ => 1} keys %$word_sentences };
                } else {
                    delete $sentences_set->{$_} for grep{!$word_sentences->{$_}} keys %$sentences_set;
                    last if !%$sentences_set;
                }
            }

            if(!$sentences_set || !%$sentences_set) {
                if($self->{categs_test_inf}) {
                    print {$self->{categs_test_inf}}
                        "phrase '".$self->decode_minicateg_subphrase($enc_ph)."' has words from different sentences\n";
                }
            } else {
                push @$encoded_phrases_new, $enc_ph;
            }
        }
        $encoded_phrases = $encoded_phrases_new   if @$encoded_phrases_new;
    }

    #delete $ph2cats->{$_} for map{$encoded_phrases->[$_]} grep{$is_filtered->[$_]} (0..$#$is_filtered);

    my %good_encoded_phrases = map { $_ => 1 } @$encoded_phrases;
    delete $ph2cats->{$_} for grep { ! $good_encoded_phrases{$_} } keys $ph2cats;
}

sub get_minicategs_subphrases_hash {
    my ($self, $layer, $addlayer) = @_;
    my $ph2cats = {};

    $layer ||= $self->language->layer_categs;

    my $final_phrase = $self->preprocess_for_categs;
    print {$self->{categs_test_inf}} "final phrase snorm: ".$final_phrase->snorm_phr."\n" if $self->{categs_test_inf};

    if($layer_models) {
        $ph2cats = $layer_models->search_subphrases_data($final_phrase);
    }

    $ph2cats //= {};

    if(!%$ph2cats) {
        # ищем подфразы от категорий
        my $field_name = $layer->name."_ph2cats";
        if(!$self->{$field_name}) {
            if($self->{categs_pack}) {
                my @phrases = ($self->{categs_pack} ? $self->{categs_pack}->phrases : $self);
                my $phl = $self->proj->phrase_list({ phrases_list => [map{$_->preprocess_for_categs} @phrases]});
                $layer->search_subphrases_data_for_phl($phl, $field_name);
                $_->{$field_name} = $_->preprocess_for_categs->{$field_name} for @phrases;
            } else {
                $self->{$field_name} = $layer->search_subphrases_data($final_phrase);
            }
        }
        $ph2cats = $self->{$field_name};

        $ph2cats //= {};
        # ищем дополнительные фразы, если нет нормальных
        if(!%$ph2cats && $addlayer) {
            print {$self->{categs_test_inf}} ("using additional phrases") if $self->{categs_test_inf};

            $self->{used_addphl} = 1;
            $ph2cats = $addlayer->search_subphrases_data($final_phrase);
        }
    }
    $ph2cats //= {};
    push @{$self->{'analysis'}}, {
        description => 'Все подфразы, найденные subphraser`ом',
        data        => transform_subphraser_data($layer, dclone($ph2cats)),
    } if $compute_phrase_analysis;

    # удаление пустых значений
    my @empty_phrases = grep{ (!defined($ph2cats->{$_})) || ($ph2cats->{$_} eq "") } keys %$ph2cats;
    delete $ph2cats->{$_} for @empty_phrases;
    push @{$self->{'analysis'}}, {
        description => 'Удаленные пустые подфразы',
        data        => [@empty_phrases],
    } if $compute_phrase_analysis;


    # расшифровываем atom_code
    %$ph2cats = %{$self->expand_atom_codes($ph2cats)} if $expand_atom_codes;

    $self->remove_categs_subphrases($ph2cats);

    push @{$self->{'analysis'}}, {
        description => 'Фильтрация минус словами',
        data        => [],
    } if $compute_phrase_analysis;
    my $ph2cats_new = {};
    # декодируем данные о категориях
    for my $ph (keys %$ph2cats) {

        # TODO нужно ли ???
        #if(ref($ph2cats->{$ph}) eq "HASH") {
        #    next;
        #}

        my $seen_categs = {};
        my $filtered_categs = {};
        for my $ct_data (split "/", $ph2cats->{$ph}) {
            my ($categ_name, @data) = split "@", $ct_data;
            $seen_categs->{$categ_name} = 1;

            if(!defined($minicateg2categid->{$categ_name})) {
                # пропускаем, если этой категории уже не существует
                $filtered_categs->{$categ_name} = 1;
                push @{$self->{'analysis'}[-1]{'data'}}, {
                    phrase      => $ph,
                    category    => $categ_name,
                    reason      => "category doesn't exist",
                } if $compute_phrase_analysis;

                next;
            }

            # парсим дополнительную информацию
            for my $item (@data) {
                if(my $minuswords_str = ($item =~ /^aw (.*)/)[0]) {
                    # минус-слова для фразы
                    my @minuswords = split " ", $minuswords_str;
                    print {$self->{categs_test_inf}} ("minuswords (".join(" ", @minuswords).") for $ph in $categ_name\n") if $self->{categs_test_inf};
                    if (my @active_minuswords = grep{$self->snormwordshash->{$_}} @minuswords) {
                        $filtered_categs->{$categ_name} = 1;
                        push @{$self->{'analysis'}[-1]{'data'}}, {
                            phrase      => $layer->get_orig_phrase($categ_name, $ph),
                            category    => $categ_name,
                            minuswords   => \@active_minuswords,
                        } if $compute_phrase_analysis;
                    }
                }
            }
        }

        my $result_categs = { map { $_ => 1 } grep { ! $filtered_categs->{$_} } keys $seen_categs };
        if(%$result_categs) {
            $ph2cats_new->{$ph} = $result_categs;
        }
    }
    return $ph2cats_new;
}

sub get_categ_antiwords_phl {
    my ($self, $categ) = @_;
    my $awphl = $self->language->{minicateg2antiwordsphl}{$categ};
    my $phl = $awphl ? $awphl->search_subphrases_in_phrase($self) : undef;

    return $phl if $phl && $phl->phrases;
    return undef;
}

sub clean_minicategs_subphrases_hash {
    my ($self, $layer, $addlayer) = @_;

    $layer ||= $self->language->layer_categs;

    # кэшируем вызов с основным слоем категорий
    my $cache_key = 'clean_minicategs_subphrases_hash:layer_categs';
    return $self->{$cache_key} if $layer->name eq 'categs' and $self->{$cache_key};

    # получаем фразы категорий
    my $ph2cats = $self->get_minicategs_subphrases_hash($layer, $addlayer);
    push @{$self->{'analysis'}}, {
        description => 'Фразы категорий',
        data        => transform_subphraser_data($layer, dclone($ph2cats)),
    } if $compute_phrase_analysis;

    if($self->{categs_test_inf} || $self->{categs_log_inf}) {
        my @lines = ();
        my @rawlines = ();

        for my $phr (sort keys %$ph2cats) {
            for my $categ (sort keys %{$ph2cats->{$phr}}) {
                my $orig = $layer->get_orig_phrase($categ, $phr);
                push @lines, "  -- ".$self->decode_minicateg_subphrase($phr)." =>" . $self->language->category_from_ru($categ) . "=> $orig\n";
                push @rawlines, [ $self->decode_minicateg_subphrase($phr), $self->language->category_from_ru($categ), $orig, ];
            }
        }
        my $text = join("\n", @lines) . "\n";

        print {$self->{categs_test_inf}} $text if $self->{categs_test_inf};
        if($self->{categs_log_inf}) {
            $self->{categs_log} = $text;
            $self->{categs_log_list} = [ @lines ];
            $self->{categs_log_rawlist} = [ @rawlines ];
        }
    }

    { # применяем антислова
        my %categ2antiwords_in_phrase; # антислова категорий, присутствующие во фразе
        for my $ct (uniq map { keys $ph2cats->{$_} } keys %$ph2cats) {
            my $phl = $self->get_categ_antiwords_phl($ct);
            $categ2antiwords_in_phrase{$ct} = $phl if $phl;
        }
        if(%categ2antiwords_in_phrase) {
            for my $ph (keys %$ph2cats) {
                delete $ph2cats->{$ph}{$_} for grep{$categ2antiwords_in_phrase{$_}} keys %{$ph2cats->{$ph}};
                #my @suffered_categories = grep{$categ2antiwords_in_phrase{$_}} keys %{$ph2cats->{$ph}};
            }
            delete $ph2cats->{$_} for grep{!%{$ph2cats->{$_}}} keys %$ph2cats;
        }
        push @{$self->{analysis}}, {
            description => 'Фильтрация антивордами категорий',
            data        => [],
        } if $compute_phrase_analysis;
        for my $ct (sort keys %categ2antiwords_in_phrase) {
            print {$self->{categs_test_inf}} ("antiwords for $ct: ".join(",", map{$_->snorm_phr} $categ2antiwords_in_phrase{$ct}->phrases)."\n")   if $self->{categs_test_inf};
            push @{$self->{analysis}[-1]{data}}, {
                filtered_category   => $ct,
                antiwords           => join(",", map{$_->snorm_phr} $categ2antiwords_in_phrase{$ct}->phrases),
            } if $compute_phrase_analysis;
        }
    }

    { # собираем информацию о флагах найденных категорий
        my $has_weakest = 0;
        my $has_not_weakest = 0;
        for my $ph (keys %$ph2cats) {
            for my $ct (keys %{$ph2cats->{$ph}}) {
                my $flags = $minicategs_flags->{$ct}; 

                $has_weakest ||= $flags->{weakest};
                $has_not_weakest ||= !$flags->{weakest};
            }
        }

        # сразу убираем фразы от тех категорий, которые всегда подавляются
        if($has_weakest && $has_not_weakest) {
            my %filtered_categories = ();
            for my $ph (keys %$ph2cats) {
                for my $weakest_ctg (grep{check_minicategs_flag($_, "weakest")} keys %{$ph2cats->{$ph}}) {
                    delete $ph2cats->{$ph}{$weakest_ctg};
                    $filtered_categories{$weakest_ctg} = 1;
                }
            }
            push @{$self->{'analysis'}}, {
                description => 'Подавляемые категории (флаг weakest)',
                data        => [keys %filtered_categories],
            };
            delete $ph2cats->{$_} for grep{!%{$ph2cats->{$_}}} keys %$ph2cats;
        }
    }

    my ($analysis, $categs_test_inf);

    if(!$never_suppress_categs && !$always_spdiff) {
        ($ph2cats, $analysis, $categs_test_inf) = $self->filter_ph2cats_by_num_words($ph2cats, $layer);
        push @{$self->{analysis}}, $analysis   if $compute_phrase_analysis;
        print {$self->{categs_test_inf}} $categs_test_inf   if $self->{categs_test_inf};
    }

    if ($use_freq_words_filter) {
        # если в исходной фразе есть слова, встретившиеся более одного раза,
        # то даём преимущество фразам с этими словами
        if(!%good_words_wide_snorms) {
            %good_words_wide_snorms = map{$self->proj->phrase($_)->snorm_phr => 1} qw(купить цена недорого);
        }
        my $good_words = {};
        my @good_words_arr = map{$self->proj->multiwords->multiword2words($_)} $self->snormwords;
        if ($freq_filter_snorms) {
            @good_words_arr = grep {$_} map {word2snorm($_)} @good_words_arr;
        }
        $good_words->{$_}++ for @good_words_arr;
        delete $good_words->{$_} for grep{$good_words->{$_} < 2} keys %$good_words;
        if(%$good_words) {
            my %good_phrases;
            for my $ph (keys %$ph2cats) {
                # слова фразы с учетом атомов
                my @words = grep {
                    !$good_words_wide_snorms{$_}
                } @{ $self->_decode_phrase($ph) };
                if ($freq_filter_snorms) {
                    @words = grep {$_} map {word2snorm($_)} @words;
                }
                $good_phrases{$ph}++ if grep{$good_words->{$_}} @words;
            }
            if(%good_phrases) {
                if($self->{categs_test_inf}) {
                    print {$self->{categs_test_inf}} ("leave only these phrases: " . join(",", keys %good_phrases) . "\n");
                    print {$self->{categs_test_inf}} (" (words filter: ".join(", ", sort keys %$good_words) . ")\n");
                }
                my @all_phrases = keys %$ph2cats;
                delete $ph2cats->{$_} for grep{!$good_phrases{$_}} keys %$ph2cats;
                push @{$self->{'analysis'}}, {
                    description => 'Фильтрация частотными словами',
                    data        => {
                        frequent_words      => [keys %$good_words],
                        filtered_phrases    => [grep {!$good_phrases{$_}} @all_phrases],
                    },
                } if $compute_phrase_analysis;
            }
        }
    }

    {
        # не используем слова из сработавших мультислов
        # собираем все слова из мультивордов для дальнейшей фильтрации
        # если фраза содержит __atom_code_xx_xx, слова из него подтянуты не будут
        my %mw_words = (); # слова из сработавших мультислов. По norm
        for my $ph (keys %$ph2cats) {
            my @multiwords = $self->get_phrase_multiwords($ph);
            for my $multiword (@multiwords) {
                $multiword =~ s/^__mw_//;
                ++$mw_words{$_} for split('_', $multiword);
            }
        }
        # фильтруем фразы словами из мультивордов
        # если фраза содержит __atom_code_xx_xx, она отфильтрована не будет
        if(%mw_words) {
            push @{$self->{'analysis'}}, {
                description => 'Фильтрация фраз сработавшими мультисловами',
                data        => [],
            } if $compute_phrase_analysis;
            for my $ph (keys %$ph2cats) {
                unless (my $check_result = $self->check_phrase_by_multiwords($ph, \%mw_words)) {
                    delete $ph2cats->{$ph};
                    push @{$self->{'analysis'}[-1]{'data'}}, $ph    if $compute_phrase_analysis;
                }
            }
        }
    }

    # приоритет нормов перед снормами
    if($categs_experiment_norm) {
        my @norm_matches;
        my @snorm_matches;

        for my $snorm (keys %$ph2cats) {
            for my $categ (keys %{$ph2cats->{$snorm}}) {
                my $orig = $layer->get_orig_phrase($categ, $snorm);

                next if !$orig || $orig =~ /\[/;

                my $orig_phr = $self->language->phrase($orig);

                if(grep{!$self->normwordshash->{$_}} $orig_phr->normwords) {
                    push @snorm_matches, [$snorm, $categ, $orig];
                } else {
                    push @norm_matches, [$snorm, $categ, $orig];
                }
            }
        }

        if($self->{categs_test_inf}) {
            print {$self->{categs_test_inf}} ("norm_matches:" . Dumper(\@norm_matches));
            print {$self->{categs_test_inf}} ("snorm_matches:" . Dumper(\@snorm_matches));
        }

        if(@norm_matches && @snorm_matches) {
            for (@snorm_matches) {
                my ($snorm, $categ) = @$_;

                delete $ph2cats->{$snorm}{$categ};
                delete $ph2cats->{$snorm} if !%{$ph2cats->{$snorm}};
            }
        }
    }

    $self->{$cache_key} = $ph2cats if $layer->name eq 'categs';
    return $ph2cats;
}

# подавляем категории, фразы которых короче фраз других категорий
sub filter_ph2cats_by_num_words {
    my ($self, $ph2cats, $layer) = @_;
    $ph2cats = dclone($ph2cats);

    my $analysis = { description => 'Подавляемые по длине категории', data => [], };
    my $categs_test_inf = '';

    # вычисление длин фраз
    my %num_words;
    for my $ph (keys %$ph2cats) {
        my $cth = $ph2cats->{$ph};
        next if !grep{!check_minicateg_flag($_, "spdiff")} keys %$cth;

        my $uniq_words = $self->_decode_phrase($ph, return_hash => 1);
        $num_words{$ph} = scalar(keys $uniq_words);

        $categs_test_inf .= "  - ".$self->decode_minicateg_subphrase($ph)." => ".join(" ", map{"$_"} sort keys $uniq_words) . "\n";
    }

    # количество слов в самой длинной фразе
    my $max_words = max map{$num_words{$_}} keys %num_words;

    # удаляем короткие фразы (кроме категорий с флагом spdiff)
    for my $ph (grep{$num_words{$_} < $max_words} keys %num_words) {
        my $cth = $ph2cats->{$ph};
        my @filtered_categories = grep{!check_minicateg_flag($_, "spdiff")} keys %$cth;
        delete $cth->{$_} for @filtered_categories; 
        for my $filtered_category (@filtered_categories) {
            push @{$analysis->{data}}, {
                phrase      => $layer->get_orig_phrase($filtered_category, $ph),
                category    => $filtered_category,
            } if $compute_phrase_analysis;
        }
    }
    delete $ph2cats->{$_} for grep{!%{$ph2cats->{$_}}} keys $ph2cats;
    return ($ph2cats, $analysis, $categs_test_inf);
};

sub get_core_subphrase {
    my ($self) = @_;
    my $words = {};
    my @categs = $self->get_minicategs;
    my $clean = $self->clean_minicategs_subphrases_hash;
    foreach my $subtext ( keys %$clean ) {
        next unless grep { exists $clean->{$subtext}{$_} } @categs;
        $words->{$_} = 1 foreach @{$self->_decode_phrase($subtext, snorm => 1)};
    }
    return $self->proj->phrase(join(' ', sort keys %$words ));
}

sub orig_minicategs_subphrases_hash_custom {
    my ($self, %opts) = @_;
    my $ph2cats =  $self->clean_minicategs_subphrases_hash;
    my $layer = $self->language->layer_categs;
    my $h = {};

    if($opts{apply_catalysts}) {
        $ph2cats = $self->apply_catalysts($ph2cats);
    }

    for my $snorm (keys %$ph2cats) {
        for my $categ (keys %{$ph2cats->{$snorm}}) {
            my $orig = $layer->get_orig_phrase($categ, $snorm);
            $orig = $self->language->layer_catalysts2->get_orig_phrase($categ, $snorm) if $snorm eq $orig;

            ($h->{$orig} ||= {})->{$categ}++;
        }
    }

    return $h;
}

sub orig_minicategs_subphrases_hash :CACHE {
    my ($self) = @_;

    return $self->orig_minicategs_subphrases_hash_custom(apply_catalysts => 1);
}

sub get_categs_phrases {
    my ($self) = @_;
    my @arr = split "\n", $self->get_minicategs_log;
    s/^#// for @arr;
    @arr = map { [ split( ' => ', $_ ) ] } @arr;
    return \@arr;
}

sub get_categs_phrases_hlist {
    my ($self) = @_;
    return [ map { { category => $_->[2], phrase => $_->[1].' => '.$_->[3] } } map { [ split( /\s*(?:--|=>)\s*/, $_->[0] ) ] } @{$self->get_categs_phrases} ];
}

sub decode_minicateg_subphrase {
    my ($self, $text) = @_;
    my $phr = $self->language->phrase($text);
    my @words;

    for my $w ($phr->snormwords) {
        my $atom = $self->{atoms2phrases}{$w};

        if($atom) {
            push @words, "[$atom]";
        } else {
            push @words, $w;
        }
    }

    return join " ", @words;
}

sub decode_minicategs_subphrases_hash :CACHE {
    my ($self) = @_;
    my $ph2cats = { %{ $self->clean_minicategs_subphrases_hash } };
    my %cth = map{$_=>1} $self->get_minicategs;
    my $categ2phrases = {};
    my $result = {};

    # фразы без катализаторов
    for my $phr (sort keys %$ph2cats) {
        my $decoded = $self->decode_minicateg_subphrase($phr);

        for my $categ (keys %{$ph2cats->{$phr}}) {
            ($categ2phrases->{$categ} ||= {})->{$decoded}++;

            if($cth{$categ}) {
                ($result->{$decoded} ||= {})->{$categ}++;
            }
        }
    }

    # добавляем катализаторы
    $ph2cats = $self->apply_catalysts($ph2cats);
    for my $phr (sort keys %$ph2cats) {
        my @ids = $phr =~ /__categ_(\S+)/;
        next if !@ids;

        my @new_categs = grep{$cth{$_}} keys %{$ph2cats->{$phr}};
        next if !@new_categs;

        my $decoded = $self->decode_minicateg_subphrase($phr);
        for my $categ_id (@ids) {
            my $categ = $self->proj->categs_tree->get_minicateg_by_id($categ_id);
            next if !$categ;

            my @categ_phrases = keys %{$categ2phrases->{$categ}};
            my $replacement = sprintf "{%s}", ($categ_phrases[0] || $categ);

            $decoded =~ s/__categ_$categ_id/$replacement/g;
        }

        ($result->{$decoded} ||= {})->{$_}++ for @new_categs;
    }

    return $result;
}

# получить список мультивордов, которые содержатся во фразе
# более менее корректно работает при наличии атомов
sub get_phrase_multiwords {
    my $self = shift;
    my $phrase = shift;

    my @multiwords = grep {
        /^__mw_/
    } map {
        split(' ', $_)
    } map {
        @{$self->{'atomcode2phrases'}{$_} // [$_]}
    } split(' ', $phrase);

    return @multiwords;
}

# проверить фразу на корректность относительно мультивордов
# если во фразе есть мультиворды, она заведомо хорошая   # ??? - emurav@   TODO
# иначе, если во фразе есть слова мультивордов - она плохая
# иначе, разворачиваем каждый атом и проверяем, что внутри каждого атома найдется хорошая фраза
# Не всегда работает? https://st.yandex-team.ru/CATALOGIA-888#1509571624000
sub check_phrase_by_multiwords {
    my $self = shift;
    my $phrase = shift;
    my $mw_words = shift; # Хеш - слова из сработавших мультислов. По norm

    #$self->log("check_phrase_by_multiwords '$phrase' " . to_json($mw_words));

    my @multiwords = $self->get_phrase_multiwords($phrase);
    #$self->log("check_phrase_by_multiwords   multiwords: @multiwords");
    # Не проверяем фразу, если в ней есть хотя бы один __mw
    # Это некорректно? Т.к. во фразе, кроме найденного __mw, могли быть другие слова,
    # которые нужно проверять по мультисловам из других фраз категорий
    # Или же это было осознанное решение?
    # TODO - посмотреть дифф и поправить, если нужно
    return 1 if @multiwords; # если во фразе есть мультиворды, она заведомо хорошая   # TODO поменять логику?

    my @words = split(' ', $phrase);
    my @filtered_mw_words = grep {$mw_words->{$_}} @words;
    return 0 if @filtered_mw_words;

    my @atom_codes = grep {/^__atom_code_/} @words;
    for my $atom_code (@atom_codes) {
        next unless $self->{'atomcode2phrases'}{$atom_code};
        my @atom_phrases = @{$self->{'atomcode2phrases'}{$atom_code}};
        my $count = 0;
        for my $atom_phrase (@atom_phrases) {
            $count += (grep {$mw_words->{$_}} split(' ', $atom_phrase)) == 0;
        }
        return 0 if $count == 0;
    }

    return 1;
}

sub apply_catalysts {
    my ($self, $ph2cts) = @_;

    return $ph2cts if $dont_use_catalysts;

    my %codes;
    for my $ph (keys %$ph2cts) {
        for my $categ (keys %{$ph2cts->{$ph}}) {
            my $code = _category_to_catalyst_code($categ);
            $codes{$code}++ if $code;
        }
    }

    return $ph2cts if !%codes;

    # создаём копию хэша
    my $new_ph2cts = {};
    for my $ph (keys %$ph2cts) {
        $new_ph2cts->{$ph} = { %{$ph2cts->{$ph}} };
    }
    $ph2cts = $new_ph2cts;

    my $phr = $self->language->phrase(join(" ", sort($self->preprocess_for_categs->snormwords, keys %codes)), snormed => 1);
    if($self->{categs_test_inf}) {
        print {$self->{categs_test_inf}} ("catalyst phrase: ". $self->decode_minicateg_subphrase($phr->text)."\n");
    }

    my $ph2catalysts = $self->language->layer_catalysts2->search_subphrases_data($phr);
    # расшифровываем atom_code
    %$ph2catalysts = %{$self->expand_atom_codes($ph2catalysts)} if $expand_atom_codes;
    push @{$self->{analysis}}, {
        description => 'ph2catalysts',
        data        => dclone($ph2catalysts),
    } if $compute_phrase_analysis;

    my %transformed_phrases;
    my %ok_with_antiwords;
    for my $ph (keys %$ph2catalysts) {
        my @phwords = map{$self->proj->multiwords->multiword2words($_)} map{$self->{atoms2phrases}{$_} || $_} grep{!/^__categ_/} split(" ", $ph);
        my %from_categs = map{$_=>1} grep{$_} map{_category_from_catalyst_code($_)} split " ", $ph;
        my @to_categs = grep{$_} split "/", $ph2catalysts->{$ph};

        # проверка на совместимость с антисловами
        for my $categ (grep{!exists($ok_with_antiwords{$_})} @to_categs) {
            my $phl = $self->get_categ_antiwords_phl($categ);

            $ok_with_antiwords{$categ} = !defined($phl);
            if($phl) {
                if($self->{categs_test_inf}) {
                    print {$self->{categs_test_inf}} ("can't convert to '$categ' because of antiwords: ".join(",", map{$_->text} @$phl)."\n");
                }
            }
        }
        @to_categs = grep{$ok_with_antiwords{$_}} @to_categs;

        next if !%from_categs || !@to_categs;

        for my $categ_ph (keys %$ph2cts) {
            # категории, которые могут быть преобразованы
            my @cts = grep{$_ && $from_categs{$_}} keys %{$ph2cts->{$categ_ph}};

            if(@cts) {
                # проверяем, что фраза не содержит в себе подфразу, по которой сработал катализатор
                my %wh = map{$_=>1} map{$self->proj->multiwords->multiword2words($_)} map{$self->{atoms2phrases}{$_} || $_} grep{!/^__categ_/} split(" ", $categ_ph);
                if(grep{!$wh{$_}} @phwords) {
                    for my $categ (@cts) {
                        $transformed_phrases{$categ_ph}++;

                        for my $to_categ (@to_categs) {
                            ($ph2cts->{$ph} ||= {})->{$to_categ}++;
                        }

                        if($self->{categs_test_inf}) {
                            print {$self->{categs_test_inf}} ("catalyst $ph: $categ => ".join("/", @to_categs)."\n");
                        }
                    }
                }
            }
        }
    }

    # преобразованные фразы исключаются из категоризации
    delete $ph2cts->{$_} for keys %transformed_phrases;

    return $ph2cts;
}

sub base_get_minicategs {
    my ($self, $layer, $addlayer) = @_;

    # если файл для вывода отладочной информации не указан, отправляем на стандартный вывод
    if($self->{categs_test_inf} && !openhandle($self->{categs_test_inf})) {
        $self->{categs_test_inf} = \*STDOUT;
    }

    if(!$layer || !$layer->is_ready) {
        # TODO ERROR ?
        $self->proj->log("WARN: No layer: $layer " . $layer->name . " " . $layer->is_ready);
        return;
    }

    $self->{'dont_save_into_a_file'} = 1 if $self->{dont_use_minicategs_cache};

    my $ph2cts = $self->clean_minicategs_subphrases_hash($layer, $addlayer);
    if($self->{categs_test_inf}) {
        print {$self->{categs_test_inf}} ("after phrases filter: ".join(",", map{$self->decode_minicateg_subphrase($_)} keys %$ph2cts)."\n");
    }

    $ph2cts = $self->apply_catalysts($ph2cts);

    my %cthash = map {$_ => 1} grep {$_} (map {keys %{$ph2cts->{$_}}} keys %$ph2cts);

    my @categs = clean_minicategs_list_by_diff(sort keys %cthash);
    if($self->{categs_test_inf} && @categs < scalar(keys %cthash)) {
        print {$self->{categs_test_inf}} "categs diff: ".join("/", sort keys %cthash)." -> ".join("/", @categs)."\n";
    }

    return @categs;
}

sub is_subcategory {
    my ($self, $categ) = @_;
    for ($self->get_minicategs) {
        return 1 if $categ eq $_;
        my @cp = _cat_path($_);
        return 1 if $categ ~~ @cp;
    }
    return 0;
}

sub get_minicategs :CACHE {
    my ($self) = @_;

    return () unless $self->text;

    # эксперименты с позициями слов
    if($Utils::Common::options->{experiment_word_position}) {
        my @snorms = $self->snormwords;
        $self->{snorm2pos} = {};

        for my $pos (0..$#snorms) {
            push @{$self->{snorm2pos}{$snorms[$pos]} ||= []}, $pos;
        }
    }

    return @{$self->{cdict_minicategs}} if (defined $self->{cdict_minicategs});

    my @categs = grep{!check_minicategs_flag $_, "dim2"} $self->base_get_minicategs($self->language->layer_categs, $layer_digits);

    @categs = $self->get_uncertain_minicategs if $use_uncertain_minicategs && !@categs;

    return @categs;
}

sub get_minicategs_ids :CACHE {
    my $self = shift;
    return grep {defined} map {get_minicateg_id($_)} $self->get_minicategs;
}

sub get_production_minicategs {
    my ($self) = @_;
    my @categs;
    my $proj = $self->proj;
    my $curr_subphraser = $proj->subphrases_client;

    $proj->{subphrases_client} = $proj->perfect_subphrases_client;
    @categs = $self->get_minicategs;
    $proj->{subphrases_client} = $curr_subphraser;

    return @categs;
}

sub get_minicategs_directids :CACHE {
    my ($self) = @_;
    return $self->get_minicategs_directids_from_categs( $self->get_minicategs );
}

sub get_minicategs_directids_from_categs {
    my @categs = @_;
    return grep { $_ } map { get_minicateg_directid($_) } @categs;
}


sub get_videodirectgroups_directids_from_categs {
    my @categs = @_;
    return grep { $_ } map { get_videodirectgroup_directid($_) } get_videodirectgroups_from_categs( @categs );
}

sub get_minicategs_videodirectgroups_directids_from_categs {
    my @categs = @_;
    return (get_minicategs_directids_from_categs(@categs), get_videodirectgroups_directids_from_categs(@categs));
}

sub get_minicategs_videodirectgroups_directids :CACHE {
    my ($self) = @_;
    return get_minicategs_videodirectgroups_directids_from_categs($self->get_minicategs);
}

sub get_minicategs_phraselog :CACHE {
    my ($self) = @_;
    my ($prrd, $prwt) = ($self->proj->categs_tree->never_read_categs_cache, $self->proj->categs_tree->never_write_categs_cache);
    $self->proj->categs_tree->never_read_categs_cache(1);
    $self->proj->categs_tree->never_write_categs_cache(1);
    my $prev_ct_log = $self->{categs_log_inf};
    $self->{categs_log_inf} = 1;

    $self->get_minicategs;
    my $res = $self->{categs_log_rawlist};

    $self->{categs_log_inf} = $prev_ct_log;
    $self->proj->categs_tree->never_read_categs_cache($prrd);
    $self->proj->categs_tree->never_write_categs_cache($prwt);
    return $res;
}

sub get_norm_minicategs_text :CACHE {
    my ($self) = @_;
    return join('/', map { $self->get_normed_categ($_) } map{ $self->language->category_from_ru($_) } $self->get_minicategs);
}

sub get_minicategs_log :CACHE {
    my ($self) = @_;
    my ($prrd, $prwt) = ($self->proj->categs_tree->never_read_categs_cache, $self->proj->categs_tree->never_write_categs_cache);
    $self->proj->categs_tree->never_read_categs_cache(1);
    $self->proj->categs_tree->never_write_categs_cache(1);
    my $prev = $self->{categs_log_inf};

    my $text = "$self";
    my $t = "";
    $text =~ s/ ?=>.*$//;
    my $ph = $self->proj->phrase($text);
    $ph->{categs_log_inf}++;
    $ph->get_minicategs;
    my @lines = @{$ph->{categs_log_list}};
    s/\n// for @lines;
    $t .= join( '', map { '#'.$_."" } @{$ph->{categs_log_list}} );
    $t=~s/,/ /g;

    $self->{categs_log_inf} = $prev;
    $self->proj->categs_tree->never_read_categs_cache($prrd);
    $self->proj->categs_tree->never_write_categs_cache($prwt);

    return $t;
}

sub get_groups_for_categs {
    my ($self, $categs, $groups) = @_;
    my $proj = $self->proj;
    my $c2g = $groups->categ2group;
    my ($fxh, $addh) = $groups->groups_fix; #данные для убирания противоречий между категориями
    my $ph = $self;
    my @ctgs = @$categs;
    my @origctgs = @ctgs;
    my @pctgs = ();
    my @log_pairs = ();
    my @log_addctgs = ();
    my @log_badctgs = ();
    my $badflt = {}; #Фильтр плохих категорий
    my $log = defined($self->{mediagroups_log});
    if(@ctgs > 1){ #накладываем подавление, если много категорий
        @ctgs = (@ctgs, (map { @{$addh->{$_} || []} } @ctgs)); #добавляем специальные категории от некоторых категорий
        @log_addctgs = map { @{$addh->{$_} || []} } @ctgs if $log;

        #Обратный фильтр по плохим
        #my $bdflt = map { my $c = $_;  map {   } ( $c, (map { @{$addh->{$c} || []} } ) ) } @ctgs;

        #перебираем пары и получаем варианты категорий от пар
        @ctgs = sort @ctgs;
        for my $c1 (@ctgs){
            for my $c2 (@ctgs){
                last if $c2 ge $c1;
                if( $fxh->{$c2.'/'.$c1} ){
                    push(@pctgs, $fxh->{$c2.'/'.$c1}); #Если для пары есть указанные правильная категория - добавляем
                    push(@log_pairs, $c2.'/'.$c1 .' -> '.$fxh->{$c2.'/'.$c1}) if $log; #Информация о парах для лога
                    my ($bdctg, $gdctg) = ($c2 ne $fxh->{$c2.'/'.$c1}) ? ($c2, $c1) : ($c1, $c2);
                    push(@log_badctgs, $bdctg) if $log;

                    #Находим категории, связанные с плохими категориями
                    $badflt->{$_}++ for grep { grep {$_ eq $bdctg } ( $_, @{$addh->{$_} || []} ) } grep { $_ ne $gdctg } @ctgs;
                }
            }
        }
        #Фильтруем категории от плохих
        @ctgs =  grep {! $badflt->{$_}} (@pctgs, @ctgs);
        @ctgs =  keys %{{ map {$_=>1} @ctgs}};

        #Удаляем обобщающие категории
        @ctgs =  grep { ! /^\*/} @ctgs;

        @ctgs = keys %{{ map {$_=>1} @pctgs }} if (!@ctgs) && @pctgs;

        #@ctgs = @pctgs if @pctgs; #Если есть указанные категории для пар, отдаём им предпочтение
    }

    my %hgrps;
    for my $categ (@ctgs) {
        my $fixed_categ = $categ;
        $fixed_categ =~ s/(\s+)$//;
        my @groups =  grep{$_} @{$c2g->{$categ} || $c2g->{$fixed_categ} || []};

        if(!@groups && $categ =~ / _ /) {
            $categ =~ s/^.+\s_\s//;
            @groups = grep{$_} @{$c2g->{$categ} || []};
        }

        $hgrps{$_}++ for @groups;
    }
    my @grps = sort keys %hgrps;

    if($log) {
        my $ttext = "";
        $ttext .= "# origcategs: ".join('/', @origctgs)."\n";
        $ttext .= $self->get_minicategs_log;
        $ttext .= "# addcategs: ".join('/', @log_addctgs)."\n";
        $ttext .= "# pairs: \n".join('', map {"#   -- $_\n"} @log_pairs);
        $ttext .= "# pctgs: ".join('/', keys %{{ map { $_=>1} @pctgs }})."\n";
        $ttext .= "# badctgs: ".join('/', @log_badctgs)."\n";
        $ttext .= "# badflt: ".join('/', keys %$badflt)."\n";
        $ttext .= "# result: ".join('/', @grps)."\n";
        $self->{mediagroups_log} = $ttext;
    }

    return @grps;
}

sub get_groups {
    my ($self, $groups) = @_;
    return $self->get_groups_for_categs([$self->get_minicategs], $groups);
}

sub get_mediagroups_for_categs {
    my ($self, $categs) = @_;

    return $self->get_groups_for_categs($categs, $self->proj->mediagroups);
}

sub get_mediagroups :CACHE {
    my ($self) = @_;

    return $self->get_groups($self->proj->mediagroups);
}

sub get_videodirectgroups :CACHE {
    my ($self) = @_;
    return get_videodirectgroups_from_categs( $self->get_minicategs );
}

sub get_videodirectgroups_from_categs {
    my @cts = @_;
    my @sts = map { @{ $categ2videodirectgroup->{$_} // [] } } @cts;
    @sts = grep { $_ } map { map { @{ $categ2videodirectgroup->{$_} // [] } } _cat_path($_) } @cts unless @sts;
    #print Dumper(\@sts);
    my @gd = grep { $_ ne 'нейтральная' } @sts;
    @sts = @gd if @gd;
    @sts = ('нейтральная') unless @sts;
    return sort keys {map {$_=>1} @sts};
}

sub get_minicategs_test_info {
    my ($self, $endline) = @_;

    my $str = "";
    open my $fh, ">", \$str or $self->log("ERROR: Cannot open > in sub get_minicategs_test_info");

    $self->{categs_test_inf} = $fh;
    $self->get_minicategs;
    close $fh or die "close failed ($!)";

    $str = Encode::decode('UTF-8', $str);

    if($endline) {
        $str =~ s/\n/$endline/g;
    }

    return $str;
}

sub get_minicategs_test_info_analyzer {
    my ($self, $endline) = @_;
    return ($self->get_minicategs_test_info($endline), $self->get_analysis);
}

sub translate_minicategs :CACHE {
    my ($self) = @_;
    return map{$self->language->category_from_ru($_)} $self->get_minicategs;
}

sub get_minicategs_rltd {
    my ($self) = @_;
    my @arr = get_minicategs_subtrees( map { $_, get_minicateg_nephews($_), get_minicateg_siblings($_) }  $self->get_minicategs );
    return @arr;
}

sub get_uncertain_minicategs :CACHE {
    my ($self) = @_;
    return $self->base_get_minicategs($self->language->layer_uncertain);
}

sub get_exact_minicategs :CACHE {
    my ($self) = @_;
    my $lang = $self->language;
    my $text = $self->text;

    my %h = map{$_ => 1} grep{$_} split "/", ($lang->layer_categs->get_phrase_data($lang->phrase(_parse_multiwords($text, $lang))) || "");
    return sort keys %h;
}

sub get_related_minicategs {
    my ($self, @cts) = @_;
    my @arr = get_minicategs_subtrees( map { $_, get_minicateg_nephews($_), get_minicateg_siblings($_) } @cts );
    return @arr;
}


########################################################################
# Работа с парадигмами слов
########################################################################=

# дерево категорий
# массив элементов вида [ID, DirectID, ParentDirectID, Title]
sub generate_categs_tree {
    my @result;

    for my $categ (sort grep{$minicateg2categid->{$_} && !/^(\!|\.)/} keys %$minicateg2directid) {
        my $parent = get_minicateg_parent($categ);
        push @result, [
            get_minicateg_id($categ),
            $minicateg2directid->{$categ},
            $minicateg2directid->{$parent} || 0,
            $categ
        ];
    }

    return @result;
}

sub expand_anonymous_atoms {
    my ($self) = @_;

    my $text = $self->text;
    # часть синтаксиса опускаем
    $text =~ s/[<>"{}]//g;

    # находим атомы
    my @raw_atoms = $text =~ /\[([^\]]+)\]/g;
    my @atoms_info = ();
    for my $raw_atom (@raw_atoms) {
        # не допускаем маркеры пустых строк в середине списка
        $raw_atom =~ s/\/(\s*\/)+/\//g;
        next if $raw_atom eq '/';
        push @atoms_info, [];
        for my $atom (split '/', "$raw_atom ") {
            # убираем пробельные символы с начала и с конца атома
            $atom =~ s/^(\s+)|(\s+)$//g;
            push @{$atoms_info[-1]}, $atom;
        }
    }
    # убираем атомы из текста
    $text =~ s/\[[^\]]+\]//g;
    $text =~ s/^(\s+)|(\s+)$//g;

    my @result = ($text);
    for my $atoms (@atoms_info) {
        my @current_result = ();
        for my $atom (@$atoms) {
            for (@result) {
                push @current_result, ($atom =~ /^\./ ? "$_ [$atom]" : "$_ $atom");
                if (@current_result >= 100_000) {
                    $self->proj->log("expand_anonymous_atoms limit 100_000 reached");
                    last;
                }
            }
        }
        @result = @current_result;
    }
    s/^(\s+)|(\s+)$//g for @result;

    return \@result;
}

sub expand_to_phl_atoms_bender {
    my ($self, $max_phrases) = @_;
    my $text = $self->text;

    # часть синтаксиса опускаем
    $text =~ s/[<>"{}]//g;

    if($text !~ /\[/) {
        return $self->proj->phrase_list({ phrases_list => [$self] });
    }

    my @atoms = ($text =~ /\[([^\]]+)\]/g);
    @atoms = map{[_parse_atom_phrases($self->proj, $_, $self->language)]} @atoms;

    $text =~ s/\[([^\]]+)\]/ /g;

    push @atoms, [$text] if $text !~ /^\s*$/;

    my $q = join " ", map{"(".join("|", grep{$_} map{$self->proj->phrase($_)->norm_phr} @$_).")".((grep{!$_} @$_) ? "?" : "")} @atoms;
    my %phrases = split "\t", $self->proj->bender_client->exec_command("top\t$max_phrases\t1\t$q");

    return $self->proj->phrase_list({ phrases_arr => [keys %phrases] });
}

sub _turkish_lc {
    my ($pattern) = @_;
    $pattern =~ tr/Iİ/ıi/;
    return lc $pattern;
}

my $lang2lccategs = {};
sub search_category_by_name {
    my ($self) = @_;
    my $pattern = $self->text;
    $pattern = $self->lang eq 'tr' ? _turkish_lc($pattern) : lc($pattern);
    $pattern = qr/$pattern/;

    if(!$lang2lccategs->{$self->lang}) {
        $lang2lccategs->{$self->lang} = [ map{$self->lang eq 'tr' ? _turkish_lc($_) : lc($_)} $self->language->get_categories_list ];
    }
    my @result = grep{/$pattern/} @{$lang2lccategs->{$self->lang}};

    return @result;
}

sub search_category_by_snorm {
    my ($self) = @_;
    my $h = $self->language->layer_csnorms->search_subphrases_data($self);
    my %result;

    for my $phr (keys %$h) {
        $result{$_}++ for grep{$_} split "/", $h->{$phr};
    }

    return sort keys %result;
}

sub search_atoms_snorm :CACHE {
    my ($self) = @_;
    my $layer = $self->language->layer_atoms_named;
    my $h = $layer->search_subphrases_data($self);
    my $result = {};

    for my $snorm (keys %$h) {
        for my $categ (grep{$_} split "/", $h->{$snorm}) {
            ($result->{$snorm} ||= {})->{$categ}++;
        }
    }

    return $result;
}

sub search_atoms :CACHE {
    my ($self) = @_;
    my $layer = $self->language->layer_atoms_named;
    my $h = $self->search_atoms_snorm;
    my $result = {};

    for my $snorm (keys %$h) {
        for my $categ (keys %{$h->{$snorm}}) {
            my $orig = $layer->get_orig_phrase($categ, $snorm);
            ($result->{$orig} ||= {})->{$categ}++;
        }
    }

    return $result;
}

sub search_marker_atoms :CACHE {
    my ($self) = @_;
    my $layer = $self->language->layer_atoms_named;
    my $h = $self->search_atoms_snorm;
    my $result = {};

    my $marker_atoms_hash = marker_atoms_hash();

    for my $snorm (keys %$h) {
        for my $categ (keys %{$h->{$snorm}}) {
            #регулярка - чтобы убрать антиворды из ответа сабфрейзера и отобрать только нужные атомы
            next unless $marker_atoms_hash->{$categ =~ s/@.*$//r};
            my $orig = $layer->get_orig_phrase($categ, $snorm);
            unless ( $orig ) {
                $categ =~ s/@.*$//;
                $orig = $layer->get_orig_phrase($categ, $snorm);
            }
            ($result->{$orig} ||= {})->{$categ}++;
        }
    }
    return $result;
}

sub search_dict_phrases {
    my ($self, $dict_name) = @_;
    my @result;

    my $h = $self->search_atoms;
    for my $phrase (keys %$h) {
        push @result, $phrase if $h->{$phrase}{$dict_name};
    }

    return @result;
}

sub get_minicategs_snippets {
    my $self = shift;
    my %par = @_;

    my $top_search_results = $par{top_search_results} // 10;
    my $n_categs = $par{n_categs} // 1;
    my %opts = (
        groupby => "groups-on-page%3D$top_search_results",
    );

    my $texts = $self->expand_anonymous_atoms;
    my %ctgs;
    for my $text (@$texts) {
        my $phr = $self->proj->phrase($text);
        my @docs = $phr->get_xml_search(%opts);
        my $n = 1;  # use weight decay
        for my $doc (@docs) {
            my $title = $doc->{title} // "";
            my $headline = $doc->{headline} // "";
            my $snippet_phr = $self->proj->phrase("$title $headline");

            $ctgs{$_} += 1/sqrt($n) for $snippet_phr->get_minicategs();
            $n++;
        }
    }

    return (sort {$ctgs{$b} <=> $ctgs{$a}} keys %ctgs)[0..$n_categs-1];
}

sub get_minicategs_snippets_tails {
    my $self = shift;
    my %par = @_;

    my $top_search_results = $par{top_search_results} // 10;
    my $n_categs = $par{n_categs} // 1;
    my %words = map {$_ => 1} $self->uniqsnormwords;
    my %opts = (
        groupby => "groups-on-page%3D$top_search_results",
    );

    my $texts = $self->expand_anonymous_atoms;
    my %ctgs;
    for my $text (@$texts) {
        my $phr = $self->proj->phrase($text);
        my @docs = $phr->get_xml_search(%opts);
        my $n = 1;  # use weight decay
        for my $doc (@docs) {
            my $title = $doc->{title} // "";
            my $headline = $doc->{headline} // "";
            my $snippet_phr = $self->proj->phrase("$title $headline");

            my $snippet_tail_words = join " ", grep {!defined $words{$_}} $snippet_phr->uniqsnormwords;
            my $snippet_tail_phr = $self->proj->phrase($snippet_tail_words);
            my @categs = $snippet_tail_phr->get_minicategs();
            next unless @categs;
            $ctgs{$_} += 1/sqrt($n) for @categs;
            $n++;
        }
    }

    return (sort {$ctgs{$b} <=> $ctgs{$a}} keys %ctgs)[0..$n_categs-1];
}

sub find_search_tails_categories_spectrum {
    my ($self, $stop_threshold) = @_;

    my $text = $self->text;
    my @search_tails = keys %{$self->get_search_tail};

    my %categories_spectrum = ();
    for my $search_tail (@search_tails) {
        my $phrase = $self->language->phrase("$text $search_tail");
        my @phrase_categories = $phrase->get_minicategs;
        $categories_spectrum{$_} = 1 for @phrase_categories;
        my $categories_spectrum_size = keys %categories_spectrum;
        return [sort keys %categories_spectrum]
            if defined($stop_threshold) && $categories_spectrum_size >= $stop_threshold;
    }

    return [sort keys %categories_spectrum];
}

sub get_category_phrases {
    my $self = shift;

    return [$self->language->get_category_raw_phrases($self->text)];
}

sub compute_categories_tree_md5 {
    my $self = shift;

    my @data = sort map {get_minicateg_parent($_) . "\t$_"} get_minicategs_list;
    return Utils::Sys::md5int(join("\t", @data));
}

sub get_analysis {
    my $self = shift;
    return $self->{analysis};
}

1;
