package BM::PhraseList;

use strict;

use utf8;
use open ':utf8';

use std;
use base qw(ObjLib::ListObj BM::MCached BM::PhraseListProductPhrases);

use Data::Dumper;
use List::Util qw(min sum);
use Utils::Sys;
use Utils::SubsetIndex;
use Scalar::Util qw(weaken);
use Utils::Sys qw(md5int uniq);
use Utils::Words;
use Utils::Common;
use Utils::Funcs qw(decode_quotes);
use Subphraser;
use Utils::XLS qw(xls2array xlsx2array csv2array array2xls array2xls_multi);
use Utils::Array;
use Utils::Regions qw();

use Encode;
use Encode qw{ _utf8_on _utf8_off };
use Time::HiRes qw(gettimeofday tv_interval);

our $genocide_categs = '';

#         count                         Количество фраз
#         size                          Количество фраз
#         number_of_phrases             Количество фраз
#         phexists                      Поверка наличия фразы
#         tgrep                         Фильтрация фраз по тексту ->tgrep( sub { /abc/ } )
#         phgrep                        Фильтрация фраз по объекту ->phgrep( sub { $_->norm_phr eq 'abc' } )

#         normwordshash                 Хэш нормальных форм слов из фраз
#         snormwordshash                Хэш снормализованных слов из фраз

#         tmap                          На вход текст, на выход - массив текстов или объектов
#         phmap                         На вход объект phrase, на выход - phrase_list
#         phtmap                        На вход объект phrase, на выход - массив текстов или объектов

#         filter_subphrases             Удаление по включению ['a b c','a b'] => ['a b c']
#         phrases_fill_a_gap            ['a b', 'a b c d'] => ['a b', 'a b c', 'a b c d']
#         minus_words_pack              ['a b', 'a b c'] => ['a b -c', 'a b c']
#         minus_words_pack_fast         без добавления новых фраз
#         test_categs_info              доклеивает через => к фразам информацию о категориях
#         add_categs_info
#         get_phrases_categs_hashref
#         filtered_snorm_pack_list
#         get_modellike_modifications
#         phrases_words                 Все слова, встречающиеся во фразах, возвращает массив
#         phrases_words_phl
#         phrases_words_counts_phl      Список слов с частотами
#         phrases                       Возвращает массив объектов фраз
#         perl_array                    Возвращает массив текстов фраз

#         norm_phrase_list              Для каждой фразы вернуть нормальную форму
#         snorm_phrase_list             Для каждой фразы вернуть снормализованную форму
#         norm_uniqwords_phrase_list
#         delete_minus_words            Удаляем минус-слова из фраз
#         delete_hyphens                Удаляет дефисы
#         text_without_stops            Удаляем из текста стоп-слова

#         pack_list                     Сжимает список фраз, нормализуя слова
#         text_pack_list                Сжимаем с точностью до текстов, не преобразуя их
#         snorm_pack_list               Сжимает список фраз, нормализуя слова с учётом синонимов
#         shortest_pack_list            Выбираем кратчайшие варианты текстов при сжатии

#         pack_minuswords               Удаляет повторы минус-слов

#         add_search_porn_minuswords    Добавляем частотные порно-слова в минус-слова

#         porn_filtered_phrases         Возвращает список не порно фраз
#         clear_list_by_other_list      Возвращает только те фразы, которых не совпадают и не уточняют фразы и не расширяют из указанного списка фраз
#         good_phrases_list             Возвращает объект с хорошими фразами
#         getmodelsphraseslist          Разваливает фразы на модели, если получается
#         phrases2text                  Пишем фразы в строку через запятую
#         search_sub_phrases($phl2)     Возвращает фразы, которые содержат фразы из второго списка (из $phl2)
#         get_wide_filtered             Возвращает список нешироких фраз
#         get_wide_phrases              Оставляет только широкие фразы
#         parse_phrase_inf              Парсит фразы по ':', помещая дополнительную информацию в поле inf
#         mark_phrs_normed              Пометить фразы как уже нормализованные

#         cache_search_count            Кэшируем частоты
#         cache_search_query_count      Кэшируем частоты как точной фразы
#         cache_search_syns             Кэшируем разваливание по синонимам
#         cache_search_tail             Кэшируем хвостики
#         cache_cdict_values($prefix, $cdict_client, $mtd)  Общий метод для кэширования, сохраняет в ->{"_cdict_value_$prefix"} значение для элемента

#         get_search_filtered           Фильтрует phrase_list по cdict
#         get_search_threshold_filtered Фильтрует phrase_list по cdict, первым параметром - порог показов
#         get_search_syns               Развалить  на синонимы с помощью cdict
#         get_search_syns_keeping_minuswords Развалить  на синонимы с помощью cdict с сохранением минус-слов
#         get_search_filtered_syns      get_search_syns + контекстные синонимы
#         test_search_and_banners_count_inf  Доклеить частоты на поиске как точной фразы, на поиске и как фразы в баннерах

#         get_xls                       Получить список фраз в формате Excel'я
#         get_xls_count                 Получить список фраз в формате Excel'я с добавлением частоты
#         get_xls_info                  Получить список фраз в формате Excel'я с добавлением статистической информации

#         text_without_cities_words     удалить названия городов из фраз, фразы нормализуются

#         harmonize                     Согласует (ставит в ту же форму число-падеж) каждую фразу phrase list c переданной в параметре фразой
#         harmonize_by_first            Согласует весь phrase list по его первой записи

#         add_search_tail               Получить по CDICT фразы, в которые фраза входит как подфраза
#         get_bnr_count_filtered        Фильтрация по использованию фразы в баннерах
#         get_query_count_filtered      Фильтрация наличием запросов из этой фразы

#         set_exclamations_befote_stops      Нормализует слова, проставляет воскл. знаки перед стоп-словами
#         set_exclamations_befote_bsstops    Не нормализует слова, проставляет воскл. знаки перед стоп-словами БК

#         get_matched_bannerlist        Извлекает все баннеры, в которых содержатся фразы фрэйзлиста
#         get_matched_bannerlist_hash   Возвращает хеш хешей: текст фразы и прикрепленный к ней баннерлист баннеров, в которые она входит подфразой

#         group_phrases                 Выделяет главные фразы из списка и группирует остальные
#         filter_subphrases             Удаляет из списка подфразы, являющиеся частью более длинных фраз

#         get_minus_words               Получить список минус-слов
#         get_plusflt_minus_words       Получить список минус-слов, убрав плюс-слова

#         delete_bad_subphrases         Вычищает тексты от плохих подфраз
#         pack_spaces                   Сжимаем пробелы
#         pack_spaces_and_underscore    Сжимаем пробелы и удаляем подчерки

#         clear_utf8                    Исправляет битый utf8
#         to_lc                         Приводит текст к нижнему регистру

#         enumerate_words               Возвращает массив хешей с пронумерованными словами (только буквы, цифры и пробелы, без дефисов)
#         enumerate_norm_words          Возвращает массив хешей с пронумерованными нормализованными словами (только буквы, цифры и пробелы, без дефисов)

#         freq_hash                     Хэш частот фраз в списке
#         freq_phrase                   Самая частотная фраза

#         hyphenation                   Вставляем тильду в местах, где возможен перенос слова

#         take_models_in_interface      Метож извлекает "тип брэнд модель" в виде фразы, используется в интерфейсе Каталогии

#         direct_format_phrases         Формат фраз Директа (убираем ~0)

#         sort_phrases                  Отсортировать фразы
#         sort_phrases_search_count     Отсортировать фразы по частоте на поиске (в обратном порядке)
#         sort_phrases_num              Отсортировать фразы как числа
#         sort_phrases_query_count      Сортировка по частоте как запроса
#         sort_phrases_query_count_and_add_count

#         delete_useless_minus_words    Удаление минус-слов без частот

#         delete_quotes                 Удаляем двойные кавычки и ~0 из фраз

#         add_count_and_categs_inf      Доклеиваем информацию о частоте и списке категорий

#         mark_misprints                Пометить фразы с опечатками

#         add_important_words($text)    Из входного текста берёт список слов и проверяет их наличие с точностью до синонимов. Если слов нет - заменяет фразу на список с дописанными словами.

#         casecorrection                Восстанавливает регистр слов
#         do_ucfirst                    Переводит первую букву в верхний регистр

#         cache_cdict_values($preix, $cdictclient)            По ключу возвращает значение хеша из cdict, пишет его в поле cdict_value_$prefix, передаются префикс хеша и объект клиента cdict

#         delete_trade_words
#         delete_town_words

#         test_regions_search_count     Доклеить данные по частотам с учётом регионов
#         tfidf                         Для каждой фразы в порядке следования вычисляет хеш tf-idf по словам; возвращает массив хешей

#         subphrases_groups_format      Фразы группируются по подстрокам в хэш массивов

#         intersection                  Вычисляет пословное пересечение фраз
#         delete_list($phl)             Вычитает указанный список по нормам
#         parse_banner_ids              (для BMAPI) по списку ID баннеров получить информацию о брендах и моделях
#         parse_banner_texts            (для BMAPI) по списку строк "$title\t$body" получить информацию о брендах и моделях в тексте баннера

# здесь учитываются возможные аргументы при создании PhraseList
#   phrases_text -- строка: фразы через запятую
#   phrases_inf_text -- строка вида фраза:парам1:парам2:...,фраза:парам1:парам2
#   phrases_arr -- массив текстов фраз
#   phrases_list -- массив объектов типа фраза

sub phrases {
    my $self = shift;
    return @{$self->phrases_arr};
#    my $proj = $self->proj;
#    return map {$proj->phrase($_)} split /,\s*/, $self->{'phrases_text'} if defined $self->{'phrases_text'};
#    return map {$proj->phrase(shift(@$_), $_ )} map { [split(':', $_)] } split ',', $self->{'phrases_inf_text'} if $self->{'phrases_inf_text'};
#    return map {$proj->phrase($_)} @{$self->{'phrases_arr'}} if $self->{'phrases_arr'};
#    return grep {$_} @{ $self->{'phrases_list'}} if $self->{'phrases_list'};
#    return ();
}

sub phrases_arr :CACHE :LANG {
    my $self = shift;
    my $proj = $self->proj;
    my $prot = $proj->{_phrase_prot};
    my ($proxy, $lang) = ( $self->{'proj_proxy_ref'}, $proj->{current_lang} );
    return [ map {$prot->new_lite( { text => $_, proj_proxy_ref => $proxy, lang => $lang } )} @{$self->split_phrases_text} ] if defined $self->{'phrases_text'};
    return [ map {$prot->new_lite( { text => shift(@$_), inf => $_, proj_proxy_ref => $proxy, lang => $lang } )} map { [split(':', $_)] } split /,\s*/, $self->{'phrases_inf_text'} ] if defined $self->{'phrases_inf_text'};
    if (defined $self->{external_inf_text}) {
        my @phrs;
        for my $data (split /,\s*/, $self->{external_inf_text}) {
            my ($text, @inf) = split /:/, $data;
            $text = decode_quotes($text);
            push @phrs, $prot->new_lite({ text => $text, inf => \@inf, proj_proxy_ref => $proxy, lang => $lang });
        }
        return \@phrs;
    }
    return [ map {$proj->phrase($_)} @{$self->{'phrases_arr'}} ] if $self->{'phrases_arr'};
    return [ grep {defined $_} @{ $self->{'phrases_list'}} ] if $self->{'phrases_list'};
    return [];
}

sub split_phrases_text {
    my $self = shift;

    my $phrases_text = $self->{phrases_text};

    # support of {...} syntax
    my @cat_names = $phrases_text =~ /\{([^\}]+)\}/g;
    $phrases_text =~ s/\{([^\}]+)\}/{}/g;
    my $cat_name_index = 0;
    my @texts = map { ##no critic
        s/\{\}/'{' . $cat_names[$cat_name_index++] . '}'/eg; $_
    } split /,\s*/, $phrases_text;

    return \@texts;
}

sub perl_array {
    my $self = shift;
    my @res = ();
    push @res, $_->text for ( $self->phrases );
    return \@res;
}

sub perl_hash {
    my $self = shift;
    my %res = ();
    $res{$_->text}++ for ( $self->phrases );
    return \%res;
}

sub list_arrayref {
    my $self = shift;
    return $self->phrases_arr;
}

sub phexists {
    my ($self, $phr) = @_;
    return $self->phgrep( sub { $_ eq $phr } )->count;
}

sub new_listobj {
    my $self = shift;
    return $self->proj->phrase_list( @_ );
}

sub list2text {
    my $self = shift;
    return $self->phrases2text;
}

sub count :CACHE {
    my $self = shift;
    return 0+@{$self->{'phrases_arr'}} if defined $self->{'phrases_arr'};
    return $self->SUPER::count;
}

sub number_of_phrases {
    my $self = shift;
    return $self->count;
}

sub language :CACHE {
    my $self = shift;
    return $self->proj->get_language($self->lang) || $self->proj->default_language;
}

sub normwordshash {
    my $self = shift;
    return { map {$_=>1} map { $_->normwords } @$self };
}

sub snormwordshash :CACHE {
    my $self = shift;
    return { map {$_=>1} map { $_->snormwords } @$self };
}

sub mark_phrs_normed {
    my $self = shift;
    $_->{normed} = 1 for @$self;
    return $self;
}

sub good_phrases_list :CACHE {
    my $self = shift;
    return $self->phrarr2phrlist( grep {$_->is_good_phrase} $self->phrases );
}

sub phrtextarr2phrlist {
    my $self = shift;
    return $self->proj->phrase_list( \@_ );
}

sub phrarr2phrlist {
    my $self = shift;
    return $self->proj->phrase_list( \@_ );
}

sub phrase_list {
    my $self = shift;
    return $self->proj->phrase_list( @_ );
}

sub clear_copy {
    my $self = shift;
    my @phrs;
    for my $phr ($self->phrases) {
        push @phrs, $self->proj->phrase($phr->text);
    }
    return $self->proj->phrase_list(\@phrs);
}

sub tgrep($&) {
    my ($self, $tgrep) = @_;
    my $phl = $self->language->phrase_list( [ grep { my $obj = $_; $_=$_->text; my $r = &$tgrep; $_=$obj; $r } $self->phrases ] ) ; ##no critic
    return $phl;
}

sub phgrep($&) {
    my ($self, $tgrep) = @_;
    my $phl = $self->language->phrase_list( [ grep { &$tgrep; } $self->phrases ] ) ;
    return $phl;
}

sub tmap($&) {
    my ($self, $func) = @_;
    my $phl = $self->language->phrase_list( [ map { $_=$_->text; &$func; } $self->phrases ] ) ; ##no critic
    return $phl;
}

sub phmap($&) {
    my ($self, $func) = @_;
    my $phl = $self->language->phrase_list( [ map { &$func->phrases } $self->phrases ] ) ;
    return $phl;
}

sub phtmap($&) {
    my ($self, $func) = @_;
    my $phl = $self->language->phrase_list( [ map { &$func } $self->phrases ] ) ;
    return $phl;
}

sub text_pack_list :CACHE :LANG {
    my $self = shift;
    my %seen;
    my @phrs = grep { !$seen{$_->text}++ } @$self;
    return $self->phrase_list(\@phrs);
}

#Для каждой фразы вернуть нормальную форму
sub norm_phrase_list : EXTERNALLY_USED("yt", "bmapi") {
    my $self = shift;
    return $self->phrarr2phrlist(phrases2norm($self->text_arr, $self->lang));
#    return $self->phrarr2phrlist( map { $_->norm_phr } $self->phrases );
}

sub norm_phrase_list_safe {
    my $self = shift;
    return $self->lmap(sub { $_->norm_phr_safe});
}

#Для каждой фразы вернуть нормальную форму
sub norm_quote_phrase_list {
    my $self = shift;
    return $self->lmap(sub { $_->norm_phr_quote});
}

#Для каждой фразы вернуть снормализованную форму
sub snorm_phrase_list {
    my $self = shift;
    return $self->phrarr2phrlist(phrases2snorm($self->text_arr, $self->lang));
#    return $self->phrarr2phrlist( map { $_->snorm_phr } $self->phrases );
}

#Для каждой фразы вернуть нормальную форму
sub norm_uniqwords_phrase_list {
    my $self = shift;
    return $self->phrarr2phrlist(phrases2uniqnorm($self->text_arr, $self->lang));
}

sub text_without_stops {
    my $self = shift;
    return $self->lmap(sub { $_->text_without_stops });
}

sub text_add_pluses_to_stop_words {
    my $self = shift;
    return $self->lmap(sub { $_->text_add_pluses_to_stop_words });
}

sub text_delete_pluses_except_stop_words {
    my $self = shift;
    return $self->lmap(sub { $_->text_delete_pluses_except_stop_words });
}

#Сжимает повторы с учётом нормализации
sub pack_list :CACHE :LANG {
    my $self = shift;
    my %seen;
    my @phrs = grep { $_->norm_phr and !$seen{$_->norm_phr}++ } @$self;
    return $self->phrase_list(\@phrs);
}

sub pack_list_angle_brackets :CACHE :LANG {
    my $self = shift;
    my (%seen, @phrs);
    for my $phr (@$self) {
        next if !$phr->norm_phr;
        my $key = ($phr->text =~ /<.+?>/) ? $phr->text : $phr->norm_phr;
        push @phrs, $phr if !$seen{$key}++;
    }
    return $self->phrase_list(\@phrs);
}

sub shortest_pack_list {
    my $self = shift;
    my @phrs = map { $_->[0] } sort { $b->[1] <=> $a->[1] } map { [$_, $_->flt_text_length ] } grep { $_->norm_phr } @$self;
    my %seen;
    @phrs = grep { !$seen{$_->norm_phr}++ } @phrs;
    return $self->phrase_list(\@phrs);
}

#Сжимаем повторы, не трогая слова в кавычках
sub spec_pack_list :CACHE :LANG {
    my $self = shift;
    return $self unless $self->count;
    my %seen;
    my @phrs = grep { $_->norm_phr_quote and !$seen{$_->norm_phr_quote}++ } @$self;
    return $self->phrase_list(\@phrs);
}

#Сжимает повторы с учётом снормализации
sub snorm_pack_list :CACHE :LANG {
    my $self = shift;
#    return $self unless $self->count;  # так делать нельзя - из-за CACHE возникают цикл. ссылки
    my %seen;
    my @phrs = grep { $_->snorm_phr and !$seen{$_->snorm_phr}++ } @$self;
    return $self->phrase_list(\@phrs);
}

sub pack_list_safe :CACHE :LANG {
    my $self = shift;
    my %seen;
    my @phrs = grep { $_->norm_phr and !$seen{$_->norm_phr_safe}++ } @$self;
    return $self->phrase_list(\@phrs);
}
sub delete_minus_words {
    my $self = shift;
    return $self->lmap(sub { $_->delete_minus_words });
}


#Если есть более длинные фразы, вкдючающие фразы короче более чем на слово,
#добавляем фразы промежуточной длины
#['a b', 'a b c d'] => ['a b', 'a b c', 'a b c d']
sub phrases_fill_a_gap {
    my $self = shift;

    my $maxcnt = undef;
    my $mincnt = undef;

    my @arr = $self->phrases;

    my $ind = {};
    for my $ph ( @arr ){
        my @w = $ph->normwords;
        my $cnt = $ph->number_of_words;
        if( (! defined $maxcnt) || ($maxcnt < $cnt) ){
            $maxcnt = $cnt;
        }
        if( (! defined $mincnt) || ($mincnt > $cnt) ){
            $mincnt = $cnt;
        }
    }

    my @lng = grep {$_->number_of_words > $mincnt+1} @arr; #фразы, которые могут включать другие
    my @sht = grep {$_->number_of_words < $maxcnt-1} @arr; #фразы, которые могут включаться в другие

    my @res = ();
    for my $ph (@lng){
        my $curcnt = $ph->number_of_words;
        for my $pht ( grep {$_->number_of_words < $curcnt-1} @sht){
            push(@res, @{$ph->get_gap($pht)});
        }
    }
    my $phl = $self->proj->phrase_list([$self->phrases, @res])->pack_list;
    return $phl;

}

sub get_minus_words {
    my ($self) = @_;
    return $self->phrtextarr2phrlist( uniq_array( map { $_->minuswords } @$self ) );
}

sub get_plusflt_minus_words {
    my ($self) = @_;
    my %flt = map { $_=>1 } map { $_->normwords } @$self;
    my @arr = grep {! $flt{$_}} uniq_array( map { $_->norm_minuswords } @$self );
    return $self->phrtextarr2phrlist( @arr );
}

# взаимная минусовка с сохранением написания фраз
sub minus_words_pack_orig : EXTERNALLY_USED("bmapi") {
    my ($self) = @_;
    my $norm2words = {};

    for my $phr (@$self) {
        my $subphl = $self->search_subphrases_in_phrase($phr, only_norm => 1);

        for my $subphr (@$subphl) {
            ($norm2words->{$subphr->norm_phr} ||= {})->{"-$_"}++ for grep{!$subphr->normwordshash->{$_}} $phr->uniqnormwords;
        }
    }

    return $self->lmap(sub { join(" ", $_->text, keys %{$norm2words->{$_->norm_phr} || {}}) });
}

#Дописываем к более коротким фразам минус-слова из более длинных
#['a b', 'a b c d'] => ['a b -c', 'a b -d', 'a b -c -d', 'a b c d']
#Не для БМ, а для внешних сервисов
sub minus_words_pack : EXTERNALLY_USED("bmapi") {
    my ($self, $fast) = @_;
    my ($qphl, $nqphl) = $self->divide(sub { $_->text =~ /^\s*"/ }); #Убираем фразы в кавычках из обработки

    my $origphrase = { map { $_->norm_phr => $_, $_->norm_phr_uniq => $_ } @$self };

    my $curphl = $nqphl->delete_hyphens;
    #print STDERR "IN:\n";
    #print STDERR Dumper ([sort @{$self->perl_array}]);
    my $result = { map{$_->norm_phr_uniq => {map{$_ => 1} $_->minuswords}} $curphl->phrases };

    #$curphl->cache_search_count;
    for my $phr (@$curphl) {
        #my $curr_count = $phr->get_search_count;
        my $subphl = $curphl->search_subphrases_in_phrase($phr, only_norm => 1);
        for my $subph (@$subphl) {
            next if $subph->norm_phr_uniq eq $phr->norm_phr_uniq; #Сама исходная фраза, пропускаем
            $subph = $origphrase->{$subph->norm_phr}; #Поиск возвращает нормализованные фразы, получаем исходную
            my %wh = map{$_ => 1} $subph->uniqnormwords;
            my @new_words = grep{!$wh{$_}} $phr->uniqnormwords;
            @new_words = keys %{{ map {$_=>1} @new_words }}; #Удаляем дубли новых слов
            next if @new_words > 10;
            my $hph = ($result->{$subph->norm_phr_uniq} ||= {}); #Хэш для найденной подфразы
            $hph->{$_}++ for @new_words; #Добавляем минус-слова
#            if($fast){ #Только добавление новых слов
#            }else{ #С дообавлением промежуточных фраз
            unless($fast){ #Только добавление новых слов
                for(my $mask = 0; $mask < (1 << scalar(@new_words)); $mask++) {
                    my %plus = map{$_ => 1} keys %wh;
                    my %minus;
                    for my $i (0..$#new_words) {
                        if($mask & (1 << $i)) {
                            $plus{$new_words[$i]}++;
                        } else {
                            $minus{$new_words[$i]}++;
                        }
                    }
                    my $text = join " ", sort keys %plus;

                    # проверяем, что новая фраза не является огрызком
                    #if($mask) {
                        #my $new_count = $phr->language->phrase($text)->get_search_count;
                        #next if $new_count > 0.9 * $curr_count;
                    #}

                    ($result->{$text} ||= {})->{$_}++ for keys %minus;
                }
            }
        }
    }
    #print STDERR "OUT:\n";
    #print STDERR Dumper ( [ sort map{join(" ", $_, map{"-$_"} keys %{$result->{$_}})} keys %$result] );
    #print STDERR " ----- \n\n";
    my $phl = $qphl + $self->phrtextarr2phrlist(map{join(" ", $_, map{"-$_"} keys %{$result->{$_}})} keys %$result);
    #$phl = $phl->uniq_pack_list;
    return $phl;
}

sub minus_words_pack_fast {
    my ($self) = @_;
    return $self->minus_words_pack(1);
}

#Определяем категории группы фраз
sub get_phrases_categs_hashref {
    my $self = shift;
    my %h = ();
    $h{$_}++ for map { $_->get_minicategs } @$self;
    return \%h;
}

sub get_phrases_categs {
    my $self = shift;
    my @ctgs = keys %{ $self->get_phrases_categs_hashref };
    return @ctgs;
}

sub get_minicategs : EXTERNALLY_USED("bmapi") {
    my $self = shift;
    return $self->get_phrases_categs;
}

sub get_minicategs_tree {
    my $self = shift;
    my ($prrd, $prwt) = ($self->proj->categs_tree->never_read_categs_cache, $self->proj->categs_tree->never_write_categs_cache);
    $self->proj->categs_tree->never_read_categs_cache(1);
    $self->proj->categs_tree->never_write_categs_cache(1);
    my $lst = {};
    my $dt = {};
    my $p = $self->proj->phrase('');
    for my $ph ( @$self ){
        $ph->{categs_log_inf}++;
        my @ctgs = $ph->get_minicategs;
        #@ctgs = ('Не категоризуются') unless @ctgs;
        for my $ct ( @ctgs ){
            my @path = $p->get_cat_path($ct);
            @path = reverse @path;
            push(@path, $ct);
            my $cur = $dt;
            for my $pct (@path){
                $cur->{"CTG $pct"} ||= { 'name' => $pct };
                $cur = $cur->{"CTG $pct"};
                $cur->{'subcnt'}++;
                if( $pct eq $ct ){
                    $cur->{'cnt'}++;
                    $cur->{catlogphrs}{$_}++ for @{$ph->{categs_log_list}};
                }
                $lst->{$pct} ||= $cur;
            }
        }
    }
    for my $el (values %$lst){
        my @arr = ();
        for my $k ( grep {/^CTG/} keys %$el){
            push(@arr, $el->{$k});
            delete($el->{$k});
        }
        $el->{sblist} = \@arr;
#        $el->{catlogphrs} = [ h2sa($el->{catlogphrs}) ];
        $el->{catlogphrs_text} = join( ' // ', map { join(' : ', @$_) }  h2sa( $el->{catlogphrs} ));
        $el->{catlogphrs_text_flt} = join( ' // ',
             map { s/^\s*--\s*//; $_ } ##no critic
             map { $_->[0][0].':'.$_->[1] }
             grep { $_->[0][1] eq $el->{'name'} }
             map { [ [ split '=>', $_->[0]], $_->[1] ] } h2sa( $el->{catlogphrs} )
             );
        $el->{'catid'} = $self->proj->categs_tree->get_minicateg_id($el->{'name'});
        $el->{'catidname'} = $self->proj->categs_tree->get_minicateg_by_id($el->{'catid'});
    }
    $self->proj->categs_tree->never_read_categs_cache($prrd);
    $self->proj->categs_tree->never_write_categs_cache($prwt);
    return [ values %$dt ];
}

sub get_minicategs_tree_text {
    my ($self, $tree, $pref) = @_;
    $tree ||= $self->get_minicategs_tree unless $pref;
    my $text = '';
    for my $dd ( @$tree ){
        $text .= $pref.$dd->{name}."   ".($dd->{'cnt'} || 0)." / ".($dd->{'subcnt'} || 0);
#        $text .= " => ".join( ', ', map { join(' : ', @$_) }  h2sa( $dd->{catlogphrs} ));
        $text .= " => ".$dd->{catlogphrs_text_flt};
        $text .= "\n";
        $text .= $self->get_minicategs_tree_text( $dd->{sblist}, "$pref    " );
    }
    return $text;
}

sub get_minicategs_rltd {
    my $self = shift;
    my %h = ();
    $h{$_}++ for map { $_->get_minicategs_rltd } @$self;
    return keys %h;
}

#Все слова, встречавшиеся во фразах
sub phrases_words {
    my $self = shift;
    my @wds = keys %{{ map { $_ => 1 } map { $_->normwords } @$self }};
    return @wds;
}

#Все слова, встречавшиеся во фразах, с частотами
sub phrases_words_counts_phl {
    my $self = shift;
    my $proj = $self->proj;
    my $h = {};
    for my $w ( map { $_->normwords } @$self  ){
        #специальный фикс для склеек слов через дефис
        if($w =~ /\-/){
            my @sw = split( /\-/, $w );
            my $lastword = pop @sw;
            $w = join( '-',
                (map { /[оеОЕ]$/ ? $_ : $proj->phrase($_)->normwords } @sw),
                $proj->phrase($lastword)->normwords,
            );
        }
        $h->{$w}++;
    }
    my @wds = map { "$_ =*> ".$h->{$_} } sort { $h->{$b} <=> $h->{$a} } keys %$h;
    return $self->phrarr2phrlist( @wds );
}

#Все слова, встречавшиеся во фразах
sub phrases_words_phl {
    my $self = shift;
    return $self->phrarr2phrlist( sort $self->phrases_words);
}

sub check_phrase_context {
    my ($self, $contexts) = @_;
    my $cts = { map {$_=>1} $self->proj->phrase( $contexts )->normwords };
#$self->proj->dd($cts, $contexts);
    my $res = $self->lmap(sub {
        my $ph = $_;
        my @wds = sort grep { $cts->{$_} } map {@$_} [$ph->normwords], $ph->get_tail_context , $ph->get_search_context;
        @wds = keys %{{ map { $_ => 1 }  @wds }};
        return "$_ => ".join(' ', @wds);
    });
#$self->proj->dd($res);
    return $res;
}

sub porn_filtered_phrases :CACHE {
    my $self = shift;
    return $self->phrarr2phrlist( grep {! $_->is_porno_phrase } $self->phrases );
}

sub filtered_snorm_pack_list :CACHE {
    my $self = shift;
    return $self->phrarr2phrlist(grep {! $_->is_good_phrase } $self->snorm_pack_list->phrases);
}

sub has_celebrities :CACHE {
    my ($self) = @_;
    for( $self->phrases ){
        return 1 if $_->has_celebrities;
    }
    return 0;
}

# разваливает модель по похожим моделям, комбинируя различные части
# параметры задаются в хеше:
#   model => текст_модели, если модель известна, ее можно передать параметром (тогда не надо парсить фразу внутри метода)
#   save_stops => экранировать стоп-слова в полученных фразах (=1, если никакие параметры не заданы)
#   ret_pairs  => возвращать список пар [оригинальная фраза, modellike_phl] (только новые фразы!)
#   no_filter_by_search_count => subj (по умолчанию требуем get_search_count > 0)
#   max_mlike  => макс. кол-во вариантов записи модели на фразу
#   fast => использовать метод parse_model вместо parse для получения модели (ускоряет работу метода)
sub get_modellike_modifications {
    my $self = shift;
    my %par  = @_;
    %par = (save_stops=>1) unless %par;
    $self->proj->rpc->call_with_rpc(
        sub { $self->get_modellike_modifications_generic(@_) },
        [ %par ],
    );
}

# код был в BM::Phrase::get_modellike_modifications, см. историю там
sub get_modellike_modifications_generic {
    my $self = shift;
    my %par  = @_;

    my $ctx = $par{ctx};
    my $proj = $self->proj;

    if (!$ctx->{todo}) {
        my @todo;
        for my $phr (@$self) {
            next if $phr->wordcount > 8;  # очень большие фразы не разваливаем
            next if !$phr->look_like_a_model;
            my $plus_text = $phr->plus_text;
            my $mdl = $par{model};
            if (!$mdl) {
                if ($par{fast}) {
                    $mdl = $proj->phrase($plus_text)->parse_model;
                    next unless $mdl;
                } else {
                    my %pres = $proj->phrase($plus_text)->parse;
                    $mdl = $pres{model} or next;
                }
            }

            my $mdl_orig = $mdl; # сохраняем оригинал модели
            $mdl =~ s/([\d.,]+)(?:x|х)([\d.,]+)/___$1___x___$2___/g;
            $mdl =~ s/([a-zA-Z])([0-9])|([0-9])([a-zA-Z])/$1? $1." ".$2 : $3." ".$4/eg; # отделяем буквы от цифр пробелами

            # пытаемся вытащить подмодели из кэша
            my $ckey = $mdl;
            $ckey =~ s/[ ]/-/g; # ключ должен быть одинаковым для моделей, где по-разному расставлены пробелы
            $ckey =~ s/\./-/g unless $ckey =~ /___/;

            #заменяем модельные разделители пробелами и разрываем буквы с цифрами
            $mdl =~ s/[-]/ /g;
            $mdl =~ s/\./ /g unless $mdl =~ /___/;
            $mdl =~ s/([a-zа-я]+)(?=\d)/$1 /g;
            $mdl =~ s/(\d+)(?=[a-zа-я])/$1 /g;
            my @pt = grep { $_ } split /\s+/, $mdl;
            next unless @pt > 1;

            @pt = @pt[0..9] if @pt > 10;
            # разваливаем по моделям
            my @arr;
            push @arr, $mdl_orig;
            push @arr, "@pt";
            while (@pt > 1 or length("@pt") > 4) {
                push @arr, $phr->verjoin(\@pt);
                pop @pt;
            }
            @arr = uniq(@arr);
            if (defined $par{max_mlike} and @arr > $par{max_mlike}) {
                # оставляем варианты с меньшим числом разбиений
                @arr = map { $_->[0] } sort { $a->[1] <=> $b->[1] } map { [ $_, scalar(split / /, $_) ] } @arr;
                @arr = splice(@arr, 0, $par{max_mlike});
            }
            $_ =~ s/___//g for @arr;

            push @todo, {
                orig_phr => $phr,
                plus_text => $plus_text,
                mdl_orig => $mdl_orig,
                mlike_phl => $proj->phrase_list(\@arr),
            };
        }
        my $mlike_phl = $proj->phrase_list([ map { @{$_->{mlike_phl}} } @todo])->text_pack_list;
        return [] if $par{ret_pairs} and !@todo;
        $ctx->{todo} = \@todo;
        return (undef, [[cache_search_count => $mlike_phl ]]);
    }

    my @res;
    my $todo = delete $ctx->{todo};
    for my $td (@$todo) {
        my $mdl_orig_quoted = quotemeta($td->{mdl_orig});
        my $phl = $td->{mlike_phl};
        $phl = $phl->lgrep(sub { $_->get_search_count > 0 }) unless $par{no_filter_by_search_count};

        # разваленные модели подставляем в исходную фразу
        my @modellike;
        for my $phr (@$phl) {
            my $mlike = $phr->text;
            my $plus_text = $td->{plus_text};
            eval { $plus_text =~ s/$mdl_orig_quoted/$mlike/i };
            push @modellike, $plus_text;
        }
        push @res, [$td->{orig_phr}, $proj->phrase_list(\@modellike)] if @modellike;
    }
    if ($par{save_stops}) {
        for my $h (@res) {
            $h->[1] = $h->[1]->set_exclamations_before_stops->set_exclamations_before_bsstops;
        }
    }
    return \@res if $par{ret_pairs};
    my $resphl = $proj->phrase_list([map { $_->[1]->phrases } @res]);
    return ($self + $resphl)->pack_list;
}


sub left_shrinking_models_extend { # обрезает модель слева без потери смысла: выкидываем слова без цифр, оставляем только много весящий остаток
    my $self = shift;
    my %params = @_;
    my $keep_all_words = $params{keep_all_words} || 0;
    sub pweight {
        my ( $txt, $keep_all_words ) = @_;
        my @words = split/\s+/, $txt;
        unless ($keep_all_words) {
            for my $w ( split/\s+/, $txt ){
                last if ( $w =~ /\d/ );
                shift @words;
            }
        }
        return () unless @words;
        $txt = join(' ',@words);
        return () if $txt =~ /^\d+ /i;
        return () if $txt =~ /^\d0{0,4}[a-z ]+$/i;
        my $digits = @{[$txt =~ /[1-9]/g]} || 0;
        my $zeroes = @{[$txt =~ /[0]/g]} || 0;
        my $letters = @{[$txt =~ /[a-zа-яё]/gi]} || 0;
        my $spaces = @{[$txt =~ /\s/g]} || 0;
        return () if ($digits && $letters/$digits > 10);
        return ($txt, $digits*10 + $letters*8 + $zeroes*6 - $spaces*5) if $txt =~ /[a-z]/i;
        return ();
    }
    my @res = ();
    for my $phr ( @$self ){
        my ( $rest, $weight ) = pweight( $phr->text, $keep_all_words );
        next unless ( $rest && $weight );
#        print Dumper ( [$rest, $weight] );
#        exit;
        push @res, $rest if ( $weight >= 35 && $rest );
    }
    return ( $self + $self->proj->phrase_list([@res]) )->pack_list;
}

sub modellike_product {
    my ($self, %hparsed) = @_;
    my $phl = $self;
    $phl += $phl->phmap(sub { $_->modellike_product( %hparsed ) });
    return $phl->pack_list;
}

sub get_modellike_modifications_without_model_parsing {
    my $self = shift;
    my $phl = $self;
    $phl += $phl->phmap(sub { $_->get_modellike_modifications_without_model_parsing });
    return $phl->pack_list;
}

sub get_phrases_index :CACHE {
    my ($self) = @_;

    #Строим индекс фраз массива, которым очищаем
    my $i = 0;
    my $h = {}; #индекс
    my $ih = {}; #количество слов
    my $iv = {}; #словарь
    for my $ph ($self->phrases){
        $i++;
        my @w = $ph->uniqnormwords;
        push( @{ $h->{$_}||=[] }, $i) for @w;
        $ih->{$i} = @w;
        $iv->{$i} = $ph;
    }

    return $h, $ih, $iv;
}


#удаляем более короткие фразы
sub filter_subphrases {
    my ($self) = @_;
    my $phrases = $self->phrases_arr;

    my $filtered = {};

    if ( @$phrases > 1 ) {
        for my $ph (@$phrases) {
            next if $filtered->{$ph->snorm_phr}; # все, что мы бы нашли, уже и так отфильтровано, так как эта фраза здесь из-за более длинной фразы, и все ее подфразы уже проверены
            my $phl = $self->search_subphrases_in_phrase($ph);
            $filtered->{$_}++ for grep{$_ ne $ph->snorm_phr} map{$_->snorm_phr} @{$phl->phrases_arr};
        }
    }

    return $self->proj->phrase_list({phrases_list => [grep{!$filtered->{$_->snorm_phr}} @$phrases]});
}

#удаляем более длинные уточняющие фразы
sub filter_by_subphrases {
    my ($self) = @_;
    my $filtered = {};

    return $self->phgrep(sub {
          my $ph = $_;
          return 0 if grep { $ph->norm_phr ne $_->norm_phr } $self->search_subphrases_in_phrase( $ph, only_norm => 1 )->phrases;
          return 1;
        });
}

#@returns BM::PhraseList
sub search_subphrases_in_phrase {
    my ($self, $ph, %par) = @_;
    my $index_name;
    my $fwords;
    my $ftext;
    my $ftext_ordered;
    my $use_xs = $par{use_xs};
    my $use_existing_phrases = $par{use_existing_phrases};

    if($par{only_norm}) {
        $index_name = "norm_index";
        $fwords = sub { return [$_[0]->uniqnormwords]; };
        $ftext = sub { return $_[0]->norm_phr_uniq; };
        $ftext_ordered = sub { return $_[0]->pnorm_phr_ordered; } if defined($par{max_distance});
    } elsif($par{no_norm}) {
        $index_name = "no_norm_index";
        $fwords = sub { return [ $_[0]->pluswords ]; };
        $ftext = sub { return join(" ", $_[0]->pluswords); };
        $ftext_ordered = sub { return $_[0]->pluswords_phr; } if defined($par{max_distance});
    } elsif($par{safe_norm}) {
        $index_name = "safe_norm_index";
        $fwords = sub { return [ split/\s+/,$_[0]->norm_phr_safe ]; };
        $ftext = sub { return $_[0]->norm_phr_safe; };
        $ftext_ordered = sub { return $_[0]->pnorm_phr_safe; } if defined($par{max_distance});
    } else {
        $index_name = "snorm_index";
        $fwords = sub { return [ $_[0]->uniqsnormwords ]; };
        $ftext = sub { return $_[0]->snorm_phr_uniq; };
        $ftext_ordered = sub { return $_[0]->psnorm_phr_ordered; } if defined($par{max_distance});
    }

    if(!$self->{$index_name}) {
        $self->{search_subphrases_in_phrase_time} = 0.0;
        if($use_xs) {
            $self->{$index_name} = new Subphraser;
            $self->{$index_name}->AddPhrase($ftext->($_), "") for @$self;
        } else {
            $self->{$index_name} = Utils::SubsetIndex->new;
            $self->{$index_name}->fill_index(map{$fwords->($_)} $self->phrases);
        }
    }

    my $norm2phrase = undef;
    if($use_existing_phrases) {
        $norm2phrase = $self->{$index_name . "_norm2phrase"};

        if(!$norm2phrase) {
            $norm2phrase = {};

            for my $phr (@$self) {
                $norm2phrase->{$ftext->($phr)} = $phr;
            }

            $self->{$index_name . "_norm2phrase"} = $norm2phrase;
        }
    }

    #my $start = [gettimeofday];
    my $phrases_arr = $use_xs ?
        $self->{$index_name}->GetSubphrasesArray($ftext->($ph)) :
        [map{join " ", @$_} $self->{$index_name}->search_subsets($fwords->($ph))];
    #my $finish = [gettimeofday];
    #$self->{search_subphrases_in_phrase_time} += tv_interval($start, $finish);

    if ( defined($par{max_distance}) && defined($ftext_ordered) ){
        my $phr_ordered = $ftext_ordered->($ph);
#        print $phr_ordered->text,"\n";
        $phrases_arr = [ grep { my $text=$_; $phr_ordered->check_subphrase_distance($text, $par{max_distance}) } @$phrases_arr ];
    }

    my $texts = $norm2phrase ? { phrases_arr => $phrases_arr } : [map{$norm2phrase->{$_} || $_} @$phrases_arr ];

    return $self->proj->phrase_list($texts);
}

sub search_subphrases_in_text {
    my ($self, $text, %par) = @_;
    return $self->search_subphrases_in_phrase($self->proj->phrase($text), %par);
}

sub group_phrases_light {
    my ($self) = @_;
    my $phl = $self->pack_list;
    my $grps = {};
    $grps->{$_} = [] for map { $_->snorm_phr } @$phl;
    for my $ph (@$phl){
        my $snph = $ph->snorm_phr;
        my $arr = $ph->all_snorm_subphrases_list_arrayref;
        my $cc = 0;
        for(@$arr){
            next if $snph eq $_; #Не добавляем в группу самой фразы
            if($grps->{$_}){
                push(@{$grps->{$_}}, $ph->snorm_phr);
                $cc++;
            }
        }
        unless($cc){ #Если не добавили ни в одну группу, то добавляем в собственную
            push(@{$grps->{$snph}}, $snph);
        }
    }
    delete($grps->{$_}) for grep { @{$grps->{$_}} == 0 } keys %$grps;
    return $grps;
}




# $sep - разделитель, по умолчанию запятая
sub phrases2text {
    my ($self, $sep) = @_;
    return $self->{'phrases_text'} if defined( $self->{'phrases_text'} ) && !$sep;
    return join(',', @{$self->{'phrases_arr'}}) if defined( $self->{'phrases_arr'} ) && !$sep;
    $sep = ',' unless $sep;
    my @str = map { join(':', $_->text, @{$_->inf || []}) } $self->phrases;
    return join ( $sep, @str );
}

sub ttext {
    my ($self, $pref, $postf) = @_;
    $pref   //= "  ";
    $postf  //= "\n";
    return join("", map { $pref.$_->text.$postf } @$self);
}

sub to_lc {
    my ($self) = shift;
    return $self->lmap(sub { lc("$_") });
}

sub all_subphrases_list {
    my ($self) = @_;
    return $self->lmap(sub { @{ $_->all_subphrases_list } });
}


####################################################################
# Работа с синонимами
####################################################################

sub get_search_syns {
    my $self = shift;
    return ($self->cache_search_syns->phmap(sub { $_->get_search_syns }) + $self)->pack_list;
}

sub get_search_syns_testinf {
    my $self = shift;
    return ($self->cache_search_syns->phmap(sub { my $ph = $_;  $_->get_search_syns->lmap( sub { "$_ => $ph" } ) }) + $self)->pack_list;
}

sub get_search_syns_keeping_minuswords {
    my $self = shift;
    return ($self->cache_search_syns->phmap(sub { $_->get_search_syns_keeping_minuswords }) + $self)->pack_list;
}

sub get_search_filtered_syns {
    my ($self, $common_context) = @_;
    my $phl = $self->get_search_syns;
#    $common_context ||= $phl->cache_cdict_minicategs->get_phrases_categs_hashref; #Если не было контекста категорий, берём категории от фраз
#    my $min_advq_count = 5;
#    $phl += $phl->context_syns_extend($common_context);
    return $phl->pack_list;
}

# удалить фразы с дублирующимися словами и противоречиями в плюс- и минус-словах
sub remove_controversial_phrases {
    my ($self) = @_;
    my $new_arr = [];
    my $has_changes = 0;

    for my $phr (@$self) {
        my %words;
        my $is_bad = 0;

        # не учитываем дефисы
        my @norm_words;
        if($phr->norm_phr =~ /\-/) {
            my $text = $phr->norm_phr;
            $text =~ s/\-/ /g;
            @norm_words = $phr->language->phrase($text)->normwords;
        } else {
            @norm_words = $phr->normwords;
        }

        for my $word (@norm_words) {
            # не учитываем +словоформы
            if($word =~ /^\+/) {
                $word =~ s/^\+//;
                $word = $self->proj->phrase($word)->norm_phr;
            }

            if($words{$word}) {
                $is_bad = 1;
                last;
            }

            $words{$word}++;
        }

        if(!$is_bad) {
            $is_bad = grep{$words{$_}} $phr->norm_minuswords;
        }

        if($is_bad) {
            $has_changes = 1;
        } else {
            push @$new_arr, $phr;
        }
    }

    return $self if !$has_changes;
    return $self->proj->phrase_list($new_arr);
}

sub context_syns_extend {
    my ($self, $common_context) = @_;
    my $newphl = $self;
    for my $type (qw(hyperonyms precise)) {
    #for my $type (qw(hyperonyms precise diacr)) {
        $newphl += $self->proj->context_syns->{$type}->extend_phraselist($common_context, $newphl)->remove_controversial_phrases;
    }
    return $newphl;
}

# Разваливание по контекстным синонимам, подхватывая свежие изменения в таблице CatalogiaPhrases
sub context_syns_extend_fresh {
    my ($self, $common_context) = @_;
    my $newphl = $self;

    my $opt = $self->proj->current_lang eq 'tr'  ?
          { threshold => 2,     types => [qw[ precise_tr medium_tr ]], }    # TODO add catmedia_csyns with lang='tr'
        : { threshold => 50,    types => [qw[ hyperonyms precise catmedia_csyns medium_exp mulword_syns translit_ru2en translit_en2ru ]], };
    for my $type (@{ $opt->{types} }) {
        for my $phr (@$self) {
            my $small_phl = $self->proj->phrase_list([ $phr ]);
            my $add_phl = $self->proj->context_syns->{$type}->extend_phraselist($common_context, $small_phl)->remove_controversial_phrases;
            $_->{context_syns_source_phrase} = $phr for @{$add_phl};
            $add_phl->cache_search_count;
            $newphl += $add_phl->get_snorm_search_filtered(min_count => ($opt->{threshold}+1)); # context_syns->{$type}->extend_phraselist работают с точностью до snorm
        }
    }
    return $newphl->pack_list;
}

# Разваливание по контекстным синонимам с использованием заданных настроек
# На входе:
#   строка параметров вида  key1:values1;key2:values2;...   values - строка вида value1|value2|value3|
#       key - 'types',   возможные значения value - ключи хэша %{$proj->context_syns}  (hyperonyms, precise, ...)
#       Например: "types:hyperonyms|precise|brands_assoc"
#   $common_context
sub context_syns_extend_custom {
    my ($self, $prmstr, $common_context) = @_;

    #$prmstr //= "types:hyperonyms|precise";
    my %prm;
    for (split /\s*;\s*/, $prmstr) {
        my ($key, $val) = /(\S*):(.*)/;
        my @val = split /\s*\|\s*/, $val;
        $prm{$key} = [@val];
    }

    my $newphl = $self;

    for my $type (@{ $prm{types} // [] }) {
        my $csyn = $self->proj->context_syns->{$type}   or do {
            $self->log("ERROR: Bad csyn type ($type)");
            next;
        };
        $newphl += $csyn->extend_phraselist($common_context, $newphl)->remove_controversial_phrases;
    }

    return $newphl;
}

sub context_syns_extend_custom_type_precise {
    my ($self) = @_;
    return $self->context_syns_extend_custom("types:precise");
}

####################################################################
# / Работа с синонимами
####################################################################

sub _tree2atoms {
    my ($tr, $pref) = @_;
    $pref ||= '';
    return () unless $tr;
    my $w = $tr->[0];
    unless($w){
        if($pref){
            return "$pref ".join(' ',@{ $tr->[1][0] }) if @{$tr->[1]} == 1;
            return "$pref [".join('/', sort {$b cmp $a} map {join(' ',@$_)} @{$tr->[1]} ).']';
        }else{
            return sort {$b cmp $a} map {join(' ',@$_)} @{$tr->[1]};
        }
    }
    #сжимаем дерево на словах, у которых одинаковые частоты
#    while( $tr->[3][0] && ( @{$tr->[3][1]} eq @{$tr->[1]} ) ){
#        $w .= " ".$tr->[3][0];
#        $tr = $tr->[3];
#    }
    my @arr = _tree2atoms($tr->[4], $pref);
    push(@arr, _tree2atoms($tr->[3], "$pref $w"));
    return @arr;
}

sub list2atoms_phl {
    my $self = shift;
    my $atomphl = $self->tgrep(sub { /\[/ });
    my $atomfreephl = $self->tgrep(sub { ! /\[/ }); #Убираем фразы, у которых уже есть атомы
    $atomfreephl = $atomfreephl->pack_list;
    my @arr = map { [ keys %{{ map {$_=>1} $_->normwords }} ] } @$atomfreephl;
    my $tr = _arr2tree(\@arr);
    return $self->phrase_list( [ @$self ] ) unless $tr->[0]; #Если нет данных для выделения атомов - возвращаем исходные
    my $phl = $self->phrase_list( [ _tree2atoms($tr) ] );
    $phl += $atomphl;
    return $phl;
}

sub list2atoms {
    my $self = shift;
    return map {"$_"} @{$self->list2atoms_phl};
}

sub atoms2list_phl {
    my $self = shift;
    my @arr = ();
    for my $t ( map {$_->text} @$self ){
        my @atoms = ();
        push( @atoms, $1 ) while $t =~ s/\[([^\]]+)\]/ /;
        @atoms = map {[ split('/', $_, -1) ]} @atoms;
        my @res = ($t);
        for my $warr (@atoms){
            my @addarr = ();
            for my $el (@$warr){
                push(@addarr, "$_ $el") for  @res;
            }
            @res = @addarr;
        }
        push(@arr, @res);
    }
    $self->phrase_list(\@arr);
}

sub enable_categs_pack {
    my ($self) = @_;

    for my $ph ($self->phrases) {
        $ph->{categs_pack} = $self;
        weaken($ph->{categs_pack});
    }
}


sub get_yandex_phraselist {
    my ($self) = @_;
    return $self->llmap(sub { $_->get_yandex_phraselist });
}

sub group_phrases_by_type : TIMELOG {
    my ($self) = @_;
    my @others  = ();
    my @models  = ();
    my @venders = ();
    for my $ph ( @$self ){
        if($ph->text =~ /\[[^\]]+?\]/){
            push(@others, $ph);
            next;
        }
        my ($vendor, $model) = $ph->parse_fast();
        if( $model ){
            push(@models, $ph);
        }elsif( $vendor ){
            push(@venders, $ph);
        }else{
            push(@others, $ph);
        }
    }
    return ( map { $self->phrase_list($_) } \@others, \@models, \@venders  );
}

sub add_phrases_without_hyphens {
    my $self = shift;
    return $self + $self->phrase_list([ map { $_->get_phrase_without_hyphens } @$self ]);
}

sub analyze_for_banners_data {
    my $self = shift;
    my %par  = @_;

    my $freq_all_threshold = 100;

    my $pt = $par{PRODUCT} // {};
    my $subtree;
    if ($pt->{task_geo_list}) {
        $subtree = [ Utils::Regions::geobase_subtree_cached($pt->{task_geo_list}) ];
    } elsif ($pt->{task_geo_subtree}) {
        $subtree = $pt->{task_geo_subtree};
    }
    if ($subtree) {
        my $count_geo = scalar(@$subtree);
        if ( $count_geo < 20000 ) {
            $self->cache_search_count;
            # в следующей строке намеренно берется закэшированное значение вместо вызова get_search_count
            # это нужно, чтобы избежать на этой операции двух вызовов RPC на YT и достать все данные за один enrich
            # В большинстве случаев search_count уже закэшированы для всех фраз предыдущими баннерлендовыми фильтрами,
            # поэтому в {search_count} будут правильные данные, и доставать надо будет только регионы (причем только для тех фраз, для которых нужно)
            # В случае некоторых экзотических продактов частотных фильтров нет, и в этом случае мы просто сделаем оба запроса в cdict за один enrich
            $self->phgrep(sub { ( $_->{search_count} // 0 ) < $freq_all_threshold })->cache_regions_count;
            $self->proj->rpc->check;
            my $dummy = $self->proj->options->{dyn_banners_dummy_phrase};
            for my $phrase ( @$self ) {
                #dummy-фразы пропускаем без проверки
                next if $phrase->text eq $dummy;
                my $freq_all = $phrase->get_search_count();
                next if $freq_all >= $freq_all_threshold;
                my $freq_geo = $phrase->get_search_count($subtree, is_subtree => 1);
                if ( $freq_geo < 5 ) {
                    $phrase->minf->{filtered_by_geofilter} = 1;
                }
            }
        }
    }
    return $self->lgrep( sub { !( $_->minf->{filtered_by_geofilter} ) } );
}

sub store_search_count_in_minf {
    my $self = shift;
    my %par  = @_;

    $self->cache_search_count;
    $self->proj->rpc->check;
    $_->minf->{search_count} = $_->get_search_count for @$self;
    return $self;
}

# отфильтровать по search_count; параметры:
#   min_count => $c  (default: 1), старое название - threshold
#   max_count => $c,  старое название - up
sub get_search_filtered {
    my ($self, %par) = @_;

    my $min_count = $par{min_count} // (($par{threshold} || 0) + 1);  # threshold - старое название; +1 т.к. было строгое неравенство
    my $max_count = $par{max_count} // $par{up};  # may be undef

    $self->cache_search_count;
    $self->proj->rpc->check;

    my $grep = sub {
        my $c = $_->get_search_count;
        return 0 if defined($min_count) and $c < $min_count;
        return 0 if defined($max_count) and $c > $max_count;
        return 1;
    };
    return $self->lgrep(sub { $grep->($_) });
}

# 50k - приемлемый порог для ширины баннерной фразы
sub get_search_filtered50k {
    my ($self) = @_;
    return $self->get_search_filtered(min_count => 1, max_count => 50000);
}

sub get_search_filtered15k {
    my ($self) = @_;
    return $self->get_search_filtered(min_count => 1, max_count => 15000);
}

sub get_search_filtered2k {
    my ($self) = @_;
    return $self->get_search_filtered(min_count => 1, max_count => 2000);
}

sub get_search_filtered_more_than_100 {
    my ($self) = @_;
    return $self->get_search_filtered(min_count => 100, max_count => 10_000_000);
}

# отфильтровать по snorm_search_count; параметры:
#   min_count => $c  (default: 1)
#   max_count => $c
sub get_snorm_search_filtered {
    my ($self, %par) = @_;
    my $min_count = $par{min_count} // 1;
    my $max_count = $par{max_count};

    my $snorm2count = $self->get_snorm_search_counts;
    my $grep = sub {
        my $phr = shift;
        my $c = $snorm2count->{$phr->snorm_phr};
        return 0 if defined($min_count) and $c < $min_count;
        return 0 if defined($max_count) and $c > $max_count;
        return 1;
    };
    return $self->lgrep(sub { $grep->($_) });
}

sub get_snorm_search_filtered50k {
    my ($self) = @_;
    return $self->get_snorm_search_filtered(min_count => 1, max_count => 50000);
}

sub get_snorm_search_filtered15k {
    my ($self) = @_;
    return $self->get_snorm_search_filtered(min_count => 1, max_count => 15000);
}

sub get_search_threshold_filtered {
    my ($self, $threshold, $region_ids) = @_;
#    $self->log("TEST PhraseList::get_search_threshold_filtered");
    $threshold ||= 0;
    #return $self->cache_search_count->lgrep(sub { $_->delete_pluses->get_search_count($region_ids) > $threshold });
    $self->cache_search_count unless $region_ids; #Нельзя кэшировать, если есть регионы
#    print "REGIONS: " . join(",", @$region_ids) . "\n";
    return $self->lgrep(sub {
#        print "PHRASE: '$_' COUNT: " . $_->get_search_count($region_ids) . "\n";
        $_->delete_pluses->get_search_count($region_ids) >= $threshold
    });
}

sub get_wide_filtered {
    my ($self) = @_;
    return $self->phgrep(sub { ! $_->is_wide_phrase });
}

sub get_wide_phrases : EXTERNALLY_USED("yt", "bmapi") {
    my ($self) = @_;
    return $self->phgrep(sub { $_->is_wide_phrase });
}

sub sort_phrases {
    my ($self) = @_;
    return $self->phrase_list( [ map {$_->[0]} sort { $a->[1] cmp $b->[1] } map { [ $_, $_->text ] } @$self ] );
}

sub sort_phrases_search_count {
    my ($self, $rgs) = @_;
    $rgs ? $self->cache_regions_count : $self->cache_search_count; #Кэшируем данные по частотам
    return $self->phrase_list( [ map {$_->[0]} sort { $b->[1] <=> $a->[1] } map { [ $_, $_->get_search_count($rgs) ] } @$self ] );
}

sub sort_phrases_query_count {
    my ($self) = @_;
    return $self->cache_search_query_count->lnsort(sub {$_->get_search_query_count})->reverse;
}

sub sort_phrases_query_count_and_add_count {
    my ($self) = @_;
    return $self->sort_phrases_query_count->lmap(sub { $_.' => '.$_->get_search_query_count });
}

sub sort_phrases_num {
    my ($self) = @_;
    return $self->phrase_list( [ map {$_->[0]} sort { $a->[1] <=> $b->[1] } map { [ $_, $_->text ] } @$self ] );
}

sub cache_cdict_tail_categs {
    my $self = shift;
    $self->proj->rpc->add('cache_cdict_tail_categs', $self, @_);
    return $self;
}

sub cache_cdict_categs_ids {
    my ($self) = @_;
    return if !@$self;

    my $resp = $self->proj->datoteka_client->exec_command(join("/", map{"get\tcategs\t".$_->snorm_phr} $self->phrases));
    my $i = 0;
    for my $phr_tail (split "/", $resp) {
        my $phr = $self->[$i++];
        my $h = {};
        if(substr($phr_tail, 0, 2) ne "NO") {
            $phr->{categs_ids} = [grep{$_} split " ", substr($phr_tail, 4)];
        } else {
            $phr->{categs_ids} = [ map{$self->proj->categs_tree->get_minicateg_id($_)} $phr->get_minicategs ];
        }
    }
}

sub cache_mobile_counts {
    my $self = shift;
    $self->proj->rpc->add('cache_search_countm', $self, @_);
    return $self;
}

sub cache_bnr_counts {
    my ($self) = @_;
    my @phrases = grep{!defined($_->{cdict_bnr_count})} @$self;
    my @res = $self->proj->datoteka_client->get_bnr_count(@phrases);

    $phrases[$_]->{cdict_bnr_count} = $res[$_] for 0..$#res;

    return $self;
}

sub get_related_minicategs {
    my ($self, $catnames) = @_;

    if ($ENV{NO_REMOTE_REQ}) {
        # не хотим лишний раз использовать cdict, сами можем всё категоризовать
        for my $phr (@$self) {
            $phr->{categs_ids} = [ $phr->get_minicategs_ids ];
        }
    } else {
        $self->cache_cdict_categs_ids;
    }
    my $ctree = $self->proj->phrase('');
    my $subtrees = $self->proj->categs_tree->{subtrees_ids};
    my %cth;
    my @catids =(); #Список номеров хороших категорий
    @catids = $catnames ? map { $ctree->wget_minicateg_id($_) } @$catnames : map { @{$_->{categs_ids}} } @$self;
    @catids = keys %{{ map { $_=>1 } @catids }}; #Удаляем дубли
    my @catnms = map { $ctree->wget_minicateg_by_id($_) } @catids;
    $cth{$_}++ for @catids; #Добавляем сами категории
    #Добавляем путь наверх
    $cth{$_}++ for map { $ctree->wget_minicateg_id($_) } map { $ctree->get_cat_path($_) } @catnms;
    #Добавляем подкатегории, сиблинги и невьюсы
    $cth{$_}++ for map { $ctree->wget_minicateg_id($_) } $ctree->get_related_minicategs( @catnms );

    return \%cth;
}

sub add_search_categs_minuswords : EXTERNALLY_USED("bmapi") {
    my ($self, $catnames, %par) = @_;
    my %cth = %{ $self->get_related_minicategs($catnames, %par) };
    return $self unless %cth;

    #$self->proj->dd(\@catids, \@catnms, \%cth, [ map { $ctree->wget_minicateg_by_id($_) } keys %cth ]);

    $self->cache_cdict_tail_categs;

    my @res = ();
    for my $ph (@$self) {
        my @bad = grep {
            @{$ph->{tail2categs}{$_}} &&
            !(grep{$cth{$_}} @{$ph->{tail2categs}{$_}})
        } keys %{$ph->{tail2categs}};

        if($par{only_minuswords}) {
            push @res, @bad;
        } else {
            if(@bad){
                    push(@res, $ph->text." ".join(" ", map { "-$_" } @bad ));
            } else {
                push(@res, $ph);
            }
        }
    }

    #$self->proj->dd(\@res);

    return $self->phrase_list(\@res);
}

sub add_search_categs_minuswords_without_cache {
    my ($self, $catnames, %par) = @_;
    my $ctree = $self->proj->phrase('');
    my @ctgs = map { $ctree->wget_minicateg_by_id($_) } keys %{$self->get_related_minicategs($catnames, %par)};
    return $self->cache_search_tail->phtmap(sub { $_->add_search_categs_minuswords_without_cache(@ctgs)->text });
}

sub add_search_categs_minuswords_without_cache_strict {
    my ($self, $catnames, %par) = @_;
    my $ctree = $self->proj->phrase('');
    my @ctgs = map { $ctree->wget_minicateg_by_id($_) } keys %{$self->get_related_minicategs(($catnames || []), %par)};
    return $self->cache_search_tail->phtmap(sub { $_->add_search_categs_minuswords_without_cache_strict(@ctgs)->text });
}

sub add_search_categs_minuswords_strict {
    my ($self, $catnames, %par) = @_;
    my $ctree = $self->proj->phrase('');
    my @ctgs = map { $ctree->wget_minicateg_by_id($_) } keys %{$self->get_related_minicategs(($catnames || []), %par)};
    return $self->cache_tail_categs->phtmap(sub { $_->add_search_categs_minuswords_strict(\@ctgs)->text });
}

sub add_search_categs_minuswords_without_cache_log {
    my ($self, $catnames, %par) = @_;
    my $proj = $self->proj;
    my $ctree = $self->proj->phrase('');
    my @ctgs = map { $ctree->wget_minicateg_by_id($_) } keys %{$self->get_related_minicategs($catnames, %par)};
    return $self->cache_search_tail->phtmap(sub {
        my $ph = $_;
        $ph->{_minuswords_log} = 1;
        return ($ph->add_search_categs_minuswords_without_cache(@ctgs)->text.' => '.join('/', map {$proj->phrase($_)->get_norm_categ_from_text} $ph->get_minicategs), #Сама фраза
            (  map { '# '.$_->[0].' => '.join('/', map {$proj->phrase($_)->get_norm_categ_from_text} @{$_->[1]}) } @{$ph->{_minuswords_log_data}} ), #Лог добавленных слов
            ''
        );
    });
}

sub add_search_porn_minuswords {
    my ($self, %par) = @_;

    my @res = ();
    for my $ph (@$self) {
        my @bad = $self->proj->phrase(join ' ', keys %{$ph->get_search_tail} )->porno_words;
        if($par{only_minuswords}) {
            push @res, @bad;
        } else {
            if(@bad){
                    push(@res, $ph->language->phrase($ph->text." ".join(" ", map { "-$_" } @bad )));
            } else {
                push(@res, $ph);
            }
        }
    }

    return $self->phrase_list(\@res);
}

sub biword_minuswords_generic {
    my $self = shift;
    my %par  = @_;

    my $proj = $self->proj;
    my $ctx = ($par{ctx}{biword_minuswords_generic} //= {});  # свой контекст!

    if (!$ctx->{step}) {
        my %bw;
        my $biwords = $proj->dict_manager->get_dict("biwords")->{pairs};
        for my $pair (keys %$biwords) {
            my ($w1, $w2) = split /$;/, $pair;
            $bw{$w1}{$w2} = 1;
            $bw{$w2}{$w1} = 1;
        }

        my @test;
        for my $phr (@$self) {
            my @sw = $phr->snormwords;
            my $sw = $phr->snormwordshash;
            for my $w1 (grep { $bw{$_} } @sw) {
                # w1 - кусок биворда, есть во фразе
                my @bad = grep { !$sw->{$_} } keys %{$bw{$w1}};  # остатки биворда, которых нет во фразе
                push @test, [ $phr, \@bad ] if @bad;
            }
        }
        return [] if !@test;

        $ctx->{biwords_test} = \@test;
        $ctx->{step}++;
        my $bwphl = $proj->phrase_list([map { $_->[0] } @test]);
        return (undef, [[cache_search_tail => $bwphl]]);
    }
    my @mws;
    my $min_count = 5;
    my $test = delete $ctx->{biwords_test};
    for my $h (@$test) {
        my $phr = $h->[0];
        my %bad = map { $_ => 1 } @{$h->[1]};
        while (my ($tail, $count) = each %{$phr->get_search_tail}) {
            push @mws, $tail if $count >= $min_count and $bad{ norm2snorm($tail, $phr->lang) };
        }
    }
    return [uniq(@mws)];
}


sub extsub {
    my ($self, $sb) = @_;
    $sb->($self);
    return $self;
}

sub prnt_stderr {
    my ($self, $text) = @_;
#    print STDERR "$text\n";
#    print "$text ".$self->count."\n";
#    print "$text >>> $_\n" for @$self;
    return $self;
}

sub do_nicely_base {
    my ( $self ) = @_;
    return
        $self
        ->phgrep(sub {$_->text})
        ->prnt_stderr("begin")
        ->get_search_filtered_syns
        ->prnt_stderr("get_search_filtered_syns")
        ->pack_list
        ->prnt_stderr("pack_list")
        ->phrases_fill_a_gap
        ->prnt_stderr("phrases_fill_a_gap")
        ->add_phrases_without_hyphens
        ->prnt_stderr('add_phrases_without_hyphens')
        ->pack_list
        ->prnt_stderr("pack_list")
        ->get_search_filtered
        ->prnt_stderr("get_search_filtered")
        ->add_trade_phrases
        ->prnt_stderr("add_trade_phrases")
        ->good_phrases_list
        ->prnt_stderr("good_phrases_list")
        ;
}

sub pack_minuswords { #Удаляет повторы минус-слов
    my ( $self ) = @_;
    return $self->phtmap(sub { $_->pack_minuswords });
}

sub add_minuswords {
    my ( $self ) = @_;
    return
        $self
        ->add_search_categs_minuswords
        ->prnt_stderr("get_search_categs_minuswords_light")
        ->minus_words_pack
        ->prnt_stderr("minus_words_pack")
        ->phtmap(sub { $_->pack_minuswords })
        ->prnt_stderr("pack_minuswords")
    ;
}

sub do_nicely {
    my ( $self ) = @_;
    return
        $self
        ->do_nicely_base
        ->prnt_stderr("do_nicely_base")
        ->add_minuswords
        ->prnt_stderr("add_minuswords")
    ;
}

sub get_subphrases {
    my $self = shift;
    return $self->phmap( sub { $_->get_subphrases } )->pack_list unless @_;
    return $self->phmap( sub { $_->get_subphrases( @_ )} )->pack_list;
}

# согласует весь phrase list по $phr
sub harmonize {
    my ( $self, $phr ) = @_;
    return $self->proj->phrase_list(phrases_arr=>$self->perl_array) unless ( $phr and $phr->text );
    return $self->phtmap(sub { $phr->harmonize( $_ ) });
}

# согласует весь phrase list по его первой записи
sub harmonize_by_first {
    my $self = shift @_;
    return $self->proj->phrase_list( { phrases_arr=>$self->perl_array } ) unless ( $self->count > 1 );
    my @phrases = $self->phrases;
    my $phr_first = shift @phrases;
    my $res = $self->proj->phrase_list( { phrases_list=>\@phrases } )->harmonize( $phr_first );
    @phrases = $res->phrases;
    unshift @phrases, $phr_first;
    return $self->proj->phrase_list( { phrases_list=>\@phrases } );
}


sub harmonize_by_first_rusword {
    my $self = shift @_;
    return $self->phmap(sub {$_->harmonize_by_first_rusword});
}

sub parse_and_do_nicely {
    my ($self) = @_;
    my $phl = $self;
    my $lngphl = $phl->phgrep(sub { $_->number_of_words > 4 }); #Получаем фразы из большого числа слов
    $phl += $lngphl->get_subphrases( modellike=>1 ); #Добавляем подфразы из длинных фраз
    $phl = $phl->do_nicely;
    return $phl;
}

sub add_trade_phrases {
    my ($self, @arr_words) = @_;
    my $proj = $self->proj;

    $self->cache_cdict_tail_categs;
    $proj->rpc->check;

    my $text = @arr_words ? join(' ', @arr_words) : 'купить магазин цена интернет-магазин распродажа скидки заказ';
    my @wds = $proj->phrase($text)->normwords;
    my @arr = ();
    my $curr_phrases = { map{$_->norm_phr => 1} @$self };
    for my $ph ( @$self ) {
       my $tail = $ph->{tail2count};
       for my $w ( grep {  $tail->{$_} } @wds ){
           my $nphtext = join(" ", sort $w, split " ", $ph->norm_phr);
           my $nph = $proj->phrase($nphtext);
           $nph->{normed} = 1;
           push(@arr, $nph) if !$curr_phrases->{$nph->norm_phr};
       }
    }
    my $phl = $self + \@arr;
    return $phl; # не вызываем здесь pack_list, чтобы не сбросить кэш у фраз
}

sub add_trade_phrases_childrens_goods {
    my ($self, @arr_words) = @_;
    my $proj = $self->proj;

    $self->cache_cdict_tail_categs;
    $proj->rpc->check;

    my $text = @arr_words ? join(' ', @arr_words) : 'купить распродажа скидки заказ';
    my @wds = $proj->phrase($text)->normwords;
    my @arr = ();
    my $curr_phrases = { map{$_->norm_phr => 1} @$self };
    for my $ph ( @$self ) {
       my $tail = $ph->{tail2count};
       for my $w ( grep {  $tail->{$_} } @wds ){
           my $nphtext = join(" ", sort $w, split " ", $ph->norm_phr);
           my $nph = $proj->phrase($nphtext);
           $nph->{normed} = 1;
           push(@arr, $nph) if !$curr_phrases->{$nph->norm_phr};
       }
    }
    my $phl = $self + \@arr;
    return $phl; # не вызываем здесь pack_list, чтобы не сбросить кэш у фраз
}

sub add_trade_phrases_dynamic_wear {
    my ($self) = @_;
    # оставим для будущих экспериментов
    my @arr_old = qw/купить магазин цена интернет-магазин распродажа скидки ассортимент дешево заказ
                заказать каталог недорого покупка продавать продажа распродажа
                акция доставить доставка лучший прайс скидки стоимость price/;
    my @arr = qw/купить магазин/;
    return $self->add_trade_phrases( @arr )->lgrep( sub { $_->wordcount < 5 } );
}

sub add_trade_phrases_dynamic_home {
    my ($self) = @_;
    my @arr = qw/купить/;
    return $self->add_trade_phrases(@arr)->lgrep( sub { $_->wordcount < 5 } );
}

sub add_trade_phrases_dynamic_auto_accessories {
    my ($self) = @_;
    my @arr = qw/купить магазин цена интернет-магазин заказать/;
    return $self->add_trade_phrases(@arr)->lgrep( sub { $_->wordcount < 5 } );
}

sub filter_auto_accessories {
    my ($self) = @_;
    return $self->get_search_filtered(up => 3000)->lgrep(sub { $_->flt_text_length > 10 });
}

#Доклеиваем информацию о частоте и категории
sub add_count_and_categs_inf : EXTERNALLY_USED("bmapi") {
    my ($self) = @_;
    my ($smplphl, $qtphl) = $self->divide(sub { $_->text !~ /["']/ }); #Выделяем фразы в кавычках, так как для них другие частоты
    #Для фраз в кавычка используем частоту как запроса, а не как подфразы
    $smplphl = $smplphl->cache_search_count->lmap(sub { my $ph = $_; join( " => ", $ph, $ph->get_search_count, $ph->get_norm_minicategs_text ) });
    $qtphl = $qtphl->cache_search_query_count->lmap(sub { my $ph = $_; join( " => ", $ph, $ph->get_search_query_count, $ph->get_norm_minicategs_text ) });
    return $smplphl + $qtphl;
}

sub _test_info {
    my ($self, %params) = @_;
    return $self unless keys %params;
    $self->cache_search_count if $params{count_info};
    my $cattree = $self->proj->categs_tree;
    my $phl = $self->phtmap(sub {
         my $ph = $_;
         $ph->{categs_log_inf}++;
         my $t = $ph->text;
         if($params{categs_info}){
             $t .= ' => '.join('/', map { $ph->get_normed_categ($_) } map{ $ph->language->category_from_ru($_) } $ph->get_minicategs);
#             $t =~ s/,/ /g;
#             $t =~ s/\s+/ /g;
         }
         $t .= ' => '.$ph->get_search_count if $params{count_info} && $t !~ /["']/;
         return $t;
       });
    return $phl;
}

#доклеивает к фразам информацию о категориях
sub test_categs_info {
    my ($self) = @_;
    return $self->_test_info(categs_info => 1);
}

#доклеивает к фразам информацию о категориях
sub add_categs_info : EXTERNALLY_USED("bmapi") {
    my ($self) = @_;
    return $self->_test_info(categs_info => 1);
}

sub test_count_info {
    my ($self) = @_;
    return $self->_test_info(count_info => 1);
}

sub test_categs_count_info {
    my ($self) = @_;
    return $self->_test_info(categs_info => 1, count_info => 1);
}

sub test_categslog_info {
    my ($self) = @_;
    my ($prrd, $prwt) = ($self->proj->categs_tree->never_read_categs_cache, $self->proj->categs_tree->never_write_categs_cache);
    $self->proj->categs_tree->never_read_categs_cache(1);
    $self->proj->categs_tree->never_write_categs_cache(1);
    my $phl = $self->phtmap(sub {
         my $text = "$_";
         my $t = "$_ // ";
         $text =~ s/ ?=>.*$//;
         my $ph = $self->proj->phrase($text);
         $ph->{categs_log_inf}++;
         $ph->get_minicategs;
         $t .= join( '', map { '#'.$_." // " } @{$ph->{categs_log_list}} );
         $t=~s/,/ /g;
         return $t;
       });
    $self->proj->categs_tree->never_read_categs_cache($prrd);
    $self->proj->categs_tree->never_write_categs_cache($prwt);
    return $phl;
}

sub test_banners_info {
    my ($self) = @_;
    return $self->lsort(sub { $_->get_bnr_count })->lmap(sub { "$_ => ".$_->get_bnr_count });
}

sub test_lang_info {
    my ($self) = @_;
    return $self->lmap(sub { "$_ => ".$_->lang_recognize });
}

sub cache_phrases_inf :REMOTECACHELIST('phrases','spec_text') {
    my ($self, @list) = @_;
    return map {"cache_phrases_inf:$_"} @list;
}

sub cache_id : CACHE {
    my ($self) = @_;
    #return md5int(join(",", sort map{$_->text} $self->phrases));
    return md5int(join(",", map{$_->text} $self->phrases));
}

sub dumper_text_lite {
    my ($self) = @_;
    $_[0] = \@$self;
    return @_;
}

sub cache_search_query_count {
    my $self = shift;
    $self->proj->rpc->add('cache_search_query_count', $self, @_);
    return $self;
}

sub cache_regions_count {
    my $self = shift;
    $self->proj->rpc->add('cache_search_countg', $self, @_);
    return $self;
}

sub cache_search_count {
    my $self = shift;
    $self->proj->rpc->add('cache_search_count', $self, @_);
    return $self;
}

sub get_snorm_search_counts :RPC_CACHE {
    my $self = shift;
    my $ctx  = shift;
    my $proj = $self->proj;

    if (!$ctx->{snorm2phrs}) {
        my %snorm2phrs;
        for my $phr (@$self) {
            push @{$snorm2phrs{$phr->snorm_phr}}, $phr;
        }
        $ctx->{snorm2phrs} = \%snorm2phrs;
    }

    if (!$ctx->{sphl}) {
        $ctx->{sphl} = $self->snorm_pack_list;
    }

    if (!$ctx->{syn_data}) {
        $ctx->{sphl}->cache_search_syns;
        $proj->rpc->check;
        my @syn_data;
        for my $phr ($ctx->{sphl}->phrases) {
            my $snorm = $phr->snorm_phr;
            my $syn_phl = $proj->phrase_list([@{$ctx->{snorm2phrs}{$snorm}}, $phr->get_search_syns->phrases]);
            push @syn_data, [ $snorm, $syn_phl->pack_list ];
        }
        $ctx->{syn_data} = \@syn_data;
        $ctx->{snorm2phrs} = $ctx->{sphl} = 'done';  # cleanup; не удаляем ради if-ов
    }

    $proj->phrase_list([map { @{$_->[1]} } @{$ctx->{syn_data}}])->cache_search_count;
    $proj->rpc->check;
    my %snorm2count;
    for my $h (@{$ctx->{syn_data}}) {
        my ($snorm, $syn_phl) = @$h;
        my $sum_count = sum(0, map { $_->get_search_count } @$syn_phl);
        $snorm2count{$snorm} = $sum_count;
    }

    return \%snorm2count;
}

sub cache_search_syns {
    my $self = shift;
    $self->proj->rpc->add('cache_search_syns', $self, @_);
    return $self;
}

sub cache_search_tail {
    my $self = shift;
    $self->proj->rpc->add('cache_search_tail', $self, @_);
    return $self;
}

sub cache_cdict_categs_atoms {
    my ($self) = @_;
    my @arr = grep {!$_->{'cdict_minicategs'} || !$_->{cdict_atoms}} @$self;
    $self->proj->cdict_client->cache_categs_atoms(@arr);
    return $self;
}

sub cache_cdict_regions_phrases {
    my $self = shift;
    $self->proj->rpc->add('cache_cdict_regions_phrases', $self, @_);
    return $self;
}

sub cache_cdict_minicategs {
    my $self = shift;
    $self->proj->rpc->add('cache_cdict_minicategs', $self, @_);
    return $self;
}

sub cache_is_good_phrase {
    my $self = shift;
    $self->proj->cdict_client->cache_good_phrases($self->phrases);
}

# если фраза почти всегда встречается с одним и тем же хвостиком, то дописываем его к ней
# если фраза не встречается как запрос, дописываем хвостики
# доп. параметры:
#   ratio =>  $r: если top-1 суперфраза имеет частоту >$r от исходной, брать хвост только от неё (default: 0.9)
#   min_query_count =>  $qc: если фраза имеет запросную частоту < $qc, доклеиваем хвостики с частотой >=$qc (default: 10)
#   query_top_size =>  $top: брать $top суперфраз (default: 10)
#   filter_bnr => $bnr: фильтровать баннером
sub restore_tail {
    my ($self, %opts) = @_;
    my @result;
    my $ratio = $opts{ratio} || 0.9;
    my $min_query_count = $opts{min_query_count} || 10;
    my $query_top_size = $opts{query_top_size} || 10;
    my $bnr = $opts{filter_bnr} || undef;
    my @q = @$self;
    my $check_phrase = sub {
        my ($phr, $new_phr) = @_;

        # новая фраза не должна быть самопротиворечивой по минус-словам
        return 0 if grep{$new_phr->normwordshash->{$_}} $new_phr->normminuswords;

        # в новой фразе не должны появляться новые плохие признаки
        return 0 if $new_phr->badphrsreason && $new_phr->badphrsreason ne $phr->badphrsreason;

        # фильтрация баннером
        if($bnr) {
            my %h = map{$_ => 1} @{$phr->{filterreason} || []};

            $bnr->filter_phrase_list($self->proj->phrase_list([$new_phr]));

            my @bad = grep{!$h{$_}} @{$new_phr->{filterreason} || []};
            if(@bad) {
                $self->log("restore_tail filters '$new_phr' (orig: '$phr'): " . join(" ", @bad) )
                    if $self->proj->{make_action_list_debug};
                return 0;
            }
        }

        return 1;
    };

    $bnr->filter_phrase_list($self) if $bnr;

    while(@q) {
        my $phr = shift @q;
        my $count = $phr->get_search_count;

        # топ хвостиков
        my $tails = $phr->get_search_tail;
        my @tail_top = sort{$tails->{$b} <=> $tails->{$a}} keys %$tails;

        # если почти все запросы c фразой содержат одно и то же слово, дописываем его к фразе
        if(@tail_top && $tails->{$tail_top[0]} >= $ratio * $count) {
            my $new_phr = $phr->language->phrase("$tail_top[0] " . $phr->text);

            if($check_phrase->($phr, $new_phr)) {
                push @q, $new_phr;
                next;
            }
        }

        # если фраза почти не встречается как запрос, заменяем хвостиками
        if(@tail_top && $phr->get_search_query_count < $min_query_count) {
            my @new_phrases = ();

            for my $word (@tail_top[0..min($#tail_top, $query_top_size - 1)]) {
                last if $tails->{$word} < $min_query_count;

                my $new_phr = $phr->language->phrase("$word " . $phr->text);

                push @new_phrases, $new_phr if $check_phrase->($phr, $new_phr);
            }

            if(@new_phrases) {
                push @q, @new_phrases;
                next;
            }
        }

        # если дописать хвостик не удалось, то оставляем исходную фразу
        push @result, $phr;
    }

    return $self->proj->phrase_list(\@result);
}

sub add_search_tail {
    my ($self) = @_;
    $self->cache_search_tail;
    return $self + $self->phmap(sub {$_->get_search_tail_phl});
}

sub add_search_tail_with_threshold {
    my ($self, $thd) = @_;

    my $rphl = $self->proj->phrase_list; #Результирующий список

    my $phl = $self->get_search_threshold_filtered($thd);
    $rphl += $phl; #Добавляем проходящие по порогу фразы начального списка

    while($phl->count > 0){
        $phl->cache_search_tail;
        $phl = $phl->phmap(sub {$_->get_search_tail_phl( threshold => $thd)})->pack_list->get_search_threshold_filtered($thd);
        $rphl += $phl;
    }

    return $rphl->pack_list;
}

#Нужно для пакетной нормализации через proj-server
sub _add_norm_phr_inf {
    my ($self) = @_;
    return $self->lmap(sub { $_->text."=>".$_->norm_phr });
}

#Возвращает экселевский файл со списком фраз
sub get_xls_multicol {
    my ($self) = @_;
    my @arr = map { [ split /\s*=[\*\-\+]?>\s*/, $_->text ] } @$self;
    return array2xls_multi([[ \@arr, 'Phrases' ]]);
}

#Возвращает экселевский файл со списком фраз
sub get_xls {
    my ($self) = @_;
    my @arr = map {$_->text} @$self;
    return array2xls(\@arr);
}

sub get_xls_info_data {
    my ($self) = @_;
    my $phl = $self->tmap(sub { s/=>.*//g; $_ });
    $phl->cache_search_count->cache_cdict_minicategs;
    #my @arr = map {[$_->text, $_->get_search_count, join('/', $_->get_minicategs)]} @$self;
    my @arr = map {[
        $_->text,
        $_->{'search_count'} || $_->get_search_count,
        $_->{'cdict_minicategs'} || join('/', $_->get_minicategs )
    ]} @$phl;
    return \@arr;
}

sub get_xls_info {
    my ($self) = @_;
    return array2xls($self->get_xls_info_data);
}

sub text_without_cities_words {
    my ($self) = @_;
    return $self->phtmap(sub { $_->text_without_cities_words });
}

#Возвращает общий префикс текстов, если он есть
sub get_list_prefix :CACHE {
    my ($self) = @_;
    my $pref = '';
    for my $ph ( @$self ){
        unless( $pref ){
            $pref = $ph;
            next;
        }
        $pref = $pref->get_common_prefix($ph);
    }
    return $pref;
}


#Заглушка для пакетной нормализации фраз
sub get_norm_phr_forms { return shift; }

#прокидываем, чтобы обойти хождение в продж-сервер
sub get_minicateg_id {
    my ($self, $catid) = @_;
    return $self->proj->categs_tree->get_minicateg_id($catid);
}

#прокидываем, чтобы обойти хождение в продж-сервер
sub get_minicateg_by_id {
    my ($self, $catid) = @_;
    return $self->proj->categs_tree->get_minicateg_by_id($catid);
}

#прокидываем, чтобы обойти хождение в продж-сервер
sub get_minicateg_by_norm {
    my ($self, $catid) = @_;
    return $self->proj->categs_tree->get_minicateg_by_norm($self->norm_categ($catid));
}

#прокидываем, чтобы обойти хождение в продж-сервер
sub norm_categ {
    my ($self, $catid) = @_;
    return $self->proj->categs_tree->norm_categ($catid);
}

#прокидываем, чтобы обойти хождение в продж-сервер
my $normcateg2id = {};
sub get_minicateg_id_lang {
    my ($self, $categ, $lang_name) = @_;
    my $lang = $self->proj->get_language($lang_name);

    if(!$normcateg2id->{$lang_name}) {
        my $h = {};
        for my $categ ($self->proj->categs_tree->get_minicategs_list()) {
            my $phr = $lang->phrase($lang->category_from_ru($categ));
            $h->{$phr->get_norm_categ_from_text} = $self->proj->categs_tree->get_minicateg_id($categ);
        }
        $normcateg2id->{$lang_name} = $h;
    }

    return $normcateg2id->{$lang_name}{$lang->phrase($categ)->get_norm_categ_from_text};
}

#Удаляет дефисы из фраз
sub delete_hyphens {
    my ($self) = @_;
    return $self->tmap(sub { s/(?<!\s)-/ /g; $_ });
}

sub get_yandex_domains {
    my ($self) = @_;
    return $self->lmap(sub { $_->text.' =!> '.join(" ", $_->get_yandex_domains) });
}

sub parse : EXTERNALLY_USED("yt") {
    my ($self) = @_;
    my @arr;
    for my $phr ( @$self ){
        my %h = $phr->parse;
        #print Dumper ( \%h );
        push @arr, $phr->text.' => '.join( '|', sort map { $h{$_} ? $_.':'.$h{$_} : () } keys %h );
    }
    return $self->phrase_list( \@arr );
}

#Срезает тестовую информацию
sub delete_all_test_info {
    my ($self) = @_;
    return $self->lgrep(sub {!/^#/})->lmap(sub { s/=.?>.*//; $_ });
}

sub get_prefiltered_phl {
    my ($self) = @_;
    my @arr = ();
    push(@arr, $_->get_banner_prefiltered_phrase) for @$self;
    return $self->phrase_list( \@arr );
}

sub get_yandex_urls {
    my ($self) = @_;
    return $self->lmap(sub { my $t = $_->text.' =!> '.join(" ", $_->get_yandex_urls); $t =~ s/,//g; return $t });
}

sub test_search_and_banners_count_inf {
    my ($self, $th) = @_;
    return $self->cache_search_query_count->cache_search_count->lmap(sub { $_.' => '.join(' / ', $_->get_search_query_count, $_->get_search_count, $_->get_bnr_count ) });
}

sub get_adjectives {
    my ($self) = @_;
    return $self->lmap(sub { $_->get_adjective });
}

sub set_exclamations_before_stops {
    my ($self) = @_;
    return $self->lmap( sub { $_->set_exclamations_before_stops });
}

sub set_exclamations_before_stops_safe {
    my ($self) = @_;
    return $self->lmap( sub { $_->set_exclamations_before_stops_safe });
}

sub set_exclamations_before_bsstops {
    my ($self) = @_;
    return $self->lmap( sub { $_->set_exclamations_before_bsstops });
}

sub replace_exclamations_with_pluses {
    my ($self) = @_;
    return $self->lmap( sub { $_->replace_exclamations_with_pluses });
}

sub move_minuswords_to_end {
    my ($self) = @_;
    return $self->lmap( sub { $_->move_minuswords_to_end });
}

sub add_minus_words_flights {
    my ($self) = @_;
    return $self->lmap( sub { $_->add_minus_words_flights });
}

sub add_minus_words_travel {
    my ($self) = @_;
    return $self->lmap( sub { $_->add_minus_words_travel });
}

sub replace_strange_symbols_by_space {
    my ($self) = @_;
    return $self->lmap( sub { $_->replace_strange_symbols_by_space });
}

sub get_matched_queries {
    my $self = shift;
    my %par  = @_;
    return $self->proj->rpc->call_with_rpc(
        sub { $self->get_matched_queries_generic(@_) },
        [ %par ],
    );
}

# получаем хэш { text => $queries_phl }; метод с rpc-вызовами!
sub get_matched_queries_generic {
    my $self = shift;
    my %par  = @_;

    my $proj = $self->proj;
    my $ctx  = ($par{ctx}{get_matched_queries_generic} //= {});  # свой контекст, чтоб не путать с глобальным; важно "//="

    my $ratio = 0.005;  # ограничение на (частота фразы с хвостиками)/(частота исходной фразы)
    my $max_phrases = 20;  # макс. кол-во хвостиков при однократном расширении
    my $max_queries = 10;  # кол-во запросов на фразу (топ по search_query_count)
    my $max_depth = $par{max_depth} // 8;


    if (!$ctx->{step}) {
        # нужны частоты исходных фраз
        $ctx->{step}++;
        my $noqphl = $self->lgrep(sub { !$_->is_quoted })->text_pack_list;
        return (undef, [
            [ cache_search_count => $noqphl ],  # для source_count
            [ cache_search_tail => $noqphl ],  # для расширения
            [ cache_search_query_count => $noqphl ],  # для расширения
        ]);
    }

    if ($ctx->{step} == 1) {
        # формируем список запросов
        $ctx->{expand} = [];
        my $noqphl = $self->lgrep(sub { !$_->is_quoted })->text_pack_list;
        for my $phr (@$noqphl) {
            push @{$ctx->{expand}}, {
                source_text => $phr->text,
                source_count => $phr->get_search_count,
                source_minus => { map { $_ => 1 } $phr->normminuswords },
                phrases => [$phr],
                seen => {},
                qcount => {},
            };
        }
    }

    for my $inf (@{$ctx->{expand}}) {
        my @new_phrases;
        for my $phr (@{$inf->{phrases}}) {
            my $text = join(' ', $phr->pluswords);  # срезаем кавычки
            $inf->{qcount}{'"'.$text.'"'} = $phr->get_search_query_count;

            my $tails = $phr->get_search_tail;
            my @good = grep { !$inf->{source_minus}{$_} and $tails->{$_} >= $ratio * $inf->{source_count} } keys %$tails;
            @good = grep { !$phr->normwordshash->{$_} } @good;  # убираем дубли
            @good = sort { $tails->{$b} <=> $tails->{$a} } @good;
            @good = splice(@good, 0, $max_phrases);

            push @new_phrases, grep { !$inf->{seen}{$_->norm_phr}++ } map { $proj->phrase("$text $_") } @good;
        }
        $inf->{phrases} = \@new_phrases;
    }

    my $to_expand_phl = $proj->phrase_list([ map { @{$_->{phrases}} } @{$ctx->{expand}} ]);
    if ($ctx->{step} > $max_depth or !$to_expand_phl->count) {
        # всё готово!
        my %result;
        for my $phr (@$self) {
            if ($phr->is_quoted) {
                $result{$phr->text} = $proj->phrase_list([$phr->text]);
            }
        }
        my $expand = delete $ctx->{expand};
        for my $inf (@$expand) {
            # выбираем топ запросов
            my $q = $inf->{qcount};
            my @q = sort { $q->{$b} <=> $q->{$a} } grep { $q->{$_} > 0 } keys %$q;
            @q = splice(@q, 0, $max_queries);
            $result{$inf->{source_text}} = $proj->phrase_list(\@q) if @q;
        }
        return \%result;
    }

    $ctx->{step}++;
    return (undef, [
        [ cache_search_tail => $to_expand_phl ],
        [ cache_search_query_count => $to_expand_phl ],
    ]);
}

sub join_to_atom {
    my ($self) = @_;
    my $text = '['.join('/', @$self).']';
    return $self->phrase_list([$text]);
}

sub grep8words {
    my ($self) = @_;
    my $phl = $self->get_norm_phr_forms;
    return $phl->lgrep(sub { my @arr = $_->normwords; @arr < 8; });
}

sub delete_bad_subphrases {
    my ($self) = @_;
    return $self->phtmap(sub { $_->delete_bad_subphrases });
}

sub pack_spaces_and_underscore {
    my ($self) = @_;
    return $self->tmap(sub { s/_/ /g; s/^\s+|\s+$//g; s/\s+/ /g; $_ });
}

sub pack_spaces {
    my ($self) = @_;
    return $self->tmap(sub { s/^\s+|\s+$//g; s/\s+/ /g; $_ });
}

sub add_mediagroups {
    my ($self, $log) = @_;
    my $proj = $self->proj;
    my @arr = ();
    for my $ph (@$self){
        $ph->{mediagroups_log} = "" if $log;
        my @grps = $ph->get_mediagroups;
        my $ttext =  $ph." => ".join('/', @grps);
        $ttext .= "\n" . $ph->{mediagroups_log} if $log;
        push(@arr, $ttext);
    }
    #$proj->dd(\@arr);

    return $self->phrase_list( \@arr );
}

sub add_catalogia_flags {
    my ($self, $log) = @_;
    my $proj = $self->proj;
    my @arr = ();

    for my $ph (@$self){
        my $ttext =  $ph." => ".join('/', $ph->get_banner_catalogia_flags);
        push(@arr, $ttext);
    }

    return $self->phrase_list( \@arr );
}

sub get_groups_hash {
    my ($self, $func) = @_;
    my $h = {};

    for my $phr (@$self) {
        $phr = $self->proj->phrase($phr) unless ref($phr);
        my @groups = $func->($phr);
        @groups = ("") if !@groups;
        ($h->{$_} ||= {})->{count}++ for @groups;
        push @{$h->{$_}{phrases} ||= []}, $phr for @groups;
    }

    for my $g (keys %$h) {
        my $phl = $self->proj->phrase_list({ phrases_arr => $h->{$g}{phrases} });
        $self->proj->save_phrase_list($phl);
        $h->{$g}{phlid} = $phl->cache_id;
        $h->{$g}{phrases} = "$phl";
    }

    return $h;
}

sub get_mediagroups_hash {
    my ($self) = @_;

    return $self->get_groups_hash(sub { return $_[0]->get_mediagroups; });
}

sub get_catalogia_flags_hash {
    my ($self) = @_;

    return $self->get_groups_hash(sub { return $_[0]->get_banner_catalogia_flags; });
}

sub compress_norms {
    my ($self) = @_;
    my $norm2text = {};
    my $norm2minus = {};
    my @order;

    for my $phr (@$self) {
        my $norm = $phr->norm_phr;

        $norm2text->{$norm} = join " ", $phr->pluswords;
        ($norm2minus->{$norm} ||= {})->{$_}++ for $phr->minuswords;
    }

    return $self->proj->phrase_list({ phrases_arr => [ map{ join(" ", $norm2text->{$_}, map{"-$_"} sort keys %{$norm2minus->{$_}}) } keys %$norm2text ]  });
}

# $newvar - на выходе стараемся сохранить новый вариант текста
sub get_difference {
    my ($self, $other, $newvar) = @_;
    my $h1 = { };
    my $h2 = { };
    my $out = [];

    push @{$h1->{$_->norm_phr_without_hyphens} ||= []}, $_ for @$self;
    push @{$h2->{$_->norm_phr_without_hyphens} ||= []}, $_ for @$other;

    for my $phr (@$self) {
        my $phr2 = shift @{$h2->{$phr->norm_phr_without_hyphens} || []};
        my $text = $phr->text;

        if($phr2) {
            my %mwh = map{$_=>1} $phr->minuswords;
            my @new_minus = grep{!$mwh{$_}} $phr2->minuswords;
            my $minus_text = join " ", map{"-$_"} @new_minus;
            if($newvar){
                $text = $phr2->text;
                $text .= " => $minus_text" if @new_minus;
            }else{
                $text .= " $minus_text => $minus_text" if @new_minus;
            }
        } else {
            $text = "#DEL $text";
        }

        push @$out, $text;
    }

    for my $norm (keys %$h2) {
        for my $phr2 (@{$h2->{$norm}}) {
            push @$out, $phr2->text . " => ADD";
        }
    }

    return $self->proj->phrase_list($out);
}

sub clear_utf8 {
    my $self = shift;
    my $phrases_text = Encode::decode('UTF-8', $self->phrases2text);
    return $self->proj->phrase_list( { phrases_text => $phrases_text } );
}

sub take_models_in_interface {
    my ($self) = @_;
    my @res = ();
    my $hh = $self->parse_type_brand_model;
    for my $h ( values %$hh ){
        my $type = $h->{type};
        my $brand = $h->{brand};
        my $model = $h->{model};
        next unless $model;
        my $txt = '';
        $txt = $type if $type;
        $txt .= " $brand" if $brand;
        $txt .= " $model" if $model;
        $txt =~ s/^\s+|\s+$//g;
        push @res, $txt if $txt;
    }
    return $self->proj->phrase_list( { phrases_arr => \@res } );
}

sub parse_type_brand_model {
    my ($self) = @_;
#    print STDERR "***$self\n";
    my %res;
    for ( @$self ){
        my $orig = $_;
        $res{$orig}{type} = '';
        $res{$orig}{brand} = '';
        $res{$orig}{brand_for} = '';
        $res{$orig}{model} = '';
        $res{$orig}{model_for} = '';
        my $orig_without_plus = (split /\+/)[0];
        next unless ( $orig_without_plus && $orig_without_plus =~ /\w/ );
        next if ( $orig_without_plus =~ /картридж/ && $orig_without_plus =~ /laserjet/ && $orig_without_plus !~ /\s+(for|для)\s+/ );
        # пока закомменттил, т.к. в парсере это учитывается, но если что - вернуть назад
#        my $text = (split /(?: с | для )/, $_->text)[0]; # убираем мешающие части
        my ( $part1, $part2 ) = split /\t/, lc($_->text);
        # для компьютеров, серверов и ноутбуков убираем лишнее
        $part2 =~ s/(?:\(| [^ ]*\\| [^ ]*\/| [^ ]*\||[\d.]+(?:\"|\'\')|[\d]+ ?(?:gb|mb|гб|ггц|мб|g)[^\d\w]|intel|celeron|core|amd|pentium|atom|athlon|retina|процессор|кабель| -(?:[,]| )| i(?:3|5|7|9)|ddr3).*$//g if ( $part2 && $part1 && $part1 =~ /^9101/ );
        my $phr = $self->proj->phrase($part2 || $part1);
#        print STDERR "==".$phr->text."\n";
         # если что - первым делом вернуть вызов parse!!!
#        my %h = $phr->parse;
        my %h = $phr->parse_sentences;
#        print STDERR Dumper ( \%h );
        my $model = $h{model};
        my $brand = $h{brand};
#        my $type = $h{type};
        my $goods = '';
        my $type = '';
        for my $part ( split /[!.?:]+/, $orig_without_plus ){
            $goods = $self->proj->phrase($part)->get_goods;
#            print STDERR "--$part -> $goods\n";
            next unless $goods;
            $res{$orig}{goods} = $goods if ( $self->proj->phrase($part)->_check_type( $goods, $model, $brand ) );
            last if $res{$orig}{goods};
        }

#        print STDERR "[$type] --> [$model] --> [$brand]\n";# unless $our_categ_name;
        $res{$orig}{type} = $h{type};
        $res{$orig}{brand} = $brand;
        $res{$orig}{brand_for} = $h{brand_for};
        $res{$orig}{model} = $model;
        $res{$orig}{model_for} = $h{model_for};
        $res{$orig}{prep} = $h{prep};
        $res{$orig}{category} = $h{category} || $goods ? 'goods' : undef;
        $res{$orig}{src} = $h{src};
        $res{$orig}{class} = $h{class};
    }
    return \%res;
}

sub _modlen {
    my $txt = shift;
    return 0 unless $txt;
    return scalar( @{[$txt=~/[a-zа-я0-9]/g]} ) - scalar( @{[$txt=~/ /g]} );
}

sub _modweight {
    my $txt = shift;
    return 0 unless $txt;
    my $letter_count = @{[$txt=~/[a-z]/g]};
    my $number_count = @{[$txt=~/[0-9]/g]};
    return $letter_count*$number_count;
}

sub freq_hash {
    my ($self) = @_;
    my %h = ();
    $h{$_}++ for @$self;
    return \%h;
}

sub freq_phrase {
    my ($self) = @_;
    my $h = $self->freq_hash;
    my @a = map {$_->[0]} sort { $b->[1] <=> $a->[1] } map { [ $_, $h->{$_} ] } keys %$h;
    return $self->proj->phrase(shift @a);
}

sub freq_good_phrase {
    my ($self) = @_;
    my $proj = $self->proj;
    my $h = $self->freq_hash;
    my @a = sort { $b->[1] <=> $a->[1] } map { [ $_, $h->{$_} ] } keys %$h;
    return undef unless @a;
    #Удаляем слишком низкочастотные варианты
    my $lim = $a[0][1] * 0.2;
    @a = grep { $_->[1] >= $lim } @a; #
    @a = map {$_->[0]} @a;
    @a = grep {! /^(для|от|в|и|или|на|по|за|да|из|с)\s/} @a;
    for my $t (@a){
        #print ">>> $t\n";
        my $inf = $proj->phrase($t)->get_gender_number_case;
        return $proj->phrase($t) if $inf->{'number'} && $inf->{'case'} && ($inf->{'number'} eq 'pl') && ($inf->{'case'} eq 'nom');
        #print Dumper($self->proj->phrase($t)->get_gender_number_case);
    }
    return $proj->phrase(shift @a);
}

#Хэш настроек преобразоавний
our $frm = '
    где можно купить => где можно купить ___vs
    можно купить => как можно купить ___vs
    цена => цена на ___
    цена +на => цена +на ___
    каталог цена => каталог ___r цены
    низкий цена => низкие цены на ___
    стоимость => стоимость ___r
    купить => купить ___vs
    прайс => ___ прайс
    купить интернет => купите ___ в интернете
    купить интернет => купите ___ в интернете
    купить интернет магазин => купить ___ в интернет-магазине
    купить цена => купите ___ цена
    стоимость купить => Купить ___ стоимость
    наличие => ___ в наличии
    avito => ___ на avito.ru
    +в кривой рог => ___ +в Кривом Роге
    кривой рог => ___ в Кривом Роге
    +в Набережных Челнах => ___ +в Набережных Челнах
    Набережных Челнах => ___ в Набережных Челнах
    +в Набережные Челны => ___ +в Набережных Челнах
    Набережные Челны => ___ в Набережных Челнах
    спб => ___ в СПБ
    +в спб => ___ +в СПБ
    ___ [ВАО/ЮВАО/ЮАО/ЮЗАО/ЗАО/СЗАО/САО/СВАО/ЦАО] Москвы
    сделаем => сделаем ___
    изготовление => изготовление ___r
    лечение => лечение ___re
    химиотерапия => химиотерапия при ___pe
    изготовим => изготовим ___
    производство продажа => производство и продажа ___r
    #делать после => ___ - что делать после
    делать после => что делать после ___re
    заказать => заказать ___ve
    перевоз => перевоз ___re
    санкт петербург => ___ в Санкт-Петербурге
    санкт-петербург => ___ в Санкт-Петербурге
    петербург => ___ в Петербурге
#    одинцово => ___ в Одинцово
#    ростов => ___ в Ростове
    ростов дон => ___ в Ростове-на-Дону
    ростов-на-дону => ___ в Ростове-на-Дону
    отделка => отделка ___
    доставка => доставка ___r
    заказать отделку => заказать отдельку ___re
    ремонт => ремонт ___r
    +без опыт => ___ +без опыта
    опыт => ___ c опытом
    отзыв => отзывы на ___
    интернет магазин => ___ в интернет-магазине
    интернет => ___ в интернете
#    ульяновск => ___ в Ульяновске
    где купить => где купить ___
    рубеж => ___ за рубежом
    где сделать => где сделать ___ve
    где взрослому => где взрослому ___
    где москва сделать => где в Москве сделать ___ve
    детские => детские ___
    практические занятия => практические занятия по ___de
    онлайн => ___ онлайн
    +по каско => ___ +по КАСКО
    +из франции => ___ +из Франции
    подключать ли => подключать ли ___vs
    подключение => подключение ___rs
    подключиться => подключиться к ___ds
    подключить => подключить ___vs
    заем => заем на ___vs
    заем приобретение => заем на приобретение ___rs
    заем покупка => заем на покупку ___rs
    бесплатно => ___ бесплатно
    расценки => расценки на ___vs
    ___ [весна/осень] [2013/2014/2015/2016/2017]
    ___ для [девочек/мальчиков] [2/3/4/5/6/7/8/9/10/11/12/13/14/15] лет
    +в {.Города России} => ___ +в d___ps
    {.Города России} => ___ в d___ps
    в районе {.Города России} => ___ в районе d___rs
';
# слова, которые не дописываем при гармонизации
my $bad_words_re = "(^| )(не|Не|я|Я|себе|Себе|б)( |\$)";

sub cache_tail_categs {
    my ($self) = @_;
    $self->proj->cdict_client->get_tail_categs(@{$self});
    return $self;
}

sub add_chars_log {
    my ($self) = @_;
    return $self->lmap( sub { $_->add_chars_log } );
#    return $self->phrarr2phrlist( map { $_.' => '.$_->add_chars_log } @$self );
}

sub direct_format_phrases {
    my ($self) = @_;
    return $self->lmap(sub { $_->direct_format_text });
}

#Удаление минус-слов без частот
sub delete_useless_minus_words { my $self = shift; my @a = @_; return $self->lmap(sub { $_->delete_useless_minus_words(@a) }); }

#Удаляем двойные кавычки у фраз
sub delete_quotes { return $_[0]->tmap(sub { s/"//g; s/~0//; $_ }); }

sub search_sub_phrases {
    my ($self, $phl) = @_;
    my @res = ();
    for my $ph (@$self){
        push(@res, $ph) if $phl->search_subphrases_in_phrase($ph)->count;
    }
    return $self->proj->phrase_list({ phrases_list => \@res });
}

sub mark_misprints {
    my ($self) = @_;
    return $self->lmap(sub { "$_ =*> ".$_->is_misspell });
}

sub casecorrection {
    my ($self) = @_;
    return $self->lmap(sub { $_->casecorrection });
}

sub add_important_words {
    my ($self, $text) = @_;
    my $bwf = { map {$_ => 1} $self->proj->phrase( "$text" )->snormwords }; #Хэш слов, которые должны быть во всех фразах
    my $newphl = $self->proj->phrase_list;
    for my $ph (@$self){
        if(grep {$bwf->{$_}} $ph->snormwords){ #Уже содержит
            $newphl += [ $ph ];
        }else{ #Доклеиваем все варианты
            $newphl += [ map { "$_ $ph" } keys %$bwf];
        }
    }
    return $newphl;
}

sub ends_of_banners_filter {
    my ($self) = @_;
    return $self
       ->lmap(sub { $_->text." => ".$_->ends_of_banners_filter });
}

sub ends_of_banners_filter_log {
    my ($self) = @_;
    return $self
       ->lmap(sub { $_->text." => ".$_->ends_of_banners_filter_log });
}

sub change_numeral_noun_case {
    my ($self) = @_;
    return $self
       ->lmap(sub {
           my ($txt, $cnt) = split(/\s*=>\s*/, $_->text);
           my $res = $self->proj->phrase($txt)->change_text_number($cnt, 1);
           $res =~ s/(?:^|(?<=\s))хорош/лучш/g if $txt =~ /лучш/; #Исправляем замену лучшего на хорошее, так как это не всегда правильно
           return "$txt => $res";
       });
}

sub change_numeral_noun_case_json {
    my ($self) = @_;
    my $json = $self->proj->json_obj;
    return $self->change_numeral_noun_case->lmap(sub { $json->encode([ split /\s*=>\s*/, $_ ]) });
}

# метод для BMAPI; TODO переделать без PhraseList
sub get_norm_dict {
    my $self = shift;
    my $file = $self->proj->options->{Words_params}{norm_dict};
    open my $fh, '<', $file
        or warn "Can't open file `$file': $!";
    my @lines = <$fh>;
    chomp $_ for @lines;
    close $fh;
    return $self->proj->phrase_list(\@lines);
}

sub do_ucfirst {
    my $self = shift;
    return $self->lmap(sub { $_->do_ucfirst->text });
}

sub pack_phr {
    my $self = shift;
    return $self->lmap(sub { $_->pack_phr });
}

sub pack_phr_lite {
    my $self = shift;
    return $self->lmap(sub { $_->pack_phr_lite });
}

sub add_dynamic_homonymy_words {
    my ( $self, %hparsed ) = @_;
    return $self unless $self->count;
    my @res = ();
    return $self unless ( $hparsed{dynamic_homonymy_words} && $hparsed{dynamic_homonymy_words} =~ /[а-яёa-z]/i );
    my @src_filtered = ();
    for my $phr ( @$self ){
        push @src_filtered, $phr if ( scalar(split/\s+/,$phr->text)<5 );
    }
    for my $word ( split/\s*\,\s*/, $hparsed{dynamic_homonymy_words} ){
        push @res, "$word $_" for ( @src_filtered );
    }
    return $self->proj->phrase_list(\@res)->pack_phr_lite;
}

sub add_dynamic_homonymy_words_if_needed {
# для каждой фразы: оставляет нетронутой, если во фразе уже есть слова, подобные dynamic_homonymy_words, и добавляет их, если их там нет
    my ( $self, %hparsed ) = @_;
    return $self unless $self->count;
    return $self unless ( $hparsed{dynamic_homonymy_words} && $hparsed{dynamic_homonymy_words} =~ /[а-яёa-z]/i );

    my @res = ();
    # делаем регулярки для каждого из слов
    my @dynamic_homonymy_words = split/\s*\,\s*/, $hparsed{dynamic_homonymy_words};
    my $dynamic_homonymy_words_re = '(^|\s)('.(join "|", (map { substr($_, 0, length($_)-1); } ( @dynamic_homonymy_words ))).').*?($|\s)';

#    print "\@dynamic_homonymy_words\n", Dumper(\@dynamic_homonymy_words);
#    print "\@dynamic_homonymy_words_re: $dynamic_homonymy_words_re\n";

    my $minicategs = $hparsed{minicategs};
    my $toys_re = '(^|\s)(игров|игруш|детск|игр).*?($|\s)';

#    print Dumper(\%hparsed);
    for my $phr ( @$self ){
        if ( scalar(split/\s+/,$phr->text)>=5 ) {
            push @res, $phr;
        }
        else {
            my $text = $phr->text;
            if (($text =~ /$dynamic_homonymy_words_re/i) or
                (($minicategs =~ /$toys_re/i) and ($text =~ /$toys_re/i))) {
                # во фразе уже есть слово, снимающее омонимию, добавляем фразу как есть
                push @res, $text;
                next;
            }
            # во фразе нет ни одного слова, снимающего омонимию, добавим все эти слова
            push @res, "$text $_" for (@dynamic_homonymy_words);
        }
    }

    return $self->proj->phrase_list(\@res)->pack_phr_lite;
}

sub delete_trade_words { return $_[0]->lmap( sub { $_->delete_trade_words } ); }
sub delete_town_words  { return $_[0]->lmap( sub { $_->delete_town_words } ); }

sub get_modellike_modifications_lite {
    my ( $self, %par ) = @_;
    return $self->lmap( sub { @{$_->get_modellike_modifications_lite( %par )} } );
}

sub tfidf {
    my ($self) = @_;
    my @res = ();

    my @docs_norm = map { $_->norm_phr } @$self;

    my %df = ();
    my @allwords = grep { $_ } map { split /\s+/ } @docs_norm;
    $df{$_}++ for ( @allwords );
    my %idf = ();
    $idf{$_} = log($self->count/$df{$_}) for ( @allwords );

    for my $doc ( @docs_norm ){
        my %tf = ();
        my %tfidf = ();
        my @docwords = grep { $_ } split /\s+/, $doc;
        $tf{$_}++ for ( @docwords );
        $tfidf{$_} = $tf{$_} * $idf{$_} for ( @docwords );
        push @res, \%tfidf;
    }

    return \@res;
}

sub dynamic_banners_generation_debug {
    my ($self) = @_;
    my @res = ();
    for my $phr ( @$self ){
        my $data = "name=".$phr->text."\n";
        my $fd = $self->proj->feed( { data=>$data, datatype=>'offers_tskv' } );
        $fd->iter_init;
        my $ptl = $fd->next_ptl_pack(1);
        for my $pt ( @$ptl ){
            my $arr = $pt->dyn_banners;
            push @res, $phr->text." => ".$_->{phrase}." => ".$_->{title} for ( @$arr );
        }
    }
    return @res ? $self->proj->phrase_list( \@res ) : $self;
}

sub save {
    my $self = shift;

    my $proj = $self->proj;
    $proj->save_phrase_list($self);

    return $self;
}

sub filter_by_pattern {
    my $self = shift;
    my $pattern = shift;

    return $pattern ? $self->tgrep(sub { /$pattern/i }) : $self;
}

sub remove_by_pattern {
    my $self = shift;
    my $pattern = shift;

    return $pattern ? $self->tgrep(sub { ! /$pattern/i }) : $self;
}

sub concatenate_text_to_phrases {
    my $self = shift;
    my $text = shift;
    my $position = shift || 'tail';

    $text =~ s/,/ /g if $text =~ /=.?>/;
    my $text_phrase_list = $self->proj->phrase_list($text);

    return $position eq 'head' ? $text_phrase_list * $self : $self * $text_phrase_list;
}

sub concatenate_text_to_phrases_save_origin {
    my $self = shift;
    my $text = shift;
    my $position = shift;

    return $self->concatenate_text_to_phrases($text, $position) + $self;
}

sub remove_subphrase_by_pattern {
    my $self = shift;
    my $pattern = shift;

    return $pattern ? $self->tmap(sub { s/$pattern//ig; $_ }) : $self;
}

sub replace_by_atom {
    my $self = shift;
    my $text = shift;

    my $proj = $self->proj;
    my @text_snorm_words = $proj->phrase($text)->uniqsnormwords;
    my %text_snorm_words_set = map {$_ => 1} @text_snorm_words;
    my $atom = '[' . join('/', @text_snorm_words) . ']';
    my @new_texts = ();
    for my $phrase (@$self) {
        my @phrase_words = $phrase->uniqsnormwords;
        if (grep {$text_snorm_words_set{$_}} @phrase_words) {
            push @new_texts, "$atom " . join(' ', grep {!$text_snorm_words_set{$_}} @phrase_words);
        } else {
            push @new_texts, $phrase->text;
        }
    }

    return $proj->phrase_list(\@new_texts)->text_pack_list;
}

sub filter_by_snorm {
    my $self = shift;
    my $text = shift;

    return $text ? $self->search_sub_phrases($self->proj->phrase_list($text)) : $self;
}

sub load_from_file {
    my $self = shift;
    my $filename = shift;
    my $data = shift;

    my $tt = $data;
    my $proj = $self->proj;
    if ($filename =~ /\.xls$/) {
       eval {
           $tt = join(",", xls2array($tt));
       };
       if( $@ ){
           my $dch = $proj->detect_charset;
           $tt = $dch->text2utf8($tt);
           $tt = join(",", csv2array($tt));
       }
    } elsif ($filename =~ /\.xlsx$/) {
        $tt = join(",", xlsx2array($tt));
        my $dch = $proj->detect_charset;
        $tt = $dch->text2utf8($tt);
        Encode::_utf8_on($tt);
    } elsif ($filename =~ /\.csv$/) {
        my $dch = $proj->detect_charset;
        $tt = $dch->text2utf8($tt);
        $tt = join(",", csv2array($tt));
    } else {
        $tt =~ s/\n/,/g;
    }

    $tt = $proj->detect_charset->text2utf8($tt);
    my $phrase_list = $proj->phrase_list($tt);

    return $phrase_list;
}

sub filter_by_min_categories_count {
    my $self = shift;
    my $categories_count_threshold = shift;

    $categories_count_threshold //= 2;

    return $self->lgrep(sub {
        my @categories = $_->get_minicategs;
        @categories >= $categories_count_threshold});
}

sub remove_by_categories {
    my $self = shift;
    my $categories_text = shift;
    my $flag = shift;

    return $self;
}

sub remove_by_most_frequent_category {
    my $self = shift;

    return $self;
}

sub filter_by_max_categories_count {
    my $self = shift;
    my $categories_count_threshold = shift;

    return $self->lgrep(sub {
        my @categories = $_->get_minicategs;
        @categories <= $categories_count_threshold});
}

#Фразы группируются по подстрокам
sub subphrases_groups_format {
    my $self = shift;
    my $shtphl = $self->filter_by_subphrases;
    my $res = { };

    my @others = ();

    for my $ph (@$self){
          my @sarr = grep { $ph->norm_phr ne $_->norm_phr } $self->search_subphrases_in_phrase( $ph, only_norm => 1 )->phrases;
          for my $sph ( @sarr ){
              $res->{ "$sph" } //= [ "$sph" ];
              push( @{ $res->{ "$sph" } }, "$ph" );
          }
          unless(@sarr){
              push( @others, "$ph" );
          }
    }

    @others = grep { ! $res->{$_} } @others;
    $res->{ "others" } = \@others if @others;

    return $res;
}

sub intersection {
    my ($self, %opts) = @_;
    my @words = ();
#    push @words, [split/\s+/, $opts{norm} ? ($_->norm_phr || $_->text) : $_->text] for @$self;
    push @words, [$opts{norm} ? $_->normwords : $_->words] for @$self;
    my $arr_intersection = array_intersection( @words );
    return $self->proj->phrase_list( $arr_intersection );
}

#Удаляет из списка другой список
sub delete_list {
    my ($self, $other) = @_;
    $other = $self->proj->phrase_list($other) if (ref( $other ) eq 'ARRAY') || (! ref $other );
    my $flt = { map { $_->norm_phr => 1 } $other->phrases };
    return $self->phgrep(sub { ! $flt->{$_->norm_phr} });
}

# метод объекта, а не класса, т.к. нужен $proj
our $JSON_KEY = "__j_BM_PhraseList__";
our $JSON_CLASS = 'BM::PhraseListFast';

use Scalar::Util qw/refaddr/;
sub TO_JSON {
    my $self = shift;

    my $inf = $self->FREEZE;
    $inf->{'__j_addr__'} = refaddr($self);
    return { $BM::PhraseList::JSON_KEY => $inf };
}

# хук, выполняемый перед сериализацией (стандартное название для модуля Sereal)
sub FREEZE {
    my ($self) = @_;
    my %inf = (
        lang => $self->lang,
        phrases_list => [ $self->phrases ],
    );
    $inf{_rpc_cache_} = $self->{_rpc_cache_} if $self->{_rpc_cache_};
    return \%inf;
}

sub FROM_JSON {
    #TODO Support smart cache?
    my ($class, $proj, $proto_obj, $hash) = @_;
    $hash->{proj} = $proj;
    return $proto_obj->new($hash);
}

use overload
    "+" => sub {
             my ($self, $other, $swap) = @_;
             $other = $self->proj->phrase_list($other) if (ref( $other ) eq 'ARRAY') || (! ref $other );
             return $self->phrarr2phrlist( $self->phrases, $other->phrases );
        },
#    '@{}' => sub {
#             my ($self) = @_;
#             return [$self->phrases];
#        },
    '""' => sub {
             my ($self) = @_;
             return $self->phrases2text;
        },
    '*' => sub {
             my ($self, $other, $swap) = @_;
             my @arr = ();
             for my $p1 (@$self){
                 for my $p2 (@$other){
                     push(@arr, "$p1 $p2");
                 }
             }
             return $self->phrase_list(\@arr);
        },
    '**' => sub {
             my ($self, $other, $swap) = @_;
             $other = $self->proj->phrase_list($other) if (ref( $other ) eq 'ARRAY') || (! ref $other );
             my $flt = { map { $_->norm_phr => 1 } $other->phrases };
             return $self->phgrep(sub { $flt->{$_->norm_phr} });
        },
    "-" => sub {
             my ($self, $other, $swap) = @_;
             $other = $self->proj->phrase_list($other) if (ref( $other ) eq 'ARRAY') || (! ref $other );
             my $flt = { map { $_->norm_phr => 1 } $other->phrases };
             return $self->phgrep(sub { ! $flt->{$_->norm_phr} });
        };


1;
