package BM::PhraseListBanners;

use strict;

use utf8;
use open ':utf8';

use std;
#use base qw(ObjLib::ProjPart BM::MCached);
use base qw(BM::PhraseListPages BM::PhraseList);

use Utils::Array;
use Utils::Words;
use List::Util;
use Data::Dumper;

# Работа с баннерами и кампаниями в представлении PhraseList

# get_direct_domain_phrases         получить списко фраз по домену из директа
# get_direct_campaign_phrases       получить фразы по списку кампаний
# get_direct_campaign_banner_texts  получить по кампаниям списки текстов баннеров
# get_banners_by_text_phrases       получить список баннеров (по 200 на фразу), у которых есть фразы в тексте
# get_banners_categs                возвращает хеш формата {bannerid => список_категорий_через_пробел}

# domains2phrases                   получение по списку доменов списка фраз

sub logins2campaigns {
    my ($self) = @_;
    my $proj = $self->proj;
    #my @arr = map { lc($_) } @$self;
    my @arr = @$self;
    s/-/./g for @arr; #Приводим к паспортному варианту
    my $list = [ map { split(/[ ,]+/, $_) } @arr ];
    my @res = $proj->banner_factory->logins2campaigns($list);
    return $proj->phrase_list({ phrases_arr => \@res });
}

sub campaigns2logins {
    my ($self) = @_;
    my $proj = $self->proj;
    my $list = [ map { split(/\D+/, $_) } @$self ];
    my @res = $proj->banner_factory->campaigns2logins($list);
    return $proj->phrase_list({ phrases_arr => \@res });
}

sub clientids2logins {
    my ($self) = @_;
    my $proj = $self->proj;
    my $list = [ map { split(/\D+/, $_) } @$self ];
    my @res = $proj->banner_factory->clientids2logins($list);
    return $proj->phrase_list({ phrases_arr => \@res });
}

sub clientids2clientids_logins {
    my ($self) = @_;
    my $proj = $self->proj;
    my $list = [ map { split(/\D+/, $_) } @$self ];
    my @res = $proj->banner_factory->clientids2clientids_logins($list);
    return $proj->phrase_list({ phrases_arr => \@res });
}

sub clientids2campaigns {
    my ($self) = @_;
    my $proj = $self->proj;
    my $list = [ map { split(/\D+/, $_) } @$self ];
    my @res = $proj->banner_factory->clientids2campaigns($list);
    return $proj->phrase_list({ phrases_arr => \@res });
}

sub campaigns2clientids {
    my ($self) = @_;
    my $proj = $self->proj;
    my $list = [ map { split(/\D+/, $_) } @$self ];
    my @res = $proj->banner_factory->campaigns2clientids($list);
    return $proj->phrase_list({ phrases_arr => \@res });
}

sub campaigns2flags {
    my $self = shift;
    my $proj = $self->proj;
    my @result = ();
    for my $campaign (@$self) {
        my $banners_ids = $proj->phrase_list($campaign->text)->campaigns2banners;
        my $banners_texts = $banners_ids->banners2texts;
        my %unique_flags = ();
        for my $banner_text (@$banners_texts) {
            $unique_flags{$_} = 1 for $banner_text->get_banner_catalogia_flags;
        }
        push @result, join('/', sort keys %unique_flags);
    }
    return $proj->phrase_list(\@result);
}

sub logins2logins_domains {
    my ($self) = @_;
    my $proj = $self->proj;
    #my @arr = map { lc($_) } @$self;
    my @arr = @$self;
    s/-/./g for @arr; #Приводим к паспортному варианту
    my $list = [ map { split(/[ ,]+/, $_) } @arr ];
    my @res = $proj->banner_factory->logins2logins_domains($list);
    return $proj->phrase_list({ phrases_arr => \@res });
}

sub logins2clientids {
    my ($self) = @_;
    my $proj = $self->proj;
    #my @arr = map { lc($_) } @$self;
    my @arr = @$self;
    s/-/./g for @arr; #Приводим к паспортному варианту
    my $list = [ map { split(/[ ,]+/, $_) } @arr ];
    my @logins_clientids = $proj->banner_factory->logins2logins_clientids($list);
    s/\./-/g for @logins_clientids;
    my %login2clientid = map {
        my ($login, $clientid) = split / /, $_;
        $login => $clientid
    } @logins_clientids;
    my @res = map {$login2clientid{"$_"}} @$self;
    return $proj->phrase_list({ phrases_arr => \@res });
}

sub logins2uids {
    my ($self) = @_;
    my $proj = $self->proj;
    #my @arr = map { lc($_) } @$self;
    my @arr = @$self;
    s/-/./g for @arr; #Приводим к паспортному варианту
    my $list = [ map { split(/[ ,]+/, $_) } @arr ];
    my @res = $proj->banner_factory->logins2uids($list);
    return $proj->phrase_list({ phrases_arr => \@res });
}

sub logins2logins_uids {
    my ($self) = @_;
    my $proj = $self->proj;
    #my @arr = map { lc($_) } @$self;
    my @arr = @$self;
    s/-/./g for @arr; #Приводим к паспортному варианту
    my $list = [ map { split(/[ ,]+/, $_) } @arr ];
    my @res = $proj->banner_factory->logins2logins_uids($list);
    return $proj->phrase_list({ phrases_arr => \@res });
}

sub logins2logins_clientids {
    my ($self) = @_;
    my $proj = $self->proj;
    #my @arr = map { lc($_) } @$self;
    my @arr = @$self;
    s/-/./g for @arr; #Приводим к паспортному варианту
    my $list = [ map { split(/[ ,]+/, $_) } @arr ];
    my @res = $proj->banner_factory->logins2logins_clientids($list);
    return $proj->phrase_list({ phrases_arr => \@res });
}

sub campaigns2banners {
    my ($self) = @_;
    my $proj = $self->proj;
    my $list = [ map { split(/\D+/, $_) } @$self ];
    my @res =  $proj->banner_factory->campaigns2banners($list);
    return $proj->phrase_list({ phrases_arr => \@res });
}

sub campaigns2orderids {
    my ($self) = @_;
    my $proj = $self->proj;
    my $list = [ map { split(/\D+/, $_) } @$self ];
    my @res =  $proj->banner_factory->campaigns2orderids($list);
    return $proj->phrase_list({ phrases_arr => \@res });
}

sub campaigns2groupid {
    my ($self) = @_;
    my $proj = $self->proj;
    my $list = [ map { split(/\D+/, $_) } @$self ];
    my @res =  $proj->banner_factory->campaigns2groupid($list);
    return $proj->phrase_list({ phrases_arr => \@res });
}

sub campaigns2campaigns_domains {
    my ($self) = @_;
    my $proj = $self->proj;
    my $list = [ map { split(/\D+/, $_) } @$self ];
    my @res =  $proj->banner_factory->campaigns2campaigns_domains($list);
    return $proj->phrase_list({ phrases_arr => \@res });
}

sub campaigns2campaigns_names :PACKETIZE {
    my ($self) = @_;
    my $proj = $self->proj;
    my $list = [ map { split(/\D+/, $_) } @$self ];
    my @res =  $proj->banner_factory->campaigns2campaigns_names($list);
    return $proj->phrase_list({ phrases_arr => \@res });
}

#Пакетная операция
#Можно оптимизировать, изначально получая сырые запросы
sub campaigns2activebanners_phrases :PACKETIZE {
    my ($self) = @_;
    return $self->campaigns2banners->banners2activebanners->banners2phrases;
}

sub banners2campaigns {
    my ($self) = @_;
    my $proj = $self->proj;
    my $list = [ map { split(/\D+/, $_) } @$self ];
    my @res =  $proj->banner_factory->banners2campaigns($list);
    return $proj->phrase_list({ phrases_arr => \@res });
}

sub banners2activebanners {
    my ($self) = @_;
    my $proj = $self->proj;
    my $list = [ map { split(/\D+/, $_) } @$self ];
    my @res =  $proj->banner_factory->banners2activebanners($list);
    return $proj->phrase_list({ phrases_arr => \@res });
}

sub bsbannerid2banners {
    my ($self) = @_;
    my $proj = $self->proj;
    my $list = [ map { split(/\D+/, $_) } @$self ];
    my @res =  $proj->banner_factory->bsbannerid2banners($list);
    return $proj->phrase_list({ phrases_arr => \@res });
}

sub banners2bsbannerid :PACKETIZE {
    my ($self) = @_;
    my $proj = $self->proj;
    my $list = [ map { split(/\D+/, $_) } @$self ];
    my @res =  $proj->banner_factory->banners2bsbannerid($list);
    return $proj->phrase_list({ phrases_arr => \@res });
}

sub domains2campaigns {
    my ($self) = @_;
    my $proj = $self->proj;
    my @dmns = ();
    for(@$self){
        my $d = $_;
        $d =~ s/^www\.//;
        push(@dmns, $d, "www.$d");
    }
    my @res = $proj->banner_factory->domains2campaigns(\@dmns);
    return $proj->phrase_list({ phrases_arr => \@res });
}

sub domains2logins_firstcampaign {
    my ($self) = @_;
    my $proj = $self->proj;
    my @dmns = ();
    for(@$self){
        my $d = $_;
        $d =~ s/^www\.//;
        push(@dmns, $d, "www.$d");
    }
    my @res = $proj->banner_factory->domains2logins_firstcampaign(\@dmns);
    return $proj->phrase_list({ phrases_arr => \@res });
}

sub domains2domains_logins {
    my ($self) = @_;
    my $proj = $self->proj;
    my @dmns = ();
    for(@$self){
        my $d = $_;
        $d =~ s/^www\.//;
        push(@dmns, $d, "www.$d");
    }
    my @res = $proj->banner_factory->domains2domains_login(\@dmns);
    return $proj->phrase_list({ phrases_arr => \@res });
}

sub domains2banners {
    my ($self) = @_;
    my $proj = $self->proj;
    my @dmns = ();
    for(@$self){
        my $d = $_;
        $d =~ s/^www\.//;
        push(@dmns, $d, "www.$d");
    }
    my @res = $proj->banner_factory->domains2banners(\@dmns);
    return $proj->phrase_list({ phrases_arr => \@res });
}

sub domains2subdomains {
    my ($self) = @_;
    my $proj = $self->proj;
    my @dmns = map { my $t = $_; $t =~ s/^www\.//; $t } @$self;
    my @res = $proj->banner_factory->domains2subdomains(\@dmns);
    return $proj->phrase_list({ phrases_arr => \@res });
}

sub domains2phrases {
    my ($self, %prm) = @_;
    my $proj = $self->proj;
    my @dms = ();
    for(@$self){
        my $d = "$_";
        $d =~ s/^www\.//;
        push(@dms, $d, "www.$d") if $d;
    }
    my @phrs = ();
    for my $d (@dms){
        my $phl = $self->proj->phrase_list->get_direct_domain_phrases($d, bnrs_limit => $prm{bnrs_limit})->fast_text_norm_packed;#->fast_search_count_filter;
        push( @phrs, @{$phl->text_arr});
    }
    return $self->proj->phrase_list({ phrases_arr => \@phrs })->fast_text_norm_packed;
}

sub banners2bnl {
    my ($self) = @_;
    my $proj = $self->proj;
    my @ids = map {$_->text} @$self;
    return $proj->bf->banner_list(\@ids);
}

sub banners2bnl_behesh {
    my ($self) = @_;
    return $self->get_banners_from_behesh;
}

sub banners2texts {
    my ($self) = @_;
    my $bnrs = $self->banners2bnl;
    my %banner_id2text = map {$_->id => $_->banner_text_phrase} grep {$_} @$bnrs;
    my @result = ();
    for my $banner_id (@$self) {
        my $text = $banner_id2text{$banner_id->text} // '';
        $text =~ s/\n|,/ /g;
        push @result, $text;
    }
    return $self->proj->phrase_list({phrases_arr => \@result});
}

sub banners2banners_texts {
    my ($self) = @_;
    my $bnrs = $self->banners2bnl;
    return $self->proj->phrase_list({ phrases_arr => [ map { s/\n|,/ /g; $_} map { $_->id." ".$_->banner_text_phrase } grep {$_} @$bnrs ] }); ##no critic
}

sub banners2banners_texts_dlm {
    my ($self) = @_;
    my $bnrs = $self->banners2bnl;
    return $self->proj->phrase_list({ phrases_arr => [ map { s/\n|,/ /g; $_} map { $_->id." =*> ".$_->banner_text_phrase } grep {$_} @$bnrs ] }); ##no critic
}

sub banners2urls {
    my ($self) = @_;
    my $bnrs = $self->banners2bnl;
    return $self->proj->phrase_list({ phrases_arr => [ map { s/\n|,/ /g; $_} map { $_->url } grep {$_} @$bnrs ] }); ##no critic
}

sub banners2banners_urls {
    my ($self) = @_;
    my $bnrs = $self->banners2bnl;
    return $self->proj->phrase_list({ phrases_arr => [ map { s/\n|,/ /g; $_} map { $_->id.' '.$_->url } grep {$_} @$bnrs ] }); ##no critic
}

sub banners2domains {
    my ($self) = @_;
    my $bnrs = $self->banners2bnl;
    my $h = {};
    $h->{$_->{site_domain}}++ for @$bnrs;
    return $self->proj->phrase_list({ phrases_arr => [ keys %$h ] });
}

sub banners2bannerinfo {
    my ($self) = @_;
    my $bnrs = $self->banners2bnl;
    my @res = ();
    for my $b (@$bnrs){
        #$proj->dd($b);
        push(@res, (
            '',
            $b->id,
            map { "#    $_" }
            map {s/[\r\n\t, ]+/ /g; $_} ($b->title, $b->body, ( 'ctgs: '. join '/', $b->get_minicategs ), $b->url,) ##no critic
        ));
    }
    return $self->proj->phrase_list({ phrases_arr => \@res });
}

sub banners2phrases {
    my ($self) = @_;
    my $bnrs = $self->banners2bnl;
    my @res = map { @{$_->phl} } @$bnrs;
    return $self->proj->phrase_list( \@res );
}

sub banners2currentcategories {
    my ($self) = @_;
    my $bnrs = $self->banners2bnl;
    my @res = map { $_->id.' '.$_->title.' '.$_->body.' =*> '.join("/", $_->get_minicategs) } @$bnrs;
    s/\s+|,/ /g for @res;
    return $self->proj->phrase_list( \@res );
}

sub banners2phrases_behesh {
    my ($self) = @_;
    my $bnrs = $self->banners2bnl_behesh;
    my @res = map { @{$_->phl} } @$bnrs;
    return $self->proj->phrase_list( \@res );
}

sub banners2phrases_ctgsflt {
    my ($self, $flt) = @_;
    my $proj = $self->proj;
    #print ">>>>>> ".$self->count."\n";
    my $bnrs = $self->banners2bnl_behesh;
    #print "bnrs: ".$bnrs->count."\n";
    #print Dumper($flt);
    #print $bnrs->lhead;
    $bnrs = $bnrs->lgrep(sub { ! ( grep { ! $flt->{$_} } $_->get_minicategs ) }) if $flt;
    #print "bnrs 1: ".$bnrs->count."\n";
    my @arr = ();
    for my $bnr (@$bnrs){
        #$proj->dd([$bnr]);
        next if grep { ! $flt->{$_} } $bnr->phl->get_minicategs;
        push(@arr, @{$bnr->phl});
    }
    #print "arr : ".@arr."\n";
    my $phl = $proj->phrase_list(\@arr);
    #my $phl = $proj->phrase_list([ map { @{$_->phl} } @$bnrs ]);
    $phl = $phl->phtmap(sub { my $t = $_->text; $t =~ s/:.+//; $t; });
    $phl = $phl->lgrep(sub { $_->text !~ /[\+~'"\!]/ });
    $phl = $phl->lgrep(sub { !( grep { ! $flt->{$_} } $_->get_minicategs ) }) if $flt;
    return $phl;
}

sub phrases2banners {
    my ($self) = @_;
    return $self->get_banners_by_text_phrases;
}

sub get_direct_campaign_phrases {
    my ($self, $d) = @_;
    my $proj = $self->proj;
    $d =~ s/^www\.//;
    my $list = [ map { split(/\D+/, $_) } @$self ];
    my @phrs = map { split ',', $_ } $proj->banner_factory->get_campaign_phrases($list);
    s/:.*$// for @phrs;
    return $proj->phrase_list({ phrases_arr => \@phrs });
}

sub get_direct_campaign_banner_texts {
    my ($self, $d) = @_;
    my $proj = $self->proj;
    $d =~ s/^www\.//;
    my $list = [ map { split(/\D+/, $_) } @$self ];
    my @phrs =  $proj->banner_factory->get_campaign_banner_texts($list);
    s/,/ /g for @phrs;
    return $proj->phrase_list({ phrases_arr => \@phrs });
}

sub get_banners_by_text_phrases {
    my ($self, $cc) = @_;
    $cc ||= 200;
    my $proj = $self->proj;
    my @arr = ();
    #print "=========".$self->count."\n";
    for my $p (@$self){
        my @ids = $proj->banners_bender->find_ids($p, $cc);
        push(@arr, @ids);
        #print "$p => ".join(',', @ids)."\n";
        #my $bnrs = $proj->bf->banner_list(\@ids);
	#$tphl += $_->phl for @$bnrs;
    }
    return $proj->phrase_list({ phrases_arr => \@arr });
}

sub phrases2phrasesbanners {
    my ($self, $cc) = @_;
    $cc ||= 200;
    my $proj = $self->proj;
    my @arr = ();
    #print "=========".$self->count."\n";
    for my $p (@$self){
        my @ids = $proj->banners_bender->find_ids($p, $cc);
        push(@arr, $p.' => '.join(' ', @ids));
        #print "$p => ".join(',', @ids)."\n";
        #my $bnrs = $proj->bf->banner_list(\@ids);
	#$tphl += $_->phl for @$bnrs;
    }
    return $proj->phrase_list({ phrases_arr => \@arr });
}

sub phrases2phrasesbannersinf {
    my ($self, $cc) = @_;
    $cc ||= 10;
    my $proj = $self->proj;
    my @arr = ();
    #print "=========".$self->count."\n";
    for my $p (@$self){
        my @ids = $proj->banners_bender->find_ids($p, $cc);
        #push(@arr, $p.' => '.join(' ', @ids));
        #print "$p => ".join(',', @ids)."\n";
        my $bnrs = $proj->bf->banner_list(\@ids);
        push( @arr, map { join(' => ', $p, $_->id, $_->campaign_id, $_->banner_text_phrase, join("/", $_->get_minicategs)) } @$bnrs);
	#$tphl += $_->phl for @$bnrs;
    }
    s/,/ /g for @arr;
    return $proj->phrase_list({ phrases_arr => \@arr });
}


sub get_banners_by_text_phrases_1000000 {
    my ($self) = @_;
    return $self->get_banners_by_text_phrases(1000000);
}

sub get_banners_by_text_phrases_2000000 {
    my ($self) = @_;
    return $self->get_banners_by_text_phrases(2000000);
}

sub get_direct_domain_phrases {
    my ($self, $d, %prm) = @_;
    my $proj = $self->proj;
    $d =~ s/^www\.//;
    my @phrs = map { split ',', $_->[1] } $proj->banner_factory->get_domain_phrases([$d, "www.$d"], bnrs_limit => $prm{bnrs_limit});
    return $proj->phrase_list({ phrases_arr => \@phrs });
}

sub get_direct_domains_report {
    my ($self, $dms) = @_;
    my @phrs = ();
    for my $d (@$dms){
        my $phl = $self->proj->phrase_list->get_direct_domain_phrases($d)->fast_text_norm_packed;#->fast_search_count_filter;
        push( @phrs, map { "$_ => $d" } @{$phl->text_arr});
#print "$d:$_\n" for grep {/7025/} @{$phl->text_arr};
    }
    return $self->proj->phrase_list({ phrases_arr => \@phrs });
}

sub get_direct_domains_top {
    my ($self, $dms) = @_;
    my $dinf = {};
    for my $d (@$dms){
        #my $phl = $self->proj->phrase_list->get_direct_domain_phrases($d)->fast_text_norm_packed;#->fast_search_count_filter;
        my $phl = $self->proj->phrase_list->get_direct_domain_phrases($d)->fast_search_count_filter;
        $dinf->{$_}++ for @{$phl->text_arr};
#print "$d:$_\n" for grep {/7025/} @{$phl->text_arr};
    }
    my @phrs = map { $_->[0].' => '.$_->[1] } sort {$b->[1] <=> $a->[1]} map { [ $_, $dinf->{$_} ] } keys %$dinf;
    return $self->proj->phrase_list({ phrases_arr => \@phrs });
}


sub random_banners {
    my ($self, $cnt) = @_;
    $cnt ||= 200;
    my $bnl = $self->proj->banner_factory->random_banners($cnt, $self->lang);
    #$self->proj->dd(\$bnl);
    #$self->proj->dd([ map {$_->{id}} @$bnl  ]);
    return $self->proj->phrase_list({ phrases_arr => [ map {$_->{id}} @$bnl ] });
}

sub texts2banners_report {
    my ($self) = @_;
    my $proj = $self->proj;
    my @arr = ();
    for my $ph (@$self){
        my $phl = $proj->phrase_list([ $ph ]);
        $phl = $phl->get_banners_by_text_phrases_2000000;
        $phl = $phl->lmap(sub { "$_ $ph" });
        $phl = $phl->pack_list;
        push(@arr, @$phl);
    }
    return $self->proj->phrase_list(\@arr);
}

sub texts2bsbanners_report {
    my ($self) = @_;
    my $proj = $self->proj;
    my @garr = ();
    for my $ph (@$self){
        my @arr = split /\//, "$ph";
        my $phl = $proj->phrase_list(\@arr)->get_search_syns;
        $phl = $phl->get_banners_by_text_phrases(2000000);
        $phl = $phl->pack_list;

        #my $min_bid = 294912139; # баннеры только с начала 2014 года
        #$phl = $phl->lgrep(sub { my $bid = $_->text; $bid > $min_bid });

        $phl = $phl->banners2bsbannerid->pack_list;
        #$phl = $phl->lmap(sub { "$_\t$ph" });

        my $s = $arr[0];  # Оставляем только первое слово из перечисленных через "/" - для уменьшения объема выходных данных (иначе получается текст длиной больше гигабайта, и возникают проблемы при сохранении в базу)
        push(@garr, map {"$_\t$s"} @$phl);
    }
    my $nphl = $self->proj->phrase_list(\@garr);
    return $nphl;
}

sub texts2flags {
    my $self = shift;
    my $proj = $self->proj;
    my @result = ();
    for my $phrase (@$self) {
        push @result, join('/', $phrase->get_banner_catalogia_flags);
    }
    return $proj->phrase_list(\@result);
}

sub texts2texts_categs_flags {
    my $self = shift;
    my $proj = $self->proj;
    my @result;
    for my $phrase (@$self) {
        my $text = $phrase->text;
        my $categs = join ('/', $phrase->get_minicategs);
        my $flags = join ('/', $phrase->get_banner_catalogia_flags);
        push @result, join(" => ", $text, $categs, $flags);
    }
    return $proj->phrase_list(\@result);
}

sub pages2titles {
    my ($self) = @_;
    my $pgl = $self->proj->page_list([ map { $_->text } @$self ]);
    return $self->proj->phrase_list( { phrases_arr => [ map { s/\,/ /g; s/\s+/ /g; s/^ | $//g; $_ } map { $_->title } @$pgl  ] } ); ##no critic
}

sub pages2pages_categs : EXTERNALLY_USED("bmapi") {
    my ($self, $raw) = @_;
    my $pgl = $self->proj->page_list([ map { $_->text } @$self ]);
    my @phrases = map { $_->url." =*> ".join("/", map {$_->{success}? @{$_->{categs}} : ('ERROR: can\'t download page. Try again later')} $_->get_minicategs_with_retries ) } @$pgl;
    @phrases = map { s/\,/ /g; s/\s+/ /g; s/^ | $//g; $_ } @phrases unless $raw; ##no critic
    return $self->proj->phrase_list( { phrases_arr => [ @phrases ] } );
}


sub banners2phrasecategsinf {
    my ($self) = @_;
    my $proj = $self->proj;
    my @res = ();
    my $bnl = $self->proj->bf->banner_list( $self->perl_array );
    for my $bn (@$bnl){
        if(defined($bn)){
            for my $ph (@{$bn->phl}){
                push(@res, $bn->id.' =*> '.$ph." =*> ".join('/', map { s/,\s*/ /g; $_ }  $ph->get_minicategs)." =*> ".$bn->campaign_id); ##no critic
            }
        }
    }
    return  $proj->phrase_list({ phrases_arr => \@res });
}

sub domains2mainmirrors {
    my ($self) = @_;
    my $proj = $self->proj;
    my @res = ();
    for my $d (@$self){
        push(@res, $proj->site("$d")->main_mirror);
    }
    return  $proj->phrase_list({ phrases_arr => \@res });
}

sub logins2banners_texts_videodirectgroups {
    my ($self) = @_;
    my @res = ();
    foreach my $login ( @{$self->perl_array} ) {
        foreach my $bannerid (@{$self->proj->phrase_list([$login])->logins2campaigns->campaigns2banners}) {
            my $banner = $self->proj->bf->get_banner_by_id($bannerid);
            my ($txt) = @{$self->proj->phrase_list([$bannerid])->banners2banners_texts_dlm};
            my $minicategs = join('/', grep {$_} $banner->get_minicategs);
            my $vdgroups = join('/', grep {$_} $txt->get_videodirectgroups);
            push @res, "$login =*> $txt =*> {$minicategs} =*> {$vdgroups}";
        }
    }
    return $self->proj->phrase_list({ phrases_arr => \@res }) ;
}

sub banners2phrasebannercategsinf {
    my ($self) = @_;
    my $proj = $self->proj;
    my @res = ();
    my $bnl = $self->proj->bf->banner_list( $self->perl_array );
    for my $bn (@$bnl){
        if(defined($bn)){
            for my $ph (@{$bn->phl}){
                push(@res, $bn->id.' =*> '.$ph." =*> ".join('/', map { s/,\s*/ /g; $_ }  $ph->get_minicategs)." =*> ".$bn->campaign_id." =*> ".join('/', map { s/,\s*/ /g; $_ } $bn->get_minicategs)); ##no critic
            }
        }
    }
    return  $proj->phrase_list({ phrases_arr => \@res });
}

sub _split_potential_interface_queries {
    my @data = @_;

    my $delim = '-----';
    push @data, $delim;

    my @result = ();
    my @current = ();
    while (@data) {
        while ($data[0] !~ /^$delim/) {
            push @current, (shift @data);
        }
        shift @data;
        my %input = map {/^([^:]+):\s*(.+)$/} @current;
        push @result, { %input } if @current;
        @current = ();
    }

    return \@result;
}

1;
