package BM::PhraseListFast;

# Работа со списком фраз как с текстами
# Ускоряем обработку больших массивов фраз

use strict;

use utf8;
use open ':utf8';

use std;
#use base qw(ObjLib::ProjPart BM::MCached);
#use base qw(BM::PhraseListBanners);
use base qw(BM::PhraseListWebCategs);

use Utils::Words;

use Data::Dumper;

# fast_text_norm_packed    быстрое приведение к нормальным формам


sub text_arr :CACHE :LANG {
    my $self = shift;
    my $proj = $self->proj;
    my $prot = $proj->{_phrase_prot};
    my ($proxy, $lang) = ( $self->{'proj_proxy_ref'}, $proj->{current_lang} );
    return [ split /,\s*/, $self->{'phrases_text'} ] if defined $self->{'phrases_text'};
    return [ map {shift(@$_)} map { [split(':', $_)] } split ',', $self->{'phrases_inf_text'} ] if $self->{'phrases_inf_text'};
    if( $self->{'phrases_inf_text'} ){
        my @arr = split ',', $self->{'phrases_inf_text'};
        s/:[^,]+$// for @arr;
        return \@arr;
    }
    return $self->{'phrases_arr'} if $self->{'phrases_arr'};
    return [ map { $_->text } @{ $self->{'phrases_list'}} ] if $self->{'phrases_list'};
    return [];
}


sub fast_text_norm_packed {
    my ($self) = @_;
    my @arr = @{$self->text_arr};
    s/( -|:)[^,]+$// for @arr;
    #s/ -.*$// for @arr; #удаляем минус-слова - ускоряет дальнейшую обработку
    @arr = keys %{{ map { $_ => 1 } @arr }}; #сжатие до нормализации снимает часть нагрузки
    my @narr = phrases2norm( \@arr );
    @narr = keys %{{ map { $_ => 1 } @narr }}; #сжатие после
    return $self->proj->phrase_list({ phrases_arr => \@narr });
}

sub add_norm_phr_forms {
    my ($self) = @_;
    return $self->phtmap(sub { "$_ => ".$_->norm_phr });    
}

sub fast_search_count_filter_stack {
    my ($self, $threshold) = @_;
    $threshold ||= 0;
    my @res = $self->proj->cdict_client->get_normarr_count($self->text_arr);
    my $i = 0;
    my @narr = ();
    for my $t ( @{ $self->text_arr } ){
        push(@narr, $t) if $res[$i] > $threshold;
        #print STDERR "$t ".$res[$i]."\n"; 
        $i++;
    }
    return $self->proj->phrase_list({ phrases_arr => \@narr });
}

sub fast_search_count_filter {
    my ($self) = @_;
    my $phl = $self->fast_text_norm_packed;
    return $phl->make_stacks_method('fast_search_count_filter_stack'); 
}

sub make_stacks_method {
    my ($self, $mtd ) = @_;
    my @phrs = $self->phrases;
    my @newphrs = ();
    my $i = 0;
    print STDERR "total:".@phrs."\n";
    while(@phrs){
        my @arr = splice(@phrs, 0, 10000);
        my $stackphl = $self->phrase_list(\@arr);
        $stackphl = $stackphl->$mtd;
        push(@newphrs, @{$stackphl->text_arr});
        print STDERR time." $mtd ".$i++." >> ".@arr." ".@{$stackphl->text_arr}."\n";
    }
    return $self->phrase_list(\@newphrs);
}



1;
