package BM::PhraseListProjSrv;

use Data::Dumper;
use base qw(BM::PhraseListFast BM::ProjSrv);

sub ProjSrvInf {
    my ($self, $cmd, @params) = @_;
    my $lang = '';
    $lang = "_lang_".$self->lang if $self->lang;
    return ('phrase_list_db_('.$self->lang.')_('.$self->{'projservlogin'}.')', $cmd, "$self", @params) if $self->{'projservlogin'};
    return ('phrase_list'.$lang, $cmd, ( join(',', map {$_->text} @$self)), @params);
}

sub norm_phrase_list  { return $_[0]->ProjSrv('norm_phrase_list' ) };
sub norm_quote_phrase_list  { return $_[0]->ProjSrv('norm_quote_phrase_list' ) };
sub snorm_phrase_list { return $_[0]->ProjSrv('snorm_phrase_list' ) };
sub norm_uniqwords_phrase_list { return $_[0]->ProjSrv('norm_uniqwords_phrase_list' ) };


sub pack_list  : CACHE { return $_[0]->ProjSrv('pack_list' ) };
sub spec_pack_list  : CACHE { return $_[0]->ProjSrv('spec_pack_list' ) };
sub snorm_pack_list  : CACHE { return $_[0]->ProjSrv('snorm_pack_list' ) };
sub text_without_stops  : CACHE { return $_[0]->ProjSrv('text_without_stops' ) };

sub group_phrases_by_type  : CACHE { return $_[0]->ProjSrv('group_phrases_by_type' ) };
sub context_syns_extend    : CACHE { return shift->ProjSrv('context_syns_extend', @_) };
sub context_syns_extend_fresh  : CACHE { return shift->ProjSrv('context_syns_extend_fresh', @_) };
sub minus_words_pack  : CACHE { return shift->ProjSrv('minus_words_pack', @_) };
sub minus_words_pack_fast  : CACHE { return shift->ProjSrv('minus_words_pack_fast', @_) };
sub porn_filtered_phrases { return shift->ProjSrv('porn_filtered_phrases') }
sub list2atoms_phl { return shift->ProjSrv('list2atoms_phl') }
sub get_modellike_modifications { return shift->ProjSrv('get_modellike_modifications') }
sub do_nicely { return shift->ProjSrv('do_nicely') }
sub parse_and_do_nicely { return shift->ProjSrv('parse_and_do_nicely') }
sub get_subphrases { return shift->ProjSrv('get_subphrases') }
sub add_trade_phrases { return shift->ProjSrv('add_trade_phrases') }
sub get_minicategs { return shift->ProjSrv('get_minicategs') }
sub get_minicategs_rltd { return shift->ProjSrv('get_minicategs_rltd') }
sub test_categs_info { return shift->ProjSrv('test_categs_info') }
sub test_categslog_info { return shift->ProjSrv('test_categslog_info') }
sub _add_norm_phr_inf { return shift->ProjSrv('_add_norm_phr_inf') }
sub filter_subphrases { return shift->ProjSrv('filter_subphrases') }
sub filter_by_subphrases { return shift->ProjSrv('filter_by_subphrases') }
sub get_wide_filtered { return shift->ProjSrv('get_wide_filtered') }
sub text_without_cities_words { return shift->ProjSrv('text_without_cities_words') }
sub get_minicategs_tree { return shift->ProjSrv('get_minicategs_tree') }
sub get_biwords_dict_with_norm_and_snorm { return shift->ProjSrv('get_biwords_dict_with_norm_and_snorm') }
sub get_minicateg_id_lang { my $self = shift; return $self->ProjSrv('get_minicateg_id_lang', @_) }
sub add_search_categs_minuswords { my $self = shift; return $self->ProjSrv('add_search_categs_minuswords', @_) }
sub get_search_filtered { my $self = shift; return $self->ProjSrv('get_search_filtered', @_) }
sub harmonize_by_first { my $self = shift; return $self->ProjSrv('harmonize_by_first') }
sub get_catalogia_flags_hash { return $_[0]->ProjSrv("get_catalogia_flags_hash"); }
sub add_catalogia_flags { return $_[0]->ProjSrv("add_catalogia_flags"); }
sub text_add_pluses_to_stop_words { return $_[0]->ProjSrv("text_add_pluses_to_stop_words"); }
sub text_delete_pluses_except_stop_words { return $_[0]->ProjSrv("text_delete_pluses_except_stop_words"); }

sub fast_text_norm_packed { my $self = shift; return $self->ProjSrv('fast_text_norm_packed', @_) }
sub fast_search_count_filter { my $self = shift; return $self->ProjSrv('fast_search_count_filter', @_) }
sub get_direct_domains_report { my $self = shift; return $self->ProjSrv('get_direct_domains_report', @_) }
sub get_direct_domains_top { my $self = shift; return $self->ProjSrv('get_direct_domains_top', @_) }

sub get_prefiltered_phl { my $self = shift; return $self->ProjSrv('get_prefiltered_phl', @_) }

sub add_norm_phr_forms { my $self = shift; return $self->ProjSrv('add_norm_phr_forms', @_) }

sub get_minus_words { my $self = shift; return $self->ProjSrv('get_minus_words', @_) }
sub get_plusflt_minus_words { my $self = shift; return $self->ProjSrv('get_plusflt_minus_words', @_) }

sub parse { my $self = shift; return $self->ProjSrv('parse', @_) }


sub get_minicateg_id {
    my ($self, $catid) = @_;
    my $res = $self->nrm_cl->DoJson('cat','get_minicateg_id', $catid);
    my ($catname) = @$res;
    return $catname;
}
sub get_minicateg_by_id {
    my ($self, $catid) = @_;
    my $res = $self->nrm_cl->DoJson('cat','get_minicateg_by_id', $catid);
    my ($catname) = @$res;
    return $catname;
}
sub get_minicateg_by_norm {
    my ($self, $catid) = @_;
    my $res = $self->nrm_cl->DoJson('cat','get_minicateg_by_norm', $catid);
    my ($catname) = @$res;
    return $catname;
}
#sub get_minicategs_tree_text { return shift->ProjSrv('get_minicategs_tree_text') }

sub get_norm_phr_forms {
    my $self = shift;
#    my ($phlprv, $phl) = $self->divide(sub { $_->{'_norm_phr_chached'} });
    $phl = $self->_add_norm_phr_inf;
#    $phl = $phl->_add_norm_phr_inf;
    my @arr = ();
    for my $p (@$phl){
        my ($text, $ntext) = split('=>', $p->text);
        my $ph = $self->proj->phrase($text);
        $ph->{'_norm_phr_chached'} = $ntext;
        push(@arr, $ph);
    }
    return $self->phrase_list(\@arr); 
#    return $phlprv + $self->phrase_list(\@arr); 
}

sub get_xls_info_data { my $self = shift; return $self->ProjSrv('get_xls_info_data', @_) }

sub pages2titles { my $self = shift; return $self->ProjSrv('pages2titles') }
sub pages2pages_categs { my $self = shift; return $self->ProjSrv('pages2pages_categs') }
sub pages2goods { my $self = shift; return $self->ProjSrv('pages2goods') }

sub page_phrases  { my $self = shift; return $self->ProjSrv('page_phrases') }
sub page_phrases2 { my $self = shift; return $self->ProjSrv('page_phrases2') }

1;

