package BM::PhraseListWebCategs;

#Работа с категориями веб-интерфейса

use strict;

use utf8;
use open ':utf8';

use std;
use base qw(BM::PhraseListBanners);

use Utils::Words;

use Data::Dumper;


#Парсинг значения категории напрямую из form.
#Не самая лучшая идея, но позволяет избежать дополнительного описания команд.
sub catid {
    my ($self, $val) = @_;
    $self->{'catid'} = $val if defined $val;
    return $self->{'catid'} if defined $self->{'catid'};
    my $proj = $self->proj;
    my $actinf = $proj->form->{'actinf'};
    if( $actinf =~ /^catid_(.+)/ ){
        $self->{'catid'} = $1;
        return $1;
    }else{
        $self->{'catid'} = '';
        return '';
    }
}

sub web_add_to_category {
    my ($self, $cid) = @_;
    $cid ||= $self->catid;

    for my $phr ($self->phrases) {
        $self->proj->add_user_phrase($cid, $phr->text, $phr->lang);
    }
}

sub web_delete_from_category {
    my ($self, $cid) = @_;
    $cid ||= $self->catid;

    for my $phr ($self->phrases) {
        $self->proj->add_user_phrase($cid, $phr->text, $phr->lang, "Delete");
    }
}

sub web_get_category { #Переписываем фразы с учётом удалений и добавлений
    my ($self, $cid) = @_;
    $cid ||= $self->catid;
    my $h = $self->proj->get_category($cid, $self->lang);
    $h->{'CategoryPhrases'} = $self->web_get_category_phl($cid)."";
    return $h;
}

sub web_get_category_full { #Переписываем фразы с учётом удалений и добавлений
    my ($self, $cid) = @_;
    $cid ||= $self->catid;
    my $h = $self->proj->get_category_full($cid, $self->lang);
    $h->{'CategoryPhrases'} = $self->web_get_category_phl($cid)."";
    return $h;
}

sub web_get_category_phl {
    my ($self, $cid) = @_;
    $cid ||= $self->catid;

    my $proj = $self->proj;

    my $ctg = $self->proj->get_category($cid, $self->lang);
    return $self->phrase_list([]) unless defined $ctg;

    my $phl = $self->phrase_list( $ctg->{'CategoryPhrases'} );

    my $uphl = $proj->get_user_phrases($cid, $self->lang);
    for my $ph (sort {$a->{CreateTime} cmp $b->{CreateTime} } @$uphl) {
        if($ph->{Action} eq "Add") {
            $phl += $self->phrase_list([ $ph->{InitialPhrase} ]);
        } elsif($ph->{Action} eq "Delete") {
            $phl = $phl->lgrep(sub { $_->text ne $ph->{InitialPhrase} });
        }
    }
    $phl = $phl->text_pack_list;

    return $phl;
}

sub web_split_phrase_by_categ {
    my ($self, $cid) = @_;
    $cid ||= $self->catid;

    my $phl = $self->web_get_category_phl($cid);
    my %h = map { $_->pack_spaces => 1 } @$phl;
    my %h2 = map { $_->pack_spaces => 1 } @$self;
    my $phlnew = $self->lgrep(sub { ! $h{$_->pack_spaces} });
    my $phldel = $phl->lgrep(sub { ! $h2{$_->pack_spaces} });
    return ($phlnew, $phldel);
}

sub web_change_category_diff {
    my ($self, $cat_id) = @_;
    $cat_id ||= $self->catid;

    my $proj = $self->proj;
    my ($phl_add, $phl_del) = $self
        ->lmap(sub { s/^\s+|\s+$//g; $_ })
        ->lmap(sub { s/&quote;/"/g; $_ })
        ->web_split_phrase_by_categ($cat_id);
    return ($phl_add, $phl_del);
}

sub categs2subcategs {
    my ($self) = @_;
    my $ctree = $self->proj->categs_tree;

    my @res = ();
    for my $c (@$self){
        push(@res, $ctree->get_minicategs_subtrees("$c"));
    }
    s/,//g for @res;

    return $self->phrase_list(\@res);
}

#Удаляем виртуальные категории из списка
sub categs2categs_delete_virt {
    my ($self) = @_;
    my @res = grep { "$_" !~ / _ / } @$self;
    return $self->phrase_list(\@res);
}

sub categs2flags : EXTERNALLY_USED("bmapi") {
    my ($self) = @_;
    my $ctree = $self->proj->categs_tree;

    my @res = ();
    for my $c (@$self){
        push(@res, "$c => " . join(" ", $ctree->get_catalogia_flags("$c")));
    }

    return $self->phrase_list(\@res);
}

sub categs2mcdirectids : EXTERNALLY_USED("bmapi") {
    my ($self) = @_;
    my $ct = $self->proj->categs_tree;

    my @res = ();
    for my $ph (@$self){
        my $c = $ph->normcateg2categ;
        push(@res, $ct->get_minicateg_directid("$c"));
    }

    return $self->phrase_list(\@res);
}

sub mcdirectids2mcdirectids_subcategs {
    my ($self) = @_;
    my $ct = $self->proj->categs_tree;

    my @res = ();
    for my $c (@$self){
        push(@res, "$c", map { $ct->get_minicateg_directid($_) } $ct->get_minicategs_subtrees( $ct->get_minicateg_by_directid("$c") ));
    }

    return $self->phrase_list(\@res);
}

sub mcdirectids2mcdirectids_catname {
    my ($self) = @_;
    my $ct = $self->proj->categs_tree;

    my @res = ();
    for my $c (@$self){
        push(@res, "$c =*> ". $self->proj->phrase( $ct->get_minicateg_by_directid("$c") )->get_norm_categ_from_text );
    }

    return $self->phrase_list(\@res);
}

sub mediagroups2categs {
    my ($self) = @_;
    my $proj = $self->proj;
    my $ctree = $proj->categs_tree;
    my $m2c = $proj->mediagroups->group2categ;

    my @res = map { @{ $m2c->{$_} || [] } } @$self;
    my $resphl = $self->phrase_list(\@res)->tmap(sub { s/,//g; $_ });
    return $resphl;
}

sub mediagroups2directcatids {
    my ($self) = @_;
    my $proj = $self->proj;
    my $ctree = $proj->categs_tree;
    my $m2c = $proj->mediagroups->group2categ;

    my @res = map { $ctree->get_minicateg_directid($_) } map { @{ $m2c->{$_} || [] } } @$self;
    my $resphl = $self->phrase_list(\@res)->tmap(sub { s/,//g; $_ });
    return $resphl;
}

sub mediagroups2directcatids_categs {
    my ($self) = @_;
    my $proj = $self->proj;
    my $ctree = $proj->categs_tree;
    my $m2c = $proj->mediagroups->group2categ;

    my @res = map { $ctree->get_minicateg_directid($_)." => ".$_ } map { @{ $m2c->{$_} || [] } } @$self;
    my $resphl = $self->phrase_list(\@res)->tmap(sub { s/,//g; $_ });
    return $resphl;
}

sub categs2mediagroups {
    my ($self) = @_;
    my $proj = $self->proj;
    my $ctree = $proj->categs_tree;
    my $c2m = $proj->mediagroups->categ2group;

    my @res = map { @{ $c2m->{$_} || [] } } @$self;
    my $resphl = $self->phrase_list(\@res)->tmap(sub { s/,//g; $_ });
    return $resphl;
}

sub search_category_by_snorm {
    my ($self) = @_;
    return $self->phtmap(sub { $_->search_category_by_snorm });
}

sub search_category {
    my ($self) = @_;
    my $proj = $self->proj;


    my $resphl = $proj->phrase_list;

    my $lang = $self->lang || 'ru';

    for my $ph (@$self){
        my $stext = "$ph";

        my $trstext = $ph->poor_layout;

        my $list = $proj->dbtable('CatalogiaDict')->List({ search => {
            'CatID LIKE' => '%'.$stext.'%',   'CategoryName LIKE' => '%'.$stext.'%',
            'CatID  LIKE' => '%'.$trstext.'%', 'CategoryName  LIKE' => '%'.$trstext.'%',  #Наличие пробелов важно, чтобы не склеились ключи
        }, Language => $lang, }, [qw{CatID CategoryName}]);

        $list = [ sort map { $_->{CategoryName} }  grep { $_->{'CatID'} !~ /^(\.|__homonym_)/ } @$list ];
        $resphl += $proj->phrase_list($list);
    }

    $resphl = $resphl->tmap(sub { s/,//g; $_ });

    return $resphl;
}


1;
