package BM::PhraseProduct;

use utf8;
use open ':utf8';

use std;
use Utils::Array;
use Utils::Words;
use List::Util qw(min max sum);

use Time::HiRes qw/time/;

########################################################
########################################################

sub postfilter_base {
    my ($self) = @_;
    my $text = $self->text;
    return 0 if length( $text ) < 4;
    return 0 if $text =~ /^[a-zа-яё]+$/i;
    return 0 if $text =~ /^[0-9]+$/i;
    return 0 if $text =~ /^\d0{0,4} [a-zа-яё ]+$/i;
    return 0 if $text =~ /^\d+ [а-яё ]+$/i;
    return 0 if $text =~ /^\d0? \d0? /i;
    return 1;
}

sub postfilter_hotel {
    my ($self) = @_;
    my $text = $self->text;
    return 0 if length( $text ) < 8;
    return 0 if $text =~ /^[a-zа-яё]+$/i;
    return 0 if $text =~ /^[0-9]+$/i;
    return 1;
}

sub postfilter_product {
    my ( $self, %hparsed ) = @_;
    my @local_wides = @BM::PhraseParser::local_wides;
    my @model_wides = @BM::PhraseParser::model_wides;
#print Dumper ($hparsed);
    my $brand = $hparsed{brand} || '';
    my $type = $hparsed{type} || '';
    my $phrzero = $self->proj->phrase;
#    return $phrzero unless $self->get_bnr_count;
    my $sub_text = $self->text;
    return $self->proj->phrase($sub_text) if $sub_text=~/(^|\s)(iphone|ipad)(\s|$)/;
    @local_wides = map { s/_/ /g; $_ } @local_wides; ##no critic
#    $sub_text =~ s/ -+/ /g; 
#    $sub_text =~ s/^-+//;
#    $sub_text =~ s/-+ / /g; 
#    $sub_text =~ s/-+$//;
    $sub_text =~ s/\-/ /g; 
    $sub_text =~ s/\"/ /g; 
    $sub_text =~ s/\\/ /g; 
    $sub_text =~ s/(^|\s+)(руб|купить)(\s+|$)/ /g; # слова которых не может быть в моделях 
#    $sub_text =~ s/$1/ / while ( $sub_text =~ /((?:\s+\w\s+|^\w\s+|\s+\w$){1})/ && $sub_text !~ /\d/ ); # удаляем одинокие буквы, если фраза не содержит цифр (i сигнал радиоприемник)
    $sub_text =~ s/(?:^|\s)\+\S+(?:\s|^$)/ /g; # удаляем плюс-слова
    $sub_text =~ s/^\s+|\s+$//g;
    my $sub_text_copy = $sub_text;
    $sub_text_copy =~ s/(\d)[.,](\d)/$1$2/g;
    return $phrzero if $sub_text =~ /^\d+$/;
    return $phrzero if $self->proj->phrase($sub_text)->pweight < 39;
    return $phrzero if ( $sub_text =~ /^\d{1,5}$/ );
    return $phrzero if ( $sub_text_copy =~ / / && length($sub_text_copy)<5 || length($sub_text_copy)<3 );
#print STDERR "here-1\n";
    return $phrzero if ( $sub_text_copy =~ /^\w\d{1,2}0{1,2}$/ ); # c32, a300, слишком омонимично
#print STDERR "here-2\n";
    return $phrzero if ( $sub_text_copy =~ /^\d+ ?(w|v)$/i ); # 750w
#print STDERR "here-3\n";
    return $phrzero if ( $sub_text_copy =~ /^([a-zа-яё-]+\s+\d{1,2}|\d{1,2}\s+[a-zа-яё-]+)$/ ); # 24 порт, 40 светодиодный итп.
#print STDERR "here-4\n";
    return $phrzero if ( $sub_text_copy =~ /^[a-zа-яё -]+ \d$/i ); # shantou gepai 2
#print STDERR "here-5\n";
    return $phrzero if ( $sub_text_copy =~ /^([a-zа-яё]{1,2}\s+\d{1,3}|\d{1,3}\s+[a-zа-яё]{1,2})$/ ); # 123 ab, ab 123
#print STDERR "here-6\n";
    return $phrzero if ( $sub_text_copy =~ /^(?:[a-zа-яё]{1,3}\s+\d0{0,3}|\d0{0,3}\s+[a-zа-яё]{1,3})$/ ); # col 2000, 400 sat
#print STDERR "here-7\n";
    return $phrzero if ( $sub_text_copy =~ /^(?:[a-zа-яё]+\s+\d\s+\d|\d\s+\d\s+[a-zа-яё]+|\d\s+[a-zа-яё]+\s+\d)$/ ); # pocketbook 1 7, 1 pocketbook 4, 1 7 pocketbook
#print STDERR "here-8\n";
    return $phrzero if ( $sub_text_copy =~ /^(?:[a-zа-яё]+\s+[a-zа-яё]+\s+\d|[a-zа-яё]+\s+\d\s+[a-zа-яё]+|\d\s+[a-zа-яё]+\s+[a-zа-яё]+)$/ 
                      && !( $sub_text_copy =~ /[a-z].*[а-я]/ or $sub_text_copy =~ /[а-я].*[a-z]/) ); # нельзя: 1 license net, license 1 net, license net 1, можно: телефон iphone 5
#print STDERR "here-9\n";
    # убираем трехзначные числа и числа с нулями на конце и возвращаем пустоту, если остаток широкая фраза
    $sub_text_copy =~ s/(^|\s)\d{1,2}0{1,4}(\s|$)/ /;
    $sub_text_copy =~ s/^\s+|\s+$//g;
    return $phrzero if ( length($sub_text_copy) != length($sub_text) && ( $self->proj->phrase($sub_text_copy)->is_wide_phrase || in_array($sub_text_copy, \@local_wides) ) );
#print STDERR "here-10\n";
    $sub_text_copy = $sub_text;
    # убираем все широкие фразы, брэнд и проверяем остаток
    $sub_text_copy =~ s/(\d)[.,](\d)/$1$2/g; # удаляем точку между цифрами
    $sub_text_copy =~ s/[.,-]/ /g; # все возможные разделители заменяем пробелом
    $sub_text_copy = join ( ' ', grep { !in_array($_,[@local_wides, @model_wides]) } split /\s+/, $sub_text_copy );
#    print STDERR "[$sub_text_copy]\n";
    $sub_text_copy =~ s/^\s+|\s+$//g;
    return $phrzero if length($sub_text_copy) < 4;
#print STDERR "here-11\n";

    my $re = $BM::PhraseParser::noisere;
    $sub_text_copy =~ s/$re/ /gi;
    $sub_text_copy =~ s/\s+/ /;
    return $phrzero if length($sub_text_copy) < 3;
#print STDERR "here-12\n";
#print STDERR "here-13\n";
    $type = quotemeta($type); 
    return $phrzero if $sub_text =~ /^$type\d+$/;

    return $phrzero if ( $sub_text =~ /^((?:\w\s+)?[a-z]+|[a-z]+(?:\s+\w)?)$/i ); # tonda, f tonda

#print STDERR "here-15\n";
    return $phrzero if ( $sub_text =~ /^([\w\d]\s)+[\w\d]$/ ); # c 1 b 3
    return $phrzero if ( $sub_text =~/^\w{1,3}\s\w{1,3}$/i ); # oe wu
    return $phrzero if ( $sub_text =~ /^(\d{1,2}\s*[а-яё]{1,2}|[а-яё]{1,2}\s*\d{1,2})$/i ); # 2мя, мя 2
    return $phrzero if ( $sub_text =~ /^(\w{1,2}\s[а-яё]+|[а-яё]+\s\w{1,2})$/i ); # h сталь
    
    return $self->proj->phrase($sub_text);
}

sub green_url {
    my ($self) = @_;
    my $text = $self->replace_html_spec->text;
    $text =~ s/[^\dа-яА-ЯёЁA-Za-z-\/№#%]/-/g;
    $text =~ s/[-]+/-/g;
    $text =~ s/([A-ЯA-ZЁа-яa-zё])([а-яА-ЯёЁA-Za-z]*)/$1.lc($2)/ge;
    $text =~ s/[\-]+$//g;
    $text =~ s/^[\-]+//g;
    if (length $text > 20) {
        $text = substr($text, 0, 20);
        if (substr($text,19,1) eq '-') {
            $text = substr($text, 0, 19);
        }
        return $text . '...';
    } else {
        return $text;
    }
}

1;
