package BM::PhraseProjSrv;

use utf8;
use open ':utf8';

use std;
use base qw(BM::PhraseModif BM::ProjSrv);

sub ProjSrvInf {
    my ($self, $cmd, @params) = @_;
    my $text = $self->text || '';
#    print STDERR Dumper ([ $self->text, $cmd, \@params]);
#    print STDERR $self->proj->stack_trace;
    my $lang = '';
    $lang = "_lang_".$self->lang if $self->lang;
    return ('phrase'.$lang, $cmd, $text, @params);
}

our $ccc = 0;
sub alive           : CACHE { return $_[0]->nrm_cl->Do("alive"); };
sub normwords       : CACHE {
    my $self = shift;
    return $self->{'_norm_phr_chached'} ? split(' ', $self->{'_norm_phr_chached'}) :  $self->ProjSrv('normwords'      );
};
sub normwords_with_stops : CACHE { return $_[0]->ProjSrv('normwords_with_stops') };
sub snormwords_with_stops : CACHE { return $_[0]->ProjSrv('snormwords_with_stops') };
sub normwords_pairs : CACHE { return $_[0]->ProjSrv('normwords_pairs') };
sub snormwords      : CACHE { return $_[0]->ProjSrv('snormwords'     ) };
sub notwidewords    : CACHE { return $_[0]->ProjSrv('notwidewords'   ) };
sub porno_words     : CACHE { return $_[0]->ProjSrv('porno_words'    ) };
#sub norm_phr        : CACHE { print $ccc." -> ".$_[0]->{'_norm_phr_chached'}."\n" if $ccc++ % 10000 == 0; return $_[0]->{'_norm_phr_chached'} || $_[0]->ProjSrv('norm_phr'       ) };
sub norm_phr        { 
    my $self = shift;
    return $self->text if $self->{normed};
    $self->{'_norm_phr_chached'} ||= $self->ProjSrv('norm_phr');
    return $self->{'_norm_phr_chached'};
};
sub snorm_phr       : CACHE { return $_[0]->ProjSrv('snorm_phr'      ) };
sub correct_phr       : CACHE { return $_[0]->ProjSrv('correct_phr'      ) };
sub is_misspell       : CACHE { return $_[0]->ProjSrv('is_misspell'      ) };
sub is_wide_spam_phrase :CACHE { return $_[0]->ProjSrv('is_wide_spam_phrase') };
sub set_exclamations_before_stops       : CACHE { return $_[0]->ProjSrv('set_exclamations_before_stops'      ) };
sub replace_exclamations_with_pluses       : CACHE { return $_[0]->ProjSrv('replace_exclamations_with_pluses') };
sub lang_recognize    : CACHE { return $_[0]->ProjSrv('lang_recognize') };
sub number_of_words : CACHE { return $_[0]->ProjSrv('number_of_words' ) };
sub get_search_count  { 
    my $self = shift; 
    my @a = @_;
    if( !@a ){
        my $regs = $self->proj->current_region;
        if(ref($regs) eq 'ARRAY'){
            @a = ( $regs ) if @$regs;
        }else{
            @a = ([ $regs ]) if $regs;
        }
    }
    return $self->ProjSrv('get_search_count', @a ) 
};
sub is_subcategory  : CACHE { return $_[0]->ProjSrv('is_subcategory' ) };
sub get_minicategs  : CACHE { return $_[0]->ProjSrv('get_minicategs' ) };
sub get_uncertain_minicategs  : CACHE { return $_[0]->ProjSrv('get_uncertain_minicategs' ) };
sub get_videodirectgroups  : CACHE { return $_[0]->ProjSrv('get_videodirectgroups' ) };
sub get_production_minicategs  : CACHE { return $_[0]->ProjSrv('get_production_minicategs' ) };
sub get_minicategs_log  : CACHE { return $_[0]->ProjSrv('get_minicategs_log' ) };
sub get_exact_minicategs  : CACHE { return $_[0]->ProjSrv('get_exact_minicategs' ) };
sub get_minicategs_phraselog  : CACHE { return $_[0]->ProjSrv('get_minicategs_phraselog' ) };
sub clean_minicategs_subphrases_hash  : CACHE { return $_[0]->ProjSrv('clean_minicategs_subphrases_hash' ) };
sub decode_minicategs_subphrases_hash  : CACHE { return $_[0]->ProjSrv('decode_minicategs_subphrases_hash' ) };
sub orig_minicategs_subphrases_hash  : CACHE { return $_[0]->ProjSrv('orig_minicategs_subphrases_hash' ) };
sub get_upcategs    : CACHE { return $_[0]->ProjSrv('get_upcategs'   ) };
sub badphrsreason   : CACHE { return $_[0]->ProjSrv('badphrsreason'  ) };
sub is_wide_phrase  : CACHE { return $_[0]->ProjSrv('is_wide_phrase' ) };
sub widephr  : CACHE { return $_[0]->ProjSrv('widephr' ) };
sub get_subphrases { my $self = shift; return $self->ProjSrv('get_subphrases', @_ ); }
sub parse  : CACHE { return $_[0]->ProjSrv('parse' ) };
sub get_good_subphrases  : CACHE { return $_[0]->ProjSrv('get_good_subphrases' ) };
sub text_without_cities_words { return $_[0]->ProjSrv('text_without_cities_words' ) };
sub phrase_list_text_norm { return $_[0]->ProjSrv('phrase_list_text_norm' ) };
sub phrase_list_text_norm_packed { return $_[0]->ProjSrv('phrase_list_text_norm_packed' ) };
sub category_from_ru { my $self = shift; return $self->ProjSrv("category_from_ru", @_) }
sub category_to_ru { my $self = shift; return $self->ProjSrv("category_to_ru", @_) }
sub update_subphraser { my $self = shift; return $self->ProjSrv("update_subphraser", @_); }
sub add_to_subphraser { my $self = shift; return $self->ProjSrv("add_to_subphraser", @_); }
sub add_subphraser_category { my $self = shift; return $self->ProjSrv("add_subphraser_category", @_); }
sub delete_subphraser_category { my $self = shift; return $self->ProjSrv("delete_subphraser_category", @_); }
sub get_minicategs_test_info { my $self = shift; return $self->ProjSrv("get_minicategs_test_info", @_); }
sub get_minicategs_test_info_analyzer { my $self = shift; return $self->ProjSrv("get_minicategs_test_info_analyzer");  }
sub analyze_synonyms_path { my $self = shift; return $self->ProjSrv("analyze_synonyms_path"); }
sub search_category_by_name { my $self = shift; return $self->ProjSrv("search_category_by_name"); }
sub search_category_by_snorm { my $self = shift; return $self->ProjSrv("search_category_by_snorm"); }
sub get_brand { my $self = shift; return $self->ProjSrv("get_brand"); }
sub get_acc_brand { my $self = shift; return $self->ProjSrv("get_acc_brand"); }
sub get_metrical { my $self = shift; return $self->ProjSrv("get_metrical"); }
sub get_bank { my $self = shift; return $self->ProjSrv("get_bank"); }
sub get_goods { my $self = shift; return $self->ProjSrv("get_goods"); }
sub cut_qty { my $self = shift; return $self->ProjSrv("cut_qty"); }
sub wget_minicateg_id { my $self = shift; return $self->ProjSrv('wget_minicateg_id', @_ ); }
sub wget_minicateg_by_id { my $self = shift; return $self->ProjSrv('wget_minicateg_by_id', @_ ); }
sub wget_minicateg_parent_id { my $self = shift; return $self->ProjSrv('wget_minicateg_parent_id', @_ ); }
sub wget_minicateg_parent { my $self = shift; return $self->ProjSrv('wget_minicateg_parent', @_ ); }
sub get_related_minicategs { my $self = shift; return $self->ProjSrv('get_related_minicategs', @_ ); }
sub get_cat_path { my $self = shift; return $self->ProjSrv('get_cat_path', @_ ); }
sub get_banner_catalogia_flags { return $_[0]->ProjSrv("get_banner_catalogia_flags"); };
sub get_banner_catalogia_flags_analysis { return $_[0]->ProjSrv("get_banner_catalogia_flags_analysis"); };
sub do_categs_method { my $self = shift; return $self->ProjSrv('do_categs_method', @_ ); }
sub search_atoms { return $_[0]->ProjSrv("search_atoms"); };
sub has_celebrities { my $self = shift; return $self->ProjSrv('has_celebrities', @_ ); }
sub get_banner_prefiltered_phrase { my $self = shift; return $self->ProjSrv('get_banner_prefiltered_phrase', @_ ); }
sub get_banner_prefiltered_text { my $self = shift; return $self->ProjSrv('get_banner_prefiltered_text', @_); }
sub get_regions { return $_[0]->ProjSrv('get_regions' ) };
#sub harmonize { return $_[0]->ProjSrv('harmonize', @_ ) };
#sub get_gender_number_case { return $_[0]->ProjSrv('get_gender_number_case') };
#sub vendors { my $self = shift; return $self->ProjSrv('vendors', @_ ); }
sub search_phrase_antiwords { my $self = shift; return $self->ProjSrv('search_phrase_antiwords', @_); }
sub casecorrection { my $self = shift; return $self->ProjSrv('casecorrection', @_); }

sub lgt_norm_phrases_text { my $self = shift; return $self->ProjSrv('lgt_norm_phrases_text', @_); }
sub lgt_phrases_filtering { my $self = shift; return $self->ProjSrv('lgt_phrases_filtering', @_); }
sub text_delete_pluses_except_stop_words { my $self = shift; return $self->ProjSrv('text_delete_pluses_except_stop_words', @_); }

sub get_category_phrases { my $self = shift; return $self->ProjSrv('get_category_phrases', @_); }
sub get_analysis { my $self = shift; return $self->ProjSrv('get_analysis', @_); }
sub word_analyze { my $self = shift; return $self->ProjSrv('word_analyze', @_); }
sub parse_fast {my $self = shift; return $self->ProjSrv('parse_fast', @_); };
sub parse_fast_auto {my $self = shift; return $self->ProjSrv('parse_fast_auto', @_); };

sub s1111 { my $self = shift; return $self->ProjSrv("s1111", @_); }

1;
