package BM::SmartJson;

use strict;
use warnings;

use base qw(ObjLib::ProjPart);

use JSON::PPPatched qw//;
use JSON::XS qw//;

sub new {
    my $class = shift;
    my $self = shift || {};

    unless ($self->{proj}) {
        die "proj should be passed in params: " . join " ", %$self;
    }
    $self->{xs_limit} ||= 12_000_000;

    return bless $self, $class;
}

sub _init_encode {
    my $self = shift;
    return if $self->{_encode_inited};

    $self->{json_pp} = JSON::PPPatched->new()
        #->utf8(1)
        ->indent(0)
        ->convert_blessed(1);
    $self->{json_xs} = JSON::XS->new()
        #->utf8(1)
        ->indent(0)
        ->convert_blessed(1);

    $self->{_encode_inited} = 1;
}

sub _init_decode {
    my $self = shift;
    return if $self->{_decode_inited};
    $self->_init_encode();

    $self->{decode_cache} = {};

    for my $class (qw/
        BM::Phrase
        BM::PhraseList
        BM::Banners::Campaign
        BM::Banners::LBannerBM
    /) {
        eval "require $class";
        my $jclass = eval "\$${class}::JSON_CLASS";
        my $jkey = eval "\$${class}::JSON_KEY";
        $jkey = [$jkey] unless ref $jkey eq 'ARRAY';  # for some rename process - allow several json-keys - current and a couple of old
        my $proto_obj = $jclass->new({proj => $self->{proj}});

        my $sub = sub {
            my $hash = shift;
            return $class->FROM_JSON($self->{proj}, $proto_obj, $hash, $self->{decode_cache});
        };

        for my $thejkey (@$jkey) {
            $self->{json_xs}->filter_json_single_key_object($thejkey => $sub);
            $self->{json_pp}->filter_json_single_key_object($thejkey => $sub);
        }
    }

    $self->{_decode_inited} = 1;
}

sub encode {
    my $self = shift;
    my @what = @_;

    if ($self->{_encode_started}) {
        die "Encode already started. Not suitable for concurrent running (Coro, for example).";
    }
    $self->{_encode_started} = 1;

    $self->_init_encode();
    $self->{encode_cache} = {};

    my $result = $self->{json_xs}->encode(@what);

    $self->{encode_cache} = {};

    $self->{_encode_started} = 0;

    return $result;
}

sub encode_cache {
    my $self = shift;
    my $key = shift;
    if (!$self->{_encode_started}) {
        die "Encode cache works only during encoding";
    }
    if (@_) {   # put value into cache
        $self->{encode_cache}->{$key} = $_[0];
    } else {
        return $self->{encode_cache}->{$key};
    }
}

sub decode {
    my $self = shift;
    my $what = shift;

    if ($self->{_decode_started}) {
        die "Decode already started. Not suitable for concurrent running (Coro, for example).";
    }
    $self->{_decode_started} = 1;

    $self->_init_decode();

    my $json = length($what) > $self->{xs_limit} ? $self->{json_pp} : $self->{json_xs};
    my $result = $json->decode($what);

    my @keys = keys %{$self->{decode_cache}};
    for my $key (@keys) {
        if ($key =~ /^dummy\//) {
            die "Not all stubs expanded: $key, for example";
        }
    }
    $self->{decode_cache} = {};

    $self->{_decode_started} = 0;

    return $result;
}

1;
