package BM::SwitchmanClient;

=h
    Обертка для клиента Switchman
    ! singleton project'а
=cut

use strict;
use utf8;
use open ':utf8';

use base qw(ObjLib::ProjPart);

__PACKAGE__->mk_accessors(qw(
    params
));

#################################################
################# Private #######################
#################################################


sub init {
    my ($self) = @_;
    die 'no admins config/params provided!' unless $self->{admins_config} && $self->{params};
    die 'no prefix provided!' unless $self->{params}{prefix};
    require App::Switchman;
    
    my $proj = $self->proj;
    
    # считаем, что пользователь отдает полный путь (не хочет, чтобы еще всякие суффиксы доклеивались)
    $App::Switchman::LOCKS_PATH = '';
    {
        no warnings 'redefine';
        *App::Switchman::lock_path = sub { join ('/', grep {$_} $_[0]->{prefix}, $App::Switchman::LOCKS_PATH, $_[0]->lockname) };
    }
 
    # парсим конфиг админов для поддержки параметров соединения с бэкендом
    my $all_admins_params = $proj->json_obj->decode($proj->file($self->{admins_config})->text);
    my @connection_params = qw/zkhosts termination_timeout data_read_len resources_wait_timeout/;
    $self->{admins_params} = {};
    $self->{admins_params}{$_} = $all_admins_params->{$_} for grep { $all_admins_params->{$_} } @connection_params;
    
    # устанавливаем параметры, переданные в Project'е
    $self->{main_prefix} = $self->{params}{prefix};
    $self->set_params();

    # инициализируем хэш для активных локов
    $self->{active_locks} = {};

    return $self;
}

#sub DESTROY {
#    my $self = shift;
#    unlink $self->{config_file} if -e $self->{config_file};
#}

sub _get_sw {
    my ($self, $name) = @_;

    my ($prefix, $lockname) = $self->_split_name($name);
    my $sw = App::Switchman->new([$lockname, "--config", $self->{config_file}, "fake_cmd"]);
    $sw->{prefix} = $prefix;
    return undef unless $sw->zkh->exists($sw->prefix);

    $sw->zk_connect();
    return $sw;
}

# сплитим lockname, т.к. не принимает с '/' 
sub _split_name {
    my ($self, $name) = @_;
    my $prefix = $self->{main_prefix};
    my $p = rindex($name, '/');
    if ($p != -1) {
        $prefix .= '/'.substr($name, 0, $p) if $p > 0;
        $name = substr($name, $p+1);
    }
    return ($prefix, $name);
}


#################################################
################# Public ########################
#################################################

sub active_locks {
    my ($self) = @_;
    return [ keys %{$self->{active_locks}} ];
}

####
# установка новых параметров
#
sub set_params {
    my $self = shift;
    my %params = @_;
    my $proj = $self->proj;

    my $new_params = %params ? \%params : $self->params;
    if ($new_params->{prefix} && $new_params->{prefix} ne $self->{main_prefix}) {
        warn 'new prefix not supported';
    }
    my %p = ();
    $p{$_} = $self->{admins_params}{$_} for (keys %{ $self->{admins_params} });
    $p{$_} = $new_params->{$_} for keys %$new_params;
    $p{prefix} = $self->{main_prefix};
    
    # все конфиги хранятся в файле
    $self->{config_file}   = $proj->get_tempfile('switchman.conf', UNLINK=>1);
    $proj->file($self->{config_file})->save( $proj->json_obj->encode(\%p) );

    $self->params(\%p);
    return $self;
}

####
# Проверяем существование ноды
#
sub is_node_exists {
    my ($self, $name) = @_;
    my $sw = $self->_get_sw($name);
    return defined($sw);
}

#####
# 1. Префикс до ноды уже должен существовать.
#    Создается командой 'direct-zkcli -H <host, f.e ipv6.ppcback01e.yandex.ru> -p <port, f.e. 2181> touch <prefix>'
# 2. Лок существует до тех пор, пока существует объект $sw, его породивший.
#
sub lock_node {
    my ($self, $name, %params) = @_;

    my $sw = $self->_get_sw($name);
    unless (defined($sw)) {
        warn "node '$name' prefix doesn\'t exist! can't use it as a lock node";
        return 0;
    }

    my $is_success = 0;

    # если блокирующий лок
    if ($params{waitable}) {
        my $timeout;
        $timeout = $params{timeout} if $params{timeout};
        my $tbt = $params{time_between_tries} || 5;
        # пингуем лок каждые $tbt секунд, но не более $timeout сек в сумме
        while ( (not defined($timeout) or $timeout > 0) and not ($is_success = $sw->get_lock()) ) {
            sleep($tbt);
            $timeout -= $tbt;
        }
    } else {
        $is_success = $sw->get_lock();
    }

    $self->{active_locks}{$name} = $sw if $is_success;
    return $is_success ? 1: 0;
}

####
# Удаляем объект $sw, породивший лок == снимаем лок
#
sub unlock_node {
    my ($self, $name) = @_;
    
    my $is_active = $self->{active_locks}{$name} ? 1: 0;
    delete $self->{active_locks}{$name} if $is_active;
    
    return $is_active;
}

1;
