package BM::XMLParser;

use utf8;
use open ':utf8';

use std;
use base qw(ObjLib::ProjPart);
use XML::Parser;


sub parse_xml {
    my ($self, $xml, $prms) = @_;
    $ParseXML::states = { map { $_ => 1 } map {@$_} $prms->{states} };
    $ParseXML::elems  = { map { $_ => 1 } map {@$_} $prms->{elems} };
    my $parser = XML::Parser->new(Style => 'Stream', Pkg => 'ParseXML');
    $ParseXML::result = {};
    $parser->parse($xml); 
    my $res = $ParseXML::result;
    $ParseXML::result = {};
    return $res;
}

sub parse_yml {
    my ($self, $xml) = @_;
    return $self->parse_xml( $xml,
        {
            states => [qw( categories offers )],
            elems  => [qw( category offer )],
        },
    ); 
}


######################################################################
# Парсинг XML
######################################################################

package ParseXML;

our $out_fh;  # костыль ?

my $curr = {}; #Данные по текущему элементу
my $text = ''; #Текущий текст

my $state = '';

our $result = {};

#Теги переключения состояний
#our $states = { map { $_ => 1 } qw( categories offers ) };
our $states = { map { $_ => 1 } qw( ) };
#Теги элементов
#our $elems = { map { $_ => 1 } qw( category offer ) };
our $elems = { map { $_ => 1 } qw( ) };

our $elopened = 0;

sub AddElem {
    my ($pl, $el) = @_;
    $result->{ $pl } ||= [];
    push( @{ $result->{ $pl } }, $curr );
}

sub StartTag {
    my $self = shift;
    my $tag = shift;
    if ($states->{$tag}) { #Переключение типа списка
        $state = $tag;
    }elsif ($elems->{$tag}) { #Переключение типов элементов
        $curr->{$_} = $_{$_} for keys %_ ;
        $elopened = 1;
    }
    $text = ''; #Сбрасывает текст при открывании нового тега
}

sub EndTag {
    my $self = shift;
    my $tag = shift;
    if ($states->{$tag}) {
        $state = '';
    } elsif ($elems->{$tag}) {
        $elopened = 0;
        $curr->{text} = $text if $text;
        AddElem( $state, $curr);
        $curr = {};
    } elsif ( $elopened ) {
        $text =~ s/\n$//;
        $curr->{$tag} = $text;
    }
}

sub Text {
    $text = $_;
}

package BM::BannersMaker::Feed;  # Возвращаемся в исходный namespace

######################################################################
# / Парсинг XML
######################################################################


1;
